/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.SecurityContextTokenProcessor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Element;

public class DerivedKeyTokenProcessor
implements Processor {
    private String id;
    private byte[] keyBytes;
    private byte[] secret;
    private int length;
    private int offset;
    private byte[] nonce;
    private String label;
    private String algorithm;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        DerivedKeyToken dkt = new DerivedKeyToken(elem);
        this.extractSecret(wsDocInfo, dkt, cb, crypto);
        String tempNonce = dkt.getNonce();
        if (tempNonce == null) {
            throw new WSSecurityException("Missing wsc:Nonce value");
        }
        this.nonce = Base64.decode(tempNonce);
        this.length = dkt.getLength();
        this.label = dkt.getLabel();
        this.algorithm = dkt.getAlgorithm();
        this.id = dkt.getID();
        if (this.length > 0) {
            this.deriveKey();
        }
    }

    private void deriveKey() throws WSSecurityException {
        try {
            DerivationAlgorithm algo = AlgoFactory.getInstance(this.algorithm);
            byte[] labelBytes = null;
            labelBytes = this.label == null || this.label != null && this.label.length() == 0 ? "WS-SecureConversationWS-SecureConversation".getBytes("UTF-8") : this.label.getBytes("UTF-8");
            byte[] seed = new byte[labelBytes.length + this.nonce.length];
            System.arraycopy(labelBytes, 0, seed, 0, labelBytes.length);
            System.arraycopy(this.nonce, 0, seed, labelBytes.length, this.nonce.length);
            this.keyBytes = algo.createKey(this.secret, seed, this.offset, this.length);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractSecret(WSDocInfo wsDocInfo, DerivedKeyToken dkt, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Processor processor;
        SecurityTokenReference str = dkt.getSecurityTokenReference();
        if (str == null) throw new WSSecurityException(6, "noReference");
        String uri = null;
        String keyIdentifierValueType = null;
        String keyIdentifierValue = null;
        if (str.containsReference()) {
            Reference ref = str.getReference();
            uri = ref.getURI();
            processor = wsDocInfo.getProcessor(uri.substring(1));
        } else {
            keyIdentifierValue = str.getKeyIdentifierValue();
            keyIdentifierValueType = str.getKeyIdentifierValueType();
            processor = wsDocInfo.getProcessor(keyIdentifierValue);
        }
        if (processor == null && uri != null) {
            this.secret = this.getSecret(cb, uri.substring(1));
            return;
        } else if (processor == null && keyIdentifierValue != null && keyIdentifierValueType != null) {
            this.secret = this.getSecret(cb, keyIdentifierValue, keyIdentifierValueType);
            return;
        } else if (processor instanceof UsernameTokenProcessor) {
            this.secret = ((UsernameTokenProcessor)processor).getDerivedKey(cb);
            return;
        } else if (processor instanceof EncryptedKeyProcessor) {
            this.secret = ((EncryptedKeyProcessor)processor).getDecryptedBytes();
            return;
        } else if (processor instanceof SecurityContextTokenProcessor) {
            this.secret = ((SecurityContextTokenProcessor)processor).getSecret();
            return;
        } else {
            if (!(processor instanceof SAMLTokenProcessor)) throw new WSSecurityException(6, "unsupportedKeyId");
            SAMLTokenProcessor samlp = (SAMLTokenProcessor)processor;
            SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
            this.secret = keyInfo.getSecret();
        }
    }

    private byte[] getSecret(CallbackHandler cb, String id) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback callback = new WSPasswordCallback(id, 6);
        Callback[] callbacks = new Callback[]{callback};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{id}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{id}, e);
        }
        return callback.getKey();
    }

    private byte[] getSecret(CallbackHandler cb, String keyIdentifierValue, String keyIdentifierType) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(keyIdentifierValue, null, keyIdentifierType, 8);
        try {
            cb.handle(new Callback[]{pwcb});
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{this.id}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{this.id}, e);
        }
        return pwcb.getKey();
    }

    public String getId() {
        return this.id;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public byte[] getKeyBytes(int len) throws WSSecurityException {
        this.length = len;
        this.deriveKey();
        return this.keyBytes;
    }
}

