/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@ConsumeMime(value={"multipart/related", "multipart/mixed", "multipart/alternative"})
public class ActivationProvider
implements MessageBodyReader<Object> {
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return DataHandler.class.isAssignableFrom(type) || DataSource.class.isAssignableFrom(type) || Attachment.class.isAssignableFrom(type) || MultipartBody.class.isAssignableFrom(type) || this.mediaTypeSupported();
    }

    public Object readFrom(Class<Object> c, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        List<Attachment> infos = AttachmentUtils.getAttachments(this.mc, this.attachmentDir, this.attachmentThreshold);
        if (List.class.isAssignableFrom(c)) {
            Class<Attachment> actual = InjectionUtils.getActualType(t);
            if (actual.isAssignableFrom(Attachment.class)) {
                return infos;
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Attachment a : infos) {
                objects.add(this.fromAttachment(a, actual, actual, anns));
            }
            return objects;
        }
        if (MultipartBody.class.isAssignableFrom(c)) {
            return new MultipartBody(infos);
        }
        Attachment multipart = AttachmentUtils.getMultipart(c, anns, mt, infos);
        if (multipart != null) {
            return this.fromAttachment(multipart, c, t, anns);
        }
        throw new WebApplicationException(404);
    }

    private Object fromAttachment(Attachment multipart, Class<?> c, Type t, Annotation[] anns) throws IOException {
        if (DataHandler.class.isAssignableFrom(c)) {
            return multipart.getDataHandler();
        }
        if (DataSource.class.isAssignableFrom(c)) {
            return multipart.getDataHandler().getDataSource();
        }
        if (Attachment.class.isAssignableFrom(c)) {
            return multipart;
        }
        MessageBodyReader r = this.mc.getProviders().getMessageBodyReader(c, t, anns, multipart.getContentType());
        if (r != null) {
            return r.readFrom(c, t, anns, multipart.getContentType(), multipart.getHeaders(), multipart.getDataHandler().getInputStream());
        }
        return null;
    }

    private boolean mediaTypeSupported() {
        if (this.mc == null) {
            return false;
        }
        MediaType mt = this.mc.getHttpHeaders().getMediaType();
        return mt.getType().equals("multipart") && (mt.getSubtype().equals("related") || mt.getSubtype().equals("mixed") || mt.getSubtype().equals("alternative"));
    }
}

