/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;

public final class WSActionAnnotator
implements Annotator {
    private static final QName WSAW_ACTION_QNAME = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
    private OperationInfo operation;

    public WSActionAnnotator(OperationInfo op) {
        this.operation = op;
    }

    public void annotate(JavaAnnotatable ja) {
        QName outputAction;
        QName inputAction;
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("RequestWrapper and ResponseWrapper can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        boolean required = false;
        JavaInterface intf = method.getInterface();
        MessageInfo inputMessage = this.operation.getInput();
        MessageInfo outputMessage = this.operation.getOutput();
        JAnnotation actionAnnotation = new JAnnotation(Action.class);
        if (inputMessage.getExtensionAttributes() != null && (inputAction = (QName)inputMessage.getExtensionAttribute(WSAW_ACTION_QNAME)) != null) {
            actionAnnotation.addElement(new JAnnotationElement("input", inputAction.getLocalPart()));
            required = true;
        }
        if (outputMessage != null && outputMessage.getExtensionAttributes() != null && (outputAction = (QName)outputMessage.getExtensionAttribute(WSAW_ACTION_QNAME)) != null) {
            actionAnnotation.addElement(new JAnnotationElement("output", outputAction.getLocalPart()));
            required = true;
        }
        if (this.operation.hasFaults()) {
            ArrayList<JAnnotation> faultAnnotations = new ArrayList<JAnnotation>();
            for (FaultInfo faultInfo : this.operation.getFaults()) {
                if (faultInfo.getExtensionAttributes() == null) continue;
                QName faultAction = (QName)faultInfo.getExtensionAttribute(WSAW_ACTION_QNAME);
                JavaException exceptionClass = this.getExceptionClass(method, faultInfo);
                if (!StringUtils.isEmpty(exceptionClass.getPackageName()) && !exceptionClass.getPackageName().equals(intf.getPackageName())) {
                    intf.addImport(exceptionClass.getClassName());
                }
                JAnnotation faultAnnotation = new JAnnotation(FaultAction.class);
                faultAnnotation.addElement(new JAnnotationElement("className", exceptionClass));
                faultAnnotation.addElement(new JAnnotationElement("value", faultAction.getLocalPart()));
                faultAnnotations.add(faultAnnotation);
                required = true;
            }
            actionAnnotation.addElement(new JAnnotationElement("fault", faultAnnotations));
        }
        if (required) {
            method.addAnnotation("Action", actionAnnotation);
        }
    }

    private JavaException getExceptionClass(JavaMethod method, FaultInfo faultInfo) {
        for (JavaException exception : method.getExceptions()) {
            QName faultName = faultInfo.getName();
            if (!exception.getTargetNamespace().equals(faultName.getNamespaceURI()) || !exception.getName().toLowerCase().startsWith(faultName.getLocalPart().toLowerCase())) continue;
            return exception;
        }
        return null;
    }
}

