/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSignatureSAML
extends WSSecSignature {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$saml$WSSecSignatureSAML == null ? (class$org$apache$ws$security$saml$WSSecSignatureSAML = WSSecSignatureSAML.class$("org.apache.ws.security.saml.WSSecSignatureSAML")) : class$org$apache$ws$security$saml$WSSecSignatureSAML).getName());
    private boolean senderVouches = false;
    private SecurityTokenReference secRefSaml = null;
    private Element samlToken = null;
    private Crypto userCrypto = null;
    private Crypto issuerCrypto = null;
    private String issuerKeyName = null;
    private String issuerKeyPW = null;
    static /* synthetic */ Class class$org$apache$ws$security$saml$WSSecSignatureSAML;

    public Document build(Document doc, Crypto uCrypto, SAMLAssertion assertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        this.prepare(doc, uCrypto, assertion, iCrypto, iKeyName, iKeyPW, secHeader);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        this.addReferencesToSign(this.parts, secHeader);
        this.prependToHeader(secHeader);
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        this.prependSAMLElementsToHeader(secHeader);
        this.computeSignature();
        return doc;
    }

    public void prepare(Document doc, Crypto uCrypto, SAMLAssertion assertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"Beginning ST signing...");
        }
        this.userCrypto = uCrypto;
        this.issuerCrypto = iCrypto;
        this.document = doc;
        this.issuerKeyName = iKeyName;
        this.issuerKeyPW = iKeyPW;
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature"});
        }
        String confirmMethod = null;
        it = samlSubj.getConfirmationMethods();
        if (it.hasNext()) {
            confirmMethod = (String)it.next();
        }
        if ("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(confirmMethod)) {
            this.senderVouches = true;
        }
        this.wsDocInfo = new WSDocInfo(doc.hashCode());
        X509Certificate[] certs = null;
        if (this.senderVouches) {
            certs = this.issuerCrypto.getCertificates(this.issuerKeyName);
            this.wsDocInfo.setCrypto(this.issuerCrypto);
        } else {
            if (this.userCrypto == null || !assertion.isSigned()) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"for SAML Signature (Key Holder)"});
            }
            Element e = samlSubj.getKeyInfo();
            try {
                KeyInfo ki = new KeyInfo(e, null);
                if (ki.containsX509Data()) {
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem != null) {
                        X509Certificate cert = certElem.getX509Certificate();
                        certs = new X509Certificate[]{cert};
                    }
                }
            }
            catch (XMLSecurityException e3) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
            }
            this.wsDocInfo.setCrypto(this.userCrypto);
        }
        if (certs == null || certs.length <= 0) {
            throw new WSSecurityException(0, "noCertsFound", new Object[]{"SAML signature"});
        }
        if (this.sigAlgo == null) {
            String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
            log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                throw new WSSecurityException(0, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
            }
        }
        this.sig = null;
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace((Document)doc, (String)"CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, this.sigAlgo);
                this.sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error((Object)"", (Throwable)e);
                throw new WSSecurityException(10, "noXMLSig", null, e);
            }
        }
        try {
            this.sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new WSSecurityException(10, "noXMLSig", null, e);
        }
        this.sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        String sigUri = "Signature-" + this.sig.hashCode();
        this.sig.setId(sigUri);
        this.keyInfo = this.sig.getKeyInfo();
        this.keyInfoUri = "KeyId-" + this.keyInfo.hashCode();
        this.keyInfo.setId(this.keyInfoUri);
        this.secRef = new SecurityTokenReference(doc);
        this.strUri = "STRId-" + this.secRef.hashCode();
        this.secRef.setID(this.strUri);
        this.certUri = "CertId-" + certs[0].hashCode();
        Transforms transforms = null;
        try {
            if (this.senderVouches) {
                this.secRefSaml = new SecurityTokenReference(doc);
                String strSamlUri = "STRSAMLId-" + this.secRefSaml.hashCode();
                this.secRefSaml.setID(strSamlUri);
                Reference ref = new Reference(doc);
                ref.setURI("#" + assertion.getId());
                ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                this.secRefSaml.setReference(ref);
                Element ctx = this.createSTRParameter(doc);
                transforms = new Transforms(doc);
                transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                this.sig.addDocument("#" + strSamlUri, transforms);
            }
        }
        catch (TransformationException e1) {
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(doc);
                if (this.senderVouches) {
                    ref.setURI("#" + this.certUri);
                    this.bstToken = new X509Security(doc);
                    ((X509Security)this.bstToken).setX509Certificate(certs[0]);
                    this.bstToken.setID(this.certUri);
                    this.wsDocInfo.setBst(this.bstToken.getElement());
                    ref.setValueType(this.bstToken.getValueType());
                } else {
                    ref.setURI("#" + assertion.getId());
                    ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                }
                this.secRef.setReference(ref);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        this.keyInfo.addUnknownElement(this.secRef.getElement());
        Element keyInfoElement = this.keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            this.samlToken = (Element)assertion.toDOM(doc);
        }
        catch (SAMLException e2) {
            throw new WSSecurityException(10, "noSAMLdoc", null, e2);
        }
        this.wsDocInfo.setAssertion(this.samlToken);
    }

    public void prependSAMLElementsToHeader(WSSecHeader secHeader) {
        if (this.senderVouches) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.secRefSaml.getElement());
        }
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.samlToken);
    }

    public void addReferencesToSign(Vector references, WSSecHeader secHeader) throws WSSecurityException {
        Transforms transforms = null;
        Element envelope = this.document.getDocumentElement();
        for (int part = 0; part < this.parts.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToSign = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            transforms = new Transforms(this.document);
            try {
                if (idToSign != null) {
                    Element toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    if (toSignById == null) {
                        toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, null);
                    }
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(toSignById)).getElement());
                    }
                    this.sig.addDocument("#" + idToSign, transforms);
                    continue;
                }
                if (elemName.equals("Token")) {
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        if (this.wssConfig.isWsiBSPCompliant()) {
                            transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(secHeader.getSecurityHeader())).getElement());
                        }
                        this.sig.addDocument("#" + this.certUri, transforms);
                        continue;
                    }
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(this.keyInfo.getElement())).getElement());
                    }
                    this.sig.addDocument("#" + this.keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(this.document);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    this.sig.addDocument("#" + this.strUri, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (this.wssConfig.isWsiBSPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(body)).getElement());
                }
                this.sig.addDocument("#" + this.setWsuId(body), transforms);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
        }
    }

    public void computeSignature() throws WSSecurityException {
        WSDocInfoStore.store(this.wsDocInfo);
        try {
            if (this.senderVouches) {
                this.sig.sign((Key)this.issuerCrypto.getPrivateKey(this.issuerKeyName, this.issuerKeyPW));
            } else {
                this.sig.sign((Key)this.userCrypto.getPrivateKey(this.user, this.password));
            }
            this.signatureValue = this.sig.getSignatureValue();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(this.wsDocInfo);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

