/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.soa.oi.openq;

import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.Provider;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalConnection;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.openq.types.ObjectFactory;
import javax.xml.namespace.QName;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2003._03.addressing.ServiceNameType;

public class WsFactoryManager {
    private static ObjectFactory WSOQ_OBJ_FACTORY = new ObjectFactory();
    private static com.nortel.soa.oi.cct.types.ObjectFactory WSBT_OBJ_FACTORY = new com.nortel.soa.oi.cct.types.ObjectFactory();
    private static org.xmlsoap.schemas.ws._2003._03.addressing.ObjectFactory WSA_OBJ_FACTORY = new org.xmlsoap.schemas.ws._2003._03.addressing.ObjectFactory();
    private static org.oasis_open.docs.wsrf._2004._06.wsrf_ws_basefaults_1_2_draft_01.ObjectFactory BASE_FAULT_FACTORY = new org.oasis_open.docs.wsrf._2004._06.wsrf_ws_basefaults_1_2_draft_01.ObjectFactory();

    public static ObjectFactory wsoq() {
        return WSOQ_OBJ_FACTORY;
    }

    public static com.nortel.soa.oi.cct.types.ObjectFactory wsbt() {
        return WSBT_OBJ_FACTORY;
    }

    public static org.xmlsoap.schemas.ws._2003._03.addressing.ObjectFactory wsa() {
        return WSA_OBJ_FACTORY;
    }

    public static org.oasis_open.docs.wsrf._2004._06.wsrf_ws_basefaults_1_2_draft_01.ObjectFactory base() {
        return BASE_FAULT_FACTORY;
    }

    public static Address createAddress(String name, AddressType type, Provider provider) {
        Address address = null;
        address = WsFactoryManager.wsbt().createAddress();
        address.setAddressName(name);
        address.setAddressType(type);
        address.setProvider(provider);
        return address;
    }

    public static Terminal createTerminal(String name, TerminalType type, Provider provider) {
        Terminal terminal = null;
        terminal = WsFactoryManager.wsbt().createTerminal();
        terminal.setTerminalName(name);
        terminal.setTerminalType(type);
        terminal.setProvider(provider);
        return terminal;
    }

    public static Contact createContact(String id, String externalId, Provider provider) {
        Contact contact = null;
        contact = WsFactoryManager.wsbt().createContact();
        contact.setContactId(id);
        contact.setExternalContactId(externalId);
        contact.setProvider(provider);
        return contact;
    }

    public static Agent createAgent(String loginId, String userName) {
        Agent agent = null;
        agent = WsFactoryManager.wsbt().createAgent();
        agent.setAgentLoginId(loginId);
        agent.setUserName(userName);
        return agent;
    }

    public static Connection createConnection(String id) {
        Connection connection = null;
        connection = WsFactoryManager.wsbt().createConnection();
        connection.setConnectionId(id);
        return connection;
    }

    public static TerminalConnection createTerminalConnection(String id) {
        TerminalConnection terminalConnection = null;
        terminalConnection = WsFactoryManager.wsbt().createTerminalConnection();
        terminalConnection.setTerminalConnectionId(id);
        return terminalConnection;
    }

    public static Provider createProvider(String name) {
        Provider provider = null;
        provider = WsFactoryManager.wsbt().createProvider();
        provider.setProviderName(name);
        return provider;
    }

    public static EndpointReferenceType createConsumerEndpointReference(String uriString, QName serviceQName, String portName) {
        return WsFactoryManager.createEndpointReference(null, uriString, serviceQName, portName);
    }

    public static EndpointReferenceType createSubscriptionReference(String subscriptionId, String uriString, ServiceNameType serviceName) {
        if (serviceName != null) {
            return WsFactoryManager.createEndpointReference(subscriptionId, uriString, serviceName.getValue(), serviceName.getPortName());
        }
        return WsFactoryManager.createEndpointReference(subscriptionId, uriString, null, null);
    }

    public static EndpointReferenceType createSubscriptionReference(String subscriptionId, String uriString, QName serviceQName, String portName) {
        return WsFactoryManager.createEndpointReference(subscriptionId, uriString, serviceQName, portName);
    }

    public static EndpointReferenceType createEndpointReference(String subscriptionId, String uriString, QName serviceQName, String portName) {
        EndpointReferenceType endpointReference = WsFactoryManager.wsa().createEndpointReferenceType();
        AttributedURI uri = WsFactoryManager.wsa().createAttributedURI();
        uri.setValue(uriString);
        ServiceNameType serviceName = WsFactoryManager.wsa().createServiceNameType();
        serviceName.setValue(serviceQName);
        serviceName.setPortName(portName);
        endpointReference.setPortType(WsFactoryManager.wsa().createAttributedQName());
        endpointReference.setReferenceProperties(WsFactoryManager.wsa().createReferencePropertiesType());
        endpointReference.setAddress(uri);
        endpointReference.setServiceName(serviceName);
        endpointReference.setSubscriptionId(subscriptionId);
        return endpointReference;
    }
}

