/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class MapFactoryBean
extends AbstractFactoryBean {
    private Map sourceMap;
    private Class targetMapClass;
    static /* synthetic */ Class class$java$util$Map;

    public void setSourceMap(Map sourceMap) {
        this.sourceMap = sourceMap;
    }

    public void setTargetMapClass(Class targetMapClass) {
        if (targetMapClass == null) {
            throw new IllegalArgumentException("'targetMapClass' must not be null");
        }
        if (!(class$java$util$Map == null ? (class$java$util$Map = MapFactoryBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(targetMapClass)) {
            throw new IllegalArgumentException("'targetMapClass' must implement [java.util.Map]");
        }
        this.targetMapClass = targetMapClass;
    }

    public Class getObjectType() {
        return class$java$util$Map == null ? (class$java$util$Map = MapFactoryBean.class$("java.util.Map")) : class$java$util$Map;
    }

    protected Object createInstance() {
        if (this.sourceMap == null) {
            throw new IllegalArgumentException("'sourceMap' is required");
        }
        Map result = null;
        result = this.targetMapClass != null ? (Map)BeanUtils.instantiateClass(this.targetMapClass) : CollectionFactory.createLinkedMapIfPossible((int)this.sourceMap.size());
        Class keyType = null;
        Class valueType = null;
        if (this.targetMapClass != null && JdkVersion.isAtLeastJava15()) {
            keyType = GenericCollectionTypeResolver.getMapKeyType((Class)this.targetMapClass);
            valueType = GenericCollectionTypeResolver.getMapValueType((Class)this.targetMapClass);
        }
        if (keyType != null || valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object convertedKey = converter.convertIfNecessary(entry.getKey(), keyType);
                Object convertedValue = converter.convertIfNecessary(entry.getValue(), valueType);
                result.put(convertedKey, convertedValue);
            }
        } else {
            result.putAll(this.sourceMap);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

