/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.HeaderUtil;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MustUnderstandInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(MustUnderstandInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public MustUnderstandInterceptor() {
        super("pre-protocol");
    }

    public MustUnderstandInterceptor(String phase) {
        super(phase);
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) {
        SoapVersion soapVersion = soapMessage.getVersion();
        HashSet<Header> mustUnderstandHeaders = new HashSet<Header>();
        HashSet<URI> serviceRoles = new HashSet<URI>();
        HashSet<QName> notUnderstandHeaders = new HashSet<QName>();
        HashSet<Header> ultimateReceiverHeaders = new HashSet<Header>();
        HashSet<QName> mustUnderstandQNames = new HashSet<QName>();
        this.buildMustUnderstandHeaders(mustUnderstandHeaders, soapMessage, serviceRoles, ultimateReceiverHeaders);
        this.initServiceSideInfo(mustUnderstandQNames, soapMessage, serviceRoles);
        this.checkUnderstand(mustUnderstandHeaders, mustUnderstandQNames, notUnderstandHeaders);
        if (!notUnderstandHeaders.isEmpty()) {
            throw new SoapFault(new Message("MUST_UNDERSTAND", BUNDLE, notUnderstandHeaders), soapVersion.getMustUnderstand());
        }
        if (!ultimateReceiverHeaders.isEmpty() && !this.isRequestor(soapMessage)) {
            soapMessage.getInterceptorChain().add(new UltimateReceiverMustUnderstandInterceptor(mustUnderstandQNames));
        }
    }

    private void initServiceSideInfo(Set<QName> mustUnderstandQNames, SoapMessage soapMessage, Set<URI> serviceRoles) {
        Set<QName> paramHeaders = HeaderUtil.getHeaderQNameInOperationParam(soapMessage);
        if (paramHeaders != null) {
            mustUnderstandQNames.addAll(paramHeaders);
        }
        for (Interceptor interceptorInstance : soapMessage.getInterceptorChain()) {
            Set<QName> understoodHeaders;
            if (!(interceptorInstance instanceof SoapInterceptor)) continue;
            SoapInterceptor si = (SoapInterceptor)interceptorInstance;
            Set<URI> roles = si.getRoles();
            if (roles != null) {
                serviceRoles.addAll(roles);
            }
            if ((understoodHeaders = si.getUnderstoodHeaders()) == null) continue;
            mustUnderstandQNames.addAll(understoodHeaders);
        }
    }

    private void buildMustUnderstandHeaders(Set<Header> mustUnderstandHeaders, SoapMessage soapMessage, Set<URI> serviceRoles, Set<Header> ultimateReceiverHeaders) {
        for (Header header : soapMessage.getHeaders()) {
            if (!(header instanceof SoapHeader) || !((SoapHeader)header).isMustUnderstand()) continue;
            String role = ((SoapHeader)header).getActor();
            if (!StringUtils.isEmpty(role)) {
                if ((role = role.trim()).equals(soapMessage.getVersion().getNextRole())) {
                    mustUnderstandHeaders.add(header);
                    continue;
                }
                if (role.equals(soapMessage.getVersion().getUltimateReceiverRole())) {
                    ultimateReceiverHeaders.add(header);
                    continue;
                }
                for (URI roleFromBinding : serviceRoles) {
                    if (!role.equals(roleFromBinding.toString())) continue;
                    mustUnderstandHeaders.add(header);
                }
                continue;
            }
            ultimateReceiverHeaders.add(header);
        }
    }

    private void checkUnderstand(Set<Header> mustUnderstandHeaders, Set<QName> mustUnderstandQNames, Set<QName> notUnderstandHeaders) {
        for (Header header : mustUnderstandHeaders) {
            QName qname = header.getName();
            if (mustUnderstandQNames.contains(qname)) continue;
            notUnderstandHeaders.add(header.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UltimateReceiverMustUnderstandInterceptor
    extends AbstractSoapInterceptor {
        Set<QName> knownHeaders;

        public UltimateReceiverMustUnderstandInterceptor(Set<QName> knownHeaders) {
            super("invoke");
            this.knownHeaders = knownHeaders;
        }

        @Override
        public void handleMessage(SoapMessage soapMessage) throws Fault {
            SoapVersion soapVersion = soapMessage.getVersion();
            HashSet<QName> notFound = new HashSet<QName>();
            List<Header> heads = soapMessage.getHeaders();
            for (Header header : heads) {
                if (!(header instanceof SoapHeader) || !((SoapHeader)header).isMustUnderstand() || header.getDirection() != Header.Direction.DIRECTION_IN || this.knownHeaders.contains(header.getName()) || !StringUtils.isEmpty(((SoapHeader)header).getActor()) && !soapVersion.getUltimateReceiverRole().equals(((SoapHeader)header).getActor())) continue;
                notFound.add(header.getName());
            }
            if (!notFound.isEmpty()) {
                throw new SoapFault(new Message("MUST_UNDERSTAND", BUNDLE, notFound), soapVersion.getMustUnderstand());
            }
        }
    }
}

