/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopedName;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlPrimitive
extends IdlDefnImplBase
implements IdlType {
    static final short MINIMUM = 1;
    static final short LONG = 1;
    static final short ULONG = 2;
    static final short LONGLONG = 3;
    static final short ULONGLONG = 4;
    static final short SHORT = 5;
    static final short USHORT = 6;
    static final short FLOAT = 7;
    static final short DOUBLE = 8;
    static final short LONGDOUBLE = 9;
    static final short CHAR = 10;
    static final short WCHAR = 11;
    static final short BOOLEAN = 12;
    static final short OCTET = 13;
    static final short ANY = 14;
    static final short MAXIMUM = 15;
    static final short DATETIME = 15;
    private String wsdlName;
    private short type;

    private IdlPrimitive(IdlScopeBase parent, String name, String wsdlFileName, short typeValue) {
        super(parent, name);
        this.wsdlName = new String(wsdlFileName);
        this.type = typeValue;
    }

    public static IdlPrimitive create(IdlScopeBase parent, short type) {
        String name = null;
        String wsdlName = null;
        switch (type) {
            case 1: {
                name = new String("long");
                wsdlName = new String("long");
                break;
            }
            case 2: {
                name = new String("unsigned long");
                wsdlName = new String("ulong");
                break;
            }
            case 3: {
                name = new String("long long");
                wsdlName = new String("longlong");
                break;
            }
            case 4: {
                name = new String("unsigned long long");
                wsdlName = new String("ulonglong");
                break;
            }
            case 5: {
                name = new String("short");
                wsdlName = new String("short");
                break;
            }
            case 6: {
                name = new String("unsigned short");
                wsdlName = new String("ushort");
                break;
            }
            case 7: {
                name = new String("float");
                wsdlName = new String("float");
                break;
            }
            case 8: {
                name = new String("double");
                wsdlName = new String("double");
                break;
            }
            case 9: {
                name = new String("long double");
                wsdlName = new String("longdouble");
                break;
            }
            case 10: {
                name = new String("char");
                wsdlName = new String("char");
                break;
            }
            case 11: {
                name = new String("wchar");
                wsdlName = new String("wchar");
                break;
            }
            case 12: {
                name = new String("boolean");
                wsdlName = new String("boolean");
                break;
            }
            case 13: {
                name = new String("octet");
                wsdlName = new String("octet");
                break;
            }
            case 14: {
                name = new String("any");
                wsdlName = new String("any");
                break;
            }
            case 15: {
                name = new String("TimeBase::UtcT");
                wsdlName = new String("dateTime");
                break;
            }
        }
        return new IdlPrimitive(parent, name, wsdlName, type);
    }

    public String fullName() {
        return this.localName();
    }

    public String fullName(IdlScopedName rel) {
        return this.localName();
    }

    public IdlScopedName scopeName() {
        return null;
    }

    short primitiveType() {
        return this.type;
    }

    String wsdlName() {
        return this.wsdlName;
    }

    public void write(PrintWriter pw) {
        pw.print(this.localName());
    }
}

