/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.InitiatorToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.RecipientToken;
import org.apache.cxf.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class AsymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private InitiatorToken initiatorToken;
    private RecipientToken recipientToken;

    public AsymmetricBinding(SPConstants version) {
        super(version);
    }

    public InitiatorToken getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(InitiatorToken initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public RecipientToken getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(RecipientToken recipientToken) {
        this.recipientToken = recipientToken;
    }

    public QName getName() {
        return this.constants.getAsymmetricBinding();
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List<Assertion> configs = algorithmSuite.getConfigurations();
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        Iterator<Assertion> iterator = configs.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            AsymmetricBinding asymmetricBinding = new AsymmetricBinding(this.constants);
            asymmetricBinding.setAlgorithmSuite((AlgorithmSuite)iterator.next());
            asymmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            asymmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            asymmetricBinding.setInitiatorToken(this.getInitiatorToken());
            asymmetricBinding.setLayout(this.getLayout());
            asymmetricBinding.setProtectionOrder(this.getProtectionOrder());
            asymmetricBinding.setRecipientToken(this.getRecipientToken());
            asymmetricBinding.setSignatureProtection(this.isSignatureProtection());
            asymmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            asymmetricBinding.setTokenProtection(this.isTokenProtection());
            asymmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)wrapper);
        }
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.initiatorToken == null) {
            throw new RuntimeException("InitiatorToken is not set");
        }
        this.initiatorToken.serialize(writer);
        if (this.recipientToken == null) {
            throw new RuntimeException("RecipientToken is not set");
        }
        this.recipientToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite is not set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            writer.writeStartElement(prefix, "EncryptBeforeSigning", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, "EncryptSignature", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isTokenProtection()) {
            writer.writeStartElement(prefix, "ProtectTokens", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeStartElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

