/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionInfoMap
extends HashMap<QName, Collection<AssertionInfo>> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionInfoMap.class, "APIMessages");

    public AssertionInfoMap(Policy p) {
        this(AssertionInfoMap.getAssertions((PolicyOperator)p));
    }

    public AssertionInfoMap(Collection<PolicyAssertion> assertions) {
        super(assertions.size());
        for (PolicyAssertion a : assertions) {
            this.putAssertionInfo(a);
        }
    }

    private void putAssertionInfo(PolicyAssertion a) {
        Policy p = a.getPolicy();
        if (p != null) {
            for (PolicyAssertion na : AssertionInfoMap.getAssertions((PolicyOperator)p)) {
                this.putAssertionInfo(na);
            }
        }
        AssertionInfo ai = new AssertionInfo(a);
        ArrayList<AssertionInfo> ail = (ArrayList<AssertionInfo>)this.get(a.getName());
        if (ail == null) {
            ail = new ArrayList<AssertionInfo>();
            this.put(a.getName(), ail);
        }
        ail.add(ai);
    }

    public Collection<AssertionInfo> getAssertionInfo(QName name) {
        List<AssertionInfo> ail = (List<AssertionInfo>)this.get(name);
        return ail != null ? ail : CastUtils.cast(Collections.EMPTY_LIST, AssertionInfo.class);
    }

    public boolean supportsAlternative(Collection<PolicyAssertion> alternative, List<QName> errors) {
        boolean pass = true;
        for (PolicyAssertion a : alternative) {
            if (a.isAsserted(this)) continue;
            errors.add(a.getName());
            pass = false;
        }
        return pass;
    }

    public void checkEffectivePolicy(Policy policy) {
        ArrayList<QName> errors = new ArrayList<QName>();
        Iterator alternatives = policy.getAlternatives();
        while (alternatives.hasNext()) {
            List<PolicyAssertion> alternative = CastUtils.cast((List)alternatives.next(), PolicyAssertion.class);
            if (!this.supportsAlternative(alternative, errors)) continue;
            return;
        }
        StringBuilder error = new StringBuilder("\n");
        for (QName name : errors) {
            Collection<AssertionInfo> ais = this.getAssertionInfo(name);
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                error.append("\n      ");
                error.append(name.toString());
                if (ai.getErrorMessage() == null) continue;
                error.append(": ").append(ai.getErrorMessage());
            }
        }
        throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, error.toString()));
    }

    public void check() {
        for (Collection ais : this.values()) {
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                throw new PolicyException(new Message("NOT_ASSERTED_EXC", BUNDLE, ai.getAssertion().getName()));
            }
        }
    }

    private static Collection<PolicyAssertion> getAssertions(PolicyOperator p) {
        List<PolicyComponent> pcs = CastUtils.cast(p.getPolicyComponents(), PolicyComponent.class);
        if (pcs.size() == 0 || pcs.get(0) instanceof PolicyAssertion) {
            return CastUtils.cast(pcs, PolicyAssertion.class);
        }
        ArrayList<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();
        for (PolicyComponent pc : pcs) {
            assertions.addAll(AssertionInfoMap.getAssertions((PolicyOperator)pc));
        }
        return assertions;
    }
}

