/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.features.Feature;
import org.apache.abdera.ext.features.Features;
import org.apache.abdera.ext.features.Selector;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;

public final class FeaturesHelper {
    public static final String FNS = "http://purl.org/atompub/features/1.0";
    public static final QName FEATURE = new QName("http://purl.org/atompub/features/1.0", "feature", "f");
    public static final QName FEATURES = new QName("http://purl.org/atompub/features/1.0", "features", "f");
    public static final QName TYPE = new QName("http://purl.org/atompub/features/1.0", "type", "f");
    private static final String FEATURE_BASE = "http://www.w3.org/2007/app/";
    private static final String ABDERA_FEATURE_BASE = "http://incubator.apache.org/abdera/features/";
    private static final String BLOG_FEATURE_BASE = "http://incubator.apache.org/abdera/features/blog/";
    public static final String FEATURE_SUPPORTS_DRAFTS = "http://www.w3.org/2007/app/supportsDraft";
    public static final String FEATURE_IGNORES_DRAFTS = "http://www.w3.org/2007/app/ignoresDraft";
    public static final String FEATURE_SUPPORTS_XHTML_CONTENT = "http://incubator.apache.org/abdera/features/supportsXhtmlContent";
    public static final String FEATURE_REQUIRES_XHTML_CONTENT = "http://incubator.apache.org/abdera/features/requiresXhtmlContent";
    public static final String FEATURE_SUPPORTS_HTML_CONTENT = "http://incubator.apache.org/abdera/features/supportsHtmlContent";
    public static final String FEATURE_REQUIRES_HTML_CONTENT = "http://incubator.apache.org/abdera/features/requiresHtmlContent";
    public static final String FEATURE_SUPPORTS_TEXT_CONTENT = "http://incubator.apache.org/abdera/features/supportsTextContent";
    public static final String FEATURE_REQUIRES_TEXT_CONTENT = "http://incubator.apache.org/abdera/features/requiresTextContent";
    public static final String FEATURE_SUPPORTS_XML_CONTENT = "http://incubator.apache.org/abdera/features/supportsXmlContent";
    public static final String FEATURE_REQUIRES_XML_CONTENT = "http://incubator.apache.org/abdera/features/requiresXmlContent";
    public static final String FEATURE_SUPPORTS_BINARY_CONTENT = "http://incubator.apache.org/abdera/features/supportsBinaryContent";
    public static final String FEATURE_REQUIRES_BINARY_CONTENT = "http://incubator.apache.org/abdera/features/requiresBinaryContent";
    public static final String FEATURE_SUPPORTS_REF_CONTENT = "http://incubator.apache.org/abdera/features/supportsRefContent";
    public static final String FEATURE_REQUIRES_REF_CONTENT = "http://incubator.apache.org/abdera/features/requiresRefContent";
    public static final String FEATURE_SUPPORTS_XHTML_TEXT = "http://incubator.apache.org/abdera/features/supportsXhtmlText";
    public static final String FEATURE_REQUIRES_XHTML_TEXT = "http://incubator.apache.org/abdera/features/requiresXhtmlText";
    public static final String FEATURE_SUPPORTS_HTML_TEXT = "http://incubator.apache.org/abdera/features/supportsHtmlText";
    public static final String FEATURE_REQUIRES_HTML_TEXT = "http://incubator.apache.org/abdera/features/requiresHtmlText";
    public static final String FEATURE_SUPPORTS_TEXT_TEXT = "http://incubator.apache.org/abdera/features/supportsTextText";
    public static final String FEATURE_REQUIRES_TEXT_TEXT = "http://incubator.apache.org/abdera/features/requiresTextText";
    public static final String FEATURE_PRESERVES_SUMMARY = "http://incubator.apache.org/abdera/features/preservesSummary";
    public static final String FEATURE_IGNORES_SUMMARY = "http://incubator.apache.org/abdera/features/ignoresSummary";
    public static final String FEATURE_PRESERVES_RIGHTS = "http://incubator.apache.org/abdera/features/preservesRights";
    public static final String FEATURE_IGNORES_RIGHTS = "http://incubator.apache.org/abdera/features/ignoresRights";
    public static final String FEATURE_PRESERVES_AUTHORS = "http://incubator.apache.org/abdera/features/preservesAuthors";
    public static final String FEATURE_IGNORES_AUTHORS = "http://incubator.apache.org/abdera/features/ignoresAuthors";
    public static final String FEATURE_PRESERVES_CONTRIBUTORS = "http://incubator.apache.org/abdera/features/preservesContributors";
    public static final String FEATURE_IGNORES_CONTRIBUTORS = "http://incubator.apache.org/abdera/features/ignoresContributors";
    public static final String FEATURE_USES_SLUG = "http://incubator.apache.org/abdera/features/usesSlug";
    public static final String FEATURE_IGNORES_SLUG = "http://incubator.apache.org/abdera/features/ignoresSlug";
    public static final String FEATURE_PRESERVES_CATEGORIES = "http://incubator.apache.org/abdera/features/preservesCategories";
    public static final String FEATURE_MULTIPLE_CATEGORIES = "http://incubator.apache.org/abdera/features/multipleCategories";
    public static final String FEATURE_IGNORES_CATEGORIES = "http://incubator.apache.org/abdera/features/ignoresCategories";
    public static final String FEATURE_PRESERVES_LINKS = "http://incubator.apache.org/abdera/features/preservesLinks";
    public static final String FEATURE_IGNORES_LINKS = "http://incubator.apache.org/abdera/features/ignoresLinks";
    public static final String FEATURE_PRESERVES_INFOSET = "http://incubator.apache.org/abdera/features/preservesInfoset";
    public static final String FEATURE_PRESERVES_ID = "http://incubator.apache.org/abdera/features/preservesId";
    public static final String FEATURE_PRESERVES_DATES = "http://incubator.apache.org/abdera/features/preservesDates";
    public static final String FEATURE_PRESERVES_EXTENSIONS = "http://incubator.apache.org/abdera/features/preservesExtensions";
    public static final String FEATURE_SCHEDULED_PUBLISHING = "http://incubator.apache.org/abdera/features/scheduledPublishing";
    public static final String FEATURE_REQUIRES_PERSON_EMAIL = "http://incubator.apache.org/abdera/features/requiresPersonEmail";
    public static final String FEATURE_HIDES_PERSON_EMAIL = "http://incubator.apache.org/abdera/features/hidesPersonEmail";
    public static final String FEATURE_REQUIRES_PERSON_URI = "http://incubator.apache.org/abdera/features/requiresPersonUri";
    public static final String FEATURE_HIDES_PERSON_URI = "http://incubator.apache.org/abdera/features/hidesPersonUri";
    public static final String FEATURE_PRESERVES_LANGUAGE = "http://incubator.apache.org/abdera/features/preservesXmlLang";
    public static final String FEATURE_IGNORES_LANGUAGE = "http://incubator.apache.org/abdera/features/ignoresXmlLang";
    public static final String FEATURE_SUPPORTS_CONDITIONALS = "http://incubator.apache.org/abdera/features/supportsConditionalUpdates";
    public static final String FEATURE_REQUIRES_CONDITIONALS = "http://incubator.apache.org/abdera/features/requiresConditionalUpdates";
    public static final String FEATURE_PRESERVES_THREADING = "http://incubator.apache.org/abdera/features/preservesThreading";
    public static final String FEATURE_REQUIRES_THREADING = "http://incubator.apache.org/abdera/features/requiresThreading";
    public static final String FEATURE_IGNORES_THREADING = "http://incubator.apache.org/abdera/features/ignoresThreading";
    public static final String FEATURE_PRESERVE_SIGNATURE = "http://incubator.apache.org/abdera/features/preservesSignature";
    public static final String FEATURE_SUPPORTS_SIGNATURE = "http://incubator.apache.org/abdera/features/supportsSignature";
    public static final String FEATURE_IGNORES_SIGNATURE = "http://incubator.apache.org/abdera/features/ignoresSignature";
    public static final String FEATURE_REQUIRES_SIGNATURE = "http://incubator.apache.org/abdera/features/requiresSignature";
    public static final String FEATURE_SIGNED_RESPONSE = "http://incubator.apache.org/abdera/features/responseSignature";
    public static final String FEATURE_SUPPORTS_BIDI = "http://incubator.apache.org/abdera/features/supportsBidi";
    public static final String FEATURE_REQUIRES_BIDI = "http://incubator.apache.org/abdera/features/requiresBidi";
    public static final String FEATURE_IGNORES_BIDI = "http://incubator.apache.org/abdera/features/ignoresBidi";
    public static final String FEATURE_SUPPORTS_GEO = "http://incubator.apache.org/abdera/features/supportsGeo";
    public static final String FEATURE_REQUIRES_GEO = "http://incubator.apache.org/abdera/features/requiresGeo";
    public static final String FEATURE_IGNORES_GEO = "http://incubator.apache.org/abdera/features/ignoresGeo";
    public static final String FEATURE_SUPPORTS_SHARING = "http://incubator.apache.org/abdera/features/supportsSharing";
    public static final String FEATURE_REQUIRES_SHARING = "http://incubator.apache.org/abdera/features/requiresSharing";
    public static final String FEATURE_IGNORES_SHARING = "http://incubator.apache.org/abdera/features/ignoresSharing";
    public static final String FEATURE_REQUIRES_GOOGLELOGIN = "http://incubator.apache.org/abdera/features/requiresGoogleLogin";
    public static final String FEATURE_SUPPORTS_GOOGLELOGIN = "http://incubator.apache.org/abdera/features/supportsGoogleLogin";
    public static final String FEATURE_REQUIRES_WSSE = "http://incubator.apache.org/abdera/features/requiresWsse";
    public static final String FEATURE_SUPPORTS_WSSE = "http://incubator.apache.org/abdera/features/supportsWsse";
    public static final String FEATURE_FILTERS_MARKUP = "http://incubator.apache.org/abdera/features/blog/filtersUnsafeMarkup";
    private static Map<String, Features> featuresCache = Collections.synchronizedMap(new WeakHashMap());

    private FeaturesHelper() {
    }

    private static Features getCachedFeatures(String iri) {
        return featuresCache.get(iri);
    }

    private static void setCachedFeatures(String iri, Features features) {
        featuresCache.put(iri, features);
    }

    public static void flushCachedFeatures() {
        featuresCache.clear();
    }

    public static Features newFeatures(Abdera abdera) {
        Factory factory = abdera.getFactory();
        Document doc = factory.newDocument();
        Features features = (Features)factory.newElement(FEATURES, (Base)doc);
        doc.setRoot((Element)features);
        return features;
    }

    public static Features getFeaturesElement(Collection collection) {
        return FeaturesHelper.getFeaturesElement(collection, true);
    }

    public static Features getFeaturesElement(Collection collection, boolean outofline) {
        String iri;
        Features features = (Features)collection.getExtension(FEATURES);
        if (features != null && outofline && features.getHref() != null && (features = FeaturesHelper.getCachedFeatures(iri = features.getResolvedHref().toASCIIString())) == null) {
            Abdera abdera = collection.getFactory().getAbdera();
            AbderaClient client = new AbderaClient(abdera);
            ClientResponse resp = client.get(iri);
            if (resp.getType() == Response.ResponseType.SUCCESS) {
                Document doc = resp.getDocument();
                features = (Features)doc.getRoot();
                FeaturesHelper.setCachedFeatures(iri, features);
            } else {
                features = null;
            }
        }
        return features;
    }

    public static Feature getFeature(Collection collection, String feature) {
        return FeaturesHelper.getFeature(FeaturesHelper.getFeaturesElement(collection), feature);
    }

    public static Feature getFeature(Features features, String feature) {
        if (features == null) {
            return null;
        }
        List list = features.getExtensions(FEATURE);
        for (Element el : list) {
            if (!el.getAttributeValue("ref").equals(feature)) continue;
            return (Feature)el;
        }
        return null;
    }

    public static Status getFeatureStatus(Collection collection, String feature) {
        return FeaturesHelper.getFeatureStatus(FeaturesHelper.getFeaturesElement(collection), feature);
    }

    public static Status getFeatureStatus(Features features, String feature) {
        if (features == null) {
            return Status.UNSPECIFIED;
        }
        Feature f = FeaturesHelper.getFeature(features, feature);
        return f != null ? Status.SPECIFIED : Status.UNSPECIFIED;
    }

    public static Feature[] getFeatures(Collection collection) {
        Features features = FeaturesHelper.getFeaturesElement(collection);
        if (features == null) {
            return null;
        }
        List list = features.getExtensions(FEATURE);
        return list.toArray(new Feature[list.size()]);
    }

    public static Features addFeaturesElement(Collection collection) {
        if (FeaturesHelper.getFeaturesElement(collection, false) != null) {
            throw new IllegalArgumentException("A collection element can only contain one features element");
        }
        return (Features)collection.addExtension(FEATURES);
    }

    public static Collection[] select(Service service, Selector selector) {
        return FeaturesHelper.select(service, new Selector[]{selector});
    }

    public static Collection[] select(Service service, Selector ... selectors) {
        ArrayList<Collection> list = new ArrayList<Collection>();
        for (Workspace workspace : service.getWorkspaces()) {
            Collection[] collections;
            for (Collection collection : collections = FeaturesHelper.select(workspace, selectors)) {
                list.add(collection);
            }
        }
        return list.toArray(new Collection[list.size()]);
    }

    public static Collection[] select(Workspace workspace, Selector selector) {
        return FeaturesHelper.select(workspace, new Selector[]{selector});
    }

    public static Collection[] select(Workspace workspace, Selector ... selectors) {
        ArrayList<Collection> list = new ArrayList<Collection>();
        for (Collection collection : workspace.getCollections()) {
            boolean accept = true;
            for (Selector selector : selectors) {
                if (selector.select(collection)) continue;
                accept = false;
                break;
            }
            if (!accept) continue;
            list.add(collection);
        }
        return list.toArray(new Collection[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNSPECIFIED,
        SPECIFIED;

    }
}

