package com.nortel.soa.oi.openq;

import java.util.Iterator;

import com.nortel.soa.oi.cct.basenotification.NotificationEventHolderType;
import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer;

@javax.jws.WebService(
		name = "NotificationConsumer", 
		serviceName = "SOAOICCT_NotificationConsumer",
		portName = "NotificationConsumer",
		targetNamespace = "http://www.nortel.com/soa/oi/cct/NotificationConsumer",
		endpointInterface = "com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer")

public class OIOpenQConsumerImpl implements NotificationConsumer {

	/* (non-Javadoc)
	 * @see com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer#notify(java.util.List<com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType>  notificationMessage )*
	 * 
	 * Keep count of the notifications received etc, and make available to test code 
	 * to verify test results...
	 */
	public void notify(java.util.List<com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType> notificationMessageHolderList) { 

		System.out.println("Executing operation notify");

		try {

			synchronized (this) {

				Iterator<NotificationMessageHolderType> notificationMessageHolderIter = notificationMessageHolderList.iterator();
				while ( notificationMessageHolderIter.hasNext() ) {
					NotificationMessageHolderType notificationMessageHolder = notificationMessageHolderIter.next();

					if ( notificationMessageHolder.getSessionId() != null ) {
						System.out.println("SessionId : " + notificationMessageHolder.getSessionId());
						System.out.println("SessionId : " + notificationMessageHolder.getSessionId());
					}
					
					if ( notificationMessageHolder.getSubscriptionId() != null ) {
						System.out.println("SubscriptionId : " + notificationMessageHolder.getSubscriptionId());
						System.out.println("SubscriptionId : " + notificationMessageHolder.getSubscriptionId());
					}

					if ( notificationMessageHolder.getTimestamp() != null ) {
						System.out.println("Timestamp : " + notificationMessageHolder.getTimestamp().toString());
						System.out.println("Timestamp : " + notificationMessageHolder.getTimestamp().toString());
					}

					NotificationEventHolderType notificationEventHolder = notificationMessageHolder.getMessage();

					System.err.println("EVENT : " + notificationEventHolder.getEventType().toString());
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
	}
}