package com.nortel.soa.oi.openq;

import java.util.HashMap;

public class ContactDetails {

	private int externalContactId = 0;
	private String outOfProviderAddress = null;
	private HashMap<String, String> intrinsics = null;
	
	public ContactDetails() {
		super();
	}
	
	public ContactDetails(
			int externalContactId, 
			String outOfProviderAddress, 
			HashMap<String, String> intrinsics) {
		super();
		this.externalContactId = externalContactId;
		this.outOfProviderAddress = outOfProviderAddress;
		this.intrinsics = intrinsics;
	}

	public int getExternalContactId() {
		return externalContactId;
	}

	public void setExternalContactId(int externalContactId) {
		this.externalContactId = externalContactId;
	}

	public String getOutOfProviderAddress() {
		return outOfProviderAddress;
	}

	public void setOutOfProviderAddress(String outOfProviderAddress) {
		this.outOfProviderAddress = outOfProviderAddress;
	}

	public HashMap<String, String> getIntrinsics() {
		return intrinsics;
	}

	public void setIntrinsics(HashMap<String, String> intrinsics) {
		this.intrinsics = intrinsics;
	}
	
	@Override
	public String toString() {
		
		StringBuffer buf = new StringBuffer();

		buf.append("ContactDetails");
		buf.append("\n");
		
		buf.append("ExternalContactId :");
		buf.append(externalContactId);
		buf.append("\n");

		if ( outOfProviderAddress != null ) {
			buf.append("OutOfProviderAddressExtId :");
			buf.append(outOfProviderAddress);
			buf.append("\n");
		}

		if ( intrinsics != null ) {
			buf.append("Intrinsics :");
			buf.append(intrinsics.toString());
			buf.append("\n");
		}
		
		return buf.toString();
	}
}
