﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;
using System.ServiceModel.Description;

namespace CCMAOpenInterfaces
{
    public partial class UserMaintenance : Form
    {
        private string userToken;
        private string ccmaURL;
        private string originalUserLoginID = "";
        private string cookieName;
        private string UserID;
        ChannelFactory<OIWebReference.soap> oiChannelFactory = null;
        ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = null;

        public UserMaintenance(string Token, string URL, string COOKIE, string strUserID)
        {
            InitializeComponent();
            userToken = Token;
            ccmaURL = URL;
            cookieName = COOKIE;
            UserID = strUserID;
            Cursor.Current = Cursors.WaitCursor;
            GetServerList();
            Cursor.Current = Cursors.Default;

        }

        public void GetServerList()
        {
            /* ***********************************************************************************************
             * This method contains calls to multiple server versions to reflect the changes 
             * introduced in AACC 6.4.1
             * ----------------------getServersList() - AACC 6.4.1 Changes -------------------------------
             * This method returns an array of CCMSServer objects. Each CCMSServer object contains 
             * a ServerType object which in turn  contains a Name property. The Name property is of type 
             * serverTypeName which is an enumerated list. New server types have been added in 6.4.1 so a 
             * new enum is required: serverTypeName_Ex. The new server types and id’s are:
             * CCPO	(1005)
             * AMS	(1006)
             * IPO	(1007)
             * The ServerType object now contains a new property Name_Ex of type serverTypeName_Ex. 
             * This will be populated by 6.4.1 and later servers. 
             * 
             * ***********************************************************************************************/


            OIWebReference.CCMSServer[] ccmsServers;
            OIWebReference_62.CCMSServer[] ccmsServers_62;
            string errorMessage;
            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62;


            //Add in dummy CCMS server address
            cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");
            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    requestProperty.Headers["NTSSOCookie"] = userToken;
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    try
                    {
                        int count = oiService.getServerList(out ccmsServers, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference.CCMSServer srvr in ccmsServers)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    requestProperty.Headers["NTSSOCookie"] = userToken;
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    try
                    {
                        int count = oiService_62.getServerList(out ccmsServers_62, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference_62.CCMSServer srvr in ccmsServers_62)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else
            {
                MessageBox.Show("Open interface version not supported!!");
            }
        }

        /// <summary>
        /// Setup the basic web service connection
        /// </summary>
        /// <param name="errorMessage">Error message string</param>
        /// <param name="oiService">Service Reference</param>
        private void ConnectionSetup(out string errorMessage, out OIWebReference.soap oiService)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            oiService = oiChannelFactory.CreateChannel();
        }

        private void ConnectionSetup_62(out string errorMessage, out OIWebReference_62.soap oiService_62)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
            oiService_62 = oiChannelFactory_62.CreateChannel();
        }
        private void ConnectionShutdown_62()
        {
            if (null != oiChannelFactory_62)
                oiChannelFactory_62.Close();
        }


        private void ConnectionShutdown()
        {
            if (null != oiChannelFactory)
                oiChannelFactory.Close();
        }

        private void cboServerList_SelectedIndexChanged(object sender, EventArgs e)
        {
            PopulateUsers();
            PopulateClasses();

        }


        public void ClearFields()
        {
            foreach (DataGridViewRow dvr in dgvSkillsets.Rows)
            {
                dvr.Cells[1].Value = "Unassigned";
            }

            for (int i = 0; i < cklbContactTypes.Items.Count; i++)
            {
                cklbContactTypes.SetItemCheckState(i, CheckState.Unchecked);
            }
        }

        private void dgvUsers_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            /* ***********************************************************************************************
             * This method makes to calls to multiple server versions to reflect the changes made in
             * AACC 6.4.1
             * --------------------------------- AACC 6.4.1 Changes --------------------------------------
             * The UserDetails object contains an array of ContactTypeAndRelatedSkillsets objects. 
             * Each of the ContactTypeAndRelatedSkillsets contains the ContactType attributes including a 
             * prefix property of type SkillsetPrefix which is an enumerated list of prefixes for the contact 
             * types (e.g. “EM_” for email). The enum cannot be extended so a new enum has been added,
             * SkillsetPrefix_Ex, which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The ContactType object has been extended to contain a “prefix_Ex” property 
             * in addition to the “Prefix” property. The “prefix_Ex” property should be used when interacting 
             * with a 6.4.1 or later CCMA server. The “prefix” property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for 
             * each skillset of a given contact type. The  SkillsetFullDetails  object contains a ContactTypeID 
             * property of type int. The range of values that can be returned in this int has been extended to 
             * handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             ************************************************************************************************/



            if (e.RowIndex == -1)
                return;

            if (dgvUsers.SelectedRows.Count == 0)
                return;

            Cursor.Current = Cursors.WaitCursor;

            ClearFields();
            string ccmsIP = string.Empty;

            if (ckbIncludeInvalidCCMSIP.Checked)
                ccmsIP = "172.15.15.15";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            string errorMessage = string.Empty;
            string loginID = dgvUsers.SelectedRows[0].Cells[0].Value.ToString();

            OIWebReference.UserDetails user;
            OIWebReference_62.UserDetails user_62;
            OIWebReference.ContactTypeAndRelatedSkillsets[] contactSkillsetList;
            OIWebReference_62.ContactTypeAndRelatedSkillsets[] contactSkillsetList_62;
            OIWebReference.AgentBasicDetails[] assignedAgents;
            OIWebReference_62.AgentBasicDetails[] assignedAgents_62;
            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);

            // 6.4+ 
            if (Global.Version == SystemVersion.SixFour)
            {
                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    try
                    {
                        oiService.getUserDetails(out user, out errorMessage, loginID, ccmsIP);


                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getUserDetails returned an error " + errorMessage);
                        else
                        {
                            if (user.voiceURI != "")
                                ckbSIPAgent.Checked = true;

                            txtcmAgent.Text = user.cmID;
                            txtcmAgentID.Text = user.cmAgentID;
                            txtPositionID.Text = user.positionID.ToString();
                            txtTNName.Text = user.tnName;
                            txtUserID.Text = user.userID;
                            txtLocalID.Text = user.localID.ToString();
                            txtAuthenticationAccountType.Text = user.authenticationAccountType.ToString();
                            txtFirstName.Text = user.firstName;
                            txtLastName.Text = user.lastName;
                            txtTitle.Text = user.title;
                            txtDepartment.Text = user.department;
                            txtLanguage.Text = user.languageID.ToString();
                            txtComment.Text = user.comment;
                            txtUserType.Text = user.userType.ToString();
                            txtLoginID.Text = user.loginID;
                            //store the original login ID
                            originalUserLoginID = user.loginID;

                            if (ckbSIPAgent.Checked)
                            {
                                txtPersonnalDN.Text = user.voiceURI;
                                txtACDQueue.Text = user.iMURI;
                            }
                            else
                            {
                                txtPersonnalDN.Text = user.personalDN;
                                txtACDQueue.Text = user.defaultACDQueue;
                            }
                            txtACDQueueError.Text = user.defaultACDQueueErrorCode.ToString();
                            ckbIsSupervisor.Checked = user.isSuper;
                            txtCCTUserName.Text = user.userName;
                            ckbCreateCCTAgent.Checked = user.cctAgentEnabled;
                            txtCCTPassword.Text = user.password;
                            txtCCTDomain.Text = user.domain;
                            txtSupervisorID.Text = user.supervisorID.ToString();
                            txtSupervisorLoginID.Text = user.supervisorLoginID;
                            assignedAgents = user.assignedAgentDetails;
                            lbAssignedAgents.Items.Clear();

                            if (assignedAgents != null)
                            {
                                foreach (OIWebReference.AgentBasicDetails agt in assignedAgents)
                                {
                                    lbAssignedAgents.Items.Add(agt.firstName + " " + agt.lastName + ", " + agt.phoneSetLoginID);
                                }
                            }

                            txtAgentKey.Text = user.agentKey.ToString();
                            if (user.loggedIn)
                                txtLoginStatus.Text = "Logged In";
                            else
                                txtLoginStatus.Text = "Logged Out";
                            cboCPC.Text = user.callPresentationClassID.ToString();
                            cboMPC.Text = user.multiplicityPresentationClassID.ToString();
                            cboThreshold.Text = user.thresholdID.ToString();
                            contactSkillsetList = user.assignedContactsandSkillsets;
                            ckbCTIEnabled.Checked = user.agentCTIEnabled;
                            if (contactSkillsetList != null)
                            {
                                foreach (OIWebReference.ContactTypeAndRelatedSkillsets conType in contactSkillsetList)
                                {
                                    if (conType.isAssigned)
                                    {
                                        //loop through contact types check box list and enable related 
                                        for (int i = 0; i < cklbContactTypes.Items.Count; i++)
                                        {
                                            if (cklbContactTypes.Items[i].ToString().Split(',')[0] == conType.ID.ToString())
                                            {
                                                int y = cklbContactTypes.Items.IndexOf(conType.ID + "," + conType.Name);
                                                cklbContactTypes.SetItemCheckState(y, CheckState.Checked);
                                            }
                                        }
                                        foreach (OIWebReference.SkillsetFullDetails skillset in conType.skillsetsOfThisContactType)
                                        {
                                            foreach (DataGridViewRow dvr in dgvSkillsets.Rows)
                                            {
                                                if (dvr.Cells[0].Value.ToString() == skillset.Name)
                                                {
                                                    if (skillset.Priority == 0)
                                                        dvr.Cells[1].Value = skillset.Status;
                                                    else
                                                        dvr.Cells[1].Value = skillset.Priority;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            #region AgentGreeting values
                            tbAgtGreetingPwd.Text = user.agentGreetingPasswd;
                            cbAgtgreetingEnabled.Checked = user.agentGreetingState;
                            cbAgtGreetingRec.Checked = user.agentGreetingRecorded;

                            #endregion

                            #region 6.4.2 Updates
                            if (user.dnObserveEnabled > 0)
                            {
                                ckbDNObserveEnabled.Checked = true;
                            }
                            else
                            {
                                ckbDNObserveEnabled.Checked = false;
                            }

                            if (user.dnBargeInEnabled > 0)
                            {
                                ckbDNBargeInEnabled.Checked = true;
                            }
                            else
                            {
                                ckbDNBargeInEnabled.Checked = false;
                            } 


                            #endregion 
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error running GetUserdetails. Details: " + Ex.Message);
                        Cursor.Current = Cursors.Default;
                    }

                    Cursor.Current = Cursors.Default;
                }

            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    try
                    {
                        oiService_62.getUserDetails(out user_62, out errorMessage, loginID, ccmsIP);


                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getUserDetails returned an error " + errorMessage);
                        else
                        {
                            if (user_62.voiceURI != "")
                                ckbSIPAgent.Checked = true;

                            txtcmAgent.Text = user_62.cmID;
                            txtcmAgentID.Text = user_62.cmAgentID;
                            txtPositionID.Text = user_62.positionID.ToString();
                            txtTNName.Text = user_62.tnName;
                            txtUserID.Text = user_62.userID;
                            txtLocalID.Text = user_62.localID.ToString();
                            txtAuthenticationAccountType.Text = user_62.authenticationAccountType.ToString();
                            txtFirstName.Text = user_62.firstName;
                            txtLastName.Text = user_62.lastName;
                            txtTitle.Text = user_62.title;
                            txtDepartment.Text = user_62.department;
                            txtLanguage.Text = user_62.languageID.ToString();
                            txtComment.Text = user_62.comment;
                            txtUserType.Text = user_62.userType.ToString();
                            txtLoginID.Text = user_62.loginID;
                            //store the original login ID
                            originalUserLoginID = user_62.loginID;

                            if (ckbSIPAgent.Checked)
                            {
                                txtPersonnalDN.Text = user_62.voiceURI;
                                txtACDQueue.Text = user_62.iMURI;
                            }
                            else
                            {
                                txtPersonnalDN.Text = user_62.personalDN;
                                txtACDQueue.Text = user_62.defaultACDQueue;
                            }
                            txtACDQueueError.Text = user_62.defaultACDQueueErrorCode.ToString();
                            ckbIsSupervisor.Checked = user_62.isSuper;
                            txtCCTUserName.Text = user_62.userName;
                            ckbCreateCCTAgent.Checked = user_62.cctAgentEnabled;
                            txtCCTPassword.Text = user_62.password;
                            txtCCTDomain.Text = user_62.domain;
                            txtSupervisorID.Text = user_62.supervisorID.ToString();
                            txtSupervisorLoginID.Text = user_62.supervisorLoginID;
                            assignedAgents_62 = user_62.assignedAgentDetails;
                            lbAssignedAgents.Items.Clear();

                            if (assignedAgents_62 != null)
                            {
                                foreach (OIWebReference_62.AgentBasicDetails agt in assignedAgents_62)
                                {
                                    lbAssignedAgents.Items.Add(agt.firstName + " " + agt.lastName + ", " + agt.phoneSetLoginID);
                                }
                            }

                            txtAgentKey.Text = user_62.agentKey.ToString();
                            if (user_62.loggedIn)
                                txtLoginStatus.Text = "Logged In";
                            else
                                txtLoginStatus.Text = "Logged Out";
                            cboCPC.Text = user_62.callPresentationClassID.ToString();
                            cboMPC.Text = user_62.multiplicityPresentationClassID.ToString();
                            cboThreshold.Text = user_62.thresholdID.ToString();
                            contactSkillsetList_62 = user_62.assignedContactsandSkillsets;
                            ckbCTIEnabled.Checked = user_62.agentCTIEnabled;
                            if (contactSkillsetList_62 != null)
                            {
                                foreach (OIWebReference_62.ContactTypeAndRelatedSkillsets conType in contactSkillsetList_62)
                                {
                                    if (conType.isAssigned)
                                    {
                                        //loop through contact types check box list and enable related 
                                        for (int i = 0; i < cklbContactTypes.Items.Count; i++)
                                        {
                                            if (cklbContactTypes.Items[i].ToString().Split(',')[0] == conType.ID.ToString())
                                            {
                                                int y = cklbContactTypes.Items.IndexOf(conType.ID + "," + conType.Name);
                                                cklbContactTypes.SetItemCheckState(y, CheckState.Checked);
                                            }
                                        }
                                        foreach (OIWebReference_62.SkillsetFullDetails skillset in conType.skillsetsOfThisContactType)
                                        {
                                            foreach (DataGridViewRow dvr in dgvSkillsets.Rows)
                                            {
                                                if (dvr.Cells[0].Value.ToString() == skillset.Name)
                                                {
                                                    if (skillset.Priority == 0)
                                                        dvr.Cells[1].Value = skillset.Status;
                                                    else
                                                        dvr.Cells[1].Value = skillset.Priority;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            #region AgentGreeting values
                            tbAgtGreetingPwd.Text = user_62.agentGreetingPasswd;
                            cbAgtgreetingEnabled.Checked = user_62.agentGreetingState;
                            cbAgtGreetingRec.Checked = user_62.agentGreetingRecorded;

                            #endregion
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error running GetUserdetails. Details: " + Ex.Message);
                        Cursor.Current = Cursors.Default;
                    }

                    Cursor.Current = Cursors.Default;
                }

            }
            else
            {
                MessageBox.Show("System Version not supported!");
            }

        }

        public void PopulateUsers()
        {
            /* ****************************************************************************************************************************
             * This method makes calls to multiple server versions to reflect changes 
             * introduced in AACC 6.4.1 to getAgentsList() 
             * ---------------------------------------------- AACC 6.4.1 Changes ----------------------------------------------------------
             * The AgentFullDetails contains a new property “offsiteAllowed” of type integer (0 = Disabled, 1 = Enabled).
             * The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the 
             * ContactTypeAndRelatedSkillsets contains the ContactType attributes including a prefix property of type 
             * SkillsetPrefix which is an enumerated list of prefixes for the contact types (e.g. “EM_” for email). 
             * The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The ContactType object has been extended to contain a “prefix_Ex” property in addition to the “Prefix” 
             * property. The “prefix_Ex” property should be used when interacting with a 6.4.1 or later CCMA server. 
             * The “prefix” property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for
             * each skillset of a given contact type. The  SkillsetFullDetails  object contains a ContactTypeID property 
             * of type int. The range of values that can be returned in this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             * *****************************************************************************************************************************/



            string ccmsIP = cboServerList.Text.Split(',')[0];

            OIWebReference.AgentFullDetails[] agentDetails;
            OIWebReference_62.AgentFullDetails[] agentDetails_62;
            OIWebReference.AgentBasicDetails[] superDetails;
            OIWebReference_62.AgentBasicDetails[] superDetails_62;
            string errorMessage = string.Empty;

            dgvUsers.Rows.Clear();

            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62;

            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);

                //Add this line before each web method if the result set is very large, i.e. greater than 800 agents 
                oiChannelFactory.Endpoint.Contract.Operations.Find("getAgentsList").Behaviors.Find<DataContractSerializerOperationBehavior>().MaxItemsInObjectGraph = 2147483647;

                //Add dummy agent for testing exceptions

                int m = dgvUsers.Rows.Add();
                dgvUsers.Rows[m].Cells[0].Value = "1234";
                dgvUsers.Rows[m].Cells[1].Value = "DummyFName";
                dgvUsers.Rows[m].Cells[2].Value = "DummyLName";
                dgvUsers.Rows[m].Cells[3].Value = "AGENT";
                dgvUsers.Rows[m].Cells[4].Value = "false";

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (ckbExcludeToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        bool result = oiService.getAgentsList(out agentDetails, out errorMessage, ccmsIP);

                        if (result)
                            MessageBox.Show("Web service getAgentsList returned " + agentDetails.Length.ToString());

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getAgentsList returned an error " + errorMessage);

                        if (!result)
                            MessageBox.Show("GetAgentList returned false!");
                        else
                        {
                            foreach (OIWebReference.AgentFullDetails agent in agentDetails)
                            {
                                int n = dgvUsers.Rows.Add();
                                dgvUsers.Rows[n].Cells[0].Value = agent.phoneSetLoginID;
                                dgvUsers.Rows[n].Cells[1].Value = agent.firstName;
                                dgvUsers.Rows[n].Cells[2].Value = agent.lastName;
                                dgvUsers.Rows[n].Cells[3].Value = agent.type.ToString();
                                dgvUsers.Rows[n].Cells[4].Value = agent.isLoggedIn.ToString();
                            }
                        }

                        errorMessage = string.Empty;

                        result = oiService.getSupervisorList(out superDetails, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getSupervisorList returned an error " + errorMessage);

                        if (!result)
                            MessageBox.Show("GetSupervisorList returned false!");
                        else
                        {
                            foreach (OIWebReference.AgentBasicDetails super in superDetails)
                            {
                                int n = dgvUsers.Rows.Add();
                                dgvUsers.Rows[n].Cells[0].Value = super.phoneSetLoginID;
                                dgvUsers.Rows[n].Cells[1].Value = super.firstName;
                                dgvUsers.Rows[n].Cells[2].Value = super.lastName;
                                dgvUsers.Rows[n].Cells[3].Value = super.type.ToString();
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving agent list. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);

                //Add this line before each web method if the result set is very large, i.e. greater than 800 agents 
                oiChannelFactory_62.Endpoint.Contract.Operations.Find("getAgentsList").Behaviors.Find<DataContractSerializerOperationBehavior>().MaxItemsInObjectGraph = 2147483647;

                //Add dummy agent for testing exceptions

                int m = dgvUsers.Rows.Add();
                dgvUsers.Rows[m].Cells[0].Value = "1234";
                dgvUsers.Rows[m].Cells[1].Value = "DummyFName";
                dgvUsers.Rows[m].Cells[2].Value = "DummyLName";
                dgvUsers.Rows[m].Cells[3].Value = "AGENT";
                dgvUsers.Rows[m].Cells[4].Value = "false";

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbExcludeToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        bool result = oiService_62.getAgentsList(out agentDetails_62, out errorMessage, ccmsIP);

                        if (result)
                            MessageBox.Show("Web service getAgentsList returned " + agentDetails_62.Length.ToString());

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getAgentsList returned an error " + errorMessage);

                        if (!result)
                            MessageBox.Show("GetAgentList returned false!");
                        else
                        {
                            foreach (OIWebReference_62.AgentFullDetails agent in agentDetails_62)
                            {
                                int n = dgvUsers.Rows.Add();
                                dgvUsers.Rows[n].Cells[0].Value = agent.phoneSetLoginID;
                                dgvUsers.Rows[n].Cells[1].Value = agent.firstName;
                                dgvUsers.Rows[n].Cells[2].Value = agent.lastName;
                                dgvUsers.Rows[n].Cells[3].Value = agent.type.ToString();
                                dgvUsers.Rows[n].Cells[4].Value = agent.isLoggedIn.ToString();
                            }
                        }

                        errorMessage = string.Empty;

                        result = oiService_62.getSupervisorList(out superDetails_62, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getSupervisorList returned an error " + errorMessage);

                        if (!result)
                            MessageBox.Show("GetSupervisorList returned false!");
                        else
                        {
                            foreach (OIWebReference_62.AgentBasicDetails super in superDetails_62)
                            {
                                int n = dgvUsers.Rows.Add();
                                dgvUsers.Rows[n].Cells[0].Value = super.phoneSetLoginID;
                                dgvUsers.Rows[n].Cells[1].Value = super.firstName;
                                dgvUsers.Rows[n].Cells[2].Value = super.lastName;
                                dgvUsers.Rows[n].Cells[3].Value = super.type.ToString();
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving agent list. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }

            }
            else
            {
                MessageBox.Show("System Version not supported!");
            }
        }

        public void PopulateClasses()
        {
            /*****************************************************************************************************************************
             * This method makes multiple calls to different server versions to reflect the 
            * changes made in AACC 6.4.1
            * ------------------------------- getContactTypes() - AACC 6.4.1 Changes ---------------------------------------------------------
            * New contact types have been introduced in 6.4.1 to support POM outbound and Social Networking. 
            * This method returns an array of ContactType objects. The ContactType object contains a prefix property
            * of type SkillsetPrefix which is an enumerated list of prefixes for the contact types (e.g. “EM_” for email). 
            * The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
            * “PO_”
            * “EV_”
            * “SN_”
            * NOTE: The “EV_” value is not used by AACC.
            * The ContactType object has been extended to contain a “prefix_Ex” property in addition to the “Prefix” property. 
            * Clients interacting with 6.4.1 servers should use the “prefix_Ex” property. Clients should continue to use the “prefix” 
            * property in order to remain backward compatible with older AACC servers.
            * Older clients interacting with a 6.4.1 server will receive the new contact types in the ContactType array however 
            * the “prefix” property will be set to UNDEFINED. 
            * These clients must be updated to use the new “prefix_Ex” property.
           *****************************************************************************************************************************/

            string ccmsIP = string.Empty;

            if (ckbIncludeInvalidCCMSIP.Checked)
                ccmsIP = "155.55.55.55";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            OIWebReference.CallPresentationClass[] cpcList;
            OIWebReference.MultiplicityPresentationClass[] mpcList;
            OIWebReference.ThresholdClass[] thresholdList;
            OIWebReference.ContactType[] contactTypeList;
            OIWebReference_62.ContactType[] contactTypeList_62;
            OIWebReference.Skillset[] skillsetList;
            string errorMessage = string.Empty;

            cboCPC.Items.Clear();
            cboMPC.Items.Clear();
            cboThreshold.Items.Clear();
            cklbContactTypes.Items.Clear();
            dgvSkillsets.Rows.Clear();

            OIWebReference.soap oiService;
            ConnectionSetup(out errorMessage, out oiService);


            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
            {
                if (ckbExcludeToken.Checked)
                {
                    //Dont add any header!
                }
                else if (ckbInvalidToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                    // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                else
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    requestProperty.Headers["NTSSOCookie"] = userToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                try
                {
                    int result = oiService.getCallPresentationClasses(out cpcList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getCallPresentationClasses returned an error " + errorMessage);
                    else
                        MessageBox.Show("Web service getCallPresentationClasses returned with result code " + result);

                    foreach (OIWebReference.CallPresentationClass cpc in cpcList)
                    {
                        cboCPC.Items.Add(cpc.ID.Trim() + "," + cpc.Name);
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error calling Get CPC. Details: " + Ex.Message);
                }

                try
                {
                    int result = oiService.getMultiplicityPresentationClass(out mpcList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getMultiplicityThresholdClass returned an error " + errorMessage);
                    else
                        MessageBox.Show("Web service getMultiplicityThresholdClass returned with result code " + result);

                    foreach (OIWebReference.MultiplicityPresentationClass mpc in mpcList)
                    {
                        cboMPC.Items.Add(mpc.ClassID.Trim() + "," + mpc.ClassName);
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error calling Get MPC. Details: " + Ex.Message);
                }

                try
                {
                    int result = oiService.getAgentThresholdClass(out thresholdList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getAgentThresholdClass returned an error " + errorMessage);
                    else
                        MessageBox.Show("Web service getAgentThresholdClass returned with result code " + result);


                    foreach (OIWebReference.ThresholdClass threshold in thresholdList)
                    {
                        cboThreshold.Items.Add(threshold.ID.Trim() + "," + threshold.Name);
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error calling Get Agent Threshold. Details: " + Ex.Message);
                }
                if (Global.Version == SystemVersion.SixFour)
                {
                    try
                    {

                        int result = oiService.getContactTypes(out contactTypeList, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getContactTypes returned an error " + errorMessage);
                        else
                            MessageBox.Show("Web service getContactTypes returned with result code " + result);

                        foreach (OIWebReference.ContactType conType in contactTypeList)
                        {
                            cklbContactTypes.Items.Add(conType.ID + "," + conType.Name);
                        }
                    }



                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error calling Get ContactTypes. Details: " + Ex.Message);
                    }

                }

                try
                {
                    bool result = oiService.getSkillsetsList(out skillsetList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getSkillsetsList returned an error " + errorMessage);

                    if (!result)
                        MessageBox.Show("getSkillsetsList returned false!");

                    foreach (OIWebReference.Skillset skillset in skillsetList)
                    {
                        int rowindex = dgvSkillsets.Rows.Add();

                        dgvSkillsets.Rows[rowindex].Cells[0].Value = skillset.Name;
                        dgvSkillsets.Rows[rowindex].Cells[1].Value = "Unassigned";
                        dgvSkillsets.Rows[rowindex].Cells[2].Value = skillset.ContactTypeID.ToString();
                        dgvSkillsets.Rows[rowindex].Cells[3].Value = skillset.ID.ToString();
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error calling Get ContactTypes. Details: " + Ex.Message);
                }


                ConnectionShutdown();
            }
            // User 6.2 WebReference for getContactType() 
            if (Global.Version == SystemVersion.SixTwo)
            {
                OIWebReference_62.soap oiService_62;
                ConnectionSetup_62(out errorMessage, out oiService_62);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbExcludeToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }



                    try
                    {

                        int result = oiService_62.getContactTypes(out contactTypeList_62, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getContactTypes returned an error " + errorMessage);
                        else
                            MessageBox.Show("Web service getContactTypes returned with result code " + result);

                        foreach (OIWebReference_62.ContactType conType in contactTypeList_62)
                        {
                            cklbContactTypes.Items.Add(conType.ID + "," + conType.Name);
                        }

                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error calling Get ContactTypes. Details: " + Ex.Message);
                    }


                    ConnectionShutdown_62();
                }
            }
        }



        private void btnDelete_Click(object sender, EventArgs e)
        {
            string errorMessage = string.Empty;
            string ccmsIP = cboServerList.Text.Split(',')[0];
            string agentLoginID = txtLoginID.Text;


            OIWebReference.soap oiService;
            ConnectionSetup(out errorMessage, out oiService);


            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
            {
                if (!ckbExcludeToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    requestProperty.Headers["NTSSOCookie"] = userToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }

                if (ckbInvalidToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                    // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";   
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }

                try
                {
                    int result = oiService.deleteUser(out errorMessage, ccmsIP, agentLoginID);
                    if (errorMessage != string.Empty)
                        MessageBox.Show("Error returned from DeleteUser. Details: " + errorMessage);
                    else
                        MessageBox.Show("Agent was deleted successfully. Return code was " + result);

                    PopulateUsers();
                }

                catch (Exception Ex)
                {
                    MessageBox.Show("Exception generated. Details: " + Ex.Message);
                }
                finally
                {
                    ConnectionShutdown();
                }
            }

        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            /* ****************************************************************************************************************************
             * This method contains calls to multiple server versions to relflect 
             * changes made to open interfaces in AACC 6.4.1 and 6.4.2 
             * --------------------- addUser() - AACC 6.4.1 Changes ----------------------------------
             * The UserDetails object contains an array of ContactTypeAndRelatedSkillsets objects. 
             * Each of the ContactTypeAndRelatedSkillsets contains the ContactType attributes including 
             * a prefix property of type SkillsetPrefix which is an enumerated list of prefixes for the contact types 
             * (e.g. “EM_” for email). The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, 
             * which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The ContactType object has been extended to contain a “prefix_Ex” property in addition to the “Prefix” property. 
             * The “prefix_Ex” property should be used when interacting with a 6.4.1 or later CCMA server. The “prefix” property 
             * should be populated for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each skillset 
             * of a given contact type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. The range
             * of values that can be returned in this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             ******************************************************************************************************************************/


            string errorMessage = string.Empty;
            string ccmsIP = cboServerList.Text.Split(',')[0];
            string agentLoginID = txtLoginID.Text;
            int localAgentID = 0;


            OIWebReference.soap oiService;
            OIWebReference.soap oiService_62;



            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        //requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true" + "; SKIPDATAVALIDATION" + "=" + "true");

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";   
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    try
                    {
                        int result = oiService.addUser(out localAgentID, out errorMessage, ccmsIP, GetAgentDetails(true));



                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from AddUser: " + errorMessage);
                        else
                            MessageBox.Show("Add user succeeded! Local ID returned " + localAgentID + " and result code " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error Adding agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup(out errorMessage, out oiService_62);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        //requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true" + "; SKIPDATAVALIDATION" + "=" + "true");

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";   
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    try
                    {
                        int result = oiService_62.addUser(out localAgentID, out errorMessage, ccmsIP, GetAgentDetails(true));



                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from AddUser: " + errorMessage);
                        else
                            MessageBox.Show("Add user succeeded! Local ID returned " + localAgentID + " and result code " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error Adding agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }

            }
            else
            {
                MessageBox.Show("System version not recognised");
            }

        }


        public OIWebReference_62.UserDetails GetAgentDetails_62(bool newAgent)
        {
            OIWebReference_62.UserDetails user = new CCMAOpenInterfaces.OIWebReference_62.UserDetails();
            //user.agentCTIEnabled 
            user.agentKey = int.Parse(txtAgentKey.Text);
            //user.assignedAgentDetails 

            //List<OIWebReference_62.ContactTypeAndRelatedSkillsets> ContactList = new List<OIWebReference_62.ContactTypeAndRelatedSkillsets>();
            CheckState val;
            int contactTypeCounter = 0;

            for (int j = 0; j < cklbContactTypes.Items.Count; j++)
            {
                val = cklbContactTypes.GetItemCheckState(j);
                if (val == CheckState.Checked)
                    contactTypeCounter++;
            }
            OIWebReference_62.ContactTypeAndRelatedSkillsets[] contactListArray = new CCMAOpenInterfaces.OIWebReference_62.ContactTypeAndRelatedSkillsets[cklbContactTypes.Items.Count];


            int counter = 0;
            for (int j = 0; j < cklbContactTypes.Items.Count; j++)
            {
                val = cklbContactTypes.GetItemCheckState(j);

                contactListArray[counter] = new CCMAOpenInterfaces.OIWebReference_62.ContactTypeAndRelatedSkillsets();
                contactListArray[counter].ID = int.Parse(cklbContactTypes.Items[j].ToString().Split(',')[0]);
                contactListArray[counter].Name = cklbContactTypes.Items[j].ToString().Split(',')[1];
                if (val == CheckState.Checked)
                {
                    contactListArray[counter].ON = "1";
                    contactListArray[counter].isAssigned = true;
                }
                else
                {
                    contactListArray[counter].ON = "0";
                    contactListArray[counter].isAssigned = false;
                }
                counter++;

            }

            OIWebReference_62.SkillsetFullDetails skillset;

            List<OIWebReference_62.SkillsetFullDetails> skillsetsToAdd = new List<OIWebReference_62.SkillsetFullDetails>();
            foreach (OIWebReference_62.ContactTypeAndRelatedSkillsets selectedContactTypes in contactListArray)
            {
                if (selectedContactTypes.isAssigned)
                {
                    for (int i = 0; i < dgvSkillsets.Rows.Count; i++)
                    {
                        if (int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString()) == selectedContactTypes.ID)
                        {
                            if (dgvSkillsets.Rows[i].Cells[1].Value.ToString() != "")
                            {
                                skillset = new CCMAOpenInterfaces.OIWebReference_62.SkillsetFullDetails();
                                skillset.ContactTypeID = int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString());
                                skillset.ID = int.Parse(dgvSkillsets.Rows[i].Cells[3].Value.ToString());
                                if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "unassigned")
                                {
                                    //skillset.Priority = 0;
                                    skillset.Priority = 49;
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.UNASSIGNED;
                                }
                                else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "standby")
                                {
                                    skillset.Priority = 0;
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.STANDBY;
                                }
                                else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim().Contains("standby,"))
                                {
                                    string[] skl_pr = null;
                                    skl_pr = dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim().Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                                    skillset.Priority = int.Parse(skl_pr[1]);
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.STANDBY;
                                }
                                else
                                {
                                    skillset.Priority = int.Parse(dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.ACTIVE;
                                }
                                skillsetsToAdd.Add(skillset);
                            }
                        }
                    }
                }

                selectedContactTypes.skillsetsOfThisContactType = skillsetsToAdd.ToArray();
                skillsetsToAdd.Clear();
            }
            user.assignedContactsandSkillsets = contactListArray;
            //user.personalDN == tbp

            if (txtAuthenticationAccountType.Text == OIWebReference_62.ACCOUNT_TYPE.Domain.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference_62.ACCOUNT_TYPE.Domain;
            else if (txtAuthenticationAccountType.Text == OIWebReference_62.ACCOUNT_TYPE.Local.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference_62.ACCOUNT_TYPE.Local;
            else if (txtAuthenticationAccountType.Text == OIWebReference_62.ACCOUNT_TYPE.LocalSecurityServer.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference_62.ACCOUNT_TYPE.LocalSecurityServer;
            else if (txtAuthenticationAccountType.Text == OIWebReference_62.ACCOUNT_TYPE.Unassigned.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference_62.ACCOUNT_TYPE.Unassigned;


            user.callPresentationClassID = int.Parse(cboCPC.Text.Split(',')[0]);
            user.cctAgentEnabled = ckbCreateCCTAgent.Checked;
            user.agentCTIEnabled = ckbCTIEnabled.Checked;
            if (!newAgent)
            {
                user.cmAgentID = txtcmAgentID.Text;
                user.cmID = txtcmAgent.Text;
                user.userID = txtUserID.Text;
                user.positionID = int.Parse(txtPositionID.Text);
                user.localID = int.Parse(txtLocalID.Text);
            }

            //Login ID
            user.loginID = txtLoginID.Text;

            user.tnName = txtTNName.Text;
            user.comment = txtComment.Text;
            //user.defaultACDQueue = txtACDQueue.Text;
            user.defaultACDQueueErrorCode = int.Parse(txtACDQueueError.Text);
            //CT Change
            //if (txtACDQueueError.Text != "")
            //{
            //    user.defaultACDQueueErrorCode = int.Parse(txtACDQueueError.Text);
            //}
            user.department = txtDepartment.Text;
            user.domain = txtCCTDomain.Text;
            user.firstName = txtFirstName.Text;
            user.isSuper = ckbIsSupervisor.Checked;
            if (ckbIsSupervisor.Checked)
            {
                user.superCTIEnabled = ckbCTIEnabled.Checked;
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR;
            }

            if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.AGENT.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.AGENT;
            else if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR;
            else if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR_AGENT.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR_AGENT;
            else
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.UNDEFINED;

            if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.CHINESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.CHINESE;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.ENGLISH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.ENGLISH;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.FRENCH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.FRENCH;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.GERMAN.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.GERMAN;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.JAPANESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.JAPANESE;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.PORTUGESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.PORTUGESE;
            else if (txtLanguage.Text == OIWebReference_62.SupportedLanguages.SPANISH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference_62.SupportedLanguages.SPANISH;
            user.lastName = txtLastName.Text;
            //CT
            user.multiplicityPresentationClassID = int.Parse(cboMPC.Text.Split(',')[0]);
            //if (cboMPC.Text.Split(',')[0] != "")
            //{
            //    user.multiplicityPresentationClassID = int.Parse(cboMPC.Text.Split(',')[0]);
            //}
            user.password = txtCCTPassword.Text;
            if (ckbSIPAgent.Checked)
            {
                user.voiceURI = txtPersonnalDN.Text;
                user.iMURI = txtACDQueue.Text;
                user.personalDN = "";
                user.defaultACDQueue = "";

            }
            else
            {
                user.personalDN = txtPersonnalDN.Text;
                user.defaultACDQueue = txtACDQueue.Text;
                user.voiceURI = "";
                user.iMURI = "";
            }

            //user.positionID = txt
            //user.supervisorID = int.Parse(txtSupervisor.Text);
            user.supervisorLoginID = txtSupervisorLoginID.Text;
            user.supervisorID = int.Parse(txtSupervisorID.Text);
            user.thresholdID = int.Parse(cboThreshold.Text.Split(',')[0]);
            user.title = txtTitle.Text;
            //user.tnName 
            //user.userID 
            user.userName = txtCCTUserName.Text;
            //user.userName = txtCCTUserName.Text + "@" + txtCCTDomain.Text + ".com";
            if (txtUserType.Text == OIWebReference_62.AGENT_TYPE.AGENT.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.AGENT;
            else if (txtUserType.Text == OIWebReference_62.AGENT_TYPE.SUPERVISOR.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR;
            else if (txtUserType.Text == OIWebReference_62.AGENT_TYPE.SUPERVISOR_AGENT.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.SUPERVISOR_AGENT;
            else if (txtUserType.Text == OIWebReference_62.AGENT_TYPE.UNDEFINED.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference_62.AGENT_TYPE.UNDEFINED;


            #region AgentGreeting values
            user.agentGreetingPasswd = tbAgtGreetingPwd.Text.Trim();
            user.agentGreetingState = cbAgtgreetingEnabled.Checked;
            user.agentGreetingRecorded = cbAgtGreetingRec.Checked;

            #endregion


            // user.offsiteAlternatePhone = "
            return user;
        }

        public OIWebReference.UserDetails GetAgentDetails(bool newAgent)
        {
            OIWebReference.UserDetails user = new CCMAOpenInterfaces.OIWebReference.UserDetails();
            //user.agentCTIEnabled 
            user.agentKey = int.Parse(txtAgentKey.Text);
            //user.assignedAgentDetails 

            //List<OIWebReference.ContactTypeAndRelatedSkillsets> ContactList = new List<OIWebReference.ContactTypeAndRelatedSkillsets>();
            CheckState val;
            int contactTypeCounter = 0;

            for (int j = 0; j < cklbContactTypes.Items.Count; j++)
            {
                val = cklbContactTypes.GetItemCheckState(j);
                if (val == CheckState.Checked)
                    contactTypeCounter++;
            }
            OIWebReference.ContactTypeAndRelatedSkillsets[] contactListArray = new CCMAOpenInterfaces.OIWebReference.ContactTypeAndRelatedSkillsets[cklbContactTypes.Items.Count];
           

            int counter = 0;
            for (int j = 0; j < cklbContactTypes.Items.Count; j++)
            {
                val = cklbContactTypes.GetItemCheckState(j);

                contactListArray[counter] = new CCMAOpenInterfaces.OIWebReference.ContactTypeAndRelatedSkillsets();
                contactListArray[counter].ID = int.Parse(cklbContactTypes.Items[j].ToString().Split(',')[0]);
                contactListArray[counter].Name = cklbContactTypes.Items[j].ToString().Split(',')[1];
                if (val == CheckState.Checked)
                {
                    contactListArray[counter].ON = "1";
                    contactListArray[counter].isAssigned = true;
                }
                else
                {
                    contactListArray[counter].ON = "0";
                    contactListArray[counter].isAssigned = false;
                }
                counter++;

            }

            OIWebReference.SkillsetFullDetails skillset;

            List<OIWebReference.SkillsetFullDetails> skillsetsToAdd = new List<OIWebReference.SkillsetFullDetails>();
            foreach (OIWebReference.ContactTypeAndRelatedSkillsets selectedContactTypes in contactListArray)
            {
                if (selectedContactTypes.isAssigned)
                {
                    for (int i = 0; i < dgvSkillsets.Rows.Count; i++)
                    {
                        if (int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString()) == selectedContactTypes.ID)
                        {
                            if (dgvSkillsets.Rows[i].Cells[1].Value.ToString() != "")
                            {
                                skillset = new CCMAOpenInterfaces.OIWebReference.SkillsetFullDetails();
                                skillset.ContactTypeID = int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString());
                                skillset.ID = int.Parse(dgvSkillsets.Rows[i].Cells[3].Value.ToString());
                                if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "unassigned")
                                {
                                    //skillset.Priority = 0;
                                    skillset.Priority = 49;
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.UNASSIGNED;
                                }
                                else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "standby")
                                {
                                    skillset.Priority = 0;
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.STANDBY;
                                }
                                else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim().Contains("standby,"))
                                {
                                    string[] skl_pr = null;
                                    skl_pr = dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim().Split(new string[]{","},StringSplitOptions.RemoveEmptyEntries);
                                    skillset.Priority = int.Parse(skl_pr[1]);
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.STANDBY;
                                }
                                else
                                {
                                    skillset.Priority = int.Parse(dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                    skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.ACTIVE;
                                }
                                skillsetsToAdd.Add(skillset);
                            }
                        }
                    }
                }

                selectedContactTypes.skillsetsOfThisContactType = skillsetsToAdd.ToArray();
                skillsetsToAdd.Clear();
            }
            user.assignedContactsandSkillsets = contactListArray;
           //user.personalDN == tbp

            if (txtAuthenticationAccountType.Text == OIWebReference.ACCOUNT_TYPE.Domain.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference.ACCOUNT_TYPE.Domain;
            else if (txtAuthenticationAccountType.Text == OIWebReference.ACCOUNT_TYPE.Local.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference.ACCOUNT_TYPE.Local;
            else if (txtAuthenticationAccountType.Text == OIWebReference.ACCOUNT_TYPE.LocalSecurityServer.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference.ACCOUNT_TYPE.LocalSecurityServer;
            else if (txtAuthenticationAccountType.Text == OIWebReference.ACCOUNT_TYPE.Unassigned.ToString())
                user.authenticationAccountType = CCMAOpenInterfaces.OIWebReference.ACCOUNT_TYPE.Unassigned;


            user.callPresentationClassID = int.Parse(cboCPC.Text.Split(',')[0]);
            user.cctAgentEnabled = ckbCreateCCTAgent.Checked;
            user.agentCTIEnabled = ckbCTIEnabled.Checked;
            if (!newAgent)
            {
                user.cmAgentID = txtcmAgentID.Text;
                user.cmID = txtcmAgent.Text;
                user.userID = txtUserID.Text;
                user.positionID = int.Parse(txtPositionID.Text);
                user.localID = int.Parse(txtLocalID.Text);
            }

            //Login ID
            user.loginID = txtLoginID.Text;

            user.tnName = txtTNName.Text;
            user.comment = txtComment.Text;
            //user.defaultACDQueue = txtACDQueue.Text;
            user.defaultACDQueueErrorCode = int.Parse(txtACDQueueError.Text);
            //CT Change
            //if (txtACDQueueError.Text != "")
            //{
            //    user.defaultACDQueueErrorCode = int.Parse(txtACDQueueError.Text);
            //}
            user.department = txtDepartment.Text;
            user.domain = txtCCTDomain.Text;
            user.firstName = txtFirstName.Text;
            user.isSuper = ckbIsSupervisor.Checked;
            if (ckbIsSupervisor.Checked)
            {
                user.superCTIEnabled = ckbCTIEnabled.Checked;
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR;
            }

            if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.AGENT.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.AGENT;
            else if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR;
            else if (txtUserType.Text.ToLower().Trim() == CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR_AGENT.ToString().ToLower())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR_AGENT;
            else 
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.UNDEFINED;

            if (txtLanguage.Text == OIWebReference.SupportedLanguages.CHINESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.CHINESE;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.ENGLISH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.ENGLISH;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.FRENCH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.FRENCH;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.GERMAN.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.GERMAN;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.JAPANESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.JAPANESE;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.PORTUGESE.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.PORTUGESE;
            else if (txtLanguage.Text == OIWebReference.SupportedLanguages.SPANISH.ToString())
                user.languageID = CCMAOpenInterfaces.OIWebReference.SupportedLanguages.SPANISH;
            user.lastName = txtLastName.Text;
            //CT
            user.multiplicityPresentationClassID = int.Parse(cboMPC.Text.Split(',')[0]);
            //if (cboMPC.Text.Split(',')[0] != "")
            //{
            //    user.multiplicityPresentationClassID = int.Parse(cboMPC.Text.Split(',')[0]);
            //}
            user.password = txtCCTPassword.Text;
            if (ckbSIPAgent.Checked)
            {
                user.voiceURI = txtPersonnalDN.Text;
                user.iMURI = txtACDQueue.Text;
                user.personalDN = "";
                user.defaultACDQueue = "";

            }
            else
            {
                user.personalDN = txtPersonnalDN.Text;
                user.defaultACDQueue = txtACDQueue.Text;
                user.voiceURI = "";
                user.iMURI = "";
            }
           
            //user.positionID = txt
            //user.supervisorID = int.Parse(txtSupervisor.Text);
            user.supervisorLoginID = txtSupervisorLoginID.Text;
            user.supervisorID = int.Parse(txtSupervisorID.Text);
            user.thresholdID = int.Parse(cboThreshold.Text.Split(',')[0]);
            user.title = txtTitle.Text;
            //user.tnName 
            //user.userID 
            user.userName = txtCCTUserName.Text;
            //user.userName = txtCCTUserName.Text + "@" + txtCCTDomain.Text + ".com";
            if (txtUserType.Text == OIWebReference.AGENT_TYPE.AGENT.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.AGENT;
            else if (txtUserType.Text == OIWebReference.AGENT_TYPE.SUPERVISOR.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR;
            else if (txtUserType.Text == OIWebReference.AGENT_TYPE.SUPERVISOR_AGENT.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.SUPERVISOR_AGENT;
            else if (txtUserType.Text == OIWebReference.AGENT_TYPE.UNDEFINED.ToString())
                user.userType = CCMAOpenInterfaces.OIWebReference.AGENT_TYPE.UNDEFINED;


            #region AgentGreeting values
            user.agentGreetingPasswd = tbAgtGreetingPwd.Text.Trim();
            user.agentGreetingState = cbAgtgreetingEnabled.Checked;
            user.agentGreetingRecorded = cbAgtGreetingRec.Checked; 
            
            #endregion

            #region 6.4.2 Updates
            // ADD 6.4.2 Updates - new AgentDetails Properties DNBargeInEnabled , DNObserveEnabled, SIPSoftPhoneEnable // 0 if disabled , 1 if Enabled
            if(ckbDNObserveEnabled.Checked)
            {
                user.dnObserveEnabled =1; 

            }else
            { 
                user.dnObserveEnabled = 0; 
            }


            if (ckbDNBargeInEnabled.Checked)
            {
                user.dnBargeInEnabled = 1;
            }
            else
            {
                user.dnBargeInEnabled = 0;
            }

            #endregion

            // user.offsiteAlternatePhone = "
            
            return user;
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            string errorMessage = string.Empty;
            string ccmsIP = cboServerList.Text.Split(',')[0];

            //get the original login ID as the user may have changed it. this is so we can identify the agent to update.
            string agentLoginID = originalUserLoginID;
            //string agentLoginID = txtLoginID.Text;

            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62;

            if (Global.Version == SystemVersion.SixFour)
            {

                ConnectionSetup(out errorMessage, out oiService);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true");
                        // requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true");

                        // requestProperty.Headers.Add(HttpRequestHeader.Cookie, "AGENTGREETING" + "=" + "true");
                        //interfacesrequestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; NTSSOUserID=" + UserID);

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;


                    }
                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService.updateUser(out errorMessage, ccmsIP, agentLoginID, GetAgentDetails(false));

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from UpdateUser: " + errorMessage);
                        else
                            MessageBox.Show("Update user succeeded! Return code was " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error updating agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true");
                        // requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; AGENTGREETING" + "=" + "true");

                        // requestProperty.Headers.Add(HttpRequestHeader.Cookie, "AGENTGREETING" + "=" + "true");
                        //interfacesrequestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; NTSSOUserID=" + UserID);

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;


                    }
                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService_62.updateUser(out errorMessage, ccmsIP, agentLoginID, GetAgentDetails_62(false));

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from UpdateUser: " + errorMessage);
                        else
                            MessageBox.Show("Update user succeeded! Return code was " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error updating agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else
            {
                MessageBox.Show("Version not supported!");
            }

        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnUpdateSkillset_Click(object sender, EventArgs e)
        {
            /**********************************************************************************
             * This method makes calls to multiple servers to reflect 
             * the changes introduced in AACC 6.4.1
             * --------------------------- AACC 6.4.1 Changes ------------------------------
             * AACC 6.4.1 supports additional contact types for “POM outbound” 
             * and “Social Networking” contacts. The updateAgentSkillsets method returns an 
             * array of SkillsetFullDetails objects each of which contains a ContactTypeID 
             * property of type int. The range of values that can be returned in this int 
             * has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
            **************************************************************************************/

            string errorMessage = string.Empty;
            string ccmsIP = cboServerList.Text.Split(',')[0];

            //get the original login ID as the user may have changed it. this is so we can identify the agent to update.
            //string agentLoginID = originalUserLoginID;
            string agentLoginID = txtLoginID.Text;

            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62;


            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    OIWebReference.SkillsetFullDetails skillset;
                    OIWebReference.SkillsetFullDetails[] skillsetArray;

                    List<OIWebReference.SkillsetFullDetails> skillsetsToAdd = new List<OIWebReference.SkillsetFullDetails>();
                    for (int i = 0; i < dgvSkillsets.Rows.Count; i++)
                    {
                        if (dgvSkillsets.Rows[i].Cells[1].Value.ToString() != "")
                        {
                            skillset = new CCMAOpenInterfaces.OIWebReference.SkillsetFullDetails();
                            skillset.ContactTypeID = int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString());
                            skillset.ID = int.Parse(dgvSkillsets.Rows[i].Cells[3].Value.ToString());
                            if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "unassigned")
                            {
                                skillset.Priority = 49;
                                skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.UNASSIGNED;
                            }
                            else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "standby")
                            {
                                skillset.Priority = 0;
                                skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.STANDBY;
                            }
                            else
                            {
                                try
                                {
                                    skillset.Priority = int.Parse(dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                }
                                catch (Exception)
                                {
                                    MessageBox.Show("Invalid skillset priority " + dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                    return;
                                }
                                skillset.Status = CCMAOpenInterfaces.OIWebReference.SkillsetStatus.ACTIVE;
                                //skillsetsToAdd.Add(skillset);
                            }
                            skillsetsToAdd.Add(skillset);
                        }
                    }
                    skillsetArray = skillsetsToAdd.ToArray();

                    try
                    {
                        int result = oiService.updateAgentSkillsets(out errorMessage, ccmsIP, agentLoginID, skillsetArray);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from UpdateUser: " + errorMessage);
                        else
                            MessageBox.Show("Update user succeeded! Return code was " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error updating agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (!ckbExcludeToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        requestProperty.Headers["NTSSOCookie"] = userToken;

                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=InvalidToken");
                        // requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }

                    OIWebReference_62.SkillsetFullDetails skillset;
                    OIWebReference_62.SkillsetFullDetails[] skillsetArray;

                    List<OIWebReference_62.SkillsetFullDetails> skillsetsToAdd = new List<OIWebReference_62.SkillsetFullDetails>();
                    for (int i = 0; i < dgvSkillsets.Rows.Count; i++)
                    {
                        if (dgvSkillsets.Rows[i].Cells[1].Value.ToString() != "")
                        {
                            skillset = new CCMAOpenInterfaces.OIWebReference_62.SkillsetFullDetails();
                            skillset.ContactTypeID = int.Parse(dgvSkillsets.Rows[i].Cells[2].Value.ToString());
                            skillset.ID = int.Parse(dgvSkillsets.Rows[i].Cells[3].Value.ToString());
                            if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "unassigned")
                            {
                                skillset.Priority = 49;
                                skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.UNASSIGNED;
                            }
                            else if (dgvSkillsets.Rows[i].Cells[1].Value.ToString().ToLower().Trim() == "standby")
                            {
                                skillset.Priority = 0;
                                skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.STANDBY;
                            }
                            else
                            {
                                try
                                {
                                    skillset.Priority = int.Parse(dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                }
                                catch (Exception)
                                {
                                    MessageBox.Show("Invalid skillset priority " + dgvSkillsets.Rows[i].Cells[1].Value.ToString());
                                    return;
                                }
                                skillset.Status = CCMAOpenInterfaces.OIWebReference_62.SkillsetStatus.ACTIVE;
                                //skillsetsToAdd.Add(skillset);
                            }
                            skillsetsToAdd.Add(skillset);
                        }
                    }
                    skillsetArray = skillsetsToAdd.ToArray();

                    try
                    {
                        int result = oiService_62.updateAgentSkillsets(out errorMessage, ccmsIP, agentLoginID, skillsetArray);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error returned from UpdateUser: " + errorMessage);
                        else
                            MessageBox.Show("Update user succeeded! Return code was " + result);
                        PopulateUsers();
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error updating agent. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                }
            }
            else
            {
                MessageBox.Show("Version not supported!");
            }
        }

        private void ckbSIPAgent_CheckedChanged(object sender, EventArgs e)
        {
            if (ckbSIPAgent.Checked)
            {
                lblPersonnalDN.Text = "Voice URI";
                lblACDQueue.Text = "IM URI";
            }
            else
            {
                lblPersonnalDN.Text = "Personnal DN";
                lblACDQueue.Text = "ACD Queue";
            }

        }

        private void dgvUsers_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }



    }
}

