using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;

namespace CCMAOpenInterfaces
{
    public partial class frmSOAP : Form
    {
        private string _CCMSIPAddress;
        private SOAP1.SOAP _ccmaClient;
        private Logger _logger;
        private string _UserToken;
        private string _url;
        private delegate void UpdateProgressDelegate(string text);
        private LoadType loadType;
        private string fName = null;
        private string lName = null;
        private int loadQuantity = 0;
        private string cookieName;
        private string UserID;
        //ctidevccma.SOAPWrapperCommonWS commonClient;


        public frmSOAP(string CCMSIPAddress, string Token, string Url, string COOKIE, string strUserID)
        {
            _CCMSIPAddress = CCMSIPAddress;
            _UserToken = Token;
            cookieName = COOKIE;
            UserID = strUserID;
            InitializeComponent();
            _ccmaClient = new CCMAOpenInterfaces.SOAP1.SOAP();

            _url = Url;
            _ccmaClient.Url = _url;
            this.Text = "SOAP CCMA Open Interfaces Test Tool using URL " + _url;
            _logger = new Logger(InterfaceType.SOAP);

            PopulatePriorityCombo();
            //this.Text = "SOAP CCMA Open Interfaces Test Tool for CCMA server " + _CCMSIPAddress + " using token " + _UserToken;
            //commonClient = new CCMAOpenInterfaces.ctidevccma.SOAPWrapperCommonWS();
            //testCommonWS();
        }

        //public void testCommonWS()
        //{
        //    string errMsg = string.Empty;
        //    string resp = string.Empty;

        //    try
        //    {
        //        resp = commonClient.SOAPWrapperCommon_UsersWS_GetServers_Wrapper("sysadmin", "172.18.130.8", "1", "", "Webadmin", "webadmin", out errMsg);
        //    }
        //    catch (Exception Ex)
        //    {
        //        MessageBox.Show(Ex.Message);
        //    }
        //}
        public void PopulatePriorityCombo()
        {
            cboPriority.Items.Add("50");
            cboPriority.Items.Add("string");

            for (int i = 0; i < 50; i++)
            {
                cboPriority.Items.Add(i);
            }

        }

        private void UpdateProgress(string Text)
        {
            if (this.InvokeRequired == false)
            {
                this.txtProgress.Text = Text;
                this.txtProgress.Refresh();
            }
            else
            {
                UpdateProgressDelegate updateProgressDel = new UpdateProgressDelegate(UpdateProgress);
                this.BeginInvoke(updateProgressDel, new object[] { Text });
            }
        }

        private void LoadCCMA()
        {
            int _localAgentID;
            bool failures = false;
            string _errMessage = string.Empty; ;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();
            OIWebReference.CCTUserDetails _cctUserDetails = new CCMAOpenInterfaces.OIWebReference.CCTUserDetails();
            for (int i = 1; i <= loadQuantity; i++)
            {
                UpdateProgress("Uploading " + i.ToString() + " of " + loadQuantity.ToString());
                switch (loadType)
                {
                    case LoadType.Agent:
                        try
                        {
                            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                            {
                                HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                                //Add the cookie to the request
                                requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                                //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                                OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                                //oiService.addAgent(_CCMSIPAddress, fName, lName + i.ToString(), out agentResult, out agentIDSpecified, out _localAgentID, out localAgentSpecified, out _errMessage);
                                oiService.addAgent(out _localAgentID, out _errMessage, _CCMSIPAddress, fName, lName + i.ToString(), _cctUserDetails);
                            }

                            if (_errMessage != null && _errMessage != "")
                            {
                                _logger.LogMessage("Received an error message from AddAgent Call for agent " + i.ToString() + ". Details: " + _errMessage);
                                UpdateProgress(_errMessage);
                                failures = true;
                            }
                            else
                            {
                                _logger.LogMessage("Successfully added agent + " + fName + " " + lName + i.ToString() + " with returned ID of " + _localAgentID.ToString());
                            }
                        }
                        catch (Exception Ex)
                        {
                            _logger.LogMessage("An Exception was caught while adding agent " + i.ToString() + ". Exception details: " + Ex.Message);
                            UpdateProgress(Ex.Message);
                            failures = true;
                        }
                        break;
                    case LoadType.Supervisor:
                        try
                        {
                            //bool supervisorResult;
                            //bool addSupervisorResultSpecified = true;
                            int localsupervisor;
                            //bool localSupervisorSpecified = false;

                            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                            {
                                HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                                //Add the cookie to the request
                                requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                                //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                                OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                                //oiService.addSupervisor(_CCMSIPAddress, fName, lName + i.ToString(), out supervisorResult, out addSupervisorResultSpecified, out localsupervisor, out localSupervisorSpecified, out _errMessage);
                                oiService.addSupervisor(out localsupervisor, out _errMessage, _CCMSIPAddress, fName, lName + i.ToString());
                            }

                            if (_errMessage != null && _errMessage != "")
                            {
                                _logger.LogMessage("Received an error message from AddSupervisor Call for Supervisor " + fName + " " + lName + i.ToString() + ". Details: " + _errMessage);
                                UpdateProgress(_errMessage);
                                failures = true;
                            }
                            else
                            {
                                _logger.LogMessage("Successfully added supervisor + " + fName + " " + lName + i.ToString() + " with returned ID of " + localsupervisor.ToString());

                            }
                        }
                        catch (Exception Ex)
                        {
                            _logger.LogMessage("An Exception was caught while adding supervisor " + i.ToString() + ". Exception details: " + Ex.Message);
                            //errorText = Ex.Message;
                            UpdateProgress(Ex.Message);
                            failures = true;
                        }
                        break;

                }
            }
            try
            {
                oiChannelFactory.Close();
            }
            catch { };

            if (failures)
                UpdateProgress("Upload encountered Failures! check log file for details!");
            else
                UpdateProgress("Upload Complete!");

        }
        private enum LoadType
        {
            Agent,
            Supervisor,
            SupervisorAgent,
        }

        private void btnAddAgents_Click(object sender, EventArgs e)
        {

            int _parseResult = 0;


            if (radAgent.Checked)
                loadType = LoadType.Agent;
            else if (radSupervisor.Checked)
                loadType = LoadType.Supervisor;

            txtProgress.Text = "Processing. Please wait.......";
            if (txtFirstName.Text == "")
            {
                MessageBox.Show("Fill in Agent First Name!");
                return;
            }
            fName = txtFirstName.Text;
            if (txtAgentLastName.Text == "")
            {
                MessageBox.Show("Fill in Agent Last Name!");
                return;
            }
            lName = txtAgentLastName.Text;
            if (txtAgentQty.Text == "")
            {
                MessageBox.Show("Fill in Agent quantity to load!");
                return;
            }
            int.TryParse(txtAgentQty.Text, out _parseResult);
            if (_parseResult == 0)
            {
                MessageBox.Show("Agent quantity to load must be an integer!");
                return;
            }
            loadQuantity = int.Parse(txtAgentQty.Text);

            this.btnAddAgents.Enabled = false;
            this.Cursor = Cursors.WaitCursor;

            //create thread
            Thread logoutThread = new Thread(new ThreadStart(LoadCCMA));
            logoutThread.Name = "Load";
            logoutThread.Priority = ThreadPriority.Normal;
            logoutThread.IsBackground = true;
            logoutThread.Start();

            //_success = LoadCCMA(loadType, int.Parse(txtAgentQty.Text), txtFirstName.Text, txtAgentLastName.Text, out errorText);
            //if (_success == false)
            //    MessageBox.Show("Loading of agents/supervisors encountered a problem. Error Text: " + errorText);
            //else
            //    MessageBox.Show("Loading of agents/supervisors is complete!");

            this.btnAddAgents.Enabled = true;
            this.Cursor = Cursors.Default;
        }

        private void btnAddAgentToSkillset_Click(object sender, EventArgs e)
        {
            String errMsg = string.Empty;
            string[] agentIDs = cboAgents.Text.Split(',');
            string agentID = agentIDs[1];

            string[] skillsets = cboAgentSkillsets.Text.Split(',');
            string skillsetID = skillsets[1];

            string priority = cboPriority.Text;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            try
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                    // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                    //requestProperty.Headers["NTSSOCookie"] = "4646";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    if (oiService.addAgentSkillset(out errMsg, _CCMSIPAddress, agentID, skillsetID, priority))
                        MessageBox.Show("Success!");
                    else
                        MessageBox.Show("Error " + errMsg);

                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception occurred. Details: " + Ex.Message);
            }
        }

        private void btnRemoveAgentFromSkillset_Click(object sender, EventArgs e)
        {
            String errMsg = string.Empty;
            string[] agentIDs = cboAgents.Text.Split(',');
            string agentID = agentIDs[1];

            string[] skillsets = cboAgentSkillsets.Text.Split(',');
            string skillsetID = skillsets[1];

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            try
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                    //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    if (oiService.removeAgentSkillset(out errMsg, _CCMSIPAddress, agentID, skillsetID))
                        MessageBox.Show("Success!");
                    else
                        MessageBox.Show("Error " + errMsg);

                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception occurred. Details: " + Ex.Message);
            }

        }


        private void btnGetAllAgents_Click(object sender, EventArgs e)
        {
            /*****************************************************************************************************************************
             * This method contains calls to multiple server versions to relflect 
             * changes made to open interfaces in AACC 6.4.1
             * ------------------------------getAgentsList() - AACC 6.4.1 Changes -----------------------------------------------------
             * The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
             *  The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the ContactTypeAndRelatedSkillsets 
             *  contains the ContactType attributes including a prefix property of type SkillsetPrefix which is an enumerated list of prefixes 
             *  for the contact types (e.g. EM_ for email). The enum cannot be extended so a new enum has been added, 
             *  SkillsetPrefix_Ex, which contains the additional values:
             * PO_
             * EV_
             * SN_
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the Prefix property. The prefix_Ex
             * property should be used when interacting with a 6.4.1 or later CCMA server. The prefix property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each skillset of a given contact
             * type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. The range of values that can be returned in
             * this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             *****************************************************************************************************************************/



            string _errorMessage = null;
            lblTotalAgents.Text = "";
            OIWebReference.AgentFullDetails[] _listOfAgents;
            OIWebReference_62.AgentFullDetails[] _listOfAgents_62; 

            cboAgents.Items.Clear();
            this.Cursor = Cursors.WaitCursor;

            //Add dummy agent first for testing web services against invalid agents
            cboAgents.Items.Add("DummyFirstName DummyLastName, 99876");
            cboAgents.Items.Add("Voice Agent1, 10219");
            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxBufferSize = int.MaxValue;
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_url);

            if (Global.Version == SystemVersion.SixFour)
            {

                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        //requestProperty.Headers["NTSSOCookie"] = "";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        //oiService.getAgentsList(_CCMSIPAddress, out getAgentsListResult, out getAgentsListResultSpecified, out _listOfAgents, out _errorMessage);
                        oiService.getAgentsList(out _listOfAgents, out _errorMessage, _CCMSIPAddress);

                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAllAgents method. Details: " + _errorMessage);
                        }
                        else
                            //Populate combo box with agents
                            lblTotalAgents.Text = _listOfAgents.Length.ToString() + " agents returned";
                        for (int i = 0; i < _listOfAgents.Length; i++)
                        {
                            cboAgents.Items.Add(_listOfAgents[i].firstName + " " + _listOfAgents[i].lastName + "," + _listOfAgents[i].localID + ", SupID " + _listOfAgents[i].superLocalID);


                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory.Close();
                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the GetAllAgents method. Details : " + Ex.Message);
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        //requestProperty.Headers["NTSSOCookie"] = "";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        oiService_62.getAgentsList(out _listOfAgents_62, out _errorMessage, _CCMSIPAddress);

                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAllAgents method. Details: " + _errorMessage);
                        }
                        else
                            //Populate combo box with agents
                            lblTotalAgents.Text = _listOfAgents_62.Length.ToString() + " agents returned";
                        for (int i = 0; i < _listOfAgents_62.Length; i++)
                        {
                            cboAgents.Items.Add(_listOfAgents_62[i].firstName + " " + _listOfAgents_62[i].lastName + "," + _listOfAgents_62[i].localID + ", SupID " + _listOfAgents_62[i].superLocalID);


                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory.Close();
                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the GetAllAgents method. Details : " + Ex.Message);
                }
            }

        }

        private void btnGetAgentSkillsets_Click(object sender, EventArgs e)
        {
            /*****************************************************************************************************************************
             * This method contains calls to multiple server versions to relflect 
             * changes made to open interfaces in AACC 6.4.1
             * ---------------------------------getSkillsetsList() - AACC 6.4.1 Changes ---------------------------------
             * The Skillset object contains a ContactTypeID property of type int. 
             * The range of values that can be returned in this property has been extended.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             *****************************************************************************************************************************/

            string _errorMessage;
             OIWebReference.Skillset[] _listOfSkillsets;
             OIWebReference_62.Skillset[] _listOfSkillsets_62;

             lblTotalSkillsets.Text = "";
             cboAgentSkillsets.Items.Clear();
             this.Cursor = Cursors.WaitCursor;

             BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
             basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
             EndpointAddress endpointAddress = new EndpointAddress(_url);


             if(Global.Version == SystemVersion.SixFour)
             { 

             ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
             OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

             try
             {
                 using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                 {
                     HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                     //Add the cookie to the request
                     requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                     //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                     OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                     cboAgentSkillsets.Items.Add("EM_DummySkillset, 2222");
                     cboAgentSkillsets.Items.Add("Travel, 10003");

                     oiService.getSkillsetsList(out _listOfSkillsets, out _errorMessage, _CCMSIPAddress);
                     if (_errorMessage != null && _errorMessage != "")
                     {
                         this.Cursor = Cursors.Default;
                         MessageBox.Show("Error text was received from the getAgentSkillsets method. Details: " + _errorMessage);
                     }
                     else
                         lblTotalSkillsets.Text = _listOfSkillsets.Length.ToString() + " skillsets returned";

                     //Populate combo box with skillsets
                     for (int i = 0; i < _listOfSkillsets.Length; i++)
                     {
                         cboAgentSkillsets.Items.Add(_listOfSkillsets[i].Name + ", " + _listOfSkillsets[i].ID.ToString());
                     }
                     this.Cursor = Cursors.Default;
                     oiChannelFactory.Close();
                 }
             }

             catch (Exception Ex)
             {
                 this.Cursor = Cursors.Default;
                 MessageBox.Show("An exception was caught while executing the getAgentSkillsets method. Details : " + Ex.Message);
             }
             this.Cursor = Cursors.Default;
             } 
             else if (Global.Version == SystemVersion.SixTwo)
             {
              ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
             OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

             try
             {
                 using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                 {
                     HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                     //Add the cookie to the request
                     requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                     //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                     OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                     cboAgentSkillsets.Items.Add("EM_DummySkillset, 2222");
                     cboAgentSkillsets.Items.Add("Travel, 10003");

                     oiService_62.getSkillsetsList(out _listOfSkillsets_62, out _errorMessage, _CCMSIPAddress);
                     if (_errorMessage != null && _errorMessage != "")
                     {
                         this.Cursor = Cursors.Default;
                         MessageBox.Show("Error text was received from the getAgentSkillsets method. Details: " + _errorMessage);
                     }
                     else
                         lblTotalSkillsets.Text = _listOfSkillsets_62.Length.ToString() + " skillsets returned";

                     //Populate combo box with skillsets
                     for (int i = 0; i < _listOfSkillsets_62.Length; i++)
                     {
                         cboAgentSkillsets.Items.Add(_listOfSkillsets_62[i].Name + ", " + _listOfSkillsets_62[i].ID.ToString());
                     }
                     this.Cursor = Cursors.Default;
                     oiChannelFactory_62.Close();
                 }
             }

             catch (Exception Ex)
             {
                 this.Cursor = Cursors.Default;
                 MessageBox.Show("An exception was caught while executing the getAgentSkillsets method. Details : " + Ex.Message);
             }
             this.Cursor = Cursors.Default;
             }
             else
             {
                 MessageBox.Show("System version is not accounted for in this solution"); 
             } 
         }


         private void btnGetAgentDetails_Click(object sender, EventArgs e)
         {
             /*****************************************************************************************************************************
              * This method contains calls to multiple server versions to relflect 
              * changes made to open interfaces in AACC 6.4.1
              * -------------------------------getAgentDetails() - AACC 6.4.1 Changes ------------------------------------------------
              * The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
              * The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the 
              * ContactTypeAndRelatedSkillsets contains the ContactType attributes including a prefix property of type 
              * SkillsetPrefix which is an enumerated list of prefixes for the contact types (e.g. EM_ for email). 
              * The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
              * PO_
              * EV_
              * SN_
              * NOTE: The EV_ value is not used by AACC.
              * The ContactType object has been extended to contain a prefix_Ex property in addition to the prefix property. 
              * The prefix_Ex property should be used when interacting with a 6.4.1 or later CCMA server. 
              * The prefix property should be used for all older servers.
              ***************************************************************************************************************************** */


             string _errorMessage;
            string _localAgentID = null;
            //bool getDetailsResult;
            //bool getDetailsResultSpecified = true;
            //SOAP.AgentFullDetails _localAgent;
            OIWebReference.AgentFullDetails _localAgent;
            OIWebReference_62.AgentFullDetails _localAgent_62; 
            OIWebReference.CCTUserDetails _cctUserDetails;
            OIWebReference_62.CCTUserDetails _cctUserDetails_62; 
            string _contactTypes = null;
            string _contactTypes_62 = null; 
            string[] _agents;
            //SOAP.SkillsetFullDetails[] _listOfSkillsets;
            OIWebReference.SkillsetFullDetails[] _listOfSkillsets;
            OIWebReference_62.SkillsetFullDetails[] _listOfSkillsets_62; 
            string _skillsets = null;
            string _skillsets_62 = null; 
            //SOAP.ContactTypeAndRelatedSkillsets[] listOfContactsAndSkillsets;
            OIWebReference.ContactTypeAndRelatedSkillsets[] listOfContactsAndSkillsets;
            OIWebReference_62.ContactTypeAndRelatedSkillsets[] listOfContactsAndSkillsets_62; 
            string record;
            string[] row;

            dgvAgentDetails.Rows.Clear();


            if (cboAgents.Text == "")
            {
                MessageBox.Show("Select an agent from the drop down list to get agent details associated with the agent!");
                return;
            }

            _agents = cboAgents.Text.Split(',');
            _localAgentID = _agents[1];
            _cctUserDetails = new CCMAOpenInterfaces.OIWebReference.CCTUserDetails();
            _cctUserDetails_62 = new CCMAOpenInterfaces.OIWebReference_62.CCTUserDetails(); 
            this.Cursor = Cursors.WaitCursor;
            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            EndpointAddress endpointAddress = new EndpointAddress(_url);


            if (Global.Version == SystemVersion.SixFour)
            {
                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;


                        oiService.getAgentDetails(out _localAgent, out _errorMessage, _localAgentID, _CCMSIPAddress, _cctUserDetails);
                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAgent method. Details: " + _errorMessage);
                        }
                        else
                        {
                            listOfContactsAndSkillsets = _localAgent.contactTypesAndSkillsets;
                            for (int i = 0; i < listOfContactsAndSkillsets.Length; i++)
                            {
                                if (listOfContactsAndSkillsets[i].isAssigned)
                                    _contactTypes += listOfContactsAndSkillsets[i].Name + "; ";
                                _listOfSkillsets = _localAgent.contactTypesAndSkillsets[i].skillsetsOfThisContactType;
                                for (int j = 0; j < _listOfSkillsets.Length; j++)
                                    _skillsets += _listOfSkillsets[j].ID + " " + _listOfSkillsets[j].Name + ": " + _listOfSkillsets[j].Priority.ToString() + ".";
                            }

                            //Populate agent details
                            record = "LocalID" + "," + _localAgent.localID;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "First Name" + "," + _localAgent.firstName;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Last Name" + "," + _localAgent.lastName;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Type" + "," + _localAgent.type.ToString();
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Contact Types Assigned" + "," + _contactTypes;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Skillsets Assigned" + "," + _skillsets;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "IsLoggedIn" + "," + _localAgent.isLoggedIn.ToString();
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Supervisor LocalID" + "," + _localAgent.superLocalID;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "PS LoginID" + "," + _localAgent.phoneSetLoginID; ;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory.Close();
                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the getAgent method. Details : " + Ex.Message);
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;


                        oiService_62.getAgentDetails(out _localAgent_62, out _errorMessage, _localAgentID, _CCMSIPAddress, _cctUserDetails_62);
                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAgent method. Details: " + _errorMessage);
                        }
                        else
                        {
                            listOfContactsAndSkillsets_62 = _localAgent_62.contactTypesAndSkillsets;
                            for (int i = 0; i < listOfContactsAndSkillsets_62.Length; i++)
                            {
                                if (listOfContactsAndSkillsets_62[i].isAssigned)
                                    _contactTypes_62 += listOfContactsAndSkillsets_62[i].Name + "; ";
                                _listOfSkillsets_62 = _localAgent_62.contactTypesAndSkillsets[i].skillsetsOfThisContactType;
                                for (int j = 0; j < _listOfSkillsets_62.Length; j++)
                                    _skillsets_62 += _listOfSkillsets_62[j].ID + " " + _listOfSkillsets_62[j].Name + ": " + _listOfSkillsets_62[j].Priority.ToString() + ".";
                            }

                            //Populate agent details
                            record = "LocalID" + "," + _localAgent_62.localID;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "First Name" + "," + _localAgent_62.firstName;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Last Name" + "," + _localAgent_62.lastName;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Type" + "," + _localAgent_62.type.ToString();
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Contact Types Assigned" + "," + _contactTypes_62;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Skillsets Assigned" + "," + _skillsets_62;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "IsLoggedIn" + "," + _localAgent_62.isLoggedIn.ToString();
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "Supervisor LocalID" + "," + _localAgent_62.superLocalID;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                            record = "PS LoginID" + "," + _localAgent_62.phoneSetLoginID; ;
                            row = record.Split(',');
                            this.dgvAgentDetails.Rows.Add(row);
                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory_62.Close();
                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the getAgent method. Details : " + Ex.Message);
                }
            } 


        }

        private void btnGetAllSupervisors_Click(object sender, EventArgs e)
        {
            string _errorMessage = null;
            //SOAP.AgentBasicDetails[] _listOfSupervisors;
            OIWebReference.AgentBasicDetails[] _listOfSupervisors;
            //bool getSupervisorListResult;
            //bool getSupervisorListResultSpecified = true;
            cboSupervisors.Items.Clear();
            lblTotalSupervisors.Text = "";

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            //Add dummy supervisor first for testing web services against invalid agents
            cboSupervisors.Items.Add("DummySupFirstName DummySupLastName, 99877");

            this.Cursor = Cursors.WaitCursor;


            try
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                    // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    //oiService.getSupervisorList(_CCMSIPAddress, out getSupervisorListResult, out getSupervisorListResultSpecified, out _listOfSupervisors, out _errorMessage);
                    oiService.getSupervisorList(out _listOfSupervisors, out _errorMessage, _CCMSIPAddress);
                    if (_errorMessage != null && _errorMessage != "")
                    {
                        this.Cursor = Cursors.Default;
                        MessageBox.Show("Error text was received from the getAllSupervisors method. Details: " + _errorMessage);
                    }
                    else
                        lblTotalSupervisors.Text = _listOfSupervisors.Length.ToString() + " supervisors returned";
                    //Populate combo box with agents
                    for (int i = 0; i < _listOfSupervisors.Length; i++)
                    {
                        cboSupervisors.Items.Add(_listOfSupervisors[i].firstName + " " + _listOfSupervisors[i].lastName + "," + _listOfSupervisors[i].localID);
                    }
                    this.Cursor = Cursors.Default;
                    oiChannelFactory.Close();
                }
            }
            catch (Exception Ex)
            {
                this.Cursor = Cursors.Default;
                MessageBox.Show("An exception was caught while executing the getAllSupervisors method. Details : " + Ex.Message + _errorMessage);
            }
        }

        private void btnGetAgentsBySupervisor_Click(object sender, EventArgs e)
        {
            //string _errorMessage;
            //string[] _listOfAgents;
            //string _localSupID = null;
            //string[] _supervisors;

            //cboSupervisorAgents.Items.Clear();

            //if (cboSupervisors.Text == "")
            //{
            //    MessageBox.Show("Select an supervisor from the drop down list to get associated agents!");
            //    return;
            //}
            //this.Cursor = Cursors.WaitCursor;
            //_supervisors = cboSupervisors.Text.Split(',');
            //_localSupID = _supervisors[1];

            ////CookieContainer cookie = new CookieContainer();
            ////_ccmaClient.CookieContainer = cookie;
            ////_ccmaClient.CookieContainer.Add(new Uri(address), new System.Net.Cookie("SSOToken", _ssoToken));

            //try
            //{
            //    _ccmaClient.getSupervisorAssignedAgents(_CCMSIPAddress, _localSupID, out _listOfAgents, out _errorMessage);
            //    if (_errorMessage != null && _errorMessage != "")
            //    {
            //        this.Cursor = Cursors.Default;
            //        MessageBox.Show("Error text wa received from the getSupervisorAssignedAgents method. Details: " + _errorMessage);
            //    }
            //    else
            //        //Populate combo box with agent ID's
            //        for (int i = 0; i < _listOfAgents.Length; i++)
            //        {
            //            cboSupervisorAgents.Items.Add(_listOfAgents[i]);
            //        }
            //    this.Cursor = Cursors.Default;


            //}
            //catch (Exception Ex)
            //{
            //    this.Cursor = Cursors.Default;
            //    MessageBox.Show("An exception was caught while executing the getAgentSkillsets method. Details : " + Ex.Message);
            //}
        }

        private void btnGetSupDetails_Click(object sender, EventArgs e)
        {
            string _errorMessage;
            string _localSupID = null;
            //SOAP.SupervisorFullDetails _localSupervisor;
            OIWebReference.SupervisorFullDetails _localSupervisor;
            string _agentIDs = null;
            //string[] _listOfAgentIDs;
            int[] _listOfAgentIDs;
            string[] _supervisors;
            string record;
            string[] row;
            //bool getSupervisorDetailsResult;
            //bool getSupervisorDetailsResultSpecified = true;

            dgvSupervisors.Rows.Clear();

            if (cboSupervisors.Text == "")
            {
                MessageBox.Show("Select an supervisor from the drop down list to view supervisor details");
                return;
            }

            _supervisors = cboSupervisors.Text.Split(',');
            _localSupID = _supervisors[1];

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            this.Cursor = Cursors.WaitCursor;

            try
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                    //requestProperty.Headers["NTSSOCookie"] = _UserToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    //oiService.getSupervisorDetails(_localSupID, _CCMSIPAddress, out getSupervisorDetailsResult, out getSupervisorDetailsResultSpecified, out _localSupervisor, out _errorMessage);
                    oiService.getSupervisorDetails(out _localSupervisor, out _errorMessage, _localSupID, _CCMSIPAddress);
                    if (_errorMessage != null && _errorMessage != "")
                    {
                        this.Cursor = Cursors.Default;
                        MessageBox.Show("Error text was received from the getSupervisor method. Details: " + _errorMessage);
                    }
                    else
                    {

                        _listOfAgentIDs = _localSupervisor.assignedAgentsLocalIDs;
                        for (int i = 0; i < _listOfAgentIDs.Length; i++)
                            _agentIDs += _listOfAgentIDs[i] + "; ";

                        //Populate agent details
                        record = "LocalID" + "," + _localSupervisor.localID;
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "First Name" + "," + _localSupervisor.firstName;
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "Last Name" + "," + _localSupervisor.lastName;
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "Type" + "," + _localSupervisor.type.ToString();
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "PSLoginID" + "," + _localSupervisor.phoneSetLoginID;
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "Number of Assigned Agents" + "," + _localSupervisor.NumAssignedAgents.ToString();
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);
                        record = "Assigned Agent IDs" + "," + _agentIDs;
                        row = record.Split(',');
                        this.dgvSupervisors.Rows.Add(row);

                    }
                    this.Cursor = Cursors.Default;
                    oiChannelFactory.Close();
                }
            }
            catch (Exception Ex)
            {
                this.Cursor = Cursors.Default;
                MessageBox.Show("An exception was caught while executing the getAgent method. Details : " + Ex.Message);
            }
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            _logger.CloseLogger();
            this.Close();
        }

        private void btnLoadTests_Click(object sender, EventArgs e)
        {
            SOAPLoadTesting loadTest = new SOAPLoadTesting(_CCMSIPAddress, _UserToken, _url, _logger);
            loadTest.ShowDialog();
        }

        private void btnGetSkillsetAgents_Click(object sender, EventArgs e)
        {

            /*****************************************************************************************************************************
             * This method makes multiple calls to different server versions to reflect the changes 
             * in AACC 6.4.1
             * --------------------------- getAgentsAssignedToSkillset() - AACC 6.4.1 Changes ------------------------------------------
             * The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
             * The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. 
             * Each of the ContactTypeAndRelatedSkillsets contains the ContactType attributes including a prefix 
             * property of type SkillsetPrefix which is an enumerated list of prefixes for the contact types 
             * (e.g. EM_ for email). The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, 
             * which contains the additional values:
             * PO_
             * EV_
             * SN_
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the Prefix property. 
             * The prefix_Ex property should be used when interacting with a 6.4.1 or later CCMA server. The prefix 
             * property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each 
             * skillset of a given contact type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. 
             * The range of values that can be returned in this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
            *****************************************************************************************************************************/



            string skillsetID;
            //SOAP.AgentFullDetails[] listOfAgents;
            OIWebReference.AgentFullDetails[] listOfAgents;
            OIWebReference_62.AgentFullDetails[] listOfAgents_62; 
            string _errorMessage;
            string[] skillsets;
            string skillsetName;
            string _contactTypes = null;
            //SOAP.SkillsetFullDetails[] _listOfSkillsets;
            //SOAP.ContactTypeAndRelatedSkillsets[] _listOfContactTypesAndSkillsets;
            OIWebReference.SkillsetFullDetails[] _listOfSkillsets;
            OIWebReference_62.SkillsetFullDetails[] _listOfSkillsets_62; 
            OIWebReference.ContactTypeAndRelatedSkillsets[] _listOfContactTypesAndSkillsets;
            OIWebReference_62.ContactTypeAndRelatedSkillsets[] _listOfContactTypesAndSkillsets_62; 
            string _skillsets = null;
            string record;
            string[] row;
            //bool getAgentsAssignedBySkillset;
            //bool getAgentsAssignedBySkillsetSpecified = true;

            if (cboAgentSkillsets.Text == "")
            {
                MessageBox.Show("You must select a skillset from the drop down list!");
                return;
            }

            dgvSkillsetAgents.Rows.Clear();
            skillsets = cboAgentSkillsets.Text.Split(',');
            skillsetID = skillsets[1];
            skillsetName = skillsets[0];

            this.Cursor = Cursors.WaitCursor;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_url);

            if (Global.Version == SystemVersion.SixFour)
            {

                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        //oiService.getAgentsAssignedToSkillset(skillsetID, _CCMSIPAddress, out getAgentsAssignedBySkillset, out getAgentsAssignedBySkillsetSpecified, out listOfAgents, out _errorMessage);
                        oiService.getAgentsAssignedToSkillset(out listOfAgents, out _errorMessage, skillsetID, _CCMSIPAddress);
                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAgentsBySkillsets method. Details: " + _errorMessage);
                        }
                        else
                        {
                            txtAgentSkillsetCount.Text = "Total agents assigned to skillset " + skillsetName + " is " + listOfAgents.Length.ToString();
                            for (int i = 0; i < listOfAgents.Length; i++)
                            {
                                _listOfContactTypesAndSkillsets = listOfAgents[i].contactTypesAndSkillsets;
                                for (int j = 0; j < _listOfContactTypesAndSkillsets.Length; j++)
                                {
                                    _contactTypes += _listOfContactTypesAndSkillsets[j].Name + ", ";
                                    _listOfSkillsets = _listOfContactTypesAndSkillsets[j].skillsetsOfThisContactType;
                                    for (int k = 0; k < _listOfSkillsets.Length; k++)
                                        _skillsets += _listOfSkillsets[k].Name + ", ";
                                }



                                //Populate agent details
                                record = listOfAgents[i].localID + "," + listOfAgents[i].firstName + "," + listOfAgents[i].lastName;
                                row = record.Split(',');
                                this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "First Name" + "," + listOfAgents[i].firstName;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Last Name" + "," + listOfAgents[i].lastName;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Title" + "," + listOfAgents[i].agentProperties.title;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Contact Types Assigned" + "," + _contactTypes;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Skillsets Assigned" + "," + _skillsets;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Login Status" + "," + listOfAgents[i].loginStatus;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Supervisor First Name" + "," + listOfAgents[i].superFirstName;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Supervisor Last Name" + "," + listOfAgents[i].superLastName;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Supervisor PSLoginID" + "," + listOfAgents[i].superPSLoginID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Supervisor LocalID" + "," + listOfAgents[i].superLocalID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "SIP Terminal" + "," + listOfAgents[i].sip_terminal;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Has Skillsets" + "," + listOfAgents[i].hasSkillsets;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Department" + "," + listOfAgents[i].agentProperties.dept;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Default ACD Queue" + "," + listOfAgents[i].agentProperties.defaultACDQueue;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Default ACD Queue Error Code" + "," + listOfAgents[i].agentProperties.defaultACDQueueErrorCode;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Full ID" + "," + listOfAgents[i].agentProperties.fullID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Position ID" + "," + listOfAgents[i].agentProperties.positionID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Terminal" + "," + listOfAgents[i].agentProperties.terminal;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Threshold ID" + "," + listOfAgents[i].agentProperties.thresholdID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Language ID" + "," + listOfAgents[i].agentProperties.languageID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "PSLogin ID" + "," + listOfAgents[i].agentProperties.psLoginID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "Supervisor Agent Key" + "," + listOfAgents[i].agentProperties.supAgentKey;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);
                                //record = "TemplateID" + "," + listOfAgents[i].agentProperties.templateID;
                                //row = record.Split(',');
                                //this.dgvSkillsetAgents.Rows.Add(row);

                            }
                            this.Cursor = Cursors.Default;
                            oiChannelFactory.Close();
                        }

                    }
                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An Exception was caught while executing the getAgentsBySkillsets method. Details: " + Ex.Message);

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {

                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        //oiService.getAgentsAssignedToSkillset(skillsetID, _CCMSIPAddress, out getAgentsAssignedBySkillset, out getAgentsAssignedBySkillsetSpecified, out listOfAgents, out _errorMessage);
                        oiService_62.getAgentsAssignedToSkillset(out listOfAgents_62, out _errorMessage, skillsetID, _CCMSIPAddress);
                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAgentsBySkillsets method. Details: " + _errorMessage);
                        }
                        else
                        {
                            txtAgentSkillsetCount.Text = "Total agents assigned to skillset " + skillsetName + " is " + listOfAgents_62.Length.ToString();
                            for (int i = 0; i < listOfAgents_62.Length; i++)
                            {
                                _listOfContactTypesAndSkillsets_62 = listOfAgents_62[i].contactTypesAndSkillsets;
                                for (int j = 0; j < _listOfContactTypesAndSkillsets_62.Length; j++)
                                {
                                    _contactTypes += _listOfContactTypesAndSkillsets_62[j].Name + ", ";
                                    _listOfSkillsets_62 = _listOfContactTypesAndSkillsets_62[j].skillsetsOfThisContactType;
                                    for (int k = 0; k < _listOfSkillsets_62.Length; k++)
                                        _skillsets += _listOfSkillsets_62[k].Name + ", ";
                                }



                                //Populate agent details
                                record = listOfAgents_62[i].localID + "," + listOfAgents_62[i].firstName + "," + listOfAgents_62[i].lastName;
                                row = record.Split(',');
                                this.dgvSkillsetAgents.Rows.Add(row);
                                
                            }
                            this.Cursor = Cursors.Default;
                            oiChannelFactory_62.Close();
                        }

                    }
                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An Exception was caught while executing the getAgentsBySkillsets method. Details: " + Ex.Message);

                }
            }
            else
            {
                MessageBox.Show("Version not supported");
            } 
        }

        private void btnViewLogs_Click(object sender, EventArgs e)
        {
            frmLogger loggerForm = new frmLogger(_logger);
            loggerForm.ShowDialog();
        }

        private void btnLoadTest_Click(object sender, EventArgs e)
        {
            frmAssignAgentsToSkillsets frmAssignmentLoad = new frmAssignAgentsToSkillsets(_CCMSIPAddress, _UserToken, _url);
            frmAssignmentLoad.Show();
        }

        private void grpSuperVisorDetails_Enter(object sender, EventArgs e)
        {

        }

        private void btnGetContactTypes_Click(object sender, EventArgs e)
        {
            /*****************************************************************************************************************************
             * This method makes multiple calls to different server versions to reflect the 
             * changes made in AACC 6.4.1
             * ------------------------------- getContactTypes() - AACC 6.4.1 Changes ---------------------------------------------------------
             * New contact types have been introduced in 6.4.1 to support POM outbound and Social Networking. 
             * This method returns an array of ContactType objects. The ContactType object contains a prefix property
             * of type SkillsetPrefix which is an enumerated list of prefixes for the contact types (e.g. EM_ for email). 
             * The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
             * PO_
             * EV_
             * SN_
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the Prefix property. 
             * Clients interacting with 6.4.1 servers should use the prefix_Ex property. Clients should continue to use the prefix 
             * property in order to remain backward compatible with older AACC servers.
             * Older clients interacting with a 6.4.1 server will receive the new contact types in the ContactType array however 
             * the prefix property will be set to UNDEFINED. 
             * These clients must be updated to use the new prefix_Ex property.
            *****************************************************************************************************************************/


            // Clear combo box
            cboContactTypes.Items.Clear();
            OIWebReference.ContactType[] contactTypeList;
            OIWebReference_62.ContactType[] contactTypeList_62;
            string _errorMessage = string.Empty;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_url);
            // Get the version from menu dropdown

            if (Global.Version == SystemVersion.SixFour)
            {
                // Call 6.4 API

                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        // Call Service to get Contact Types 
                        oiService.getContactTypes(out contactTypeList, out _errorMessage, _CCMSIPAddress);


                        if (_errorMessage != string.Empty)
                        {
                            MessageBox.Show("Web Service getContactTypes returned an error. Details:" + _errorMessage);
                        }
                        else
                        {
                            // Display number of contact types
                            lblContactTypeNumber.Text = contactTypeList.Length + " contact types returned.";
                            // Put Info in drop down list 
                            foreach (OIWebReference.ContactType cType in contactTypeList)
                            {
                                cboContactTypes.Items.Add("Name:" + cType.Name + " Prefix:" + cType.prefix_Ex);
                            }
                        }


                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An Exception was caught while executing the getContactTypes method. Details: " + Ex.Message);

                }


            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                // Call 6.2 API
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        //Add the cookie to the request
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _UserToken);

                        // requestProperty.Headers["NTSSOCookie"] = _UserToken;
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        // Call Service to get Contact Types 
                        oiService_62.getContactTypes(out contactTypeList_62, out _errorMessage, _CCMSIPAddress);


                        if (_errorMessage != string.Empty)
                        {
                            MessageBox.Show("Web Service getContactTypes returned an error. Details:" + _errorMessage);
                        }
                        else
                        {

                            int numberOfContactTypes = contactTypeList_62.Length;
                            // Put Info in drop down list 
                            foreach (OIWebReference_62.ContactType cType in contactTypeList_62)
                            {
                                if (cType.prefix != OIWebReference_62.SkillsetPrefix.Undefined)
                                {

                                    cboContactTypes.Items.Add("Name:" + cType.Name + " Prefix:" + cType.prefix);
                                }
                                else
                                {
                                    // Reduce number displayed
                                    numberOfContactTypes--;
                                }

                            }

                            // Display number of contact types
                            lblContactTypeNumber.Text = numberOfContactTypes + " contact types returned.";
                        }


                    }

                }
                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An Exception was caught while executing the getContactTypes method. Details: " + Ex.Message);

                }
            }
            else
            {
                MessageBox.Show("Please Choose the version from the drop down list on the menu bar at the top of your screen");
            }





        }

        private void grpContactTypes_Enter(object sender, EventArgs e)
        {

        }

        private void grpAgentDetails_Enter(object sender, EventArgs e)
        {

        }


    }


}