using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Net;
using System.IO;
using System.Xml;
using System.Collections.Specialized;

namespace CCMAOpenInterfaces
{
    public partial class frmREST : Form
    {
        #region Variables
        private string _CCMSIPAddress;
        private string _CCMAIPAddress;
        private string _ssoToken;
        private string cookieName;
        private string UserID;
        private delegate void UpdateProgressDelegate(string text);
        #endregion

        public frmREST(string CCMSIPAddress, string CCMAIPAddress, string ssoToken, string COOKIE, string strUserID)
        {
            _CCMSIPAddress = CCMSIPAddress;
            _CCMAIPAddress = CCMAIPAddress;
            _ssoToken = ssoToken;
            cookieName = COOKIE;
            UserID = strUserID;
            InitializeComponent();
            this.Text = "REST CCMA Open Interfaces Test Tool for CCMA server " + _CCMSIPAddress;
            PopulatePriorityCombo();

        }

        public void PopulatePriorityCombo()
        {
            cboPriority.Items.Add("50");
            cboPriority.Items.Add("string");

            for (int i = 0; i < 50; i++)
            {
                cboPriority.Items.Add(i);
            }

        }

        #region Methods
        /// <summary>
        /// Read xml data from file
        /// </summary>
        /// <param name="file"></param>
        /// <returns>returns file content in xml string format</returns>
        private string GetTextFromXMLFile(string file)
        {
            StreamReader reader = new StreamReader(file);
            string ret = reader.ReadToEnd();
            reader.Close();
            return ret;
        }
        /// <summary>
        /// Process GET from specified URL
        /// </summary>
        /// <param name="address"></param>
        /// <returns>returns REST call result in xml string format</returns>
        public string ProcessGET_RESTCall(Uri address)
        {
            HttpWebResponse response = null;
            StreamReader reader;
            StringBuilder sbSource;
            string returnString = string.Empty;

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                //CookieContainer cookie = new CookieContainer();
                //request.CookieContainer = cookie;
                //request.CookieContainer.Add(new Uri(address), new System.Net.Cookie("SSOToken", _ssoToken));
                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    // Get the response stream   
                 
                    
                    reader = new StreamReader(response.GetResponseStream());
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());

                    // Read it into a StringBuilder   
                    sbSource = new StringBuilder(reader.ReadToEnd());
                    
                    returnString = sbSource.ToString();
                    reader.Close();
                    response.Close();
                }
                return returnString;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                return "";
            }
        }
        public Hashtable ProcessGetSupervisors_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            Hashtable supervisors = new Hashtable();
            string temp;
            string temp2 = string.Empty;
            string returnString = string.Empty;
            string errorText = "";
            
            int i  = 0;

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;
                
                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {
                        
                        switch (xmlReader.NodeType)
                        {
                            case XmlNodeType.Element:
                                temp = xmlReader.Name.ToString();
                                if (temp == "localID")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString();
                                    supervisors.Add("Value" + i.ToString(), temp2);
                                    i++;
                                }
                                else if (temp == "firstName")
                                {
                                    xmlReader.Read();
                                    temp2 = xmlReader.Value.ToString() + " ";
                                }
                                else if (temp == "lastName")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString() + ",";
                                }
                                else if (temp == "errorMsg")
                                {
                                    xmlReader.Read();
                                    errorText = xmlReader.Value.ToString();

                                }
                                break;

                        }
                    }
                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return supervisors;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return supervisors;
            }
        }
        public Hashtable ProcessGetAgents_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            Hashtable agents = new Hashtable();
            string temp;
            string temp2 = string.Empty;
            int i = 0;
            string errorText = "";


            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                //requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);
                
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);
                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;

                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {

                        switch (xmlReader.NodeType)
                        {
                            case XmlNodeType.Element:
                                temp = xmlReader.Name.ToString();
                                if (temp == "errorMsg")
                                {
                                    xmlReader.Read();
                                    errorText = xmlReader.Value.ToString();
                                }
                                if (temp == "localID")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString();
                                    agents.Add("Value" + i.ToString(), temp2);
                                    i++;
                                }
                                else if (temp == "firstName")
                                {
                                    xmlReader.Read();
                                    temp2 = xmlReader.Value.ToString() + " ";
                                }
                                else if (temp == "lastName")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString() + ",";
                                }
                                break;

                        }
                    }
                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return agents;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return agents;
            }
        }
        public Hashtable ProcessGetAgentSkillsets_REST(Uri address)
        {
            HttpWebResponse response = null;
            Hashtable supervisors = new Hashtable();
            string temp;
            string temp2 = string.Empty;
            string returnString = string.Empty;
            int i = 0;

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;

                //CookieContainer cookie = new CookieContainer();
                //request.CookieContainer = cookie;
                //request.CookieContainer.Add(new Uri(address), new System.Net.Cookie("SSOToken", _ssoToken));
                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {

                        switch (xmlReader.NodeType)
                        {
                            case XmlNodeType.Element:
                                temp = xmlReader.Name.ToString();
                                if (temp == "localID")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString();
                                    supervisors.Add("Value" + i.ToString(), temp2);
                                    i++;
                                }
                                else if (temp == "firstName")
                                {
                                    xmlReader.Read();
                                    temp2 = xmlReader.Value.ToString() + " ";
                                }
                                else if (temp == "lastName")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString() + ", ";
                                }
                                break;

                        }
                    }
                    xmlReader.Close();
                    response.Close();
                }
                return supervisors;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                return supervisors;
            }
        }
        public Hashtable ProcessGetSkillsets_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            Hashtable skillsets = new Hashtable();
            string temp;
            string temp2 = string.Empty;
            string errorText = "";
            string returnString = string.Empty;
            int i = 0;
  
    

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;
               

                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {

                        switch (xmlReader.NodeType)
                        {
                            case XmlNodeType.Element:
                                temp = xmlReader.Name.ToString();
                                if (temp == "Name")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString();
                                    skillsets.Add("Value" + i.ToString(), temp2);
                                    i++;
                                }
                                else if (temp == "ID")
                                {
                                    xmlReader.Read();
                                    temp2 = xmlReader.Value.ToString() + ", ";
                                }
                                else if (temp == "errorMsg")
                                {
                                    xmlReader.Read();
                                    errorText = xmlReader.Value.ToString();
                                }
                                break;

                        }
                    }
                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return skillsets;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return skillsets;
            }
        }
        public Hashtable ProcessGetSkillsetAgents_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            Hashtable agents = new Hashtable();
            string temp;
            string temp2 = string.Empty;
            string returnString = string.Empty;
            int i = 0;
            string errorText = "";

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";

                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;

                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {

                        switch (xmlReader.NodeType)
                        {
                            case XmlNodeType.Element:
                                temp = xmlReader.Name.ToString();
                                if (temp == "phoneSetLoginID")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString();
                                    agents.Add("Value" + i.ToString(), temp2);
                                    i++;
                                }
                                else if (temp == "firstName")
                                {
                                    xmlReader.Read();
                                    temp2 = xmlReader.Value.ToString() + " ";
                                }
                                else if (temp == "lastName")
                                {
                                    xmlReader.Read();
                                    temp2 += xmlReader.Value.ToString() + ", ";
                                }
                                else if (temp == "errorMsg")
                                {
                                    xmlReader.Read();
                                    errorText = xmlReader.Value.ToString();
                                }
                                break;

                        }
                    }
                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return agents;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return agents;
            }
        }
        public AgentDetail ProcessGetAgentDetails_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            AgentDetail agents = new AgentDetail();
            string element;
            string temp2 = string.Empty;
            string errorText = "";

            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

               // securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;

                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {
                        //if (xmlReader.NodeType == XmlNodeType.Element)
                        //{
                                element = xmlReader.Name.ToString();
                                switch (element)
                                {
                                    case "errorMsg":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            errorText = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "comment":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Comment = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "defaultACDQueue":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.DefaultACDQueue = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "defaultACDQueueErrorCode":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.DefaultACDQueueErrorCode = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "dept":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Dept = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "desktopUserID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.DesktopUserID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "desktopUserPassword":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.DesktopUserPassword = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "firstName":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.FirstName = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "fullID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.FullID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "isSuper":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.IsSuper = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "languageID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.LanguageID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "lastName":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.LastName = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "localID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.LocalID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "personalDN":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.PersonalDN = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "positionID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.PositionID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "phoneSetLoginID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.PsLoginID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "type":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Type = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "supAgentKey":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.SupAgentKey = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "templateID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.TemplateID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "terminal":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Terminal = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "thresholdID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.ThresholdID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "title":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Title = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "uri":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Uri = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "hasSkillsets":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.HasSkillsets = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "isLoggedIn":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.LoginStatus = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "sip_terminal":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.Sip_terminal = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "superFirstName":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.SuperFirstName = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "superLastName":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.SuperLastName = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "superLocalID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.SuperLocalID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "superPSLoginID":
                                        if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                        {
                                            xmlReader.Read();
                                            agents.SuperPSLoginID = xmlReader.Value.ToString();
                                        }
                                        break;
                                    case "assignedContactTypes":
                                        while(xmlReader.Read())
                                        {
                                            if (xmlReader.Name == "assignedContactTypes" && xmlReader.NodeType == XmlNodeType.EndElement)
                                                break;

                                            if (xmlReader.Name == "name" && xmlReader.NodeType != XmlNodeType.EndElement)
                                            {
                                                xmlReader.Read();
                                                agents.AssignedContactTypes += xmlReader.Value.ToString() + "; ";
                                            }
                                        }
                                        break;
                                    case "assignedSkillsets":
                                        while (xmlReader.Read())
                                        {
                                            if (xmlReader.Name == "assignedSkillsets" && xmlReader.NodeType == XmlNodeType.EndElement)
                                                break;

                                            if (xmlReader.Name == "skillsetName" && xmlReader.NodeType != XmlNodeType.EndElement)
                                            {
                                                xmlReader.Read();
                                                agents.AssignedSkillsets += xmlReader.Value.ToString() + "; ";
                                            }
                                        }
                                        break;

                                }
                        //}
                    }
                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return agents;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return agents;
            }
        }
        public SupervisorDetail ProcessGetSupervisorDetails_REST(Uri address, out string errorRaised)
        {
            HttpWebResponse response = null;
            SupervisorDetail supervisorDetails = new SupervisorDetail();
            string element;
            string temp2 = string.Empty;
            string errorText = "";


            try
            {
                HttpWebRequest request = WebRequest.Create(address) as HttpWebRequest;
                request.Method = "GET";
                request.ContentType = "text/xml";
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;

                response = request.GetResponse() as HttpWebResponse;
                if (request.HaveResponse == true && response != null)
                {
                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {
                        
                        element = xmlReader.Name.ToString();
                        switch (element)
                        {
                            case "errorMsg":
                                {
                                    xmlReader.Read();
                                    if(xmlReader.Value.ToString() != "")
                                        errorText = xmlReader.Value.ToString();
                                }
                                break;
                            case "comment":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Comment = xmlReader.Value.ToString();
                                }
                                break;
                            case "defaultACDQueue":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.DefaultACDQueue = xmlReader.Value.ToString();
                                }
                                break;
                            case "defaultACDQueueErrorCode":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.DefaultACDQueueErrorCode = xmlReader.Value.ToString();
                                }
                                break;
                            case "dept":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Dept = xmlReader.Value.ToString();
                                }
                                break;
                            case "desktopUserID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.DesktopUserID = xmlReader.Value.ToString();
                                }
                                break;
                            case "desktopUserPassword":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.DesktopUserPassword = xmlReader.Value.ToString();
                                }
                                break;
                            case "firstName":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.FirstName = xmlReader.Value.ToString();
                                }
                                break;
                            case "fullID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.FullID = xmlReader.Value.ToString();
                                }
                                break;
                            case "isSuper":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.IsSuper = xmlReader.Value.ToString();
                                }
                                break;
                            case "languageID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.LanguageID = xmlReader.Value.ToString();
                                }
                                break;
                            case "lastName":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.LastName = xmlReader.Value.ToString();
                                }
                                break;
                            case "localID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.LocalID = xmlReader.Value.ToString();
                                }
                                break;
                            case "personalDN":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.PersonalDN = xmlReader.Value.ToString();
                                }
                                break;
                            case "positionID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.PositionID = xmlReader.Value.ToString();
                                }
                                break;
                            case "phoneSetLoginID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.PsLoginID = xmlReader.Value.ToString();
                                }
                                break;
                            case "type":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Type = xmlReader.Value.ToString();
                                }
                                break;
                            case "supAgentKey":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.SupAgentKey = xmlReader.Value.ToString();
                                }
                                break;
                            case "templateID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.TemplateID = xmlReader.Value.ToString();
                                }
                                break;
                            case "terminal":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Terminal = xmlReader.Value.ToString();
                                }
                                break;
                            case "thresholdID":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.ThresholdID = xmlReader.Value.ToString();
                                }
                                break;
                            case "title":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Title = xmlReader.Value.ToString();
                                }
                                break;
                            case "uri":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.Uri = xmlReader.Value.ToString();
                                }
                                break;
                            case "numAssignedAgents":
                                if (xmlReader.NodeType != XmlNodeType.EndElement && xmlReader.IsEmptyElement == false)
                                {
                                    xmlReader.Read();
                                    supervisorDetails.NumAssignedAgents = xmlReader.Value.ToString();
                                }
                                break;
                           
                            case "assignedAgentsLocalIDs":
                                long counter = 0;
                                while (xmlReader.Read())
                                {
                                    if (xmlReader.Name == "assignedAgentsLocalIDs" && xmlReader.NodeType == XmlNodeType.EndElement)
                                        break;
                                    if (xmlReader.Value.ToString() != "")
                                    {
                                        supervisorDetails.AssignedAgentsLocalIDs += xmlReader.Value.ToString() + "; ";
                                        counter++;
                                    }
                                }
                                supervisorDetails.NumAssignedAgents = counter.ToString();
                                break;
                        }

                    }

                    xmlReader.Close();
                    response.Close();
                }
                errorRaised = errorText;
                return supervisorDetails;
            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                errorRaised = Ex.Message;
                return supervisorDetails;
            }
        }
        public static string InputBox(string prompt,
            string title, string defaultValue)
        {
            frmInputBoxDialog localInputBox = new frmInputBoxDialog();
            localInputBox.FormPrompt = prompt;
            localInputBox.FormCaption = title;
            localInputBox.DefaultValue = defaultValue;
            localInputBox.ShowDialog();
            if (localInputBox.DialogResult == DialogResult.OK)
            {
                string response = localInputBox.InputResponse;
                localInputBox.Close();
                return response;
            }
            else
            {
                return "Cancel";
            }
        }
        #endregion

        #region Buttons
        private void btnAddAgents_Click(object sender, EventArgs e)
        {
            WebResponse response = null;
            WebRequest request = null;
            //StreamReader reader;
            //StringBuilder sbSource;
            //string xmlFile;
            Uri address = null;
            int counter;
            string element = "";
            string stringaddress;
            string errorText = "";
            bool failures = false;

            counter = int.Parse(txtAgentQty.Text);
            for(int i=1;i<=counter;i++)
            {
                try
                {
                    UpdateProgress("Uploading " + i.ToString() + " of " + counter.ToString());
                    if(radAgent.Checked)
                       stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/firstName/" + txtFirstName.Text + i.ToString() + "/lastName/" + txtAgentLastName.Text + i.ToString();
                     //   stringaddress = "http://" + _CCMAIPAddress + "/WebServices/GeminiOI/rest.svc/agents/" + _CCMSIPAddress + "/firstName/" + txtFirstName.Text + i.ToString() + "/lastName/" + txtAgentLastName.Text + i.ToString();
                    else
                       // stringaddress = "http://" + _CCMAIPAddress + "/WebServices/GeminiOI/rest.svc/supervisors/" + _CCMSIPAddress + "/firstName/" + txtFirstName.Text + i.ToString() + "/lastName/" + txtAgentLastName.Text + i.ToString();
                    stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/supervisors/" + _CCMSIPAddress + "/firstName/" + txtFirstName.Text + i.ToString() + "/lastName/" + txtAgentLastName.Text + i.ToString();

                    System.Diagnostics.Debug.Print("URL is: " + stringaddress);
                    address = new Uri(stringaddress);
                    request = WebRequest.Create(address);
                    request.Method = "POST";
                    request.ContentType = "text/xml";
                    request.ContentLength = 0;
                    WebHeaderCollection securityHeader = new WebHeaderCollection();
                    securityHeader.Add(cookieName, _ssoToken);

                   // securityHeader.Add("NTSSOCookie", _ssoToken);
                    request.Headers = securityHeader;
                    response = request.GetResponse() as HttpWebResponse;

                    //reader = new StreamReader(response.GetResponseStream());
                    //sbSource = new StringBuilder(reader.ReadToEnd());
                    //reader.Close();

                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {
                        element = xmlReader.Name.ToString();
                        if (element == "errorMsg")
                        {
                            xmlReader.Read();
                            if (xmlReader.Value.ToString() != "")
                            {
                                errorText = xmlReader.Value.ToString();
                                failures = true;
                            }  
                        }
                    }
               

                    //MessageBox.Show("Web Response: " + sbSource.ToString());
                }
                catch (WebException Ex)
                {
                    MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                    failures = true;
                }
            }
            if (failures)
                UpdateProgress("Upload encountered Failures!" + errorText);
            else
                UpdateProgress("Upload Complete!");
            return;
            //try
            //{
                
                
            //    if (radAgent.Checked)
            //        address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress);
            //    else
            //        address = new Uri("http://" + _CCMAIPAddress + "/CC_ADMIN/supervisor.svc/" + _CCMSIPAddress);
               

            //    xmlFile = Application.StartupPath + "\\Agents.xml";
                
            //    request = WebRequest.Create(address);
            //    request.Method = "POST";
            //    request.ContentType = "text/xml";
            //    StreamWriter writer = new StreamWriter(request.GetRequestStream());
            //    writer.WriteLine(this.GetTextFromXMLFile(xmlFile));
            //    writer.Close();
            //    response = request.GetResponse();
            //    reader = new StreamReader(response.GetResponseStream());
            //    sbSource = new StringBuilder(reader.ReadToEnd());
            //    reader.Close();

            //    MessageBox.Show("Web Response: " + sbSource.ToString());
                
            //}

            //catch (WebException Ex)
            //{
            //    MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
            //}

        }

        private void UpdateProgress(string Text)
        {
            if (this.InvokeRequired == false)
            {
                this.txtProgress.Text = Text;
                this.txtProgress.Refresh();
            }
            else
            {
                UpdateProgressDelegate updateProgressDel = new UpdateProgressDelegate(UpdateProgress);
                this.BeginInvoke(updateProgressDel, new object[] { Text });
            }
        }
        private void btnGetAllSupervisors_Click(object sender, EventArgs e)
        {
            Hashtable returnString;
            string uri;
            cboSupervisors.Items.Clear();
            lblTotalSupervisors.Text = "";
            string errorRaised;
            cboSupervisors.Items.Add("DummySupFirstName DummySupLastName, 99877");
            try
            {
                this.Cursor = Cursors.WaitCursor;
                // e.g. http://ctidevccma/WebServices/OpenInterfaces/rest.svc/supervisors/172.18.130.16
                uri = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/supervisors/" + _CCMSIPAddress;
                Uri address = new Uri(uri);
                returnString = ProcessGetSupervisors_REST(address, out errorRaised);
                
                
                IDictionaryEnumerator en = returnString.GetEnumerator();
                lblTotalSupervisors.Text = returnString.Count.ToString() + " supervisors returned!";
                while (en.MoveNext())
                {
                    cboSupervisors.Items.Add(en.Value.ToString());
                }
                this.Cursor = Cursors.Default;

                if (errorRaised != "")
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorRaised);
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAllSupervisors. Details: " + Ex.Message);
            }
        }

        private void btnGetAgentsBySupervisor_Click(object sender, EventArgs e)
        {
            string returnString;
            string supervisorID;
            string[] supervisors;

            if (cboSupervisors.Text == "")
            {
                MessageBox.Show("No supervisor is selected. Select a supervisor from the drop doqwn list to vew details!");
                return;
            }
          
           
            supervisors = cboSupervisors.Text.Split(',');
            supervisorID = supervisors[1];

            try
            {
                this.Cursor = Cursors.WaitCursor;
                Uri address = new Uri("http://" + _CCMAIPAddress + "/agent.svc/agents/" + _CCMSIPAddress + "/supervisors/" + supervisorID);
                returnString = ProcessGET_RESTCall(address);
                //TODO - read through return string for agent details.
                this.Cursor = Cursors.Default;

            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAgentsBySupervisor. Details: " + Ex.Message);
            }
        }

        private void btnGetSupDetails_Click(object sender, EventArgs e)
        {
            string supervisorID;
            string[] supervisors;
            SupervisorDetail supDetails;
            string record;
            string errorRaised = "";
            string[] row;

            dgvSupervisorDetails.Rows.Clear();

            if (cboSupervisors.Text == "")
            {
                MessageBox.Show("No supervisor is selected. Select a supervisor from the drop doqwn list to vew details!");
                return;
            }
            supervisors = cboSupervisors.Text.Split(',');
            supervisorID = supervisors[1];

            try
            {
                this.Cursor = Cursors.WaitCursor;
                //e.g. http://ctidevccma/WebServices/OpenInterfaces/rest.svc/supervisors/172.18.130.16/10016
                Uri address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/supervisors/" + _CCMSIPAddress + "/" + supervisorID);
                supDetails = ProcessGetSupervisorDetails_REST(address, out errorRaised);

                if (errorRaised != "")
                {
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorRaised);
                    return;
                }
                
                record = "LocalID" + "," + supDetails.LocalID;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Title" + "," + supDetails.Title;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                record = "First Name" + "," + supDetails.FirstName;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                record = "Last Name" + "," + supDetails.LastName;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Is Super" + "," + supDetails.IsSuper;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Department" + "," + supDetails.Dept;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Default ACD Queue" + "," + supDetails.DefaultACDQueue;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Default ACD Queue Error Code" + "," + supDetails.DefaultACDQueueErrorCode;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Full ID" + "," + supDetails.FullID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Position ID" + "," + supDetails.PositionID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Personal DN" + "," + supDetails.PersonalDN;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                record = "PSLogin ID" + "," + supDetails.PsLoginID;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Supervisor Agent Key" + "," + supDetails.SupAgentKey;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Terminal" + "," + supDetails.Terminal;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Threshold ID" + "," + supDetails.ThresholdID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                record = "Number of assigned Agents" + "," + supDetails.NumAssignedAgents;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                record = "Assigned Agent IDs" + "," + supDetails.AssignedAgentsLocalIDs;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Desktop User ID" + "," + supDetails.DesktopUserID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Desktop Password" + "," + supDetails.DesktopUserPassword;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Language ID" + "," + supDetails.LanguageID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                record = "Type" + "," + supDetails.Type;
                row = record.Split(',');
                this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Template ID" + "," + supDetails.TemplateID;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);
                //record = "Uri" + "," + supDetails.Uri;
                //row = record.Split(',');
                //this.dgvSupervisorDetails.Rows.Add(row);

                this.Cursor = Cursors.Default;
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetSupDetails. Details: " + Ex.Message);
            }
        }

        private void btnGetAllAgents_Click(object sender, EventArgs e)
        {
            Hashtable agents;
            cboAgents.Items.Clear();
            cboAgents.Items.Add("DummyFirstName DummyLastName, 99876");
            cboAgents.Items.Add("Voice Agent4, 16196");
            lblTotalAgents.Text = "";
            string errorRaised = "";

            try
            {
                this.Cursor = Cursors.WaitCursor;
                Uri address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress);
                agents = ProcessGetAgents_REST(address, out errorRaised);

                lblTotalAgents.Text = agents.Count.ToString() + " agents returned!";
                IDictionaryEnumerator en = agents.GetEnumerator();
                while (en.MoveNext())
                {
                    cboAgents.Items.Add(en.Value.ToString());
                }

                if (errorRaised != "")
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorRaised);
                
                this.Cursor = Cursors.Default;
            }
            catch(Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAllAgents. Details: " + Ex.Message);
            }

        }

        private void btnGetAgentSkillsets_Click(object sender, EventArgs e)
        {
            Hashtable returnString;
            string agentID = string.Empty;
            string errorText;
            lblTotalSkillsets.Text = "";
            
            cboAgentSkillsets.Items.Clear();
            cboAgentSkillsets.Items.Add("EM_DummySkillset, 2222");
            cboAgentSkillsets.Items.Add("3333, Test");
            cboAgentSkillsets.Items.Add("10003, Travel");

            try
            {
                this.Cursor = Cursors.WaitCursor;
                //e.g. http://ctidevccma/WebServices/OpenInterfaces/rest.svc/skillsets/172.18.130.16
                Uri address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/skillsets/" + _CCMSIPAddress);
                returnString = ProcessGetSkillsets_REST(address, out errorText);

                lblTotalSkillsets.Text = returnString.Count.ToString() + " skillsets returned!";
                IDictionaryEnumerator en = returnString.GetEnumerator();

                while (en.MoveNext())
                {
                    cboAgentSkillsets.Items.Add(en.Value.ToString());
                }

                if (errorText != "")
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorText);

                this.Cursor = Cursors.Default;
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAgentSkillsets. Details: " + Ex.Message);
            }
        }

        private void btnGetAgentDetails_Click(object sender, EventArgs e)
        {
            AgentDetail returnString;
            string agentID;
            string[] agents;
            string record;
            string[] row;
            string errorRaised = "";

            if (cboAgents.Text == "")
            {
                MessageBox.Show("Select an agent from the drop down list to get agent details associated with the agent!");
                return;
            }

            dgvAgentDetails.Rows.Clear();
            agents = cboAgents.Text.Split(',');
            agentID = agents[1];

            try
            {
                this.Cursor = Cursors.WaitCursor;
                //e.g. http://ctidevccma/WebServices/OpenInterfaces/rest.svc/agents/172.18.130.16/10028
                Uri address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/" + agentID);
                returnString = ProcessGetAgentDetails_REST(address, out errorRaised);

                if (errorRaised != "")
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorRaised);

                record = "LocalID" + "," + returnString.LocalID;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                record = "First Name" + "," + returnString.FirstName;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                record = "Last Name" + "," + returnString.LastName;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                //record = "Title" + "," + returnString.Title;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Assigned Contact Types" + "," + returnString.AssignedContactTypes;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Has Skillsets" + "," + returnString.HasSkillsets;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Assigned Skillsets" + "," + returnString.AssignedSkillsets;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                record = "Login Status" + "," + returnString.LoginStatus;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                //record = "Supervisor First Name" + "," + returnString.SuperFirstName;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Supervisor Last Name" + "," + returnString.SuperLastName;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                record = "Supervisor Local ID" + "," + returnString.SuperLocalID;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                //record = "Supervisor PSLoginID" + "," + returnString.SuperPSLoginID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "SIP Terminal" + "," + returnString.Sip_terminal;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Department" + "," + returnString.Dept;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Full ID" + "," + returnString.FullID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Position ID" + "," + returnString.PositionID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Terminal" + "," + returnString.Terminal;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Default ACD Queue" + "," + returnString.DefaultACDQueue;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Default ACD Queue Error Code" + "," + returnString.DefaultACDQueueErrorCode;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Desktop UserID" + "," + returnString.DesktopUserID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Desktop User Password" + "," + returnString.DesktopUserPassword;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Is Super" + "," + returnString.IsSuper;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "LanguageID" + "," + returnString.LanguageID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Personal DN" + "," + returnString.PersonalDN;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                record = "PsLoginID" + "," + returnString.PsLoginID;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                record = "Type" + "," + returnString.Type;
                row = record.Split(',');
                this.dgvAgentDetails.Rows.Add(row);
                //record = "Supervisor Agent Key" + "," + returnString.SupAgentKey;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "TemplateID" + "," + returnString.TemplateID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "ThresholdID" + "," + returnString.ThresholdID;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);
                //record = "Uri" + "," + returnString.Uri;
                //row = record.Split(',');
                //this.dgvAgentDetails.Rows.Add(row);

                this.Cursor = Cursors.Default;
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAgentDetails. Details: " + Ex.Message);
            }
        }

        private void btnGetSkillsetAgents_Click(object sender, EventArgs e)
        {
            Hashtable returnString;
            string skillsetID;
            string[] skillsets;
            string record;
            string[] row;
            string skillsetName;
            string errorRaised = "";

            if (cboAgentSkillsets.Text == "")
            {
                MessageBox.Show("Select a skillset from the drop down list to get agent details associated with the skillset!");
                return;
            }


            skillsets = cboAgentSkillsets.Text.Split(',');
            skillsetID = skillsets[0];
            skillsetName = skillsets[1];

            dgvSkillsetAgents.Rows.Clear();
            try
            {
                this.Cursor = Cursors.WaitCursor;
                // e.g. http://ctidevccma/WebServices/OpenInterfaces/rest.svc/agents/172.18.130.16/skillsets/10000
                Uri address = new Uri("http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/skillsets/" + skillsetID);
                returnString = ProcessGetSkillsetAgents_REST(address, out errorRaised);

                IDictionaryEnumerator en = returnString.GetEnumerator();
                int counter = 0;
                while (en.MoveNext())
                {
                    record = en.Value.ToString();
                    row = record.Split(',');
                    this.dgvSkillsetAgents.Rows.Add(row);
                    counter++;
                }

                this.Cursor = Cursors.Default;
                txtAgentCount.Text = "There are " + counter.ToString() + " agents assigned to skillset " + skillsetName;

                if (errorRaised != "")
                    MessageBox.Show("An error occurred while processing REST call. Details: " + errorRaised);
            }
            catch(Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetSkillsetAgents. Details: " + Ex.Message);
            }

        }

        private void btnGetAgentSupervisor_Click(object sender, EventArgs e)
        {
            string returnString;
            string agentID;
            string[] agents;

            if (cboAgents.Text == "")
            {
                MessageBox.Show("Select an agent from the drop down list to get agent details associated with the agent!");
                return;
            }
           
            agents = cboAgents.Text.Split(',');
            agentID = agents[1];

            try
            {
                this.Cursor = Cursors.WaitCursor;
                Uri address = new Uri("http://" + _CCMAIPAddress + "/agent.svc/agents/" + _CCMSIPAddress + "/" + agentID + "/supervisor");
                returnString = ProcessGET_RESTCall(address);

                //TODO - read through return string for agent details.
                this.Cursor = Cursors.Default;
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was thrown while executing GetAgentSupervisor. Details: " + Ex.Message);
            }

        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        #endregion

        private void btnCreatXMLFile_Click(object sender, EventArgs e)
        {
            string agentNumber;
            int agentQty;
            string xmlFile;
            string agentFirstName;
            string agentLastName;

            agentNumber = InputBox("Enter number of agents:", "Enter agent number", "10");
            agentQty = int.Parse(agentNumber);

            xmlFile = Application.StartupPath + "\\AgentXML.xml";
            XmlTextWriter xmlWriter = new XmlTextWriter(xmlFile, null);
            xmlWriter.Formatting = Formatting.Indented;
            xmlWriter.WriteStartDocument();
            xmlWriter.WriteStartElement("Agents");
            
            for (int i = 0; i <= agentQty; i++)
            {
                agentFirstName = "Test" + i.ToString();
                agentLastName = "Agent" + i.ToString();
                xmlWriter.WriteStartElement("Agent", "Agents");
                xmlWriter.WriteAttributeString("FName", agentFirstName);
                xmlWriter.WriteAttributeString("LName", agentLastName);
                xmlWriter.WriteEndElement();
            }
            xmlWriter.WriteEndDocument();
            xmlWriter.Flush();
            xmlWriter.Close();



        }

        private void dgvSupervisorDetails_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void grpLoadAgents_Enter(object sender, EventArgs e)
        {

        }

        private void btnRemoveAgentFromSkillset_Click(object sender, EventArgs e)
        {
            txtProgress.Text = "";

            WebResponse response = null;
            WebRequest request = null;
            //StreamReader reader;
            //StringBuilder sbSource;
           
            Uri address = null;
           
            string element = "";
            string stringaddress;
            string errorText = "";
            bool failures = false;

            string[] agentIDs = cboAgents.Text.Split(',');
            string agentID = agentIDs[1];

            string[] skillsets = cboAgentSkillsets.Text.Split(',');
            string skillsetID = skillsets[0];
          
                try
                {
                    
                    stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/" + agentID + "/skillsets/" + skillsetID;
                    
                    //http://[CCMA IP Address]/WebServices/OpenInterfaces/rest.svc/agents/{ccmsIPAddress}/{agentLocalID}/skillsets/{skillsetID}

                    System.Diagnostics.Debug.Print("URL is: " + stringaddress);
                    address = new Uri(stringaddress);
                    request = WebRequest.Create(address);
                    request.Method = "POST";
                    request.ContentType = "text/xml";
                    request.ContentLength = 0;
                    WebHeaderCollection securityHeader = new WebHeaderCollection();
                    securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                    //securityHeader.Add("NTSSOCookie", _ssoToken);
                    request.Headers = securityHeader;
                    response = request.GetResponse() as HttpWebResponse;


                    XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                    while (xmlReader.Read())
                    {
                        element = xmlReader.Name.ToString();
                        if (element == "errorMsg")
                        {
                            xmlReader.Read();
                            if (xmlReader.Value.ToString() != "")
                            {
                                errorText = xmlReader.Value.ToString();
                                failures = true;
                            }
                        }
                    }

                }
                catch (WebException Ex)
                {
                    MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                    failures = true;
                }
           
            if (failures)
                UpdateProgress("Failed to remove Agent to Skillset!" + errorText);
            else
                UpdateProgress("Successfully removed Agent to Skillset!");
            return;
            
        }

        private void btnAddAgentToSkillset_Click(object sender, EventArgs e)
        {

           // string[] agentIDs = cboAgents.Text.Split(',');
           // string agentID = agentIDs[1];

           // string[] skillsets = cboAgentSkillsets.Text.Split(',');
           // string skillsetID = skillsets[1];

           // string priority = cboPriority.Text;
            
            //stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/" + agentID + "/skillsets/" + skillsetID + "/priority/" + priority;

            txtProgress.Text = "";

            WebResponse response = null;
            WebRequest request = null;
            //StreamReader reader;
            //StringBuilder sbSource;

            Uri address = null;

            string element = "";
            string stringaddress;
            string errorText = "";
            bool failures = false;

            string[] agentIDs = cboAgents.Text.Split(',');
            string agentID = agentIDs[1];

            string[] skillsets = cboAgentSkillsets.Text.Split(',');
            string skillsetID = skillsets[0];

            string priority = cboPriority.Text; 

            try
            {

                stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/" + agentID + "/skillsets/" + skillsetID + "/priority/" + priority;

                //stringaddress = "http://" + _CCMAIPAddress + "/WebServices/OpenInterfaces/rest.svc/agents/" + _CCMSIPAddress + "/" + agentID + "/skillsets/" + skillsetID + "/priority/" + priority;

                System.Diagnostics.Debug.Print("URL is: " + stringaddress);
                address = new Uri(stringaddress);
                request = WebRequest.Create(address);
                request.Method = "POST";
                request.ContentType = "text/xml";
                request.ContentLength = 0;
                WebHeaderCollection securityHeader = new WebHeaderCollection();
                securityHeader.Add(HttpRequestHeader.Cookie, cookieName + "=" + _ssoToken);

                //securityHeader.Add("NTSSOCookie", _ssoToken);
                request.Headers = securityHeader;
                response = request.GetResponse() as HttpWebResponse;


                XmlTextReader xmlReader = new XmlTextReader(response.GetResponseStream());
                while (xmlReader.Read())
                {
                    element = xmlReader.Name.ToString();
                    if (element == "errorMsg")
                    {
                        xmlReader.Read();
                        if (xmlReader.Value.ToString() != "")
                        {
                            errorText = xmlReader.Value.ToString();
                            failures = true;
                        }
                    }
                }

            }
            catch (WebException Ex)
            {
                MessageBox.Show("Web Exception thrown. Details: " + Ex.Message);
                failures = true;
            }

            if (failures)
                UpdateProgress("Failed to add Agent to Skillset!" + errorText);
            else
                UpdateProgress("Successfully added Agent to Skillset!");
            return;

        }
    }
}