using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;

namespace CCMAOpenInterfaces
{
    public partial class SOAPLoadTesting : Form
    {
        private bool _stopTest = false;
        
        private SOAP1.SOAP _ccmaClient;
        private LoadType _loadType;
        private delegate void SetResultsBox(string Text);
        private delegate void SetErrorBox(string Text);
        private int mSecondsTimer = 0;
        Logger logger;
        string clientToken;

        public SOAPLoadTesting(string CCMSIPAddress, string Token, string url, Logger mainLogger)
        {
            InitializeComponent();
            _ccmaClient = new CCMAOpenInterfaces.SOAP1.SOAP();
            _ccmaClient.Url = url;
            txtCCMSIPAddress.Text = CCMSIPAddress;
            logger = mainLogger;
            clientToken = Token;
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            rtbErrors.Clear();
            rtbResults.Clear();
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            _stopTest = true;
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            rtbErrors.Clear();
            rtbResults.Clear();

            if (txtMSeconds.Text == "")
            {
                MessageBox.Show("Provide time between calls in milli seconds!");
                return;
            }
            mSecondsTimer = int.Parse(txtMSeconds.Text);

            _stopTest = false;
            if (radGetAgent.Checked)
            {
                _loadType = LoadType.GetAgentDetails;
                if (txtParameter.Text == "")
                {
                    MessageBox.Show("Provide localID of agent in the parameter field!");
                    return;
                }
            }
            else if (radGetAgentSkillsets.Checked)
            {
                _loadType = LoadType.GetAgentsAssignedToSkillset;
                if (txtParameter.Text == "")
                {
                    MessageBox.Show("Provide skillset string in the parameter field!");
                    return;
                }
            }
           
            else if (radGetAllAgent.Checked)
            {
                _loadType = LoadType.GetAgentList;
            }
            else if (radGetAllSupervisors.Checked)
            {
                _loadType = LoadType.GetSupervisorList;
            }
            else if (radGetSkillsets.Checked)
            {
                _loadType = LoadType.GetSkillsetList;
            }
            else if (radGetSupervisor.Checked)
            {
                _loadType = LoadType.GetSupervisorDetails;
                if (txtParameter.Text == "")
                {
                    MessageBox.Show("Provide localID of supervisor in the parameter field!");
                    return;
                }
            }

            rtbResults.Text = DateTime.Now + ":" + DateTime.Now.Millisecond + " Load running........";

            Thread _loadTest = new Thread(new ThreadStart(LoadTest));
            _loadTest.Name = "LoadTest";
            _loadTest.Priority = ThreadPriority.AboveNormal;
            _loadTest.IsBackground = true;
            _loadTest.Start();
        }

        public void LoadTest() //will be run on a thread
        {
            /*****************************************************************************************************************************
             * This method contains calls to multiple server versions to refelect 
             * changes introduced in AACC 6.2.1 
             * --------------------------------------getAgentsList - AACC 6.4.1 Changes -------------------------------------------
             * The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
             * The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the 
             * ContactTypeAndRelatedSkillsets contains the ContactType attributes including a prefix property of type 
             * SkillsetPrefix which is an enumerated list of prefixes for the contact types (e.g. EM_ for email). 
             * The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
             * PO_
             * EV_
             * SN_
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the Prefix property. 
             * The prefix_Ex property should be used when interacting with a 6.4.1 or later CCMA server. The prefix property 
             * should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each skillset 
             * of a given contact type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. 
             * The range of values that can be returned in this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             * 
             * -------------------------------- getAgentDetails() - AACC 6.4.1 Changes -------------------------------------------
             *  The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
             * (The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the ContactTypeAndRelatedSkillsets 
             * contains the ContactType attributes including a prefix property of type SkillsetPrefix which is an enumerated list of prefixes 
             * for the contact types (e.g. EM_ for email). The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, 
             * which contains the additional values:
             * PO_
             * EV_
             * SN_
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the prefix property. 
             * The prefix_Ex property should be used when interacting with a 6.4.1 or later CCMA server. The prefix property 
             * should be used for all older servers.
             * 
             * ------------------------------ getSkillsetsList() AACC 6.4.1 Changes -----------------------------------------------
             * The Skillset object contains a ContactTypeID property of type int. The range of values that can be returned in this 
             * property has been extended.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             *
             * ------------------------------ getAgentsAssignedToSkillset() AACC 6.4.1 Changes --------------------------------------
             * The AgentFullDetails contains a new property offsiteAllowed of type integer (0 = Disabled, 1 = Enabled).
             * The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the ContactTypeAndRelatedSkillsets 
             * contains the ContactType attributes including a prefix property of type SkillsetPrefix which is an enumerated list of prefixes for 
             * the contact types (e.g. EM_ for email). The enum cannot be extended so a new enum has been added, SkillsetPrefix_Ex, which contains 
             * the additional values:
             * PO_
             * EV_
             * SN_    
             * NOTE: The EV_ value is not used by AACC.
             * The ContactType object has been extended to contain a prefix_Ex property in addition to the Prefix property. The prefix_Ex 
             * property should be used when interacting with a 6.4.1 or later CCMA server. The prefix property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each skillset of a given 
             * contact type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. The range of values that can be returned 
             * in this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015

            *****************************************************************************************************************************/



            string _errorString = string.Empty;
            string _resultString;
            long _counter = 0;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();
            // 6.2 API
            ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<CCMAOpenInterfaces.OIWebReference_62.soap>(basicHttpBinding,endpointAddress);
            OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel(); 
            
            
            do
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers["NTSSOCookie"] = clientToken;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    _counter++;
                    _resultString = string.Empty;
                    switch (_loadType)
                    {
                        case LoadType.GetAgentList:
                            try
                            {
                                if(Global.Version == SystemVersion.SixFour)
                                {
                                bool getAgentsListResult = false;
                                //SOAP.AgentFullDetails[] agentList;
                                OIWebReference.AgentFullDetails[] agentList;

                                //oiService.getAgentsList(txtCCMSIPAddress.Text, out getAgentsListResult, out getAgentsListResultSpecified, out agentList, out _errorString);
                                getAgentsListResult = oiService.getAgentsList(out agentList, out _errorString, txtCCMSIPAddress.Text);
                                if (getAgentsListResult)
                                {
                                    _resultString = "Results for getAgentsList, run " + _counter + ":SUCCESS\n";
                                    _resultString += agentList.Length.ToString() + " agents returned!";
                                    _resultString += "---------------------------------------------------------------\n";
                                    _resultString += "\n\n";
                                    logger.LogMessage(_resultString);
                                    //SetResultsText(_resultString);
                                }
                                else
                                {
                                    //Populate error list box
                                    SetErrorText("getAgentsListResult returned FALSE. Details from call: " + _errorString + "\n");
                                    _stopTest = true;
                                }
                                }
                                else if(Global.Version == SystemVersion.SixTwo)
                                { 
                                    bool getAgentListResult_62 = false;
                                    OIWebReference_62.AgentFullDetails[] agentList_62;
                                    getAgentListResult_62 = oiService_62.getAgentsList(out agentList_62, out _errorString, txtCCMSIPAddress.Text);
                                if (getAgentListResult_62)
                                {
                                    _resultString = "Results for getAgentsList, run " + _counter + ":SUCCESS\n";
                                    _resultString += agentList_62.Length.ToString() + " agents returned!";
                                    _resultString += "---------------------------------------------------------------\n";
                                    _resultString += "\n\n";
                                    logger.LogMessage(_resultString);
                                    //SetResultsText(_resultString);
                                }
                                else
                                {
                                    //Populate error list box
                                    SetErrorText("getAgentsListResult returned FALSE. Details from call: " + _errorString + "\n");
                                    _stopTest = true;
                                }
                                }
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the GetAgent method. Details from call: " + Ex.Message);
                                _stopTest = true;

                            }
                            
                            break;
                        case LoadType.GetSupervisorList:
                            try
                            {
                                bool getSupervisorListResult = false;
                                //SOAP.AgentBasicDetails[] supervisorList;
                                OIWebReference.AgentBasicDetails[] supervisorList;

                                //oiService.getSupervisorList(txtCCMSIPAddress.Text, out getSupervisorListResult, out getsupervisorListResultSpecified, out supervisorList, out _errorString);
                                getSupervisorListResult = oiService.getSupervisorList(out supervisorList, out _errorString, txtCCMSIPAddress.Text);
                                if (getSupervisorListResult)
                                {
                                    _resultString = "Results for getSupervisorList, run " + _counter + ":SUCCESS\n";
                                    _resultString += supervisorList.Length.ToString() + " supervisors returned!";
                                    _resultString += "---------------------------------------------------------------\n";
                                    _resultString += "\n\n";
                                    //SetResultsText(_resultString);
                                    logger.LogMessage(_resultString);
                                }
                                else
                                {
                                    //Populate error list box
                                    SetErrorText("getSupervisorListResult returned false. Details from call: " + _errorString + "\n");
                                    _stopTest = true;
                                }
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the GetSupervisor method. Details from call: " + Ex.Message);
                                _stopTest = true;

                            }
                            break;
                        case LoadType.GetAgentsAssignedToSkillset:

                            try
                            {
                                if (Global.Version == SystemVersion.SixFour)
                                {
                                    bool getAgentsAssignedToSkillsetResult = false;

                                    //SOAP.AgentFullDetails[] agentList;
                                    OIWebReference.AgentFullDetails[] agentList;

                                 
                                    getAgentsAssignedToSkillsetResult = oiService.getAgentsAssignedToSkillset(out agentList, out _errorString, txtParameter.Text, txtCCMSIPAddress.Text);
                                    if (getAgentsAssignedToSkillsetResult)
                                    {
                                        _resultString = "Results for getAgentsAssignedToSkillset, run " + _counter + ":SUCCESS\n";
                                        _resultString += "Agent Count: " + agentList.Length.ToString() + "\n";
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("getAgentsAssignedToSkillsetResult returned FALSE. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                }
                                else if (Global.Version == SystemVersion.SixTwo)
                                {
                                    bool getAgentsAssignedToSkillsetResult_62 = false;

                                    //SOAP.AgentFullDetails[] agentList;
                                    OIWebReference_62.AgentFullDetails[] agentList_62;

                            
                                    getAgentsAssignedToSkillsetResult_62 = oiService_62.getAgentsAssignedToSkillset(out agentList_62, out _errorString, txtParameter.Text, txtCCMSIPAddress.Text);
                                    if (getAgentsAssignedToSkillsetResult_62)
                                    {
                                        _resultString = "Results for getAgentsAssignedToSkillset, run " + _counter + ":SUCCESS\n";
                                        _resultString += "Agent Count: " + agentList_62.Length.ToString() + "\n";
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("getAgentsAssignedToSkillsetResult returned FALSE. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                } 
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the getAgentSkillsets method. Details from call: " + Ex.Message);
                                _stopTest = true;
                            }
                            break;

                        case LoadType.GetAgentDetails:
                            try
                            {
                                if (Global.Version == SystemVersion.SixFour)
                                {
                                    bool getDetailsResult = false;
                                    OIWebReference.CCTUserDetails _cctUserDetails = new CCMAOpenInterfaces.OIWebReference.CCTUserDetails();
                                   
                                    //SOAP.AgentFullDetails agentDetails;
                                    OIWebReference.AgentFullDetails agentDetails;

                                    //oiService.getAgentDetails(txtParameter.Text, txtCCMSIPAddress.Text, out getDetailsResult, out getDetailsResultSpecified, out agentDetails, out _errorString);
                                    getDetailsResult = oiService.getAgentDetails(out agentDetails, out _errorString, txtParameter.Text, txtCCMSIPAddress.Text, _cctUserDetails);
                                    if (getDetailsResult)
                                    {
                                        _resultString = "Results for getDetails, run " + _counter + ":SUCCESS\n";
                                        _resultString += "Agent Details: " + agentDetails.phoneSetLoginID + ", " + agentDetails.firstName + " " + agentDetails.lastName;
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("getDetailsResult returned FALSE. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                }
                                else if (Global.Version == SystemVersion.SixTwo)
                                {
                                    bool getDetailsResult_62 = false;
                                    OIWebReference_62.CCTUserDetails _cctUserDetails_62 = new CCMAOpenInterfaces.OIWebReference_62.CCTUserDetails();
                                    //SOAP.AgentFullDetails agentDetails;
                                    OIWebReference_62.AgentFullDetails agentDetails_62;


                                    getDetailsResult_62 = oiService_62.getAgentDetails(out agentDetails_62, out _errorString, txtParameter.Text, txtCCMSIPAddress.Text, _cctUserDetails_62);
                                    if (getDetailsResult_62)
                                    {
                                        _resultString = "Results for getDetails, run " + _counter + ":SUCCESS\n";
                                        _resultString += "Agent Details: " + agentDetails_62.phoneSetLoginID + ", " + agentDetails_62.firstName + " " + agentDetails_62.lastName;
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("getDetailsResult returned FALSE. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                }
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the getAllAgents method. Details from call: " + Ex.Message);
                                _stopTest = true;
                            }
                            break;
                        case LoadType.GetSupervisorDetails:
                            try
                            {
                                bool getSupervisorDetailsResult = false;
                                //SOAP.SupervisorFullDetails supervisor;
                                OIWebReference.SupervisorFullDetails supervisor;
                                
                                //oiService.getSupervisorDetails(txtParameter.Text, txtCCMSIPAddress.Text, out getSupervisorDetailsResult, out getSupervisorDetailsResultSpecified, out supervisor, out _errorString);
                                getSupervisorDetailsResult = oiService.getSupervisorDetails(out supervisor, out _errorString, txtParameter.Text, txtCCMSIPAddress.Text);
                                if (getSupervisorDetailsResult)
                                {
                                    _resultString = "Results for getSupervisorDetails, run " + _counter + ":SUCCESS\n";
                                    _resultString += "Agent Details: " + supervisor.phoneSetLoginID + ", " + supervisor.firstName + " " + supervisor.lastName;
                                    _resultString += "---------------------------------------------------------------\n";
                                    _resultString += "\n\n";
                                    //SetResultsText(_resultString);
                                    logger.LogMessage(_resultString);
                                }
                                else
                                {
                                    //Populate error list box
                                    SetErrorText("An error occurred while executing the getAllSupervisors method. Details from call: " + _errorString + "\n");
                                    _stopTest = true;
                                }
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the getAllSupervisors method. Details from call: " + Ex.Message);
                                _stopTest = true;
                            }
                            break;
                        case LoadType.GetSkillsetList:
                            try
                            {
                                if (Global.Version == SystemVersion.SixFour)
                                {
                                    bool getSkillsetsResult = false;
                                    //SOAP.Skillset[] listOfSkillsets;
                                    OIWebReference.Skillset[] listOfSkillsets;

                                    //oiService.getSkillsetsList(txtCCMSIPAddress.Text, out getSkillsetsResult, out getSkillsetsResultSpecified, out listOfSkillsets, out _errorString);
                                    getSkillsetsResult = oiService.getSkillsetsList(out listOfSkillsets, out _errorString, txtCCMSIPAddress.Text);

                                    if (getSkillsetsResult)
                                    {
                                        _resultString = "Results for getSkillsetsList, run " + _counter + ":SUCCESS\n";
                                        _resultString += "SkillsetsReturned: " + listOfSkillsets.Length.ToString();
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("An error occurred while executing the getAgentsBySkillsets method. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                }
                                else if (Global.Version == SystemVersion.SixTwo)
                                {
                                    bool getSkillsetsResult_62 = false;
                                    //SOAP.Skillset[] listOfSkillsets;
                                    OIWebReference_62.Skillset[] listOfSkillsets_62;

                                    //oiService.getSkillsetsList(txtCCMSIPAddress.Text, out getSkillsetsResult, out getSkillsetsResultSpecified, out listOfSkillsets, out _errorString);
                                    getSkillsetsResult_62 = oiService_62.getSkillsetsList(out listOfSkillsets_62, out _errorString, txtCCMSIPAddress.Text);

                                    if (getSkillsetsResult_62)
                                    {
                                        _resultString = "Results for getSkillsetsList, run " + _counter + ":SUCCESS\n";
                                        _resultString += "SkillsetsReturned: " + listOfSkillsets_62.Length.ToString();
                                        _resultString += "---------------------------------------------------------------\n";
                                        _resultString += "\n\n";
                                        //SetResultsText(_resultString);
                                        logger.LogMessage(_resultString);
                                    }
                                    else
                                    {
                                        //Populate error list box
                                        SetErrorText("An error occurred while executing the getAgentsBySkillsets method. Details from call: " + _errorString + "\n");
                                        _stopTest = true;
                                    }
                                }
                            }
                            catch (Exception Ex)
                            {
                                SetErrorText("An Exception was thrown while executing the getAgentsBySkillsets method. Details from call: " + Ex.Message);
                                _stopTest = true;
                            }
                            break;

                    }
                }
                Thread.Sleep(mSecondsTimer);
            }
            while (_stopTest == false);

            rtbResults.Text += "\n" + DateTime.Now + ":" + DateTime.Now.Millisecond + " Load Stopped........";


        }
        private void SetResultsText(string Text)
        {
            if (this.InvokeRequired == false)
            {
                this.rtbResults.Text += Text;
                this.rtbResults.Refresh();
            }
            else
            {
                SetResultsBox setResultsDel = new SetResultsBox(SetResultsText);
                this.BeginInvoke(setResultsDel, new object[] { Text });
            }
        }
        private void SetErrorText(string Text)
        {
            if (this.InvokeRequired == false)
            {
                this.rtbErrors.Text += Text;
                this.rtbErrors.Refresh();
            }
            else
            {
                SetErrorBox setErrorDel = new SetErrorBox(SetErrorText);
                this.BeginInvoke(setErrorDel, new object[] { Text });
            }
        }

        private void btnViewLogs_Click(object sender, EventArgs e)
        {
            frmLogger loggerForm = new frmLogger(logger);
            loggerForm.ShowDialog();
        }

        private void grpSelectMethod_Enter(object sender, EventArgs e)
        {

        }
    }
    public enum LoadType
    {
        GetAgentList,
        GetAgentDetails,
        GetSupervisorList,
        GetSupervisorDetails,
        GetSkillsetList,
        GetAgentsAssignedToSkillset
    }
}