﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CCMAOpenInterfaces
{
    public partial class frmLogger : Form
    {
        Logger localLogger;

        public frmLogger(Logger logger)
        {
            InitializeComponent();
            localLogger = logger;
            ReadLog();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        public void ReadLog()
        {
            string filename = Application.StartupPath + "\\CCMAOILog.txt";
            localLogger.CloseAllStreams();
            FileStream fileStream = null;
            StreamReader streamReader = null;
            string tmpString = string.Empty;

            try
            {
                fileStream = new FileStream(filename, FileMode.Open, FileAccess.Read);
                streamReader = new StreamReader(fileStream);
            }
            catch
            {
                if (fileStream != null)
                    fileStream.Close();
            }

            while (streamReader.Peek() >= 0)
            {
                tmpString += streamReader.ReadLine() + "\n";
            }

            rtbLogDetails.Text = tmpString;
            streamReader.Close();
            fileStream.Close();
            localLogger.ReOpenAllStreams();
        }
    }
}
