using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace CCMAOpenInterfaces
{

    public class Logger
    {
        string _filename;
        FileStream _fileStreamLog;
        StreamWriter _streamWriterLog;

        public Logger(InterfaceType Type)
        {

            _filename = Application.StartupPath + "\\CCMAOILog.txt";


            _fileStreamLog = new FileStream(_filename, FileMode.Append, FileAccess.Write);
            _streamWriterLog = new StreamWriter(_fileStreamLog);
            try
            {
                _streamWriterLog.WriteLine("Starting Logging....");
            }

            catch (System.InvalidOperationException ExInvalid)
            {
                System.Diagnostics.Debug.Print("could not open log file: " + ExInvalid.Message);
            }
            catch (Exception Ex)
            {
                MessageBox.Show("Error: " + Ex.Message);
            }
        }
        public void CloseLogger()
        {
            if (_streamWriterLog != null)
                _streamWriterLog.Close();
            if (_fileStreamLog != null)
                _fileStreamLog.Close();
        }
        public void LogMessage(string Message)
        {
            string _logMessage;
            try
            {
                _logMessage = DateTime.Now + ":" + DateTime.Now.Millisecond + "," + Message;
                _streamWriterLog.WriteLine(_logMessage);
            }
            catch (Exception Ex)
            {
                MessageBox.Show("Error on Logging: " + Ex.Message);
            }
        }
        public void CloseAllStreams()
        {
            //close all streams
            CloseStreams();
            if (_fileStreamLog != null)
                _fileStreamLog.Close();

        }
        
        public void ReOpenAllStreams()
        {
            _fileStreamLog = new FileStream(_filename, FileMode.Append, FileAccess.Write);
            _streamWriterLog = new StreamWriter(_fileStreamLog);

        }
        private void CloseStreams()
        {
            if (_streamWriterLog != null)
                _streamWriterLog.Close();
        }

    }
}
