﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;

namespace CCMAOpenInterfaces
{
    public partial class ActivityCodes : Form
    {
        private string userToken;
        private string ccmaURL;
        private string cookieName;
        private string UserID;

        public ActivityCodes(string Token, string URL, string COOKIE, string strUserID)
        {
            InitializeComponent();
            userToken = Token;
            ccmaURL = URL;
            cookieName = COOKIE;
            UserID = strUserID;
            GetServerList();
        }

        private void ActivityCodes_Load(object sender, EventArgs e)
        {

        }

        private void GetActivityCodes()
        {

        }

        public void GetServerList()
        {
            /* ****************************************************************************************************************************
             * This method contains calls to multiple servers to reflect the changes 
             * introduced in AACC 6.4.1 
             * ------------------------------ getServerList() - AACC 6.4.1 Changes --------------------------------------
             * This method returns an array of CCMSServer objects. Each CCMSServer object contains a ServerType object 
             * which in turn contains a Name property. The Name property is of type serverTypeName which is an enumerated list.
             * New server types have been added in 6.4.1 so a new enum is required: serverTypeName_Ex. The new server types and id’s are:
             * CCPO	(1005)
             * AMS	(1006)
             * IPO	(1007)

             * The ServerType object now contains a new property Name_Ex of type serverTypeName_Ex.
             * This will be populated by 6.4.1 and later servers. 
            *****************************************************************************************************************************/

            string errorMessage = string.Empty;
            OIWebReference.CCMSServer[] ccmsServers;
            OIWebReference_62.CCMSServer[] ccmsServers_62;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);


            if (Global.Version == SystemVersion.SixFour)
            {
                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                //Add in dummy CCMS server address
                cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    try
                    {
                        int count = oiService.getServerList(out ccmsServers, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            //MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference.CCMSServer srvr in ccmsServers)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);

                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                //Add in dummy CCMS server address
                cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    try
                    {
                        int count = oiService_62.getServerList(out ccmsServers_62, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            //MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference_62.CCMSServer srvr in ccmsServers_62)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);

                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else
            {
                MessageBox.Show("Openinterface version not supported!");
            }
        }

        private void cboServerList_SelectedIndexChanged(object sender, EventArgs e)
        {
            string ccmsIP = string.Empty;
            OIWebReference.ActivityCodes[] activityCodeList;
            string errorMessage = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "155.55.55.55";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            dgvActivityCodes.Rows.Clear();

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
            {
                if (ckbExcludeToken.Checked)
                {
                    //Dont add any header!
                }
                else if (ckbInvalidToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                else
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                try
                {
                    int count = oiService.getActivityCodes(out activityCodeList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getActivityCodes returned an error " + errorMessage);
                    else
                        MessageBox.Show("Web service getActivityCodes returned with result code " + count);

                    foreach (OIWebReference.ActivityCodes code in activityCodeList)
                    {
                        int n = dgvActivityCodes.Rows.Add();
                        dgvActivityCodes.Rows[n].Cells[0].Value = code.ID;
                        dgvActivityCodes.Rows[n].Cells[1].Value = code.Name;
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error executing getActivityCodes. Details: " + Ex.Message);
                }
            }
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
