using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace CCMAOpenInterfaces
{
    public partial class frmLogin : Form
    {
       
        private bool stopTest = true;
        private AuthenticationService.AuthenticationService localAuthenticate;
        string ssoToken = string.Empty;
        private delegate void SetResultsBox(string Text);
        private Logger localLogger;
        private int timer = 0;
        string username;
        string password;

        public frmLogin(AuthenticationService.AuthenticationService authenticate)
        {
            localAuthenticate = authenticate;
            localLogger = new Logger(InterfaceType.SOAPLogin);
            InitializeComponent();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            rtbResults.Clear();

            if (txtUserName.Text == "")
            {
                MessageBox.Show("Invalid User!");
                return;
            }

            if (txtPassword.Text == "")
            {
                MessageBox.Show("Invalid Password!");
                return;
            }
            username = txtUserName.Text;
            password = txtPassword.Text;

            timer = int.Parse(txtTimer.Text);
            int result;
            int.TryParse(txtTimer.Text, out result);
            if (result == 0)
            {
                MessageBox.Show("Invalid Timer!");
                return;
            }

            this.btnStart.Enabled = false;
            stopTest = false;
            rtbResults.Text = DateTime.Now + ":" + DateTime.Now.Millisecond + " Load running........";
            Thread _loadTest = new Thread(new ThreadStart(LoadTest));
            _loadTest.Name = "LoadTest";
            _loadTest.Priority = ThreadPriority.AboveNormal;
            _loadTest.IsBackground = true;
            _loadTest.Start();
        }
        

        public void LoadTest() //will be run on a thread
        {
            string errorResult = string.Empty;
            int i = 0;

            do
            {
                i++;

                //Login
                if (!localAuthenticate.AuthenticateUser(username, password, out ssoToken, out errorResult))
                {
                    localLogger.LogMessage("Error logging in user. Details: " + errorResult + "\n");
                    SetResultsText("Error logging in user. Details: " + errorResult + "\n");
                }
                else
                    localLogger.LogMessage("Run " + i.ToString() + " Login Success. SSO Token: " + ssoToken + "\n");
                    SetResultsText("Run " + i.ToString() + " Login Success. SSO Token: " + ssoToken + "\n");

                Thread.Sleep(timer);

                //Validate ssoToken
                if (!localAuthenticate.AuthenticateToken(ssoToken, out errorResult))
                {
                    localLogger.LogMessage("Error verifying token. Details: " + errorResult + "\n");
                    SetResultsText("Error verifying token. Details: " + errorResult + "\n");
                }
                else
                    localLogger.LogMessage("Run " + i.ToString() + " Token authentication success. SSO Token: " + ssoToken + "\n");
                    SetResultsText("Run " + i.ToString() + " Token authentication success. SSO Token: " + ssoToken + "\n");

                Thread.Sleep(timer);

                //Logout
                if (!localAuthenticate.LogoutToken(ssoToken, out errorResult))
                {
                    localLogger.LogMessage("Error logging out user. Details: " + errorResult + "\n");
                    SetResultsText("Error logging out user. Details: " + errorResult + "\n");
                }
                else
                    localLogger.LogMessage("Run " + i.ToString() + " Logout Success.\n");
                    SetResultsText("Run " + i.ToString() + " Logout Success.\n");

                Thread.Sleep(timer);
                

            }
            while (stopTest == false);

            SetResultsText("\n" + DateTime.Now + ":" + DateTime.Now.Millisecond + " Load Stopped.Check Log file for details.");

        }

        private void SetResultsText(string Text)
        {
            if (this.InvokeRequired == false)
            {
                this.rtbResults.Text += Text;
                this.rtbResults.Refresh();
            }
            else
            {
                SetResultsBox setResultsDel = new SetResultsBox(SetResultsText);
                this.BeginInvoke(setResultsDel, new object[] { Text });
            }
        }
        private void btnStop_Click(object sender, EventArgs e)
        {
            //this.rtbResults.Text = "Load Stopped!";
            stopTest = true;
            this.btnStart.Enabled = true;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            localLogger.CloseLogger();
        }
    }
}