﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;
using System.ServiceModel.Description;
using System.IO;

namespace CCMAOpenInterfaces
{
    public partial class LoadTesting : Form
    {
        private string userToken;
        private string cookieName;
        private string UserID;
        ChannelFactory<OIWebReference.soap> oiChannelFactory = null;
        ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = null;
        string token = string.Empty;
        string CCMSIP;
        string CCMAIP;
        string url;
        Credentials localCredentials = null;
        AuthenticationService.AuthenticationService authenticate = null;
        string authenticateURL;
        string ssoToken = string.Empty;
        private string ccmaURL;
        string strSSOCookieName = "";



        public LoadTesting(string Token, string URL,string COOKIE, string strUserID)
        {
            InitializeComponent();
            txtNumberTime.Text = "1";
            userToken = Token;
            ccmaURL = URL;
            cookieName = COOKIE;
            UserID = strUserID;
            Cursor.Current = Cursors.WaitCursor;
            //txtInfo.AppendText("Start call to get server list " + DateTime.Now + "\n");
            btnGetServers_Click(this, null);
            //GetServerList();
            //txtInfo.AppendText("Finished call to get server list " + DateTime.Now + "\n"); 
            Cursor.Current = Cursors.Default;
        }

        private void LoadTesting_Load(object sender, EventArgs e)
        {
            txtPassword.Text = "webadmin";
            txtUserID.Text = "webadmin";
        }

        private void btLogin_Click(object sender, EventArgs e)
        {
            string error = string.Empty;
            try
            {
                txtInfo.AppendText("Start login at " + DateTime.Now + "\n");
                if (!authenticate.AuthenticateUser(txtUserID.Text, txtPassword.Text, out ssoToken, out error))
                {
                    MessageBox.Show("Error logging in user " + localCredentials.UserID + ". Error: " + error);
                    return;
                }
                else
                {
                    txtInfo.AppendText("Login success. Token returned: " + ssoToken + "\n");
                    txtInfo.AppendText("login at " + DateTime.Now + "\n");

                    //MessageBox.Show("Login success. Token returned: " + ssoToken);
                    //this.Text = "CCMA Open Interfaces Client - Logged In!";
                    //Get the SSO cookie name
                    strSSOCookieName = authenticate.GetSSOCookieName(out error);

                    txtInfo.AppendText("Start call to get server list " + DateTime.Now + "\n"); 
                    GetServerList();
                    txtInfo.AppendText("Finished call to get server list " + DateTime.Now + "\n"); 

                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("An exception was raised while attempting to authenticate user. Details: " + Ex.Message);
            }
        }
        private void ConnectionSetup_62(out string errorMessage, out OIWebReference_62.soap oiService)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
            oiService = oiChannelFactory_62.CreateChannel();
        }

        private void ConnectionSetup(out string errorMessage, out OIWebReference.soap oiService)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            oiService = oiChannelFactory.CreateChannel();
        }

        public void GetServerList()
        {
            /* ***********************************************************************************************
             * This method contains calls to multiple server versions to reflect the changes 
             * introduced in AACC 6.4.1
             * ----------------------getServersList() - AACC 6.4.1 Changes -------------------------------
             * This method returns an array of CCMSServer objects. Each CCMSServer object contains 
             * a ServerType object which in turn  contains a Name property. The Name property is of type 
             * serverTypeName which is an enumerated list. New server types have been added in 6.4.1 so a 
             * new enum is required: serverTypeName_Ex. The new server types and id’s are:
             * CCPO	(1005)
             * AMS	(1006)
             * IPO	(1007)
             * The ServerType object now contains a new property Name_Ex of type serverTypeName_Ex. 
             * This will be populated by 6.4.1 and later servers. 
             * 
             * ***********************************************************************************************/ 

            OIWebReference.CCMSServer[] ccmsServers;
            OIWebReference_62.CCMSServer[] ccmsServers_62; 
            string errorMessage;
            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62; 


            //Add in dummy CCMS server address
            cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");


            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);


                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    //requestProperty.Headers["NTSSOCookie"] = userToken;
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    try
                    {

                        int count = oiService.getServerList(out ccmsServers, out errorMessage);
                        if (errorMessage != "")
                            txtInfo.AppendText("Error message was populated with " + errorMessage + "\n");
                        else
                        {
                            txtInfo.AppendText("GetServerList succeeded with return value of " + count + "\n");
                            foreach (OIWebReference.CCMSServer srvr in ccmsServers)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        txtInfo.AppendText("Error retrieving server list. Details: " + Ex.Message + "\n");
                    }

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);


                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    //requestProperty.Headers["NTSSOCookie"] = userToken;
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    try
                    {

                        int count = oiService_62.getServerList(out ccmsServers_62, out errorMessage);
                        if (errorMessage != "")
                            txtInfo.AppendText("Error message was populated with " + errorMessage + "\n");
                        else
                        {
                            txtInfo.AppendText("GetServerList succeeded with return value of " + count + "\n");
                            foreach (OIWebReference_62.CCMSServer srvr in ccmsServers_62)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        txtInfo.AppendText("Error retrieving server list. Details: " + Ex.Message + "\n");
                    }

                }
            }
            else
            {
                MessageBox.Show("Open Interface version not supported!");
            }
        }

        private void ReadConfig()
        {
            FileStream fs;

            try
            {
                fs = new FileStream((Application.StartupPath + "\\AppConfig.txt"), FileMode.Open, FileAccess.Read);
            }
            catch (IOException ex)
            {
                MessageBox.Show("  Error: ReadConfig:" + ex.ToString());
                return;
            }

            StreamReader sr = new StreamReader(fs);
            //switch statement to match parameters, case sensitive

            string[] strArray;
            string strKey = string.Empty;
            string strValue = string.Empty;

            while (sr.Peek() >= 0)
            {
                try
                {
                    strKey = string.Empty;
                    strKey = sr.ReadLine();
                    strValue = "";
                    strArray = strKey.Split(new string[] { " " }, StringSplitOptions.RemoveEmptyEntries);

                    strKey = strArray[0];
                    if (strArray.Length > 1)
                    {
                        strValue = strArray[1];
                    }
                    switch (strKey)
                    {
                        //Setup CCT credentials
                        case "CCMSIP":
                            CCMSIP = strValue;
                            break;
                        case "URL":
                            url = strValue;
                            break;
                        case "CCMAIP":
                            CCMAIP = strValue;
                            break;
                        case "AuthenticateURL":
                            authenticateURL = strValue;
                            break;
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error extracting details from the AppConfig File. Details:" + Ex.Message);
                }
            }

            sr.Close();
            fs.Close();
        }

        private void btnGetServers_Click(object sender, EventArgs e)
        {
            DateTime execTime = DateTime.Now;
            cboServerList.Items.Clear();
            GetServerList();
            txtInfo.AppendText("get server list took " + (DateTime.Now - execTime) + "\n");
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtInfo.Clear();
        }

        private void btRunTest_Click(object sender, EventArgs e)
        {
            DateTime execTime = DateTime.Now;
            for (int i = 0; i < Convert.ToInt32(txtNumberTime.Text); i++)
            {
                btnGetServers_Click(this, null);
            }
            txtInfo.AppendText("Complete Run took for " + txtNumberTime.Text + " Calls took " + (DateTime.Now - execTime) + "\n");

        }
    }
}
