﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;

namespace CCMAOpenInterfaces
{
    public partial class ServerList : Form
    {

        private string userToken;
        private string ccmaURL;
        private string cookieName;
        private string UserID;

        public ServerList(string Token, string URL, string COOKIE, string strUserID)
        {
            InitializeComponent();
            userToken = Token;
            ccmaURL = URL;
            cookieName = COOKIE;
            UserID = strUserID;
            GetServerList();
        }

        public void GetServerList()
        {
            string errorMessage = string.Empty;
            OIWebReference.CCMSServer[] ccmsServers;
            OIWebReference_62.CCMSServer[] ccmsServers_62; 

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);

            if (Global.Version == SystemVersion.SixFour)
            {
                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (ckbExcludeToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + "InvalidToken");
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int count = oiService.getServerList(out ccmsServers, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            int m = 0;
                            foreach (OIWebReference.CCMSServer srvr in ccmsServers)
                            {
                                m = dgvServers.Rows.Add();
                                dgvServers.Rows[m].Cells[0].Value = srvr.HostIpAddress;
                                dgvServers.Rows[m].Cells[1].Value = srvr.Name;
                                dgvServers.Rows[m].Cells[2].Value = srvr.DisplayName;
                                dgvServers.Rows[m].Cells[3].Value = srvr.CCMAUserID;
                                dgvServers.Rows[m].Cells[4].Value = srvr.CCMAUserName;
                                dgvServers.Rows[m].Cells[5].Value = srvr.HasLoadedOK.ToString();
                                dgvServers.Rows[m].Cells[6].Value = srvr.IsBasicIVREnabled.ToString();
                                dgvServers.Rows[m].Cells[7].Value = srvr.isExpress.ToString();
                                dgvServers.Rows[m].Cells[8].Value = srvr.IsHeteroNetworkingEnabled.ToString();
                                dgvServers.Rows[m].Cells[9].Value = srvr.IsNetworked.ToString();
                                dgvServers.Rows[m].Cells[10].Value = srvr.IsOpenQueueEnabled.ToString();
                                dgvServers.Rows[m].Cells[11].Value = srvr.isSecurityEnabled.ToString();
                                dgvServers.Rows[m].Cells[12].Value = srvr.Password;
                                dgvServers.Rows[m].Cells[13].Value = srvr.SID.ToString();
                                dgvServers.Rows[m].Cells[14].Value = srvr.Type.Name_Ex.ToString();
                                dgvServers.Rows[m].Cells[15].Value = srvr.UserID;
                                dgvServers.Rows[m].Cells[16].Value = srvr.Version.Major.ToString() + "." + srvr.Version.Minor.ToString() + "." + srvr.Version.Revision;

                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbExcludeToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + "InvalidToken");
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int count = oiService_62.getServerList(out ccmsServers_62, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            int m = 0;
                            foreach (OIWebReference_62.CCMSServer srvr in ccmsServers_62)
                            {
                                m = dgvServers.Rows.Add();
                                dgvServers.Rows[m].Cells[0].Value = srvr.HostIpAddress;
                                dgvServers.Rows[m].Cells[1].Value = srvr.Name;
                                dgvServers.Rows[m].Cells[2].Value = srvr.DisplayName;
                                dgvServers.Rows[m].Cells[3].Value = srvr.CCMAUserID;
                                dgvServers.Rows[m].Cells[4].Value = srvr.CCMAUserName;
                                dgvServers.Rows[m].Cells[5].Value = srvr.HasLoadedOK.ToString();
                                dgvServers.Rows[m].Cells[6].Value = srvr.IsBasicIVREnabled.ToString();
                                dgvServers.Rows[m].Cells[7].Value = srvr.isExpress.ToString();
                                dgvServers.Rows[m].Cells[8].Value = srvr.IsHeteroNetworkingEnabled.ToString();
                                dgvServers.Rows[m].Cells[9].Value = srvr.IsNetworked.ToString();
                                dgvServers.Rows[m].Cells[10].Value = srvr.IsOpenQueueEnabled.ToString();
                                dgvServers.Rows[m].Cells[11].Value = srvr.isSecurityEnabled.ToString();
                                dgvServers.Rows[m].Cells[12].Value = srvr.Password;
                                dgvServers.Rows[m].Cells[13].Value = srvr.SID.ToString();
                                dgvServers.Rows[m].Cells[14].Value = srvr.Type.Name.ToString();
                                dgvServers.Rows[m].Cells[15].Value = srvr.UserID;
                                dgvServers.Rows[m].Cells[16].Value = srvr.Version.Major.ToString() + "." + srvr.Version.Minor.ToString() + "." + srvr.Version.Revision;

                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }

                }
            }
            else
            {
                MessageBox.Show("Version is not supported!"); 
            } 
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            dgvServers.Rows.Clear();
            GetServerList();
        }

    }
}
