﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;
using System.Security.Cryptography.X509Certificates;
using System.Net.Security;
using System.Web;



namespace CCMAOpenInterfaces
{
    public partial class SkillsetMaintenance : Form
    {
        private string userToken;
        private string ccmaURL;
        private string cookieName;
        private string UserID;

        ChannelFactory<OIWebReference.soap> oiChannelFactory = null;
        ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = null;

        public static int inum = 0;

        public SkillsetMaintenance(string Token, string URL, string COOKIE, string strUserID)
        {

            ServicePointManager.ServerCertificateValidationCallback = new RemoteCertificateValidationCallback(ValidateServerCertificate);

            InitializeComponent();
            userToken = Token;
            ccmaURL = URL;
            cookieName = COOKIE;
            UserID = strUserID;
            Cursor.Current = Cursors.WaitCursor;
            GetServerList();
            Cursor.Current = Cursors.Default;

        }

        // The following method is invoked by the RemoteCertificateValidationDelegate.
        public static bool ValidateServerCertificate(
              object sender,
              X509Certificate certificate,
              X509Chain chain,
              SslPolicyErrors sslPolicyErrors)
        {
            if (sslPolicyErrors != SslPolicyErrors.None)
            {
                if (inum == 0)
                {
                    inum++;
                }

                // SSL Certificate Error
                //return false;
            }

            // always allow this client to communicate with unauthenticated servers.
            // HACK remove this backdoor & test before putting code into production
            return true;
        }

        private void ConnectionSetup_62(out string errorMessage, out OIWebReference_62.soap oiService)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
            oiService = oiChannelFactory_62.CreateChannel();
        }

        private void ConnectionSetup(out string errorMessage, out OIWebReference.soap oiService)
        {
            BasicHttpBinding basicHttpBinding = null;
            errorMessage = string.Empty;

            EndpointAddress endpointAddress = new EndpointAddress(ccmaURL);
            if (endpointAddress.Uri.Scheme == Uri.UriSchemeHttps)
                basicHttpBinding = new BasicHttpBinding(BasicHttpSecurityMode.Transport);
            else
                basicHttpBinding = new BasicHttpBinding();

            basicHttpBinding.CloseTimeout = TimeSpan.FromMinutes(5);
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            oiService = oiChannelFactory.CreateChannel();
        }

        private void ConnectionShutdown_62()
        {
            if (null != oiChannelFactory_62)
                oiChannelFactory_62.Close();
        }

        private void ConnectionShutdown()
        {
            if (null != oiChannelFactory)
                oiChannelFactory.Close();
        }


        private void cboServerList_SelectedIndexChanged(object sender, EventArgs e)
        {
            PopulateSkillsets();
        }

        

        private void dgvSkillsets_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            /*****************************************************************************************************************************
             * This method makes calls to multiple server versions to reflect the changes 
             * introduced in AACC 6.4.1
             * ------------------------- getSkillsetConfigurationDetails()- AACC 6.4.1 Changes --------------------------------
             * AACC 6.4.1 supports additional contact types for “POM outbound” and “Social Networking” contacts. 
             * The getSkillsetConfigurationDetails method returns an array of SkillsetConfigDetails objects each of which 
             * contains a ContactTypeID property of type int. The range of values that can be returned in this int has been 
             * extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015

             * The SkillsetConfigDetails object also contains a “prefix” property of type SkillsetPrefix which is an 
             * enumerated list of prefixes for the contact types (e.g. “EM_” for email). The existing enum cannot be 
             * extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The SkillsetConfigDetails object has been extended to contain a “prefix_Ex” property in addition to the “Prefix” property. 
             * Clients interacting with 6.4.1 servers should use the “prefix_Ex” property. Clients should continue to use the “prefix”
             * property in order to remain backward compatible with older AACC servers.
             *****************************************************************************************************************************/



            if (e.RowIndex == -1)
                return;

            if (dgvSkillsets.SelectedRows.Count == 0)
                return;

            Cursor.Current = Cursors.WaitCursor;

            int selectedSkillsetID = int.Parse(dgvSkillsets.SelectedRows[0].Cells[0].Value.ToString());

            OIWebReference.SkillsetConfigDetails[] skillsetConfigList;
            OIWebReference_62.SkillsetConfigDetails[] skillsetConfigList_62;
            string errorMessage = string.Empty;
            string ccmsIP = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "invalid";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            if (Global.Version == SystemVersion.SixFour)
            {

                OIWebReference.soap oiService;
                ConnectionSetup(out errorMessage, out oiService);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService.getSkillsetConfigurationDetails(out skillsetConfigList, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getSkillsetConfigurationDetails returned an error " + errorMessage);
                        else
                            MessageBox.Show("Web service executed with return code " + result);

                        foreach (OIWebReference.SkillsetConfigDetails skillset in skillsetConfigList)
                        {
                            if (skillset.ID == selectedSkillsetID)
                            {
                                txtACdDNMap.Text = skillset.mapToACDDN;
                                txtCallAgePref.Text = skillset.callAgePreference.ToString();
                                txtCallReqQueueSize.Text = skillset.callRequestQueueSize.ToString();
                                txtCallSourcePref.Text = skillset.callSourcePreference.ToString();
                                txtComment.Text = skillset.comment;
                                txtContactType.Text = skillset.ContactTypeID.ToString();
                                txtDefaultActivityCode.Text = skillset.defaultActivityCode;
                                txtFlowControlThreshold.Text = skillset.flowControlThreshold.ToString();
                                txtID.Text = skillset.ID.ToString();
                                txtNetworkSkillsetID.Text = skillset.networkSkillsetID;
                                txtOutOfServiceMode.Text = skillset.outOfServiceMode.ToString();
                                txtPrefix.Text = skillset.prefix_Ex.ToString();
                                txtSkillsetName.Text = skillset.Name;
                                txtSkillsetType.Text = skillset.skillsetType.ToString();
                                txtThresholdClass.Text = skillset.thresholdClass.ToString();
                                ckbIncludeLocalNode.Checked = skillset.includeLocalNode;


                                //RemoveForAACC6.1
                                try
                                {
                                    //    cbServiceLevelRouting.Checked = skillset.ServiceLevelRouting;
                                    //    tbTargetServicelevel.Text = skillset.TargetServiceLevel.ToString();
                                }
                                catch (Exception)
                                {
                                    MessageBox.Show("Service level routing is not supported");
                                    cbServiceLevelRouting.Checked = false;
                                    tbTargetServicelevel.Text = "0";
                                }
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error encountered while executing getSkillsetConfigurationDetails. Details: " + Ex.Message);
                        Cursor.Current = Cursors.Default;

                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                    Cursor.Current = Cursors.Default;
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                OIWebReference_62.soap oiService_62;
                ConnectionSetup_62(out errorMessage, out oiService_62);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService_62.getSkillsetConfigurationDetails(out skillsetConfigList_62, out errorMessage, ccmsIP);

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service getSkillsetConfigurationDetails returned an error " + errorMessage);
                        else
                            MessageBox.Show("Web service executed with return code " + result);

                        foreach (OIWebReference_62.SkillsetConfigDetails skillset in skillsetConfigList_62)
                        {
                            if (skillset.ID == selectedSkillsetID)
                            {
                                txtACdDNMap.Text = skillset.mapToACDDN;
                                txtCallAgePref.Text = skillset.callAgePreference.ToString();
                                txtCallReqQueueSize.Text = skillset.callRequestQueueSize.ToString();
                                txtCallSourcePref.Text = skillset.callSourcePreference.ToString();
                                txtComment.Text = skillset.comment;
                                txtContactType.Text = skillset.ContactTypeID.ToString();
                                txtDefaultActivityCode.Text = skillset.defaultActivityCode;
                                txtFlowControlThreshold.Text = skillset.flowControlThreshold.ToString();
                                txtID.Text = skillset.ID.ToString();
                                txtNetworkSkillsetID.Text = skillset.networkSkillsetID;
                                txtOutOfServiceMode.Text = skillset.outOfServiceMode.ToString();
                                txtPrefix.Text = skillset.prefix.ToString();
                                txtSkillsetName.Text = skillset.Name;
                                txtSkillsetType.Text = skillset.skillsetType.ToString();
                                txtThresholdClass.Text = skillset.thresholdClass.ToString();
                                ckbIncludeLocalNode.Checked = skillset.includeLocalNode;


                                //RemoveForAACC6.1
                                try
                                {
                                    //    cbServiceLevelRouting.Checked = skillset.ServiceLevelRouting;
                                    //    tbTargetServicelevel.Text = skillset.TargetServiceLevel.ToString();
                                }
                                catch (Exception)
                                {
                                    MessageBox.Show("Service level routing is not supported");
                                    cbServiceLevelRouting.Checked = false;
                                    tbTargetServicelevel.Text = "0";
                                }
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error encountered while executing getSkillsetConfigurationDetails. Details: " + Ex.Message);
                        Cursor.Current = Cursors.Default;

                    }
                    finally
                    {
                        ConnectionShutdown();
                    }
                    Cursor.Current = Cursors.Default;
                }
            }
            else
            {
                MessageBox.Show("Version not supported!");
            } 
        }
    

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {

            if (dgvSkillsets.SelectedRows.Count == 0)
                return;

            int selectedSkillsetID = int.Parse(dgvSkillsets.SelectedRows[0].Cells[0].Value.ToString());
            string errorMessage = string.Empty;
            string ccmsIP = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "invalid";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            OIWebReference.soap oiService;
            ConnectionSetup(out errorMessage, out oiService);

            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
            {
                if (ckbNoToken.Checked)
                {
                    //Dont add any header!
                }
                else if (ckbInvalidToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                else
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                try
                {
                    int result = oiService.deleteSkillset(out errorMessage, ccmsIP, selectedSkillsetID.ToString());
                    if (errorMessage != string.Empty)
                        MessageBox.Show("Error message generated " + errorMessage);
                    else
                        MessageBox.Show("Successfully deleted skillset " + selectedSkillsetID + " with return code " + result);
                        
                }
                catch(Exception Ex)
                {
                    MessageBox.Show("Error deleting skillset. Details: " + Ex.Message);
                }
            }

            PopulateSkillsets();
        }

  
        #region Methods
        public void GetServerList()
        {
            /* ****************************************************************************************************************************
             * This method contains calls to multiple server versions to reflect the changes 
             * introduced in AACC 6.4.1 
             * ------------------------- getServersList() - AACC 6.4.1 Changes -------------------------------------------
             * This method returns an array of CCMSServer objects. Each CCMSServer object contains a ServerType object 
             * which in turn contains a Name property. The Name property is of type serverTypeName which is an enumerated list.
             * New server types have been added in 6.4.1 so a new enum is required: serverTypeName_Ex. The new server types and id’s are:
             * CCPO	(1005)
             * AMS	(1006)
             * IPO	(1007)
             * The ServerType object now contains a new property Name_Ex of type serverTypeName_Ex.
             * This will be populated by 6.4.1 and later servers. 
            *****************************************************************************************************************************/

            string errorMessage = string.Empty;
            OIWebReference.CCMSServer[] ccmsServers;
            OIWebReference_62.CCMSServer[] ccmsServers_62; 

            OIWebReference.soap oiService;
            OIWebReference_62.soap oiService_62;

            if (Global.Version == SystemVersion.SixFour)
            {
                ConnectionSetup(out errorMessage, out oiService);


                //Add in dummy CCMS server address
                cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    //interfacesrequestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; NTSSOUserID=" + UserID);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    try
                    {

                        int count = oiService.getServerList(out ccmsServers, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            //MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference.CCMSServer srvr in ccmsServers)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown();
                    }

                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ConnectionSetup_62(out errorMessage, out oiService_62);


                //Add in dummy CCMS server address
                cboServerList.Items.Add("172.15.15.15" + ", " + "Invalid CCMS Server");

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();

                    //Add the cookie to the request
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    //interfacesrequestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken + "; NTSSOUserID=" + UserID);


                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    try
                    {

                        int count = oiService_62.getServerList(out ccmsServers_62, out errorMessage);
                        if (errorMessage != "")
                            MessageBox.Show("Error message was populated with " + errorMessage);
                        else
                        {
                            //MessageBox.Show("GetServerList succeeded with return value of " + count);
                            foreach (OIWebReference_62.CCMSServer srvr in ccmsServers_62)
                            {
                                cboServerList.Items.Add(srvr.HostIpAddress + ", " + srvr.Name + ", " + srvr.DisplayName);
                            }
                        }
                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error retrieving server list. Details: " + Ex.Message);
                    }
                    finally
                    {
                        ConnectionShutdown_62();
                    }

                }
            }
            else
            {
                MessageBox.Show("Open Interface version not supported!");
            } 
        }

        public void PopulateSkillsets()
        {
            string ccmsIP = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "155.55.55.55";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];


            OIWebReference.Skillset[] skillsetList;
            OIWebReference.ThresholdClass[] sillsetThresholds;
            string errorMessage = string.Empty;

            cboSkillsetThreshold.Items.Clear();

            dgvSkillsets.Rows.Clear();

            OIWebReference.soap oiService;
            ConnectionSetup(out errorMessage, out oiService);

            //Add in dummy skillset for testing purposes
            int m = dgvSkillsets.Rows.Add();
            dgvSkillsets.Rows[m].Cells[0].Value = "76543";
            dgvSkillsets.Rows[m].Cells[1].Value = "DummySkillset";
            dgvSkillsets.Rows[m].Cells[2].Value = "88";

            using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
            {
                if (ckbNoToken.Checked)
                {
                    //Dont add any header!
                }
                else if (ckbInvalidToken.Checked)
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                else
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                }
                try
                {
                    int result = oiService.getSkillsetThresholdClass(out sillsetThresholds, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getSkillsetThresholdClass returned an error " + errorMessage);
                    if (result != 0)
                        MessageBox.Show("Web service getSkillsetThresholdClass returned " + result);

                    foreach (OIWebReference.ThresholdClass skClass in sillsetThresholds)
                    {
                        cboSkillsetThreshold.Items.Add(skClass.ID + ", " + skClass.Name);
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error encountered after calling getSkillsetThresholdClass. Details: " + Ex.Message);
                }

                try
                {
                    bool result = oiService.getSkillsetsList(out skillsetList, out errorMessage, ccmsIP);

                    if (errorMessage != string.Empty)
                        MessageBox.Show("Web service getSkillsetsList returned an error " + errorMessage);
                    if (!result)
                        MessageBox.Show("Web service getSkillsetsList returned false!");

                    foreach (OIWebReference.Skillset skillset in skillsetList)
                    {
                        int n = dgvSkillsets.Rows.Add();
                        dgvSkillsets.Rows[n].Cells[0].Value = skillset.ID.ToString();
                        dgvSkillsets.Rows[n].Cells[1].Value = skillset.Name;
                        dgvSkillsets.Rows[n].Cells[2].Value = skillset.ContactTypeID.ToString();
                    }

                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error encountered after calling getSkillsetList. Details: " + Ex.Message);
                }

                ConnectionShutdown();
            }
        }
        public OIWebReference_62.SkillsetConfigDetails getSkillset_62(bool asNew)
        {
            OIWebReference_62.SkillsetConfigDetails newSkillset = new CCMAOpenInterfaces.OIWebReference_62.SkillsetConfigDetails();

            if (txtCallAgePref.Text == OIWebReference_62.SkillsetCallAgePreference.FirstInQueue.ToString())
                newSkillset.callAgePreference = CCMAOpenInterfaces.OIWebReference_62.SkillsetCallAgePreference.FirstInQueue;
            else if (txtCallAgePref.Text == OIWebReference_62.SkillsetCallAgePreference.Oldest.ToString())
                newSkillset.callAgePreference = CCMAOpenInterfaces.OIWebReference_62.SkillsetCallAgePreference.Oldest;

            newSkillset.callRequestQueueSize = int.Parse(txtCallReqQueueSize.Text);
            if (txtCallSourcePref.Text == OIWebReference_62.SkillsetCallSourcePreference.Local.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference_62.SkillsetCallSourcePreference.Local;
            else if (txtCallSourcePref.Text == OIWebReference_62.SkillsetCallSourcePreference.Network.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference_62.SkillsetCallSourcePreference.Network;
            else if (txtCallSourcePref.Text == OIWebReference_62.SkillsetCallSourcePreference.None.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference_62.SkillsetCallSourcePreference.None;
            newSkillset.comment = txtComment.Text;
            newSkillset.ContactTypeID = int.Parse(txtContactType.Text);
            newSkillset.defaultActivityCode = txtDefaultActivityCode.Text;
            newSkillset.flowControlThreshold = int.Parse(txtFlowControlThreshold.Text);
            newSkillset.includeLocalNode = ckbIncludeLocalNode.Checked;
            newSkillset.mapToACDDN = txtACdDNMap.Text;
            newSkillset.Name = txtSkillsetName.Text;
            newSkillset.ID = int.Parse(txtID.Text);

            newSkillset.networkSkillsetID = txtNetworkSkillsetID.Text;
            if (txtOutOfServiceMode.Text == OIWebReference_62.SkillsetOutOfServiceMode.NA.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference_62.SkillsetOutOfServiceMode.NA;
            else if (txtOutOfServiceMode.Text == OIWebReference_62.SkillsetOutOfServiceMode.Night.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference_62.SkillsetOutOfServiceMode.Night;
            else if (txtOutOfServiceMode.Text == OIWebReference_62.SkillsetOutOfServiceMode.Transition.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference_62.SkillsetOutOfServiceMode.Transition;

            if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.EM_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.EM_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.FX_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.FX_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.VO_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.VO_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.IM_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.IM_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.OB_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.OB_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.OQ_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.OQ_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.PR_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.PR_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.SD_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.SD_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.SM_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.SM_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.VI_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.VI_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.VM_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.VM_;
            else if (txtPrefix.Text == OIWebReference_62.SkillsetPrefix.WC_.ToString())
                newSkillset.prefix = CCMAOpenInterfaces.OIWebReference_62.SkillsetPrefix.WC_;

            if (txtSkillsetType.Text == OIWebReference_62.SkillsetType.Local.ToString())
                newSkillset.skillsetType = CCMAOpenInterfaces.OIWebReference_62.SkillsetType.Local;
            else if (txtSkillsetType.Text == OIWebReference_62.SkillsetType.Network.ToString())
                newSkillset.skillsetType = CCMAOpenInterfaces.OIWebReference_62.SkillsetType.Network;

            newSkillset.thresholdClass = int.Parse(txtThresholdClass.Text);

            //RemoveForAACC6.1
            //try
            //{
            //    newSkillset.TargetServiceLevel = int.Parse(tbTargetServicelevel.Text);
            //}
            //catch (Exception)
            //{
            //    newSkillset.TargetServiceLevel = 0;
            //}

            //if (cbServiceLevelRouting.Checked)
            //    newSkillset.ServiceLevelRouting = true;
            //else
            //    newSkillset.ServiceLevelRouting = false;


            //if (!asNew)
            //    newSkillset.ID = int.Parse(txtID.Text);

            return newSkillset;
        }

        public OIWebReference.SkillsetConfigDetails getSkillset(bool asNew)
        {
            OIWebReference.SkillsetConfigDetails newSkillset = new CCMAOpenInterfaces.OIWebReference.SkillsetConfigDetails();

            if (txtCallAgePref.Text == OIWebReference.SkillsetCallAgePreference.FirstInQueue.ToString())
                newSkillset.callAgePreference = CCMAOpenInterfaces.OIWebReference.SkillsetCallAgePreference.FirstInQueue;
            else if (txtCallAgePref.Text == OIWebReference.SkillsetCallAgePreference.Oldest.ToString())
                newSkillset.callAgePreference = CCMAOpenInterfaces.OIWebReference.SkillsetCallAgePreference.Oldest;

            newSkillset.callRequestQueueSize = int.Parse(txtCallReqQueueSize.Text);
            if (txtCallSourcePref.Text == OIWebReference.SkillsetCallSourcePreference.Local.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference.SkillsetCallSourcePreference.Local;
            else if (txtCallSourcePref.Text == OIWebReference.SkillsetCallSourcePreference.Network.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference.SkillsetCallSourcePreference.Network;
            else if (txtCallSourcePref.Text == OIWebReference.SkillsetCallSourcePreference.None.ToString())
                newSkillset.callSourcePreference = CCMAOpenInterfaces.OIWebReference.SkillsetCallSourcePreference.None;
            newSkillset.comment = txtComment.Text;
            newSkillset.ContactTypeID = int.Parse(txtContactType.Text);
            newSkillset.defaultActivityCode = txtDefaultActivityCode.Text;
            newSkillset.flowControlThreshold = int.Parse(txtFlowControlThreshold.Text);
            newSkillset.includeLocalNode = ckbIncludeLocalNode.Checked;
            newSkillset.mapToACDDN = txtACdDNMap.Text;
            newSkillset.Name = txtSkillsetName.Text;
            newSkillset.ID = int.Parse(txtID.Text);

            newSkillset.networkSkillsetID = txtNetworkSkillsetID.Text;
            if (txtOutOfServiceMode.Text == OIWebReference.SkillsetOutOfServiceMode.NA.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference.SkillsetOutOfServiceMode.NA;
            else if (txtOutOfServiceMode.Text == OIWebReference.SkillsetOutOfServiceMode.Night.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference.SkillsetOutOfServiceMode.Night;
            else if (txtOutOfServiceMode.Text == OIWebReference.SkillsetOutOfServiceMode.Transition.ToString())
                newSkillset.outOfServiceMode = CCMAOpenInterfaces.OIWebReference.SkillsetOutOfServiceMode.Transition;

            if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.EM_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.EM_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.FX_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.FX_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.VO_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.VO_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.IM_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.IM_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.OB_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.OB_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.OQ_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.OQ_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.PR_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.PR_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.SD_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.SD_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.SM_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.SM_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.VI_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.VI_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.VM_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.VM_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.WC_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.WC_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.SN_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.SN_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.PO_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.PO_;
            else if (txtPrefix.Text == OIWebReference.SkillsetPrefix_Ex.EV_.ToString())
                newSkillset.prefix_Ex = CCMAOpenInterfaces.OIWebReference.SkillsetPrefix_Ex.EV_;

            if (txtSkillsetType.Text == OIWebReference.SkillsetType.Local.ToString())
                newSkillset.skillsetType = CCMAOpenInterfaces.OIWebReference.SkillsetType.Local;
            else if (txtSkillsetType.Text == OIWebReference.SkillsetType.Network.ToString())
                newSkillset.skillsetType = CCMAOpenInterfaces.OIWebReference.SkillsetType.Network;

                newSkillset.thresholdClass = int.Parse(txtThresholdClass.Text);

            //RemoveForAACC6.1
            //try
            //{
            //    newSkillset.TargetServiceLevel = int.Parse(tbTargetServicelevel.Text);
            //}
            //catch (Exception)
            //{
            //    newSkillset.TargetServiceLevel = 0;
            //}

            //if (cbServiceLevelRouting.Checked)
            //    newSkillset.ServiceLevelRouting = true;
            //else
            //    newSkillset.ServiceLevelRouting = false;


            //if (!asNew)
            //    newSkillset.ID = int.Parse(txtID.Text);

            return newSkillset;
        }
#endregion

        private void btnAdd_Click(object sender, EventArgs e)
        {
            /*****************************************************************************************************************************
             * This method makes calls to multiple server versions to reflect the changes 
             * introduced in AACC 6.4.1
             * ------------------------addSkillset() - AACC 6.4.1 Changes ---------------------------------------------
             * AACC 6.4.1 supports additional contact types for “POM outbound” and “Social Networking” contacts. 
             * The addSkillset  method takes a  SkillsetConfigDetails objects which contains a ContactTypeID
             * property of type int. The range of values that can be returned in this int has been extended to handle 
             * the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015

             * The SkillsetConfigDetails object also contains a “prefix” property of type SkillsetPrefix which is an
             * enumerated list of prefixes for the contact types (e.g. “EM_” for email). The existing enum cannot be 
             * extended so a new enum has been added, SkillsetPrefix_Ex, which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The SkillsetConfigDetails object has been extended to contain a “prefix_Ex” property in addition to the 
             * “Prefix” property. 
             * Clients interacting with 6.4.1 servers should use the “prefix_Ex” property. Clients should continue to 
             * use the “prefix” property in order to remain backward compatible with older AACC servers.
             * NOTE: A skillset added to an AACC server with an unrecognized contact type will result in the skillset
             * being added with type Voice.
             *****************************************************************************************************************************/


            OIWebReference.SkillsetConfigDetails newSkillset = new CCMAOpenInterfaces.OIWebReference.SkillsetConfigDetails();
            OIWebReference_62.SkillsetConfigDetails newSkillset_62l = new OIWebReference_62.SkillsetConfigDetails(); 
            string errorMessage = string.Empty;
            string newSkillsetID = string.Empty;
            string ccmsIP = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "invalid";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            if (Global.Version == SystemVersion.SixFour)
            {
                OIWebReference.soap oiService;
                ConnectionSetup(out errorMessage, out oiService);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {

                        int result = oiService.addSkillset(out newSkillsetID, out errorMessage, ccmsIP, getSkillset(true));

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service addSkillset returned an error " + errorMessage);

                        MessageBox.Show("Successfully added skillset with new ID " + newSkillsetID + ". Return code was " + result);

                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error adding skillset. Details: " + Ex.Message);
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                OIWebReference_62.soap oiService_62;
                ConnectionSetup_62(out errorMessage, out oiService_62);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {

                        int result = oiService_62.addSkillset(out newSkillsetID, out errorMessage, ccmsIP, getSkillset_62(true));

                        if (errorMessage != string.Empty)
                            MessageBox.Show("Web service addSkillset returned an error " + errorMessage);

                        MessageBox.Show("Successfully added skillset with new ID " + newSkillsetID + ". Return code was " + result);

                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error adding skillset. Details: " + Ex.Message);
                    }
                }

            }
            else
            {
                MessageBox.Show("System Version not supported");
            }

            PopulateSkillsets();
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            OIWebReference.SkillsetConfigDetails newSkillset = new CCMAOpenInterfaces.OIWebReference.SkillsetConfigDetails();
            string errorMessage = string.Empty;
            string ccmsIP = string.Empty;
            if (ckbInvalidCCMS.Checked)
                ccmsIP = "invalid";
            else
                ccmsIP = cboServerList.Text.Split(',')[0];

            if (Global.Version == SystemVersion.SixFour)
            {

                OIWebReference.soap oiService;
                ConnectionSetup(out errorMessage, out oiService);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService.updateSkillset(out errorMessage, ccmsIP, getSkillset(false), txtID.Text);
                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error message detected. " + errorMessage);
                        else
                            MessageBox.Show("Successfully updated skillset with new ID. Return code was " + result);

                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error adding skillset. Details: " + Ex.Message);
                    }
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {

                OIWebReference_62.soap oiService_62;
                ConnectionSetup_62(out errorMessage, out oiService_62);

                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                {
                    if (ckbNoToken.Checked)
                    {
                        //Dont add any header!
                    }
                    else if (ckbInvalidToken.Checked)
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = "InvalidToken";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    else
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers.Add(HttpRequestHeader.Cookie, cookieName + "=" + userToken);
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;
                    }
                    try
                    {
                        int result = oiService_62.updateSkillset(out errorMessage, ccmsIP, getSkillset_62(false), txtID.Text);
                        if (errorMessage != string.Empty)
                            MessageBox.Show("Error message detected. " + errorMessage);
                        else
                            MessageBox.Show("Successfully updated skillset with new ID. Return code was " + result);

                    }
                    catch (Exception Ex)
                    {
                        MessageBox.Show("Error adding skillset. Details: " + Ex.Message);
                    }
                }
            }
            else
            {
                MessageBox.Show("System version not supported!");
            }
            PopulateSkillsets();
        }

    

    }
}
