﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Threading;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Xml;

namespace CCMAOpenInterfaces
{
    public partial class frmAssignAgentsToSkillsets : Form
    {
        private string _ccmsIPAddress;
        private string _token;
        private string _url;
        private SOAP1.SOAP _ccmaClient;

        public frmAssignAgentsToSkillsets(string CCMSIPAddress, string Token, string Url)
        {
            _ccmaClient = new CCMAOpenInterfaces.SOAP1.SOAP();
            InitializeComponent();
            _ccmsIPAddress = CCMSIPAddress;
            _token = Token;
            _url = Url;
            PopulateSkillsets();
            PopulateAgents();
            PopulatePriorityCombo();
        }

        public void PopulatePriorityCombo()
        {
            //cboPriority.Items.Add("50");
            //cboPriority.Items.Add("string");
       
            for (int i = 0; i < 50; i++)
            {
                cboPriority.Items.Add(i);
            }
            
        }

        public void PopulateSkillsets()
        {

            string _errorMessage;
            OIWebReference.Skillset[] _listOfSkillsets;
            this.Cursor = Cursors.WaitCursor;

            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
            ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
            OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

            try
            {
                using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                {
                    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    requestProperty.Headers["NTSSOCookie"] = _token;
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    oiService.getSkillsetsList(out _listOfSkillsets, out _errorMessage, _ccmsIPAddress);
                    if (_errorMessage != null && _errorMessage != "")
                    {
                        this.Cursor = Cursors.Default;
                        MessageBox.Show("Error text was received from the getAgentSkillsets method. Details: " + _errorMessage);
                    }
                    //else
                    //    lblTotalSkillsets.Text = _listOfSkillsets.Length.ToString() + " skillsets returned";

                    //Populate combo box with skillsets
                    for (int i = 0; i < _listOfSkillsets.Length; i++)
                    {
                        lstSkillsets.Items.Add(_listOfSkillsets[i].Name + ", " + _listOfSkillsets[i].ID.ToString());
                        //cboAgentSkillsets.Items.Add(_listOfSkillsets[i].Name + ", " + _listOfSkillsets[i].ID.ToString());
                    }
                    this.Cursor = Cursors.Default;
                    oiChannelFactory.Close();
                }
            }

            catch (Exception Ex)
            {
                this.Cursor = Cursors.Default;
                MessageBox.Show("An exception was caught while executing the getAgentSkillsets method. Details : " + Ex.Message);
            }
            this.Cursor = Cursors.Default;
        }

        public void PopulateAgents()
        {
            /* ****************************************************************************************************************************
             * This method contains calls to multiple server versions to relflect 
             * changes made to open interfaces in AACC 6.4.1
             * ------------------------------getAgentsList() - AACC 6.4.1 Changes -----------------------------------------------------
             * The AgentFullDetails contains a new property “offsiteAllowed” of type integer (0 = Disabled, 1 = Enabled).
             *  The AgentFullDetails object contains an array of ContactTypeAndRelatedSkillsets objects. Each of the ContactTypeAndRelatedSkillsets 
             *  contains the ContactType attributes including a prefix property of type SkillsetPrefix which is an enumerated list of prefixes 
             *  for the contact types (e.g. “EM_” for email). The enum cannot be extended so a new enum has been added, 
             *  SkillsetPrefix_Ex, which contains the additional values:
             * “PO_”
             * “EV_”
             * “SN_”
             * NOTE: The “EV_” value is not used by AACC.
             * The ContactType object has been extended to contain a “prefix_Ex” property in addition to the “Prefix” property. The “prefix_Ex”
             * property should be used when interacting with a 6.4.1 or later CCMA server. The “prefix” property should be used for all older servers.
             * The ContactTypeAndRelatedSkillsets contains an array of SkillsetFullDetails objects with a record for each skillset of a given contact
             * type. The  SkillsetFullDetails  object contains a ContactTypeID property of type int. The range of values that can be returned in
             * this int has been extended to handle the new 6.4.1 contact types.
             * The new values are:
             * POM_Outbound = 10013
             * Elite_Voice = 10014  (NOTE: This is defined but never used)
             * Social_Networking = 10015
             *****************************************************************************************************************************/
            string _errorMessage = null;
            //lblTotalAgents.Text = "";
            OIWebReference.AgentFullDetails[] _listOfAgents;
            OIWebReference_62.AgentFullDetails[] _listOfAgents_62;

    
            this.Cursor = Cursors.WaitCursor;

            //Add dummy agent first for testing web services against invalid agents
            //lstAgents.Items.Add("DummyFirstName DummyLastName, 99876");
            //cboAgents.Items.Add("Voice Agent1, 10219");
            
            
            BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
            basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
            EndpointAddress endpointAddress = new EndpointAddress(_url);

            if (Global.Version == SystemVersion.SixFour)
            {

                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = _token;
                        //requestProperty.Headers["NTSSOCookie"] = "";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        //oiService.getAgentsList(_CCMSIPAddress, out getAgentsListResult, out getAgentsListResultSpecified, out _listOfAgents, out _errorMessage);
                        oiService.getAgentsList(out _listOfAgents, out _errorMessage, _ccmsIPAddress);

                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAllAgents method. Details: " + _errorMessage);
                        }
                        //else
                        //Populate combo box with agents
                        //   lblTotalAgents.Text = _listOfAgents.Length.ToString() + " agents returned";
                        for (int i = 0; i < _listOfAgents.Length; i++)
                        {

                            lstAgents.Items.Add(_listOfAgents[i].firstName + " " + _listOfAgents[i].lastName + "," + _listOfAgents[i].localID);


                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory.Close();
                    }
                }


                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the GetAllAgents method. Details : " + Ex.Message);
                }
            }
            else if (Global.Version == SystemVersion.SixTwo)
            {
                ChannelFactory<OIWebReference_62.soap> oiChannelFactory_62 = new ChannelFactory<OIWebReference_62.soap>(basicHttpBinding, endpointAddress);
                OIWebReference_62.soap oiService_62 = oiChannelFactory_62.CreateChannel();

                try
                {
                    using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService_62))
                    {
                        HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                        requestProperty.Headers["NTSSOCookie"] = _token;
                        //requestProperty.Headers["NTSSOCookie"] = "";
                        OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                        //oiService.getAgentsList(_CCMSIPAddress, out getAgentsListResult, out getAgentsListResultSpecified, out _listOfAgents, out _errorMessage);
                        oiService_62.getAgentsList(out _listOfAgents_62, out _errorMessage, _ccmsIPAddress);

                        if (_errorMessage != null && _errorMessage != "")
                        {
                            this.Cursor = Cursors.Default;
                            MessageBox.Show("Error text was received from the getAllAgents method. Details: " + _errorMessage);
                        }
                        //else
                        //Populate combo box with agents
                        //   lblTotalAgents.Text = _listOfAgents.Length.ToString() + " agents returned";
                        for (int i = 0; i < _listOfAgents_62.Length; i++)
                        {

                            lstAgents.Items.Add(_listOfAgents_62[i].firstName + " " + _listOfAgents_62[i].lastName + "," + _listOfAgents_62[i].localID);


                        }
                        this.Cursor = Cursors.Default;
                        oiChannelFactory_62.Close();
                    }
                }


                catch (Exception Ex)
                {
                    this.Cursor = Cursors.Default;
                    MessageBox.Show("An exception was caught while executing the GetAllAgents method. Details : " + Ex.Message);
                }
            } 


        }

        private void btnAssign_Click(object sender, EventArgs e)
        {

            String errMsg = string.Empty;

            for (int i = 0; i < lstSkillsets.Items.Count; i++)
            {

                string[] agentIDs = lstAgents.Text.Split(',');
                string agentID = agentIDs[1];

                string[] skillsets = lstSkillsets.Items[i].ToString().Split(',');
                //string[] skillsets = lstSkillsets.Text.Split(',');
                string skillsetID = skillsets[1];

                string priority = cboPriority.Text;



                BasicHttpBinding basicHttpBinding = new BasicHttpBinding();
                basicHttpBinding.MaxReceivedMessageSize = int.MaxValue;
                EndpointAddress endpointAddress = new EndpointAddress(_ccmaClient.Url);
                ChannelFactory<OIWebReference.soap> oiChannelFactory = new ChannelFactory<OIWebReference.soap>(basicHttpBinding, endpointAddress);
                OIWebReference.soap oiService = oiChannelFactory.CreateChannel();


                try
                {
                    //using (OperationContextScope scope = new OperationContextScope((IContextChannel)oiService))
                    //{
                    //    HttpRequestMessageProperty requestProperty = new HttpRequestMessageProperty();
                    //    requestProperty.Headers["NTSSOCookie"] = _token;
                    //    //requestProperty.Headers["NTSSOCookie"] = "4646";
                    //    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestProperty;

                    //    if (oiService.addAgentSkillset(out errMsg, _ccmsIPAddress, agentID, skillsetID, priority))
                    //    {
                    //        //MessageBox.Show("Success!");
                    //        //rtbProgress.Text += ("Success");
                    //        rtbProgress.Text += ("Success - Added Skillset to Agent" + Environment.NewLine);
                           
                    //        rtbProgress.Select(rtbProgress.Text.Length, rtbProgress.Text.Length + 1);
                    //        rtbProgress.ScrollToCaret();
                    //    }

                    //    else
                    //    {

                    //        //MessageBox.Show("Error " + errMsg);
                    //        rtbProgress.Text += ("Error" + errMsg + Environment.NewLine);
                            
                    //        rtbProgress.Select(rtbProgress.Text.Length, rtbProgress.Text.Length + 1);
                    //        rtbProgress.ScrollToCaret();

                    //    }

                    //}

                }

                catch (Exception Ex)
                {
                    rtbProgress.Text += "An exception occurred. Details: " + Ex.Message;
                    rtbProgress.Select(rtbProgress.Text.Length, rtbProgress.Text.Length + 1);
                    rtbProgress.ScrollToCaret();

                    //MessageBox.Show("An exception occurred. Details: " + Ex.Message);
                }

            }
        }

       
    }
}
