﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CCMAOpenInterfaces
{
    public partial class frmMDIParent : Form
    {
        string token = string.Empty;
        string CCMSIP;
        string url;
        string CCMAIP;
        Credentials localCredentials = null;
        AuthenticationService.AuthenticationService authenticate;
        string authenticateURL;
        string ssoToken = string.Empty;
        //SOAP.SOAP _ccmaClient;
        private int childFormNumber = 0;
        string strSSOCookieName = "";


        public frmMDIParent()
        {
            InitializeComponent();

            ReadConfig();

            localCredentials = new Credentials();
            //authenticate = new CCMAOpenInterface.AuthenticationService.AuthenticationService();
            authenticate = new AuthenticationService.AuthenticationService();
            authenticate.Url = authenticateURL;

        }

        private void ShowNewForm(object sender, EventArgs e)
        {
            Form childForm = new Form();
            childForm.MdiParent = this;
            childForm.Text = "Window " + childFormNumber++;
            childForm.Show();
        }

        private void OpenFile(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            openFileDialog.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                string FileName = openFileDialog.FileName;
            }
        }

        private void SaveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog = new SaveFileDialog();
            saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            saveFileDialog.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
            if (saveFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                string FileName = saveFileDialog.FileName;
            }
        }

        private void ExitToolsStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void CutToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void CopyToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void PasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void ToolBarToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void StatusBarToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void CascadeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.Cascade);
        }

        private void TileVerticalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.TileVertical);
        }

        private void TileHorizontalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.TileHorizontal);
        }

        private void ArrangeIconsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.ArrangeIcons);
        }

        private void CloseAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (Form childForm in MdiChildren)
            {
                childForm.Close();
            }
        }

        private void loginToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string error = string.Empty;

            frmCredentials credForm = new frmCredentials(ref localCredentials);
            //credForm.MdiParent = this;
            if (credForm.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    if (!authenticate.AuthenticateUser(localCredentials.UserID, localCredentials.UserPassword, out ssoToken, out error))
                    {
                        MessageBox.Show("Error logging in user " + localCredentials.UserID + ". Error: " + error);
                        return;
                    }
                    else
                    {
                        MessageBox.Show("Login success. Token returned: " + ssoToken);
                        this.Text = "CCMA Open Interfaces Client - Logged In!";
                        //Get the SSO cookie name
                        strSSOCookieName = authenticate.GetSSOCookieName(out error);
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("An exception was raised while attempting to authenticate user. Details: " + Ex.Message);
                }
            }
        }

        private void logoutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string error = string.Empty;

            if (!authenticate.LogoutToken(ssoToken, out error))
            {
                MessageBox.Show("Error logging out user " + localCredentials.UserID + " with token + " + ssoToken + ". Error: " + error);
                return;
            }
            else
            {
                MessageBox.Show("Logout success!");
                this.Text = "CCMA Open Interfaces Client - Logged Out!";
            }
        }

        private void loginLogoutLoadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmLogin loadtest = new frmLogin(authenticate);
            loadtest.ShowDialog();
        }

        private void sOAPTestingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string error = string.Empty;
            //Get the SSO cookie name
            string strSSOCookieName = authenticate.GetSSOCookieName(out error);

            frmSOAP _SOAPForm = new frmSOAP(CCMSIP, ssoToken, url, strSSOCookieName, "");
            _SOAPForm.MdiParent = this;
            _SOAPForm.Show();
        }

        private void rESTTestingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string error = string.Empty;
            //Get the SSO cookie name
            string strSSOCookieName = authenticate.GetSSOCookieName(out error);

            frmREST _RESTForm = new frmREST(CCMSIP, CCMAIP, ssoToken, strSSOCookieName, "");
            _RESTForm.MdiParent = this;
            _RESTForm.Show();
        }

        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void ReadConfig()
        {
            FileStream fs;

            try
            {
                fs = new FileStream((Application.StartupPath + "\\AppConfig.txt"), FileMode.Open, FileAccess.Read);
            }
            catch (IOException ex)
            {
                MessageBox.Show("  Error: ReadConfig:" + ex.ToString());
                return;
            }

            StreamReader sr = new StreamReader(fs);
            //switch statement to match parameters, case sensitive

            string[] strArray;
            string strKey = string.Empty;
            string strValue = string.Empty;

            while (sr.Peek() >= 0)
            {
                try
                {
                    strKey = string.Empty;
                    strKey = sr.ReadLine();
                    strValue = "";
                    strArray = strKey.Split(new string[] { " " }, StringSplitOptions.RemoveEmptyEntries);

                    strKey = strArray[0];
                    if (strArray.Length > 1)
                    {
                        strValue = strArray[1];
                    }
                    switch (strKey)
                    {
                        //Setup CCT credentials
                        case "CCMSIP":
                            CCMSIP = strValue;
                            break;
                        case "URL":
                            url = strValue;
                            break;
                        case "CCMAIP":
                            CCMAIP = strValue;
                            break;
                        case "AuthenticateURL":
                            authenticateURL = strValue;
                            break;
                    }
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error extracting details from the AppConfig File. Details:" + Ex.Message);
                }
            }

            sr.Close();
            fs.Close();
        }

        private void userMaintenanceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            UserMaintenance _UserForm = new UserMaintenance(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            _UserForm.MdiParent = this;
            _UserForm.Show();
        }

        private void skillsetMaintenanceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SkillsetMaintenance _UserForm = new SkillsetMaintenance(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            _UserForm.MdiParent = this;
            _UserForm.Show();
        }

        private void activityCodesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ActivityCodes _UserForm = new ActivityCodes(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            _UserForm.MdiParent = this;
            _UserForm.Show();
        }

        private void viewCompleteServerListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ServerList _ServersForm = new ServerList(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            _ServersForm.MdiParent = this;
            _ServersForm.Show();
        }

        private void agentGreetingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmAgentGreetingDetails _AgentGreetingForm = new frmAgentGreetingDetails(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            _AgentGreetingForm.MdiParent = this;
            _AgentGreetingForm.Show();

        }

        private void bulkIploadAgentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //  BulkUploadSkillsets bulkUploadSkls = new BulkUploadSkillsets();
            //   bulkUploadSkls.ShowDialog();
        }

        private void frmMDIParent_Load(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            LoadTesting loadtest = new LoadTesting(ssoToken, url, strSSOCookieName, localCredentials.UserID);
            loadtest.MdiParent = this;
            loadtest.Show();
        }

        private void versionToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void cboAPIVersion_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            string _version; 
            ToolStripComboBox cboVersion = (ToolStripComboBox)sender;
            _version =  cboVersion.Text;
            if (_version == "6.2")
            {
                Global.Version = SystemVersion.SixTwo;
            }
            else if (_version == "6.4")
            {
                Global.Version = SystemVersion.SixFour;
            }
            else
            {
                MessageBox.Show("System version selected is not currently configured");
            } 


        }

      
    }
}
