using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Nortel.CCT;

namespace AgentWebservicesClient
{
  /// <summary>
  /// Summary description for Form2.
  /// </summary>
  public partial class CredentialsForm : System.Windows.Forms.Form
  {
    private System.Windows.Forms.Label lblUserID;
    private System.Windows.Forms.Label lblDomain;
    private System.Windows.Forms.Label lblPassword;
    private System.Windows.Forms.TextBox txtUserID;
    private System.Windows.Forms.TextBox txtDomain;
    private System.Windows.Forms.TextBox txtPassword;
    private System.Windows.Forms.Button btnOK;
    /// <summary>
    /// Required designer variable.
    /// </summary>
    private System.Windows.Forms.RadioButton rdioCurrent;
    private System.Windows.Forms.ColorDialog colorDialog1;
    private System.Windows.Forms.Button btn_Cancel;

    private CCTCredentials _credentials;

    public CredentialsForm(CCTCredentials credentials)
    {
      //
      // Required for Windows Form Designer support
      //
      InitializeComponent();
      _credentials = credentials;

      //
      // TODO: Add any constructor code after InitializeComponent call
      //
    }


    public CCTCredentials GetCredentials()
    {
      return _credentials;
    }


    private void CredentialsForm_Load(object sender, System.EventArgs e)
    {

    }

    private void btnOK_Click(object sender, System.EventArgs e)
    {
      bool sso = rdioCurrent.Checked;

      if (!sso)
      {
        string userid = txtUserID.Text.Trim();
        string domain = txtDomain.Text.Trim();
        string password = txtPassword.Text;

        _credentials.SetWindowsUser(userid, domain);
        _credentials.Password = password;
      }
      else
      {
        _credentials.SetSingleSignOn();
      }
    }

    private void rdioCurrent_CheckedChanged(object sender, System.EventArgs e)
    {
      txtUserID.Enabled = !rdioCurrent.Checked;
      txtDomain.Enabled = !rdioCurrent.Checked;
      txtPassword.Enabled = !rdioCurrent.Checked;
    }

    private void btn_Cancel_Click(object sender, EventArgs e)
    {

    }
  }
}
