/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;

public class WSHandler
extends WebSocketHandler {
    private final Set<ChatWebSocket> webSockets = new CopyOnWriteArraySet<ChatWebSocket>();
    private static ChatWebSocket wSocket = null;
    private static HashMap<String, WebSocket.Connection> SocketCon = new HashMap();

    @Override
    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        wSocket = new ChatWebSocket();
        return wSocket;
    }

    public static ChatWebSocket getWebSocket() {
        return wSocket;
    }

    public static HashMap<String, WebSocket.Connection> getMap() {
        return SocketCon;
    }

    class ChatWebSocket
    implements WebSocket.OnTextMessage {
        private WebSocket.Connection connection;
        private List<Integer> servers = new ArrayList<Integer>();

        ChatWebSocket() {
        }

        @Override
        public void onOpen(WebSocket.Connection connection) {
            this.connection = connection;
            WSHandler.this.webSockets.add(this);
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String myLANIP = addr.getHostAddress();
                this.onMessage("IP:" + myLANIP);
                boolean exist = true;
                while (exist) {
                    UUID id = UUID.randomUUID();
                    if (SocketCon != null && SocketCon.containsKey(id.toString())) continue;
                    this.onMessage("UUID:" + id);
                    SocketCon.put(id.toString(), connection);
                    exist = false;
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public void onMessage(WebSocket.Connection connection, String data) {
            if (connection != null) {
                try {
                    connection.sendMessage(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.onMessage(data);
            }
        }

        @Override
        public void onMessage(String data) {
            if (data.startsWith("Port")) {
                int portName = Integer.parseInt(data.split(":")[1]);
                if (!this.servers.contains(portName)) {
                    Server server = new Server(portName);
                    server.setHandler(new HandleSocket());
                    this.servers.add(portName);
                    try {
                        server.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    for (ChatWebSocket webSocket : WSHandler.this.webSockets) {
                        webSocket.connection.sendMessage(data);
                    }
                }
                catch (IOException x) {
                    this.connection.disconnect();
                }
            }
        }

        @Override
        public void onClose(int closeCode, String message) {
            WSHandler.this.webSockets.remove(this);
        }
    }

    class HandleSocket
    extends AbstractHandler {
        HandleSocket() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String key = target.split("/")[1];
            response.setStatus(200);
            baseRequest.setHandled(true);
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    WSHandler.getWebSocket().onMessage((WebSocket.Connection)SocketCon.get(key), line);
                }
            }
            catch (Exception localException) {
                localException.printStackTrace();
            }
        }
    }
}

