dojo.require("dojox.grid.DataGrid");
dojo.require("dojo.data.ItemFileWriteStore");

var agentStatisticDataLength = 15;
var agentStatsLayout = [
	{ field: "id", name: "Agent Id", width: '100px', visibility: false },
	{ field: "name", name: "Agent Name", width: '100px' },
	{ field: "answeringApplication", name: "Answering Application", width: '100px' },
	{ field: "answeringCdn", name: "Answering CDN", width: '100px' },
	{ field: "anseringDnis", name: "Ansering DNIS", width: '100px' },
	{ field: "answeringSkillset", name: "Answering Skillset", width: '100px' },
	{ field: "dnInCallAnswered", name: "DN In Call Answered", width: '100px' },
	{ field: "dnInTimeInState", name: "DN In Time In State", width: '100px' },
	{ field: "dnOutCallMade", name: "DN Out Call Made", width: '100px' },
	{ field: "dnOutCalledNumber", name: "DN Out Called Number", width: '100px' },
	{ field: "dnOutTimeInState", name: "DN Out Time In State", width: '100px' },
	{ field: "notReadyReasonCode", name: "Not Ready Reason Code", width: '100px' },
	{ field: "positionId", name: "Position Id", width: '100px' },
	{ field: "skillsetCallAnswered", name: "Skillset Calls Answered", width: '100px' },
	{ field: "state", name: "State", width: '100px' },
	{ field: "supervisor", name: "Supervisor", width: '100px' },
// TODO, paulda	{ field: "supervisorUserId", name: "Supervisor Id", width: '100px' },
	{ field: "timeInState", name: "Time In State", width: '100px' }
];

var applicationStatisticDataLength = 20;
var applicationStatsLayout = [
	{ field: "id", name: "Application Id", width: '100px', visibility: false },
	{ field: "name", name: "Application Name", width: '100px' },
	{ field: "callsAbandoned", name: "Calls Abandoned", width: '100px' },
	{ field: "callsAbandonedAfterThreshold", name: "Calls Abandoned After Threshold", width: '100px' },
	{ field: "callsAbandonedDelay", name: "Calls Abandoned Delay", width: '100px' },
	{ field: "callsAnswered", name: "Calls Answered", width: '100px' },
	{ field: "callsAnsweredAfterThreshold", name: "Calls Answered After Threshold", width: '100px' },
	{ field: "callsAnsweredDelay", name: "Calls Answered Delay", width: '100px' },
	{ field: "callsAnsweredAtSkillset", name: "Calls Answered At Skillset", width: '100px' },
	{ field: "callsGivenTerminationTreatment", name: "Calls Given Termination Treatment", width: '100px' },
	{ field: "callsOffered", name: "Calls Offered", width: '100px' },
	{ field: "callsWaiting", name: "Calls Waiting", width: '100px' },
	{ field: "maxWaitingTime", name: "Max Waiting Time", width: '100px' },
	{ field: "networkOutCalls", name: "Network Out Calls", width: '100px' },
	{ field: "networkOutCallsAbandoned", name: "Network Out Calls Abandoned", width: '100px' },
	{ field: "networkOutCallsAbandonedDelay", name: "Network Out Calls Abandoned Delay", width: '100px' },
	{ field: "networkOutCallsAnswered", name: "Network Out Calls Answered", width: '100px' },
	{ field: "networkOutCallsAnsweredDelay", name: "Network Out Calls Answered Delay", width: '100px' },
	{ field: "networkOutCallsRequested", name: "Network Out Calls Requested", width: '100px' },
	{ field: "networkOutCallsWaiting", name: "Network Out Calls Waiting", width: '100px' },
	{ field: "timeBeforeInterflow", name: "Time Before Interflow", width: '100px' },
	{ field: "waitingTime", name: "Waiting Time", width: '100px' }
];

var skillsetStatisticDataLength = 29;
var skillsetStatsLayout = [
	
	{ field: "id", name: "Skillset Id", width: '100px', visibility: false },
	{ field: "name", name: "Skillset Name", width: '100px' },
	{ field: "agentOnAcddnCall", name: "Agent On ACD-DN Call", width: '100px' },
	{ field: "agentOnNacddnCall", name: "Agent On NACD-DN Call", width: '100px' },
	{ field: "agentOnNetworkSkillsetCall", name: "Agent On Network Skillset Call", width: '100px' },
	{ field: "agentOnOtherSkillsetCall", name: "Agent On Other Skillset Call", width: '100px' },
	{ field: "agentsAvailable", name: "Agents Available", width: '100px' },
	{ field: "agentsInService", name: "Agents InService", width: '100px' },
	{ field: "agentsNotReady", name: "Agents Not Ready", width: '100px' },
	{ field: "agentsOnDnCall", name: "Agents On DN Call", width: '100px' },
	{ field: "agentsOnSkillsetCall", name: "Agents On Skillset Call", width: '100px' },
	{ field: "agentsUnavailable", name: "Agents Unavailable", width: '100px' },
	{ field: "callsAnsweredAfterThreshold", name: "Calls Answered After Threshold", width: '100px' },
	{ field: "callsOffered", name: "Calls Offered", width: '100px' },
	{ field: "callsWaiting", name: "Calls Waiting", width: '100px' },
	{ field: "expectedWaitingTime", name: "Expected Waiting Time", width: '100px' },
	{ field: "longestWaitingTimeSinceLastCall", name: "Longest Waiting Time Since Last Call", width: '100px' },
	{ field: "longestWaitingTimeSinceLogin", name: "Longest Waiting Time Since Login", width: '100px' },
	{ field: "maxWaitingTime", name: "Max Waiting Time", width: '100px' },
	{ field: "networkCallsAnswered", name: "Network Calls Answered", width: '100px' },
	{ field: "networkCallsOffered", name: "Network Calls Offered", width: '100px' },
	{ field: "networkCallsWaiting", name: "Network Calls Waiting", width: '100px' },
	{ field: "queuedCallsAnswered", name: "Queued Calls Answered", width: '100px' },
	{ field: "skillsetAbandoned", name: "Skillset Abandoned", width: '100px' },
	{ field: "skillsetAbandonedAfterThreshold", name: "Skillset Abandoned After Threshold", width: '100px' },
	{ field: "skillsetAbandonedDelay", name: "Skillset Abandoned Delay", width: '100px' },
	{ field: "skillsetState", name: "Skillset State", width: '100px' },
	{ field: "skillsetThreshold", name: "Skillset Threshold", width: '100px' },
	{ field: "totalCallsAnswered", name: "Total Calls Answered", width: '100px' },
	{ field: "totalCallsAnsweredDelay", name: "Total Calls Answered Delay", width: '100px' },
	{ field: "waitingTime", name: "Waiting Time", width: '100px' }
	];

//{
//"data":	{
//	[{\"applicationStatistics\":{
//		\"timestamp\":31611,
//		\"data\":[[\"10000\",\"Application_10000\",[\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\"]]],
//		\"statScheme\":\"itd\"}
//	}]"
//},
//"id":"173d3b12-5e02-4ec8-b34a-39dc27a6c9ee",
//"channel":"/stats/173d3b12-5e02-4ec8-b34a-39dc27a6c9ee"
//}		
function setupApplicationStatsDataGrid(gridName, gridDivNodeName) {

	var initialDataItems = {
			identifier: 'id',
			label: 'Id',
			items: [	
	        ]
	};

	initialDataStore = new dojo.data.ItemFileWriteStore({data: initialDataItems});	

	var grid = new dojox.grid.DataGrid({
		id: gridName,
		query: { id: '*' },
		store: initialDataStore,
		structure: applicationStatsLayout
	}, gridDivNodeName);

	// Call startup, in order to render the grid:
	grid.startup();

//var checkBoxes = [];
//var container = dojo.byId('checkBoxContainer');
//dojo.forEach(appItdGrid.layout.cells, function(cell, index){
//	var cb = new dijit.form.CheckBox({
//		checked: !cell.hidden
//	});
//	dojo.connect(cb, "onChange", function(newValue){
//		appItdGrid.layout.setColumnVisibility(index, newValue);
//	});
//
//	var label = dojo.doc.createElement('label');
//	label.innerHTML = cell.name;
//	dojo.attr(label, 'for', cb.id);
//
//	dojo.place(cb.domNode, container);
//	dojo.place(label, container);
//	dojo.place(dojo.doc.createElement("br"), container);
//
//	checkBoxes.push(cb);
//});
}

function setupAgentStatsDataGrid(gridName, gridDivNodeName) {

	var initialDataItems = {
			identifier: 'id',
			label: 'Id',
			items: [	
	        ]
	};

	initialDataStore = new dojo.data.ItemFileWriteStore({data: initialDataItems});	

	var grid = new dojox.grid.DataGrid({
		id: gridName,
		query: { id: '*' },
		store: initialDataStore,
		structure: agentStatsLayout
	}, gridDivNodeName);

	// Call startup, in order to render the grid:
	grid.startup();
}

function setupSkillsetStatsDataGrid(gridName, gridDivNodeName) {

	var initialDataItems = {
			identifier: 'id',
			label: 'Id',
			items: [	
	        ]
	};

	initialDataStore = new dojo.data.ItemFileWriteStore({data: initialDataItems});	

	var grid = new dojox.grid.DataGrid({
		id: gridName,
		query: { id: '*' },
		store: initialDataStore,
		structure: skillsetStatsLayout
	}, gridDivNodeName);

	// Call startup, in order to render the grid:
	grid.startup();
}

function setupAgentSkillsetStatsDataGrid(gridName, gridDivNodeName) {

	var initialDataItems = {
			identifier: 'id',
			label: 'Id',
			items: [	
	        ]
	};

	initialDataStore = new dojo.data.ItemFileWriteStore({data: initialDataItems});	

	var grid = new dojox.grid.DataGrid({
		id: gridName,
		query: { id: '*' },
		store: initialDataStore,
		structure: skillsetStatsLayout
	}, gridDivNodeName);

	// Call startup, in order to render the grid:
	grid.startup();
}

//
//	{
//		"timestamp":31611,
//		"data":	[
//					["10000","Application_10000",["3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22"]]
//				],
//		"statScheme":"itd"
//	}
//
function updateApplicationStatsDataGrid(stats, gridName) {
	console.log("updateApplicationStatsDataGrid");
	var dataStr = JSON.stringify(stats);
	console.log(dataStr);
	
	var statScheme = stats.statScheme;
	var timestamp = stats.timestamp;
	var numStats = stats.data.length;

	var itemJsonArray = new Array();
	for (i=0;i<numStats;i++) {
		var statData = stats.data[i];
		if ( statData.length == 3 ) {
			var entityId = statData[0];
			var entityName = statData[1];
			var statValueArray = statData[2];
			if ( statValueArray.length != applicationStatisticDataLength ) {
				// log error...
				console.log("Invalid statistic data length " + statValueArray.length + ", expected " + applicationStatisticDataLength);
				return;
			}
			var itemJson = {
				id:entityId, name:entityName,
				callsAbandoned:statValueArray[0], callsAbandonedAfterThreshold:statValueArray[1], callsAbandonedDelay:statValueArray[2], 
				callsAnswered:statValueArray[3], callsAnsweredAfterThreshold:statValueArray[4], callsAnsweredDelay:statValueArray[5],
				callsAnsweredAtSkillset:statValueArray[6], callsGivenTerminationTreatment:statValueArray[7], callsOffered:statValueArray[8],
				callsWaiting:statValueArray[9], maxWaitingTime:statValueArray[10], networkOutCalls:statValueArray[11], networkOutCallsAbandoned: statValueArray[12],
				networkOutCallsAbandonedDelay:statValueArray[13], networkOutCallsAnswered:statValueArray[14], networkOutCallsAnsweredDelay:statValueArray[15],
				networkOutCallsRequested:statValueArray[16], networkOutCallsWaiting:statValueArray[17], timeBeforeInterflow:statValueArray[18], waitingTime:statValueArray[19] 
			};
			itemJsonArray[i] = itemJson;
		} else {
			console.log("Invalid statistic JSON structure");
		}
	}
	
	var dataItems = { identifier:"id", label:"Id", items: itemJsonArray	};
	
//	var newStore = new dojo.data.ItemFileWriteStore({data:dataItems, urlPreventCache:true});
	var newStore = new dojo.data.ItemFileWriteStore({data:dataItems});
	var grid = dijit.byId(gridName);
//	grid.store.close();
//	grid.setStore(newStore, { id: '*' });
	grid.setStore(newStore);
//	_appItdGrid._refresh(true);
} 	

function updateAgentStatsDataGrid(stats, gridName) {
	console.log("updateAgentStatsDataGrid");
	var dataStr = JSON.stringify(stats);
	console.log(dataStr);
	
	var statScheme = stats.statScheme;
	var timestamp = stats.timestamp;
	var numStats = stats.data.length;

	var itemJsonArray = new Array();
	for (i=0;i<numStats;i++) {
		var statData = stats.data[i];
		if ( statData.length == 3 ) {
			var entityId = statData[0];
			var entityName = statData[1];
			var statValueArray = statData[2];
			if ( statValueArray.length != agentStatisticDataLength ) {
				// log error...
				console.log("Invalid statistic data length " + statValueArray.length + ", expected " + agentStatisticDataLength);
				return;
			}
			
			var itemJson = {
				id:entityId, name:entityName,
				answeringApplication:statValueArray[0], answeringCdn:statValueArray[1], anseringDnis:statValueArray[2], 
				answeringSkillset:statValueArray[3], dnInCallAnswered:statValueArray[4], dnInTimeInState:statValueArray[5],
				dnOutCallMade:statValueArray[6], dnOutCalledNumber:statValueArray[7], dnOutTimeInState:statValueArray[8],
				notReadyReasonCode:statValueArray[9], positionId:statValueArray[10], skillsetCallAnswered:statValueArray[11],
				state: statValueArray[12], supervisor:statValueArray[13], 
				//supervisorUserId:statValueArray[14], 
				timeInState:statValueArray[14]
			};
			itemJsonArray[i] = itemJson;
		} else {
			console.log("Invalid statistic JSON structure");
		}
	}
	
	var dataItems = { identifier:"id", label:"Id", items: itemJsonArray	};
	var newStore = new dojo.data.ItemFileWriteStore({data:dataItems});
	var grid = dijit.byId(gridName);
	grid.setStore(newStore);
} 	

function updateSkillsetStatsDataGrid(stats, gridName) {
	console.log("updateSkillsetStatsDataGrid");
	var dataStr = JSON.stringify(stats);
	console.log(dataStr);
	
	var statScheme = stats.statScheme;
	var timestamp = stats.timestamp;
	var numStats = stats.data.length;

	var itemJsonArray = new Array();
	for (i=0;i<numStats;i++) {
		var statData = stats.data[i];
		if ( statData.length == 3 ) {
			var entityId = statData[0];
			var entityName = statData[1];
			var statValueArray = statData[2];
			if ( statValueArray.length != skillsetStatisticDataLength ) {
				// log error...
				console.log("Invalid statistic data length " + statValueArray.length + ", expected " + skillsetStatisticDataLength);
				return;
			}
			
			var itemJson = {
				id:entityId, name:entityName,
				agentOnAcddnCall:statValueArray[0], agentOnNacddnCall:statValueArray[1], agentOnNetworkSkillsetCall:statValueArray[2], 
				agentOnOtherSkillsetCall:statValueArray[3], agentsAvailable:statValueArray[4], agentsInService:statValueArray[5],
				agentsNotReady:statValueArray[6], agentsOnDnCall:statValueArray[7], agentsOnSkillsetCall:statValueArray[8],
				agentsUnavailable:statValueArray[9], callsAnsweredAfterThreshold:statValueArray[10], callsOffered:statValueArray[11], 
				callsWaiting:statValueArray[12], expectedWaitingTime:statValueArray[13], longestWaitingTimeSinceLastCall:statValueArray[14],
				longestWaitingTimeSinceLogin:statValueArray[15], maxWaitingTime:statValueArray[16], networkCallsAnswered:statValueArray[17], 
				networkCallsOffered:statValueArray[18], networkCallsWaiting:statValueArray[19], queuedCallsAnswered:statValueArray[20],
				skillsetAbandoned:statValueArray[21], skillsetAbandonedAfterThreshold:statValueArray[22], skillsetAbandonedDelay:statValueArray[23],
				skillsetState:statValueArray[24], skillsetThreshold:statValueArray[25], totalCallsAnswered:statValueArray[26], 
				totalCallsAnsweredDelay:statValueArray[27],waitingTime:statValueArray[28] 
			};
			itemJsonArray[i] = itemJson;
		} else {
			console.log("Invalid statistic JSON structure");
		}
	}
	var dataItems = { identifier:"id", label:"Id", items: itemJsonArray	};
	var newStore = new dojo.data.ItemFileWriteStore({data:dataItems});
	var grid = dijit.byId(gridName);
	grid.setStore(newStore);
} 	


function issueGETRequest(url, successCallback, errorCallback) {
 	dojo.xhrGet({
		url: url,
		handleAs: "json",
		load: successCallback,
		error: errorCallback
	});
}

function issuePOSTRequest(url, jsonReqData, successCallback, errorCallback) {
	dojo.xhrPost({
		url: url,
		handleAs: "json",
		postData:JSON.stringify(jsonReqData), 
		load: successCallback,
		error: errorCallback
	});	
}  

function issueDELETERequest(url, successCallback, errorCallback) {
	dojo.xhrDelete({
		url: url,
		handleAs: "json",
		load: successCallback,
		error: errorCallback
	});
}

//function updateGasketTypes(){
//	console.log("updateGasketTypes");
//	_jsonStore.fetch({
//		query: { part_num: '??1?' },
//		onComplete: function(items, result){
//			dojo.forEach(items, function(item){
//				_jsonStore.setValue(item, "type", 2);
//			});
//		}
//	});
//}

function createLoginJsonReq(username, password) {
	var str = "{\"login\":{\"username\":\""+username+"\",\"password\":\""+password+"\"}}";
	var json = JSON.parse(str);
	return json;
}

function createLogoutReq(sso) {
	var str = "{\"logout\":{\"sso\":\""+sso+"\"}}";
	var json = JSON.parse(str);
	return json;
}

// Example JSON for subscribe request...
// --------------------------------------
// {"subscribe":{"statGroup":"agent","statScheme":"itd","entityRef":"10003"}}
// {"subscribe":{"statGroup":"application","statScheme":"mw","entityRef":"Application_10003"}}
// {"subscribe":{"statGroup":"agentSkillset","statScheme":"mw","entityRef":"10005"}}
// {"subscribe":{"statGroup":"skillset","statScheme":"itd","entityRef":"Skillset_10003"}}
function createSubscribeJsonReq(statGroupStr, statSchemeStr, entityRefStr) {
	var str = "{\"subscribe\":{\"statGroup\":\""+statGroupStr+"\",\"statScheme\":\""+statSchemeStr+"\",\"entityRef\":\""+entityRefStr+"\"}}";
	var json = JSON.parse(str);
	return json;
}

function createUnsubscribeJsonReq(subscriptionId) {
	var str = "{\"unsubscribe\":{\"subscriptionId\":\""+_subscriptionId+"\"}}";
	var json = JSON.parse(str);
	return json;
}


	