dojo.require("dojox.grid.DataGrid");
dojo.require("dojo.data.ItemFileWriteStore");

var contactNotificationsDataLength = 15;

var contactNotificationsLayout = [
	{ field: "id", name: "Contact Id", width: '100px', visibility: false },
	{ field: "name", name: "Contact State", width: '100px' }
];

function setupContactNotificationsDataGrid(gridName, gridDivNodeName) {

	var initialDataItems = {
			identifier: 'id',
			label: 'Id',
			items: [	
	        ]
	};

	initialDataStore = new dojo.data.ItemFileWriteStore({data: initialDataItems});	

	var grid = new dojox.grid.DataGrid({
		id: gridName,
		query: { id: '*' },
		store: initialDataStore,
		structure: contactNotificationsLayout
	}, gridDivNodeName);

	// Call startup, in order to render the grid:
	grid.startup();
}

function updateContactNotificationsDataGrid(stats, gridName) {
	console.log("updateApplicationStatsDataGrid");
	var dataStr = JSON.stringify(stats);
	console.log(dataStr);
	
	var statScheme = stats.statScheme;
	var timestamp = stats.timestamp;
	var numStats = stats.data.length;

	var itemJsonArray = new Array();
	for (i=0;i<4;i++) {
		var theId = i;
		var theName = name + i;
		var itemJson = {
			id:theId, 
			name:theName
		};
		itemJsonArray[i] = itemJson;
	}
	
	// I think this replaces the data store each time.
	var dataItems = { identifier:"id", label:"Id", items: itemJsonArray	};
	var newStore = new dojo.data.ItemFileWriteStore({data:dataItems});
	var grid = dijit.byId(gridName);

	grid.setStore(newStore);
} 	

function issueGETRequest(url, successCallback, errorCallback) {
 	dojo.xhrGet({
		url: url,
		handleAs: "text",
		load: successCallback,
		error: errorCallback
	});
}

function issuePOSTRequest(url, jsonReqData, successCallback, errorCallback) {
	alert(url);
	alert(JSON.stringify(jsonReqData));
	dojo.xhrPost({
		url: url,
		handleAs: "json",
		postData:JSON.stringify(jsonReqData), 
		load: successCallback,
		error: errorCallback
	});	
}  

function issueDELETERequest(url, successCallback, errorCallback) {
	dojo.xhrDelete({
		url: url,
		handleAs: "json",
		load: successCallback,
		error: errorCallback
	});
}


function createLoginJsonReq(username, password) {
	var str = "{\"login\":{\"username\":\""+username+"\",\"password\":\""+password+"\"}}";
	var json = JSON.parse(str);
	return json;
}

function createLogoutReq(sso) {
	var str = "{\"logout\":{\"sso\":\""+sso+"\"}}";
	var json = JSON.parse(str);
	return json;
}

// Example JSON for subscribe request...
// --------------------------------------
// {"subscribe":{"statGroup":"agent","statScheme":"itd","entityRef":"10003"}}
// {"subscribe":{"statGroup":"application","statScheme":"mw","entityRef":"Application_10003"}}
// {"subscribe":{"statGroup":"agentSkillset","statScheme":"mw","entityRef":"10005"}}
// {"subscribe":{"statGroup":"skillset","statScheme":"itd","entityRef":"Skillset_10003"}}
function createSubscribeJsonReq(statGroupStr, statSchemeStr, entityRefStr) {
	var str = "{\"subscribe\":{\"statGroup\":\""+statGroupStr+"\",\"statScheme\":\""+statSchemeStr+"\",\"entityRef\":\""+entityRefStr+"\"}}";
	var json = JSON.parse(str);
	return json;
}

function createUnsubscribeJsonReq(subscriptionId) {
	var str = "{\"unsubscribe\":{\"subscriptionId\":\""+_subscriptionId+"\"}}";
	var json = JSON.parse(str);
	return json;
}
