/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dao.ITerminalConnectionServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class GetContactDetailsCommand
extends Command {
    private IContactServiceDAO contactServiceDAO;
    private IConnectionServiceDAO connectionServiceDAO;
    private ITerminalConnectionServiceDAO terminalConnectionServiceDAO;
    private ICapabilitiesFacade capabilitiesFacade;
    private static final Category log = Category.getInstance((String)GetContactDetailsCommand.class.getName());

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        String string = (String)map.get("contactId");
        String string2 = (String)map.get("externalContactId");
        ContactTO contactTO = new ContactTO();
        contactTO.setContactId(string);
        AddressTO addressTO = new AddressTO();
        AddressTO addressTO2 = new AddressTO();
        TerminalTO terminalTO = new TerminalTO();
        AddressTO addressTO3 = new AddressTO();
        AddressTO addressTO4 = new AddressTO();
        AttachedDataTO attachedDataTO = null;
        String string3 = "";
        Exception exception = null;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList();
        this.capabilitiesFacade.getCapabilities(contactTO, ssoToken);
        try {
            addressTO = (AddressTO)this.getContactServiceDAO().getCallingAddress(string, ssoToken).getObject();
        }
        catch (Exception exception2) {
            addressTO.setAddressName("Can't Get");
        }
        try {
            addressTO2 = (AddressTO)this.getContactServiceDAO().getCalledAddress(string, ssoToken).getObject();
        }
        catch (Exception exception3) {
            addressTO2.setAddressName("Can't Get");
        }
        if (contactTO.getCapabilities().isCanGetCallingTerminal()) {
            try {
                terminalTO = (TerminalTO)this.getContactServiceDAO().getCallingTerminal(string, ssoToken).getObject();
            }
            catch (Exception exception4) {
                terminalTO.setTerminalName("Can't Get");
            }
        } else {
            terminalTO.setTerminalName("Can't Get");
        }
        if (contactTO.getCapabilities().isCanGetLastRedirectedAddress()) {
            try {
                addressTO3 = (AddressTO)this.getContactServiceDAO().getLastRedirectedAddress(string, ssoToken).getObject();
            }
            catch (Exception exception5) {
                addressTO3.setAddressName("Can't Get");
            }
        } else {
            addressTO3.setAddressName("Can't Get");
        }
        if (contactTO.getCapabilities().isCanGetOriginalDestination()) {
            try {
                addressTO4 = (AddressTO)this.getContactServiceDAO().getOriginalDestinationAddress(string, ssoToken).getObject();
            }
            catch (Exception exception6) {
                addressTO4.setAddressName("Can't Get");
            }
        } else {
            addressTO4.setAddressName("Can't Get");
        }
        if (contactTO.getCapabilities().isCanGetAttachedData()) {
            try {
                attachedDataTO = (AttachedDataTO)this.getContactServiceDAO().getAttachedData(string, ssoToken).getObject();
                log.info((Object)("GetContactDetailsCommand: " + attachedDataTO));
            }
            catch (Exception exception7) {
                attachedDataTO = new AttachedDataTO();
                addressTO4.setAddressName("Can't Get");
                bl = true;
                exception = exception7;
            }
        } else {
            attachedDataTO = new AttachedDataTO();
            attachedDataTO.setStringData("Can't Get");
        }
        if (contactTO.getCapabilities().isCanGetUUI()) {
            try {
                string3 = this.getContactServiceDAO().getUUIData(string, ssoToken).getMessage();
            }
            catch (Exception exception8) {
                string3 = "Can't Get";
            }
        } else {
            string3 = "Can't Get";
        }
        try {
            arrayList = (List)this.getContactServiceDAO().getContactTypes(string, ssoToken).getObject();
        }
        catch (Exception exception9) {
            System.err.println("Contact Types Exception (Contact)");
        }
        try {
            for (ConnectionTO connectionTO : (List)this.getContactServiceDAO().getConnections(string, ssoToken).getObject()) {
                String string4 = connectionTO.getConnectionId();
                try {
                    connectionTO.setAddressName(((AddressTO)this.getConnectionServiceDAO().getAddress(string4, ssoToken).getObject()).getAddressName());
                }
                catch (DAOException dAOException) {
                    log.warn((Object)("The address could not be fetched for connection[" + string4 + "]"), (Throwable)dAOException);
                }
                try {
                    connectionTO.setStateSummary((StateSummaryTO)this.getConnectionServiceDAO().getState(string4, ssoToken).getObject());
                }
                catch (DAOException dAOException) {
                    log.warn((Object)("The state could not be fetched for connection[" + string4 + "]"), (Throwable)dAOException);
                }
                try {
                    this.getCapabilitiesFacade().getCapabilities(connectionTO, ssoToken);
                }
                catch (DAOException dAOException) {
                    log.warn((Object)("The capabilities could not be fetched for connection[" + string4 + "]"), (Throwable)dAOException);
                }
                try {
                    for (TerminalConnectionTO terminalConnectionTO : (List)this.getConnectionServiceDAO().getTerminalConnections(string4, ssoToken).getObject()) {
                        String string5 = terminalConnectionTO.getTerminalConnectionId();
                        try {
                            terminalConnectionTO.setTerminalName(((TerminalTO)this.getTerminalConnectionServiceDAO().getTerminal(string5, ssoToken).getObject()).getTerminalName());
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The terminal could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        try {
                            terminalConnectionTO.setContactType((String)this.getTerminalConnectionServiceDAO().getContactType(string5, ssoToken).getObject());
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The contactType could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        try {
                            terminalConnectionTO.setStateSummary((StateSummaryTO)this.getTerminalConnectionServiceDAO().getState(string5, ssoToken).getObject());
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The state could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        try {
                            terminalConnectionTO.setConferenceConsult((ContactTO)this.getTerminalConnectionServiceDAO().getConferenceConsult(string5, ssoToken).getObject());
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The conference consult could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        try {
                            terminalConnectionTO.setTransferConsult((ContactTO)this.getTerminalConnectionServiceDAO().getTransferConsult(string5, ssoToken).getObject());
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The transfer consult could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        try {
                            this.getCapabilitiesFacade().getCapabilities(terminalConnectionTO, ssoToken);
                        }
                        catch (DAOException dAOException) {
                            log.warn((Object)("The capabilities could not be fetched for terminalConnection[" + string5 + "]"), (Throwable)dAOException);
                        }
                        connectionTO.addTerminalConnection(terminalConnectionTO);
                    }
                }
                catch (DAOException dAOException) {
                    log.warn((Object)("The terminal connections could not be fetched for connection[" + string4 + "]"), (Throwable)dAOException);
                }
                contactTO.addConnection(connectionTO);
            }
        }
        catch (DAOException dAOException) {
            log.warn((Object)("The connections could not be fetched for the contact[" + string + "] "), (Throwable)dAOException);
        }
        contactTO.setExternalContactId(string2);
        contactTO.setCalledAddress(addressTO2 != null ? addressTO2.getAddressName() : null);
        contactTO.setCallingAddress(addressTO != null ? addressTO.getAddressName() : null);
        contactTO.setCallingTerminal(terminalTO != null ? terminalTO.getTerminalName() : null);
        contactTO.setLastRedirectedAddress(addressTO3 != null ? addressTO3.getAddressName() : null);
        contactTO.setOriginalDestinationAddress(addressTO4 != null ? addressTO4.getAddressName() : null);
        contactTO.setAttachedData(attachedDataTO);
        contactTO.setUuiData(string3);
        contactTO.setContactTypes(arrayList);
        this.getRefClient().supplementContactInfo(contactTO);
        if (bl) {
            throw new Exception(exception);
        }
    }

    public IContactServiceDAO getContactServiceDAO() {
        return this.contactServiceDAO;
    }

    public void setContactServiceDAO(IContactServiceDAO iContactServiceDAO) {
        this.contactServiceDAO = iContactServiceDAO;
    }

    public ICapabilitiesFacade getCapabilitiesFacade() {
        return this.capabilitiesFacade;
    }

    public void setCapabilitiesFacade(ICapabilitiesFacade iCapabilitiesFacade) {
        this.capabilitiesFacade = iCapabilitiesFacade;
    }

    public IConnectionServiceDAO getConnectionServiceDAO() {
        return this.connectionServiceDAO;
    }

    public void setConnectionServiceDAO(IConnectionServiceDAO iConnectionServiceDAO) {
        this.connectionServiceDAO = iConnectionServiceDAO;
    }

    public ITerminalConnectionServiceDAO getTerminalConnectionServiceDAO() {
        return this.terminalConnectionServiceDAO;
    }

    public void setTerminalConnectionServiceDAO(ITerminalConnectionServiceDAO iTerminalConnectionServiceDAO) {
        this.terminalConnectionServiceDAO = iTerminalConnectionServiceDAO;
    }
}

