/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dto;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CapabilityTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateEventTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UserContextDO {
    private List<TerminalTO> terminals = new ArrayList<TerminalTO>();
    private List<AddressTO> unmappedAddresses = new ArrayList<AddressTO>();
    private List<ContactTO> contacts = new ArrayList<ContactTO>();
    private List<ContactTO> routePointContacts = new ArrayList<ContactTO>();

    public List<TerminalTO> getTerminals() {
        return this.terminals;
    }

    public void setTerminals(List<TerminalTO> list) {
        this.terminals = list;
    }

    public List<AddressTO> getUnmappedAddresses() {
        return this.unmappedAddresses;
    }

    public void setUnmappedAddresses(List<AddressTO> list) {
        this.unmappedAddresses = list;
    }

    public Vector<CapabilityTO> findCapabilitySet(String string, String string2) {
        for (TerminalTO object : this.terminals) {
            if (!object.getTerminalName().equals(string)) continue;
            for (AddressTO addressTO : object.getAddresses()) {
                if (!addressTO.getAddressName().equals(string2)) continue;
                return new Vector<CapabilityTO>(addressTO.getCapabilities().getCapabilityList());
            }
        }
        for (TerminalTO terminalTO : this.terminals) {
            if (!terminalTO.getTerminalName().equals(string2)) continue;
            Vector<CapabilityTO> vector = new Vector<CapabilityTO>(terminalTO.getTerminalCapabilities().getCapabilityList());
            vector.addAll(terminalTO.getAgentTerminalCapabilities().getCapabilityList());
            return vector;
        }
        if (this.unmappedAddresses != null) {
            for (AddressTO addressTO : this.unmappedAddresses) {
                if (!addressTO.getAddressName().equals(string2)) continue;
                return new Vector<CapabilityTO>(addressTO.getCapabilities().getCapabilityList());
            }
        }
        return null;
    }

    public TerminalTO getTerminal(String string) {
        if (this.terminals != null) {
            for (TerminalTO terminalTO : this.terminals) {
                if (!terminalTO.getTerminalName().equals(string)) continue;
                return terminalTO;
            }
        }
        return null;
    }

    public void updateContact(ContactTO contactTO) {
        if (this.contacts.size() == 0) {
            this.contacts.add(contactTO);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.contacts.size(); ++i) {
                if (!this.contacts.get(i).getContactId().equals(contactTO.getContactId())) continue;
                ContactTO contactTO2 = this.contacts.get(i);
                contactTO2.setCalledAddress(contactTO.getCalledAddress());
                contactTO2.setCallingAddress(contactTO.getCallingAddress());
                contactTO2.setCallingTerminal(contactTO.getCallingTerminal());
                contactTO2.setLastRedirectedAddress(contactTO.getLastRedirectedAddress());
                contactTO2.setOriginalDestinationAddress(contactTO.getOriginalDestinationAddress());
                contactTO2.setAttachedData(contactTO.getAttachedData());
                contactTO2.setUuiData(contactTO.getUuiData());
                contactTO2.setContactTypes(contactTO.getContactTypes());
                contactTO2.setConnections(contactTO.getConnections());
                contactTO2.setExternalContactId(contactTO.getExternalContactId());
                this.contacts.set(i, contactTO2);
                bl = true;
                break;
            }
            if (!bl) {
                this.contacts.add(contactTO);
            }
        }
    }

    public void updateContactCapabilities(ContactTO contactTO) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!this.contacts.get(i).getContactId().equals(contactTO.getContactId())) continue;
            n = i;
            bl = true;
            break;
        }
        if (bl) {
            this.contacts.get(n).setCapabilities(contactTO.getCapabilities());
            for (ConnectionTO connectionTO : contactTO.getConnections()) {
                ConnectionTO connectionTO2 = this.findConnection(connectionTO.getConnectionId());
                if (connectionTO2 != null) {
                    connectionTO2.setCapabilities(connectionTO.getCapabilities());
                }
                TerminalConnectionTO terminalConnectionTO = null;
                for (TerminalConnectionTO terminalConnectionTO2 : connectionTO.getTerminalConnections()) {
                    terminalConnectionTO = this.findTerminalConnection(terminalConnectionTO2.getTerminalConnectionId());
                    if (terminalConnectionTO == null) continue;
                    terminalConnectionTO.setCapabilities(terminalConnectionTO2.getCapabilities());
                }
            }
        } else {
            this.contacts.add(contactTO);
        }
    }

    public ContactTO findContact(String string) {
        for (ContactTO contactTO : this.contacts) {
            if (!contactTO.getContactId().equals(string) && !contactTO.getExternalContactId().equals(string)) continue;
            return contactTO;
        }
        return null;
    }

    public ContactTO findRoutePointContact(String string) {
        for (ContactTO contactTO : this.routePointContacts) {
            if (!contactTO.getContactId().equals(string) && !contactTO.getExternalContactId().equals(string)) continue;
            return contactTO;
        }
        return null;
    }

    public ConnectionTO findConnection(String string) {
        ConnectionTO connectionTO = null;
        for (ContactTO contactTO : this.contacts) {
            ConnectionTO connectionTO2 = contactTO.getConnectionById(string);
            if (connectionTO2 == null) continue;
            connectionTO = connectionTO2;
            break;
        }
        return connectionTO;
    }

    public TerminalConnectionTO findTerminalConnection(String string) {
        TerminalConnectionTO terminalConnectionTO = null;
        for (ContactTO contactTO : this.contacts) {
            for (ConnectionTO connectionTO : contactTO.getConnections()) {
                TerminalConnectionTO terminalConnectionTO2 = connectionTO.getTerminalConnection(string);
                if (terminalConnectionTO2 == null) continue;
                terminalConnectionTO = terminalConnectionTO2;
            }
        }
        return terminalConnectionTO;
    }

    public AddressTO getAddress(String string) {
        for (TerminalTO object : this.terminals) {
            for (AddressTO addressTO : object.getAddresses()) {
                if (!addressTO.getAddressName().equals(string)) continue;
                return addressTO;
            }
        }
        if (this.unmappedAddresses != null) {
            for (AddressTO addressTO : this.unmappedAddresses) {
                if (!addressTO.getAddressName().equals(string)) continue;
                return addressTO;
            }
        }
        return null;
    }

    public TerminalTO deriveTerminal(String string) {
        for (TerminalTO terminalTO : this.terminals) {
            for (AddressTO addressTO : terminalTO.getAddresses()) {
                if (!addressTO.getAddressName().equals(string)) continue;
                return terminalTO;
            }
        }
        return null;
    }

    public String deriveTerminalName(String string) {
        TerminalTO terminalTO = this.deriveTerminal(string);
        return terminalTO == null ? "" : terminalTO.getTerminalName();
    }

    public void removeContact(String string) {
        int n = -1;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!this.contacts.get(i).getContactId().equals(string)) continue;
            n = i;
        }
        if (n > -1) {
            this.contacts.remove(n);
        }
    }

    public void removeRoutePointContact(String string) {
        int n = -1;
        for (int i = 0; i < this.routePointContacts.size(); ++i) {
            if (!this.routePointContacts.get(i).getContactId().equals(string)) continue;
            n = i;
        }
        if (n > -1) {
            this.routePointContacts.remove(n);
        }
    }

    public void addContact(ContactTO contactTO) {
        this.contacts.add(contactTO);
    }

    public void addRoutePointContact(ContactTO contactTO) {
        this.routePointContacts.add(contactTO);
    }

    public void removeTerminal(String string) {
        int n = -1;
        int n2 = 0;
        for (TerminalTO terminalTO : this.terminals) {
            if (terminalTO.getTerminalName().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            this.terminals.remove(n);
        }
    }

    public void removeAddress(String string) {
        boolean bl = false;
        for (TerminalTO object : this.terminals) {
            AddressTO addressTO = object.getAddress(string);
            if (addressTO == null) continue;
            object.getAddresses().remove(addressTO);
            bl = true;
            break;
        }
        if (!bl) {
            for (AddressTO addressTO : this.unmappedAddresses) {
                if (!addressTO.getAddressName().equals(string)) continue;
                this.unmappedAddresses.remove(addressTO);
                break;
            }
        }
    }

    public void addTerminal(TerminalTO terminalTO) {
        this.terminals.add(terminalTO);
    }

    public void addAddress(List<TerminalTO> list, AddressTO addressTO) {
        if (list != null) {
            for (TerminalTO terminalTO : list) {
                TerminalTO terminalTO2 = this.getTerminal(terminalTO.getTerminalName());
                if (terminalTO2 == null) continue;
                boolean bl = false;
                for (AddressTO addressTO2 : terminalTO2.getAddresses()) {
                    if (!addressTO2.getAddressName().equals(addressTO.getAddressName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.getTerminal(terminalTO.getTerminalName()).getAddresses().add(addressTO);
            }
        } else {
            this.unmappedAddresses.add(addressTO);
        }
    }

    public String getContactRemoteState(StateEventTO stateEventTO) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (stateEventTO != null) {
            String string = stateEventTO.getContactId();
            TerminalTO terminalTO = null;
            terminalTO = !stateEventTO.isRemote() && stateEventTO.getNotifiedAddress() != null ? this.deriveTerminal(stateEventTO.getNotifiedAddress()) : (!stateEventTO.getTerminal().equals("") ? this.getTerminal(stateEventTO.getTerminal()) : this.deriveTerminal(stateEventTO.getAddress()));
            for (int i = 0; i < this.contacts.size(); ++i) {
                if (!this.contacts.get(i).getContactId().equals(string)) continue;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                String string2 = null;
                ContactTO contactTO = this.contacts.get(i);
                List<ConnectionTO> list = contactTO.getConnections();
                for (ConnectionTO object : list) {
                    string2 = object.getStateSummary().getCurrent();
                    if ((terminalTO != null || this.getAddress(object.getAddressName()) != null) && (terminalTO == null || terminalTO.getAddresses().contains(this.getAddress(object.getAddressName()))) || string2.equalsIgnoreCase("DISCONNECTED")) continue;
                    hashMap.put(string2, hashMap.get(string2) == null ? 1 : (Integer)hashMap.get(string2) + 1);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    stringBuilder.append((String)entry.getKey());
                    if ((Integer)entry.getValue() > 1) {
                        stringBuilder.append('(').append(entry.getValue()).append(')');
                    }
                    stringBuilder.append(",");
                }
                break;
            }
        }
        if (!stringBuilder.toString().equals("")) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "<n/a>";
    }

    public void addConnection(StateEventTO stateEventTO, StateSummaryTO stateSummaryTO) {
        ContactTO contactTO;
        if (stateEventTO != null && (contactTO = this.findContact(stateEventTO.getContactId())) != null) {
            ConnectionTO connectionTO = new ConnectionTO();
            connectionTO.setAddressName(stateEventTO.getAddress());
            connectionTO.setConnectionId(stateEventTO.getConnection().getConnectionId());
            connectionTO.setStateSummary(stateSummaryTO);
            contactTO.getConnections().add(connectionTO);
        }
    }

    public void reset() {
        if (this.terminals != null) {
            this.terminals.clear();
        }
        if (this.contacts != null) {
            this.contacts.clear();
        }
        if (this.unmappedAddresses != null) {
            this.unmappedAddresses.clear();
        }
        if (this.routePointContacts != null) {
            this.routePointContacts.clear();
        }
    }
}

