/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.handler;

import com.nortel.rc.command.Command;
import com.nortel.rc.event.IHASwitchOverHandler;
import com.nortel.rc.event.INotificationHandler;
import com.nortel.rc.exception.DAOException;
import com.nortel.rc.gui.SOARefClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.io.ClassPathResource;

public class RequestHandler
implements MessageSourceAware {
    private INotificationHandler notificationHandler;
    private IHASwitchOverHandler haSwitchOverHandler;
    private Map<String, Command> commands;
    public MessageSource messageSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandler(String string) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new ClassPathResource(string).getInputStream();
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        PropertyConfigurator.configure((Properties)properties);
    }

    public boolean handle(String string, Map<String, Object> map) {
        Command command = null;
        boolean bl = false;
        try {
            command = this.getCommand(string);
        }
        catch (Exception exception) {
            SOARefClient.reportError(string, exception.getMessage());
            return true;
        }
        try {
            command.execute(map);
        }
        catch (DAOException dAOException) {
            if (dAOException.getCause() != null && dAOException.getCause().getClass().toString().contains("javax.xml.ws.soap.SOAPFaultException")) {
                SOARefClient.reportError(string, "Your session token has expired. Connect to CCT again to receive a new token");
            } else {
                SOARefClient.reportError(string, dAOException.getMessage());
            }
            bl = true;
        }
        catch (Exception exception) {
            SOARefClient.reportError(string, exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
            bl = true;
        }
        return bl;
    }

    private Command getCommand(String string) throws Exception {
        if (this.commands.containsKey(string)) {
            return this.commands.get(string);
        }
        throw new NullPointerException("Problem locating Command to execute " + string);
    }

    public void setCommands(Map<String, Command> map) {
        this.commands = map;
    }

    public void setNotificationHandler(INotificationHandler iNotificationHandler) {
        this.notificationHandler = iNotificationHandler;
    }

    public INotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public IHASwitchOverHandler getHaSwitchOverHandler() {
        return this.haSwitchOverHandler;
    }

    public void setHaSwitchOverHandler(IHASwitchOverHandler iHASwitchOverHandler) {
        this.haSwitchOverHandler = iHASwitchOverHandler;
    }
}

