/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.js.rhino;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cxf.js.rhino.ProviderFactory;

public class ServerApp {
    public static final String NO_ADDR_ERR = "error: an endpoint address must be provided";
    public static final String NO_FILES_ERR = "error: no JavaScript files specified";
    public static final String WRONG_ADDR_ERR = "error: -a requires a URL argument";
    public static final String WRONG_BASE_ERR = "error: -b requires a base URL argument";
    public static final String ILLEGAL_OPTIONS_ERR = "error: -a and -b cannot be used together";
    public static final String UNKNOWN_OPTION = "error: unknown option";
    private boolean verbose;
    private boolean bOptSeen;
    private String epAddr;

    protected void start(String[] args) throws Exception {
        ProviderFactory ph = this.createProviderFactory();
        JSFilter jsFilter = new JSFilter();
        boolean fileSeen = false;
        boolean msgPrinted = false;
        for (int i = 0; i != args.length; ++i) {
            File[] flist;
            if (args[i].startsWith("-")) {
                i = this.checkOption(args, i);
                if (!this.verbose || msgPrinted) continue;
                msgPrinted = true;
                if (!this.verbose) continue;
                System.out.println("entering server");
                continue;
            }
            File f = new File(args[i]);
            if (f.isFile() && jsFilter.accept(f)) {
                fileSeen = true;
                if (this.verbose) {
                    System.out.println("processing file " + f.getCanonicalPath());
                }
                ph.createAndPublish(f, this.epAddr, this.bOptSeen);
                continue;
            }
            if (!f.isDirectory()) continue;
            for (File file : flist = f.listFiles(jsFilter)) {
                fileSeen = true;
                if (this.verbose) {
                    System.out.println("processing file " + file.getCanonicalPath());
                }
                ph.createAndPublish(file, this.epAddr, this.bOptSeen);
            }
        }
        if (!fileSeen) {
            throw new Exception(NO_FILES_ERR);
        }
    }

    public static void main(String[] args) throws Exception {
        ServerApp app = null;
        try {
            app = new ServerApp();
            app.start(args);
        }
        catch (Exception e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
        }
        if (app.verbose) {
            System.out.println("server ready...");
        }
        Thread.sleep(300000L);
        if (app.verbose) {
            System.out.println("server timed out, exiting");
        }
        System.exit(0);
    }

    protected ProviderFactory createProviderFactory() {
        return new ProviderFactory();
    }

    private int checkOption(String[] args, int index) throws Exception {
        if ("-v".equals(args[index])) {
            this.verbose = true;
        } else if ("-a".equals(args[index])) {
            this.bOptSeen = false;
            if (++index == args.length) {
                throw new Exception(WRONG_ADDR_ERR);
            }
            try {
                new URL(args[index]);
            }
            catch (MalformedURLException m) {
                throw new Exception(WRONG_ADDR_ERR, m);
            }
            this.epAddr = args[index];
        } else if ("-b".equals(args[index])) {
            this.bOptSeen = true;
            if (++index == args.length) {
                throw new Exception(WRONG_BASE_ERR);
            }
            try {
                new URL(args[index]);
            }
            catch (MalformedURLException m) {
                throw new Exception(WRONG_BASE_ERR, m);
            }
            this.epAddr = args[index];
        } else {
            throw new Exception("error: unknown option: " + args[index]);
        }
        return index;
    }

    private static class JSFilter
    implements FileFilter {
        private JSFilter() {
        }

        @Override
        public final boolean accept(File f) {
            if (f.isFile()) {
                String name = f.getName();
                return name.endsWith(".js") || name.endsWith(".jsx");
            }
            return false;
        }
    }
}

