/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.idlpreprocessor;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import org.apache.cxf.tools.corba.idlpreprocessor.DefineState;
import org.apache.cxf.tools.corba.idlpreprocessor.IncludeResolver;
import org.apache.cxf.tools.corba.idlpreprocessor.IncludeStackEntry;
import org.apache.cxf.tools.corba.idlpreprocessor.PreprocessingException;

public final class IdlPreprocessorReader
extends Reader {
    private static final int MAX_INCLUDE_DEPTH = 64;
    private static final char PUSH = '1';
    private static final char POP = '2';
    private static final String LF = System.getProperty("line.separator");
    private final IncludeResolver includeResolver;
    private final Stack<IncludeStackEntry> includeStack = new Stack();
    private final Stack<Boolean> ifStack = new Stack();
    private final DefineState defineState;
    private final StringBuilder buf = new StringBuilder();
    private int readPos;
    private String pragmaPrefix;

    public IdlPreprocessorReader(URL startURL, String startLocation, IncludeResolver resolver, DefineState state) throws IOException {
        this.includeResolver = resolver;
        this.defineState = state;
        this.pushInclude(startURL, startLocation);
        this.fillBuffer();
    }

    private void pushInclude(URL url, String location) throws IOException {
        IncludeStackEntry includeStackEntry = new IncludeStackEntry(url, location);
        this.includeStack.push(includeStackEntry);
        int lineNumber = this.getReader().getLineNumber();
        this.signalFileChange(location, lineNumber, '1');
    }

    @Override
    public void close() throws IOException {
        this.buf.setLength(0);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int buflen = this.buf.length();
        if (this.readPos >= buflen) {
            return -1;
        }
        int numCharsRead = Math.min(len, buflen - this.readPos);
        this.buf.getChars(this.readPos, this.readPos + numCharsRead, cbuf, off);
        this.readPos += numCharsRead;
        return numCharsRead;
    }

    @Override
    public int read() throws IOException {
        if (this.buf.length() == 0) {
            return -1;
        }
        return this.buf.charAt(this.readPos++);
    }

    private void fillBuffer() throws IOException {
        while (!this.includeStack.isEmpty()) {
            LineNumberReader reader = this.getReader();
            int lineNo = reader.getLineNumber();
            String line = reader.readLine();
            if (line == null) {
                this.popInclude();
                continue;
            }
            if (!(line = this.processComments(line)).trim().startsWith("#")) {
                if (!this.skips()) {
                    this.buf.append(line);
                }
                this.buf.append(LF);
                continue;
            }
            IncludeStackEntry ise = this.includeStack.peek();
            line = line.trim();
            if ((line = this.processPreprocessorComments(this.buf, line)).startsWith("#include")) {
                this.handleInclude(line, lineNo, ise);
                continue;
            }
            if (line.startsWith("#ifndef")) {
                this.handleIfndef(line);
                continue;
            }
            if (line.startsWith("#ifdef")) {
                this.handleIfdef(line);
                continue;
            }
            if (line.startsWith("#if")) {
                this.handleIf(line);
                continue;
            }
            if (line.startsWith("#endif")) {
                this.handleEndif(lineNo, ise);
                continue;
            }
            if (line.startsWith("#else")) {
                this.handleElse(lineNo, ise);
                continue;
            }
            if (line.startsWith("#define")) {
                this.handleDefine(line);
                continue;
            }
            if (line.startsWith("#pragma")) {
                this.handlePragma(line);
                continue;
            }
            throw new PreprocessingException("unknown preprocessor instruction", ise.getURL(), lineNo);
        }
    }

    private String processComments(String line) {
        int pos = line.indexOf("**/");
        if (pos != -1) {
            line = line.substring(0, pos + 1) + " " + line.substring(pos + 1);
        }
        return line;
    }

    private String processPreprocessorComments(StringBuilder buffer, String line) {
        int pos = line.indexOf("//");
        if (pos != -1 && pos != 0) {
            buffer.append(line.substring(pos));
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf("/*")) != -1 && pos != 0) {
            buffer.append(line.substring(pos));
            line = line.substring(0, pos);
        }
        return line;
    }

    private void handleDefine(String line) {
        this.buf.append(LF);
        if (this.skips()) {
            return;
        }
        String def = line.substring("#define".length()).trim();
        int idx = def.indexOf(32);
        if (idx == -1) {
            this.defineState.define(def, null);
        } else {
            String symbol = def.substring(0, idx);
            String value = def.substring(idx + 1).trim();
            this.defineState.define(symbol, value);
        }
    }

    private void handleElse(int lineNo, IncludeStackEntry ise) {
        if (this.ifStack.isEmpty()) {
            throw new PreprocessingException("unexpected #else", ise.getURL(), lineNo);
        }
        boolean top = this.ifStack.pop();
        this.ifStack.push(!top);
        this.buf.append(LF);
    }

    private void handleEndif(int lineNo, IncludeStackEntry ise) {
        if (this.ifStack.isEmpty()) {
            throw new PreprocessingException("unexpected #endif", ise.getURL(), lineNo);
        }
        this.ifStack.pop();
        this.buf.append(LF);
    }

    private void handleIfdef(String line) {
        String symbol = line.substring("#ifdef".length()).trim();
        boolean isDefined = this.defineState.isDefined(symbol);
        this.registerIf(!isDefined);
        this.buf.append(LF);
    }

    private void handleIf(String line) {
        String symbol = line.substring("#if".length()).trim();
        boolean notSkip = true;
        try {
            int value = Integer.parseInt(symbol);
            if (value == 0) {
                notSkip = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.registerIf(!notSkip);
        this.buf.append(LF);
    }

    private void handlePragma(String line) {
        String symbol = line.substring(line.indexOf("prefix") + "prefix".length()).trim();
        if (symbol.startsWith("\"")) {
            symbol = symbol.substring(1);
        }
        if (symbol.endsWith("\"")) {
            symbol = symbol.substring(0, symbol.length() - 1);
        }
        this.setPragmaPrefix(symbol);
        this.buf.append(LF);
    }

    private void handleIfndef(String line) {
        String symbol = line.substring("#ifndef".length()).trim();
        boolean isDefined = this.defineState.isDefined(symbol);
        this.registerIf(isDefined);
        this.buf.append(LF);
    }

    private void handleInclude(String line, int lineNo, IncludeStackEntry ise) throws IOException {
        URL include;
        if (this.skips()) {
            this.buf.append(LF);
            return;
        }
        if (this.includeStack.size() >= 64) {
            throw new PreprocessingException("more than 64 nested #includes - assuming infinite recursion, aborting", ise.getURL(), lineNo);
        }
        String arg = line.replaceFirst("#include", "").trim();
        if (arg.length() == 0) {
            throw new PreprocessingException("#include without an argument", ise.getURL(), lineNo);
        }
        char first = arg.charAt(0);
        int lastIdx = arg.length() - 1;
        char last = arg.charAt(lastIdx);
        if (arg.length() < 3 || (first != '<' || last != '>') && (first != '\"' || last != '\"')) {
            throw new PreprocessingException("argument for '#include' must be enclosed in '< >' or '\" \"'", ise.getURL(), lineNo);
        }
        String spec = arg.substring(1, lastIdx);
        URL uRL = include = first == '<' ? this.includeResolver.findSystemInclude(spec) : this.includeResolver.findUserInclude(spec);
        if (include == null) {
            throw new PreprocessingException("unable to resolve include '" + spec + "'", ise.getURL(), lineNo);
        }
        this.pushInclude(include, spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popInclude() throws IOException {
        IncludeStackEntry poppedStackEntry = this.includeStack.pop();
        if (!this.includeStack.isEmpty()) {
            this.buf.append(LF);
        }
        try {
            if (this.includeStack.size() > 0) {
                IncludeStackEntry newTopEntry = this.includeStack.peek();
                LineNumberReader reader = this.getReader();
                int lineNumber = reader.getLineNumber();
                String location = newTopEntry.getLocation();
                this.signalFileChange(location, lineNumber, '2');
            }
        }
        finally {
            poppedStackEntry.getReader().close();
        }
    }

    private boolean skips() {
        if (this.ifStack.isEmpty()) {
            return false;
        }
        return this.ifStack.peek();
    }

    private void registerIf(boolean skip) {
        this.ifStack.push(skip);
    }

    private LineNumberReader getReader() {
        IncludeStackEntry topOfStack = this.includeStack.peek();
        return topOfStack.getReader();
    }

    private void signalFileChange(String location, int lineNumber, char flag) {
        this.buf.append("# ").append(lineNumber).append(' ').append(location).append(' ').append(flag).append(LF);
    }

    public void setPragmaPrefix(String pragmaPrefix) {
        this.pragmaPrefix = pragmaPrefix;
    }

    public String getPragmaPrefix() {
        return this.pragmaPrefix;
    }
}

