/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IAddressServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressCapabilitiesTO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.addressservice.AddressService;
import com.nortel.soa.oi.cct.addressservice.SOAOICCTAddressService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressCapabilities;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.addressservice.AddressRequest;
import com.nortel.soa.oi.cct.types.addressservice.GetConnectionsResponse;
import com.nortel.soa.oi.cct.types.addressservice.GetTerminalsResponse;
import com.nortel.soa.oi.cct.types.addressservice.SetDoNotDisturbRequest;
import com.nortel.soa.oi.cct.types.addressservice.SetForwardingRequest;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AddressServiceDAO
extends ServiceDAO
implements IAddressServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.AddressServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getConnections(AddressTO addressTO, String string) throws DAOException {
        String string2 = "getConnections():";
        AddressRequest addressRequest = new AddressRequest();
        ArrayList<ConnectionTO> arrayList = new ArrayList<ConnectionTO>();
        GetConnectionsResponse getConnectionsResponse = null;
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        ssoToken.setToken(string);
        addressRequest.setAddress(address);
        addressRequest.setSsoToken(ssoToken);
        try {
            getConnectionsResponse = this.getPort().getConnections(addressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        for (Connection connection : getConnectionsResponse.getConnection()) {
            ConnectionTO connectionTO = new ConnectionTO();
            connectionTO.setConnectionId(connection.getConnectionId());
            arrayList.add(connectionTO);
        }
        CallResult callResult = new CallResult();
        callResult.setObject(arrayList);
        return callResult;
    }

    @Override
    public CallResult getTerminals(AddressTO addressTO, String string) throws DAOException {
        String string2 = "getTerminals():";
        AddressRequest addressRequest = new AddressRequest();
        ArrayList<TerminalTO> arrayList = new ArrayList<TerminalTO>();
        GetTerminalsResponse getTerminalsResponse = null;
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        ssoToken.setToken(string);
        addressRequest.setAddress(address);
        addressRequest.setSsoToken(ssoToken);
        try {
            getTerminalsResponse = this.getPort().getTerminals(addressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        for (Terminal terminal : getTerminalsResponse.getTerminals()) {
            TerminalTO terminalTO = new TerminalTO();
            terminalTO.setTerminalName(terminal.getTerminalName());
            terminalTO.setTerminalType(terminal.getTerminalType().value());
            arrayList.add(terminalTO);
        }
        CallResult callResult = new CallResult();
        callResult.setObject(arrayList);
        return callResult;
    }

    @Override
    public CallResult getCapabilities(AddressTO addressTO, String string) throws DAOException {
        String string2 = "getCapabilities():";
        AddressRequest addressRequest = new AddressRequest();
        AddressCapabilities addressCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        ssoToken.setToken(string);
        addressRequest.setAddress(address);
        addressRequest.setSsoToken(ssoToken);
        try {
            addressCapabilities = this.getPort().getCapabilities(addressRequest).getAddressCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        AddressCapabilitiesTO addressCapabilitiesTO = new AddressCapabilitiesTO();
        addressCapabilitiesTO.setCanConference(addressCapabilities.isCanConference());
        addressCapabilitiesTO.setCanDoNotDisturb(addressCapabilities.isCanDoNotDisturb());
        addressCapabilitiesTO.setCanOriginate(addressCapabilities.isCanOriginate());
        addressCapabilitiesTO.setCanTransfer(addressCapabilities.isCanTransfer());
        CallResult callResult = new CallResult();
        callResult.setObject(addressCapabilitiesTO);
        return callResult;
    }

    @Override
    public CallResult setDoNotDisturb(AddressTO addressTO, String string) throws DAOException {
        String string2 = "setDoNotDisturb():";
        SetDoNotDisturbRequest setDoNotDisturbRequest = new SetDoNotDisturbRequest();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        ssoToken.setToken(string);
        setDoNotDisturbRequest.setAddress(address);
        setDoNotDisturbRequest.setSsoToken(ssoToken);
        setDoNotDisturbRequest.setDoNotDisturb(!addressTO.isDoNotDisturb());
        try {
            this.getPort().setDoNotDisturb(setDoNotDisturbRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setForwarding(AddressTO addressTO, String string) throws DAOException {
        String string2 = "setForwarding():";
        SetForwardingRequest setForwardingRequest = new SetForwardingRequest();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        ssoToken.setToken(string);
        setForwardingRequest.setAddress(address);
        setForwardingRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setForwarding(setForwardingRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    public AddressService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTAddressService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(AddressService.class);
        object = (AddressService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

