/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactCapabilitiesTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.KeyValuePairTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.contactservice.ContactService;
import com.nortel.soa.oi.cct.contactservice.SOAOICCTContactService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.AttachedData;
import com.nortel.soa.oi.cct.types.AttachmentType;
import com.nortel.soa.oi.cct.types.ByteArray;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.ContactCapabilities;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.KeyValuePair;
import com.nortel.soa.oi.cct.types.KeyValuePairArray;
import com.nortel.soa.oi.cct.types.MediaTreatment;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.contactservice.AddressResponse;
import com.nortel.soa.oi.cct.types.contactservice.ContactAttachedDataRequest;
import com.nortel.soa.oi.cct.types.contactservice.ContactRequest;
import com.nortel.soa.oi.cct.types.contactservice.GetAttachedDataResponse;
import com.nortel.soa.oi.cct.types.contactservice.GetConnectionsResponse;
import com.nortel.soa.oi.cct.types.contactservice.GetContactTypesResponse;
import com.nortel.soa.oi.cct.types.contactservice.GiveTreatmentRequest;
import com.nortel.soa.oi.cct.types.contactservice.SetIntrinsicsRequest;
import com.nortel.soa.oi.cct.types.contactservice.SetUUIRequest;
import com.nortel.soa.oi.cct.types.contactservice.TerminalResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContactServiceDAO
extends ServiceDAO
implements IContactServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.ContactServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getCalledAddress(String string, String string2) throws DAOException {
        AddressResponse addressResponse;
        String string3 = "getCalledAddress():";
        CallResult callResult = new CallResult();
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            addressResponse = this.getPort().getCalledAddress(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (addressResponse != null && addressResponse.getAddress() != null) {
            AddressTO addressTO = new AddressTO();
            addressTO.setAddressName(addressResponse.getAddress().getAddressName());
            addressTO.setAddressType(addressResponse.getAddress().getAddressType().toString());
            addressTO.setAddressStatus(addressResponse.getAddress().getStatus());
            callResult.setObject(addressTO);
        }
        return callResult;
    }

    @Override
    public CallResult getCallingAddress(String string, String string2) throws DAOException {
        AddressResponse addressResponse;
        String string3 = "getCallingAddress():";
        CallResult callResult = new CallResult();
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            addressResponse = this.getPort().getCallingAddress(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (addressResponse != null && addressResponse.getAddress() != null) {
            AddressTO addressTO = new AddressTO();
            addressTO.setAddressName(addressResponse.getAddress().getAddressName());
            addressTO.setAddressType(addressResponse.getAddress().getAddressType().toString());
            addressTO.setAddressStatus(addressResponse.getAddress().getStatus());
            callResult.setObject(addressTO);
        }
        return callResult;
    }

    @Override
    public CallResult getCallingTerminal(String string, String string2) throws DAOException {
        TerminalResponse terminalResponse;
        String string3 = "getCallingTerminal():";
        CallResult callResult = new CallResult();
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            terminalResponse = this.getPort().getCallingTerminal(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (terminalResponse != null && terminalResponse.getTerminal() != null) {
            TerminalTO terminalTO = new TerminalTO();
            terminalTO.setTerminalName(terminalResponse.getTerminal().getTerminalName());
            terminalTO.setTerminalType(terminalResponse.getTerminal().getTerminalType().toString());
            terminalTO.setTerminalStatus(terminalResponse.getTerminal().getStatus());
            callResult.setObject(terminalTO);
        }
        return callResult;
    }

    @Override
    public CallResult getLastRedirectedAddress(String string, String string2) throws DAOException {
        AddressResponse addressResponse;
        String string3 = "getLastRedirectedAddress():";
        CallResult callResult = new CallResult();
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            addressResponse = this.getPort().getLastRedirectedAddress(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (addressResponse != null && addressResponse.getAddress() != null) {
            AddressTO addressTO = new AddressTO();
            addressTO.setAddressName(addressResponse.getAddress().getAddressName());
            addressTO.setAddressType(addressResponse.getAddress().getAddressType().toString());
            addressTO.setAddressStatus(addressResponse.getAddress().getStatus());
            callResult.setObject(addressTO);
        }
        return callResult;
    }

    @Override
    public CallResult getOriginalDestinationAddress(String string, String string2) throws DAOException {
        AddressResponse addressResponse;
        String string3 = "getOriginalDestinationAddress():";
        ContactRequest contactRequest = new ContactRequest();
        CallResult callResult = new CallResult();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            addressResponse = this.getPort().getOriginalDestinationAddress(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        AddressTO addressTO = new AddressTO();
        if (addressResponse != null && addressResponse.getAddress() != null) {
            addressTO.setAddressName(addressResponse.getAddress().getAddressName());
            addressTO.setAddressType(addressResponse.getAddress().getAddressType().toString());
            addressTO.setAddressStatus(addressResponse.getAddress().getStatus());
            callResult.setObject(addressTO);
        }
        return callResult;
    }

    @Override
    public CallResult getContactTypes(String string, String string2) throws DAOException {
        GetContactTypesResponse getContactTypesResponse;
        String string3 = "getContactTypes():";
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            getContactTypesResponse = this.getPort().getContactTypes(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (getContactTypesResponse != null) {
            callResult.setObject(getContactTypesResponse.getContactTypes());
        }
        return callResult;
    }

    @Override
    public CallResult setAttachedData(String string, AttachedDataTO attachedDataTO, String string2) throws DAOException {
        Object object;
        String string3 = "setAttachedData():";
        ContactAttachedDataRequest contactAttachedDataRequest = new ContactAttachedDataRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        AttachedData attachedData = null;
        contact.setContactId(string);
        ssoToken.setToken(string2);
        if (attachedDataTO != null) {
            attachedData = new AttachedData();
            if (attachedDataTO.getType().equals((Object)AttachedDataTO.AttachedDataType.STRING)) {
                attachedData.setType(AttachmentType.STRING);
                attachedData.setStringData(attachedDataTO.getStringData());
            } else if (attachedDataTO.getType().equals((Object)AttachedDataTO.AttachedDataType.BINARY)) {
                attachedData.setType(AttachmentType.BINARY);
                object = new ByteArray();
                for (byte by : attachedDataTO.getBinaryData()) {
                    ((ByteArray)object).getItem().add(new Byte(by));
                }
                attachedData.setBinaryData((ByteArray)object);
            } else {
                attachedData.setType(AttachmentType.KEY_VALUE_PAIRS);
                object = new KeyValuePairArray();
                for (KeyValuePairTO keyValuePairTO : attachedDataTO.getKeyValueData()) {
                    KeyValuePair keyValuePair = new KeyValuePair();
                    keyValuePair.setKey(keyValuePairTO.getKey());
                    keyValuePair.setValue(keyValuePairTO.getValue());
                    ((KeyValuePairArray)object).getItem().add(keyValuePair);
                }
                attachedData.setKeyValueData((KeyValuePairArray)object);
            }
        }
        contactAttachedDataRequest.setContact(contact);
        contactAttachedDataRequest.setAttachedData(attachedData);
        contactAttachedDataRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setAttachedData(contactAttachedDataRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        object = new CallResult();
        return object;
    }

    @Override
    public CallResult getAttachedData(String string, String string2) throws DAOException {
        KeyValuePairTO[] keyValuePairTOArray;
        String string3 = "getAttachedData():";
        ContactRequest contactRequest = new ContactRequest();
        AttachedDataTO attachedDataTO = new AttachedDataTO();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        GetAttachedDataResponse getAttachedDataResponse = null;
        try {
            getAttachedDataResponse = this.getPort().getAttachedData(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (getAttachedDataResponse != null && getAttachedDataResponse.getAttachedData() != null && getAttachedDataResponse.getAttachedData().getType() != null) {
            AttachedData attachedData = getAttachedDataResponse.getAttachedData();
            if (attachedData.getType().value().equals("STRING")) {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.STRING);
                attachedDataTO.setStringData(attachedData.getStringData());
            } else if (attachedData.getType().value().equals("BINARY")) {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.BINARY);
                keyValuePairTOArray = (KeyValuePairTO[])new byte[attachedData.getBinaryData().getItem().size()];
                int n = 0;
                for (Byte by : attachedData.getBinaryData().getItem()) {
                    keyValuePairTOArray[n++] = (KeyValuePairTO)((Object)by);
                }
                attachedDataTO.setBinaryData((byte[])keyValuePairTOArray);
            } else {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.KVP);
                keyValuePairTOArray = new KeyValuePairTO[attachedData.getKeyValueData().getItem().size()];
                int n = 0;
                for (KeyValuePair keyValuePair : attachedData.getKeyValueData().getItem()) {
                    KeyValuePairTO keyValuePairTO = new KeyValuePairTO();
                    keyValuePairTO.setKey(keyValuePair.getKey());
                    keyValuePairTO.setValue(keyValuePair.getValue());
                    keyValuePairTOArray[n] = keyValuePairTO;
                    ++n;
                }
                attachedDataTO.setKeyValueData(keyValuePairTOArray);
            }
        }
        keyValuePairTOArray = new CallResult();
        keyValuePairTOArray.setObject(attachedDataTO);
        return keyValuePairTOArray;
    }

    @Override
    public CallResult getCapabilities(String string, String string2) throws DAOException {
        String string3 = "getCapabilities():";
        ContactRequest contactRequest = new ContactRequest();
        CallResult callResult = null;
        ContactCapabilities contactCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            contactCapabilities = this.getPort().getCapabilities(contactRequest).getContactCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (contactCapabilities != null) {
            ContactCapabilitiesTO contactCapabilitiesTO = new ContactCapabilitiesTO();
            contactCapabilitiesTO.setCanAddParty(contactCapabilities.isCanAddParty());
            contactCapabilitiesTO.setCanBargeIn(contactCapabilities.isCanBargeIn());
            contactCapabilitiesTO.setCanDrop(contactCapabilities.isCanDrop());
            contactCapabilitiesTO.setCanGetAttachedData(contactCapabilities.isCanGetAttachedData());
            contactCapabilitiesTO.setCanGetCallingTerminal(contactCapabilities.isCanGetCallingTerminal());
            contactCapabilitiesTO.setCanGetIntrinsics(contactCapabilities.isCanGetIntrinsics());
            contactCapabilitiesTO.setCanGetLastRedirectedAddress(contactCapabilities.isCanGetLastRedirectedAddress());
            contactCapabilitiesTO.setCanGetOriginalDestination(contactCapabilities.isCanGetOriginalDestination());
            contactCapabilitiesTO.setCanGetUUI(contactCapabilities.isCanGetUUI());
            contactCapabilitiesTO.setCanObserve(contactCapabilities.isCanObserve());
            contactCapabilitiesTO.setCanSetAttachedData(contactCapabilities.isCanSetAttachedData());
            contactCapabilitiesTO.setCanSetIntrinsics(contactCapabilities.isCanSetIntrinsics());
            contactCapabilitiesTO.setCanSetUUI(contactCapabilities.isCanSetUUI());
            contactCapabilitiesTO.setCanWhisper(contactCapabilities.isCanWhisper());
            callResult = new CallResult();
            callResult.setObject(contactCapabilitiesTO);
        }
        return callResult;
    }

    @Override
    public CallResult getConnections(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getConnections():";
        ContactRequest contactRequest = new ContactRequest();
        GetConnectionsResponse getConnectionsResponse = null;
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            getConnectionsResponse = this.getPort().getConnections(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ArrayList<ConnectionTO> arrayList = new ArrayList<ConnectionTO>();
        if (getConnectionsResponse != null) {
            object = getConnectionsResponse.getConnection();
            for (int i = 0; i < object.size(); ++i) {
                ConnectionTO connectionTO = new ConnectionTO();
                connectionTO.setConnectionId(((Connection)object.get(i)).getConnectionId());
                arrayList.add(connectionTO);
            }
        }
        object = new CallResult();
        ((CallResult)object).setObject(arrayList);
        return object;
    }

    @Override
    public CallResult setUUIData(String string, String string2, String string3) throws DAOException {
        String string4 = "setUUIData():";
        SetUUIRequest setUUIRequest = new SetUUIRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string3);
        setUUIRequest.setContact(contact);
        setUUIRequest.setUui(string2);
        setUUIRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setUUI(setUUIRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " sso[" + string3 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getUUIData(String string, String string2) throws DAOException {
        String string3;
        String string4 = "getUUIData():";
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            string3 = this.getPort().getUUI(contactRequest).getUui();
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setMessage(string3);
        return callResult;
    }

    @Override
    public CallResult setIntrinsicData(String string, List<IntrinsicTO> list, String string2) throws DAOException {
        String string3 = "setIntrinsicData():";
        SetIntrinsicsRequest setIntrinsicsRequest = new SetIntrinsicsRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        setIntrinsicsRequest.setContact(contact);
        setIntrinsicsRequest.setSsoToken(ssoToken);
        for (IntrinsicTO intrinsicTO : list) {
            if (intrinsicTO.getKey() == null || intrinsicTO.getKey().equals("") || intrinsicTO.isImmutable()) continue;
            Intrinsic intrinsic = new Intrinsic();
            intrinsic.setKey(intrinsicTO.getKey());
            intrinsic.setValue(intrinsicTO.getValue());
            intrinsic.setImmutable(intrinsicTO.isImmutable());
            setIntrinsicsRequest.getIntrinsics().add(intrinsic);
        }
        try {
            this.getPort().setIntrinsics(setIntrinsicsRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getIntrinsicData(String string, String string2) throws DAOException {
        String string3 = "getIntrinsicData():";
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        List<Intrinsic> list = null;
        try {
            list = this.getPort().getIntrinsics(contactRequest).getIntrinsic();
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ArrayList<IntrinsicTO> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<IntrinsicTO>(list.size());
            for (Intrinsic intrinsic : list) {
                IntrinsicTO intrinsicTO = new IntrinsicTO();
                intrinsicTO.setKey(intrinsic.getKey());
                intrinsicTO.setValue(intrinsic.getValue());
                intrinsicTO.setImmutable(intrinsic.isImmutable());
                arrayList.add(intrinsicTO);
            }
        }
        CallResult callResult = new CallResult();
        callResult.setObject(arrayList);
        return callResult;
    }

    @Override
    public CallResult giveMediaTreatment(AddressTO addressTO, ContactTO contactTO, String string) throws DAOException {
        String string2 = "giveMediaTreatment():";
        GiveTreatmentRequest giveTreatmentRequest = new GiveTreatmentRequest();
        Address address = new Address();
        Contact contact = new Contact();
        MediaTreatment mediaTreatment = new MediaTreatment();
        SsoToken ssoToken = new SsoToken();
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        address.setAddressName(addressTO.getAddressName());
        contact.setContactId(contactTO.getContactId());
        mediaTreatment.setInterruptible(true);
        mediaTreatment.setTreatmentAddress("treatmentAddress");
        mediaTreatment.setTreatmentParameter("String");
        mediaTreatment.setTreatmentTerminal("terminal");
        mediaTreatment.setType("");
        ssoToken.setToken(string);
        giveTreatmentRequest.setSsoToken(ssoToken);
        giveTreatmentRequest.setAddress(address);
        giveTreatmentRequest.setContact(contact);
        giveTreatmentRequest.setMediaTreatment(mediaTreatment);
        try {
            this.getPort().giveTreatment(giveTreatmentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    public ContactService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTContactService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(ContactService.class);
        object = (ContactService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

