/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.KeyValuePairTO;
import com.nortel.rc.dto.ProviderTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.faults.CreateContactException;
import com.nortel.soa.oi.cct.faults.GetContactException;
import com.nortel.soa.oi.cct.faults.LogInToCCTServerException;
import com.nortel.soa.oi.cct.sessionservice.SOAOICCT;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AttachedData;
import com.nortel.soa.oi.cct.types.AttachmentType;
import com.nortel.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.soa.oi.cct.types.ByteArray;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.GetVersionRequest;
import com.nortel.soa.oi.cct.types.GetVersionResponse;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.KeyValuePair;
import com.nortel.soa.oi.cct.types.KeyValuePairArray;
import com.nortel.soa.oi.cct.types.Provider;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.cct.types.sessionservice.AddressList;
import com.nortel.soa.oi.cct.types.sessionservice.AddressResponse;
import com.nortel.soa.oi.cct.types.sessionservice.ContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.sessionservice.CreateContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GenerateDTMFRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAddressesRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAgentsResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetContactDataResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetIntrinsicsResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalAddressesRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalsRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerResponse;
import com.nortel.soa.oi.cct.types.sessionservice.LogOffFromCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentToStateRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentToTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogoutAgentFromTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogoutAgentRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetActivityCodeRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetContactDataRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetIntrinsicsRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetToNotReadyStateWithReasonCodeRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SsoRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalList;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SessionServiceDAO
extends ServiceDAO
implements IContactDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.SessionServiceDAO");
    String endPoint = null;

    @Override
    public CallResult loginAgent(TerminalTO terminalTO, String string, String string2, String string3) throws DAOException {
        Object object;
        String string4 = "loginAgent():";
        LoginAgentRequest loginAgentRequest = new LoginAgentRequest();
        SsoToken ssoToken = new SsoToken();
        if (terminalTO != null) {
            object = new Terminal();
            ((Terminal)object).setTerminalName(terminalTO.getTerminalName());
            ((Terminal)object).setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
            loginAgentRequest.setTerminal((Terminal)object);
        }
        ssoToken.setToken(string3);
        loginAgentRequest.setSsoToken(ssoToken);
        loginAgentRequest.setAgentId(string);
        loginAgentRequest.setAgentPassword(string2);
        try {
            this.getPort().loginAgent(loginAgentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " sso[" + string3 + "] endpoint : " + this.endPoint));
        }
        object = new CallResult();
        return object;
    }

    @Override
    public CallResult loginAgentToTerminal(TerminalTO terminalTO, AgentTO agentTO, int n, String string) throws DAOException {
        String string2 = "loginAgentToTerminal():";
        LoginAgentToTerminalRequest loginAgentToTerminalRequest = new LoginAgentToTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setStatus("Enabled");
        Provider provider = new Provider();
        provider.setProviderName("Passive");
        ssoToken.setToken(string);
        loginAgentToTerminalRequest.setAgentTerminal(terminal);
        loginAgentToTerminalRequest.setSsoToken(ssoToken);
        loginAgentToTerminalRequest.setAgentId(agentTO.getAgentLoginId());
        loginAgentToTerminalRequest.setPassword("Password");
        loginAgentToTerminalRequest.setInitialState(n);
        try {
            this.getPort().loginAgentToTerminal(loginAgentToTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult logoutAgentFromTerminal(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "logoutAgentFromTerminal():";
        LogoutAgentFromTerminalRequest logoutAgentFromTerminalRequest = new LogoutAgentFromTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setStatus("Enabled");
        Provider provider = new Provider();
        provider.setProviderName("Passive");
        ssoToken.setToken(string);
        logoutAgentFromTerminalRequest.setAgentTerminal(terminal);
        logoutAgentFromTerminalRequest.setSsoToken(ssoToken);
        try {
            this.getPort().logoutAgentFromTerminal(logoutAgentFromTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult loginAgentToState(TerminalTO terminalTO, AgentTO agentTO, int n, String string) throws DAOException {
        String string2 = "loginAgentToState():";
        LoginAgentToStateRequest loginAgentToStateRequest = new LoginAgentToStateRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        if (terminalTO != null) {
            terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
            terminal.setTerminalName(terminalTO.getTerminalName());
            terminal.setStatus("Enabled");
            loginAgentToStateRequest.setTerminal(terminal);
        }
        ssoToken.setToken(string);
        loginAgentToStateRequest.setSsoToken(ssoToken);
        loginAgentToStateRequest.setAgentId(agentTO.getAgentLoginId());
        loginAgentToStateRequest.setAgentPassword("Password");
        loginAgentToStateRequest.setInitialState(n);
        try {
            this.getPort().loginAgentToState(loginAgentToStateRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult logoutAgent(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "logoutAgent():";
        LogoutAgentRequest logoutAgentRequest = new LogoutAgentRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        logoutAgentRequest.setTerminal(terminal);
        logoutAgentRequest.setSsoToken(ssoToken);
        try {
            this.getPort().logoutAgent(logoutAgentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult createContact(TerminalTO terminalTO, AddressTO addressTO, AddressTO addressTO2, String string) throws DAOException {
        String string2 = "createContact():";
        CreateContactRequest createContactRequest = new CreateContactRequest();
        ContactResponse contactResponse = null;
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        Address address2 = new Address();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        address.setAddressName(addressTO.getAddressName());
        address2.setAddressName(addressTO2.getAddressName());
        address2.setAddressType(AddressType.valueOf(addressTO2.getAddressType()));
        ssoToken.setToken(string);
        createContactRequest.setTerminal(terminal);
        createContactRequest.setSsoToken(ssoToken);
        createContactRequest.setSrcAddress(address);
        createContactRequest.setDstAddress(address2);
        try {
            contactResponse = this.getPort().createContact(createContactRequest);
            if (contactResponse == null) {
                throw new CreateContactException("NULL response received");
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setMessage(contactResponse.getContact().getContactId());
        return callResult;
    }

    @Override
    public CallResult getContact(String string, String string2) throws DAOException {
        String string3 = "getContact():";
        ContactRequest contactRequest = new ContactRequest();
        ContactResponse contactResponse = null;
        Contact contact = new Contact();
        SsoToken ssoToken = new SsoToken();
        contact.setExternalContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        try {
            contactResponse = this.getPort().getContact(contactRequest);
            if (contactResponse == null) {
                throw new GetContactException("NULL response received");
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setMessage(contactResponse.getContact().getContactId());
        return callResult;
    }

    @Override
    public CallResult answerContact(String string, TerminalTO terminalTO, String string2) throws DAOException {
        String string3 = "answerContact():";
        TerminalContactRequest terminalContactRequest = new TerminalContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactRequest.setTerminal(terminal);
        terminalContactRequest.setSsoToken(ssoToken);
        terminalContactRequest.setContact(contact);
        try {
            this.getPort().answerContact(terminalContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult transferContact(TerminalTO terminalTO, AddressTO addressTO, String string, String string2) throws DAOException {
        String string3 = "transferContact():";
        TerminalContactAddressRequest terminalContactAddressRequest = new TerminalContactAddressRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactAddressRequest.setTerminal(terminal);
        terminalContactAddressRequest.setSsoToken(ssoToken);
        terminalContactAddressRequest.setAddress(address);
        terminalContactAddressRequest.setContact(contact);
        try {
            this.getPort().transferContact(terminalContactAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult initiateSupervisedTransfer(TerminalTO terminalTO, AddressTO addressTO, String string, String string2) throws DAOException {
        String string3 = "initiateSupervisedTransfer():";
        TerminalContactAddressRequest terminalContactAddressRequest = new TerminalContactAddressRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactAddressRequest.setTerminal(terminal);
        terminalContactAddressRequest.setSsoToken(ssoToken);
        terminalContactAddressRequest.setAddress(address);
        terminalContactAddressRequest.setContact(contact);
        try {
            this.getPort().initiateSupervisedTransfer(terminalContactAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult completeSupervisedTransfer(TerminalTO terminalTO, String string, String string2, String string3) throws DAOException {
        String string4 = "completeSupervisedTransfer():";
        TerminalContactContactRequest terminalContactContactRequest = new TerminalContactContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        Contact contact2 = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string2);
        contact2.setContactId(string);
        ssoToken.setToken(string3);
        terminalContactContactRequest.setTerminal(terminal);
        terminalContactContactRequest.setSsoToken(ssoToken);
        terminalContactContactRequest.setConsultedContact(contact2);
        terminalContactContactRequest.setContact(contact);
        try {
            this.getPort().completeSupervisedTransfer(terminalContactContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " sso[" + string3 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult dropContact(String string, TerminalTO terminalTO, String string2) throws DAOException {
        String string3 = "dropContact():";
        TerminalContactRequest terminalContactRequest = new TerminalContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactRequest.setTerminal(terminal);
        terminalContactRequest.setSsoToken(ssoToken);
        terminalContactRequest.setContact(contact);
        try {
            this.getPort().dropContact(terminalContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult holdContact(String string, TerminalTO terminalTO, String string2) throws DAOException {
        String string3 = "holdContact():";
        TerminalContactRequest terminalContactRequest = new TerminalContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactRequest.setTerminal(terminal);
        terminalContactRequest.setSsoToken(ssoToken);
        terminalContactRequest.setContact(contact);
        try {
            this.getPort().holdContact(terminalContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult unHoldContact(String string, TerminalTO terminalTO, String string2) throws DAOException {
        String string3 = "unHoldContact():";
        TerminalContactRequest terminalContactRequest = new TerminalContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactRequest.setTerminal(terminal);
        terminalContactRequest.setSsoToken(ssoToken);
        terminalContactRequest.setContact(contact);
        try {
            this.getPort().unHoldContact(terminalContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult initiateConference(TerminalTO terminalTO, AddressTO addressTO, String string, String string2) throws DAOException {
        String string3 = "initiateConference():";
        TerminalContactAddressRequest terminalContactAddressRequest = new TerminalContactAddressRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Address address = new Address();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        address.setAddressName(addressTO.getAddressName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactAddressRequest.setTerminal(terminal);
        terminalContactAddressRequest.setSsoToken(ssoToken);
        terminalContactAddressRequest.setAddress(address);
        terminalContactAddressRequest.setContact(contact);
        try {
            this.getPort().initiateConference(terminalContactAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult completeConference(TerminalTO terminalTO, String string, String string2, String string3) throws DAOException {
        String string4 = "completeConference():";
        TerminalContactContactRequest terminalContactContactRequest = new TerminalContactContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        Contact contact2 = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string2);
        contact2.setContactId(string);
        ssoToken.setToken(string3);
        terminalContactContactRequest.setTerminal(terminal);
        terminalContactContactRequest.setSsoToken(ssoToken);
        terminalContactContactRequest.setConsultedContact(contact2);
        terminalContactContactRequest.setContact(contact);
        try {
            this.getPort().completeConference(terminalContactContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " sso[" + string3 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult cctLogin(String string, String string2, String string3) throws DAOException {
        String string4 = "cctLogin():";
        LogInToCCTServerRequest logInToCCTServerRequest = new LogInToCCTServerRequest();
        AuthenticationLevel authenticationLevel = new AuthenticationLevel();
        authenticationLevel.setUsername(string);
        authenticationLevel.setPassword(string2);
        authenticationLevel.setDomain(string3);
        logInToCCTServerRequest.setAuthenticationLevel(authenticationLevel);
        LogInToCCTServerResponse logInToCCTServerResponse = null;
        try {
            logInToCCTServerResponse = this.getPort().logInToCCTServer(logInToCCTServerRequest);
            if (logInToCCTServerResponse == null) {
                throw new LogInToCCTServerException("NULL response received");
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string4, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string4 + " " + this.getWsdlUrl().getHost() + "::" + this.getPort().toString()));
        }
        CallResult callResult = new CallResult();
        callResult.setMessage(logInToCCTServerResponse.getSsoToken().getToken());
        return callResult;
    }

    @Override
    public CallResult cctLogout(String string) throws DAOException {
        String string2 = "cctLogout():";
        LogOffFromCCTServerRequest logOffFromCCTServerRequest = new LogOffFromCCTServerRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        logOffFromCCTServerRequest.setSsoToken(ssoToken);
        try {
            this.getPort().logOffFromCCTServer(logOffFromCCTServerRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult emergencyKey(String string, TerminalTO terminalTO, String string2) throws DAOException {
        String string3 = "emergencyKey():";
        TerminalContactRequest terminalContactRequest = new TerminalContactRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(string);
        ssoToken.setToken(string2);
        terminalContactRequest.setTerminal(terminal);
        terminalContactRequest.setSsoToken(ssoToken);
        terminalContactRequest.setContact(contact);
        try {
            this.getPort().emergencyKey(terminalContactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult callSupervisor(TerminalTO terminalTO, AddressTO addressTO, String string) throws DAOException {
        String string2 = "callSupervisor():";
        TerminalAddressRequest terminalAddressRequest = new TerminalAddressRequest();
        Terminal terminal = new Terminal();
        Address address = new Address();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
        address.setAddressName(addressTO.getAddressName());
        ssoToken.setToken(string);
        terminalAddressRequest.setTerminal(terminal);
        terminalAddressRequest.setAddress(address);
        terminalAddressRequest.setSsoToken(ssoToken);
        try {
            this.getPort().callSupervisor(terminalAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setToReadyState(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setToReadyState():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setToReadyState(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setToNotReadyState(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setToNotReadyState():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setToNotReadyState(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setToNotReadyStateWithReasonCode(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setToNotReadyStateWithReasonCode():";
        SetToNotReadyStateWithReasonCodeRequest setToNotReadyStateWithReasonCodeRequest = new SetToNotReadyStateWithReasonCodeRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        setToNotReadyStateWithReasonCodeRequest.setTerminal(terminal);
        setToNotReadyStateWithReasonCodeRequest.setSsoToken(ssoToken);
        setToNotReadyStateWithReasonCodeRequest.setReasonCode(terminalTO.getTerminalNotReadyReason());
        try {
            this.getPort().setToNotReadyStateWithReasonCode(setToNotReadyStateWithReasonCodeRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult makeSetBusy(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "makeSetBusy():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            this.getPort().makeSetBusy(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public List<TerminalTO> getUserTerminals(String string) throws DAOException {
        TerminalList terminalList;
        String string2 = "getUserTerminals():";
        ArrayList<TerminalTO> arrayList = new ArrayList<TerminalTO>();
        GetTerminalsRequest getTerminalsRequest = new GetTerminalsRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        getTerminalsRequest.setSsoToken(ssoToken);
        try {
            terminalList = this.getPort().getTerminals(getTerminalsRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (terminalList != null) {
            for (Terminal terminal : terminalList.getTerminals()) {
                TerminalTO terminalTO = new TerminalTO();
                terminalTO.setTerminalName(terminal.getTerminalName());
                terminalTO.setTerminalType(terminal.getTerminalType().value());
                terminalTO.setTerminalStatus(terminal.getStatus());
                ProviderTO providerTO = new ProviderTO();
                providerTO.setProviderName(terminal.getProvider() != null ? terminal.getProvider().getProviderName() : "");
                terminalTO.setProvider(providerTO);
                arrayList.add(terminalTO);
            }
        }
        return arrayList;
    }

    @Override
    public List<AddressTO> getTerminalAddresses(TerminalTO terminalTO, String string) throws DAOException {
        AddressList addressList;
        String string2 = "getTerminalAddresses():";
        ArrayList<AddressTO> arrayList = new ArrayList<AddressTO>();
        GetTerminalAddressesRequest getTerminalAddressesRequest = new GetTerminalAddressesRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Provider provider = new Provider();
        provider.setProviderName("Passive");
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        getTerminalAddressesRequest.setSsoToken(ssoToken);
        getTerminalAddressesRequest.setTerminal(terminal);
        try {
            addressList = this.getPort().getTerminalAddresses(getTerminalAddressesRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (addressList != null) {
            for (Address address : addressList.getAddresses()) {
                AddressTO addressTO = new AddressTO();
                addressTO.setAddressName(address.getAddressName());
                addressTO.setAddressType(address.getAddressType().value());
                addressTO.setAddressStatus(address.getStatus());
                arrayList.add(addressTO);
            }
        }
        return arrayList;
    }

    @Override
    public List<AddressTO> getUserAddresses(String string) throws DAOException {
        AddressList addressList;
        String string2 = "getUserAddresses():";
        ArrayList<AddressTO> arrayList = new ArrayList<AddressTO>();
        GetAddressesRequest getAddressesRequest = new GetAddressesRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        getAddressesRequest.setSsoToken(ssoToken);
        try {
            addressList = this.getPort().getAddresses(getAddressesRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (addressList != null) {
            for (Address address : addressList.getAddresses()) {
                AddressTO addressTO = new AddressTO();
                addressTO.setAddressName(address.getAddressName());
                addressTO.setAddressType(address.getAddressType().value());
                addressTO.setAddressStatus(address.getStatus());
                arrayList.add(addressTO);
            }
        }
        return arrayList;
    }

    public AddressTO getAddress(String string, String string2) throws DAOException {
        String string3 = "getAddress():";
        AddressTO addressTO = null;
        Address address = null;
        GetAddressRequest getAddressRequest = new GetAddressRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        getAddressRequest.setAddressName(string2);
        getAddressRequest.setSsoToken(ssoToken);
        AddressResponse addressResponse = null;
        try {
            addressResponse = this.getPort().getAddress(getAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (addressResponse != null && addressResponse.getAddressResponse() != null) {
            address = addressResponse.getAddressResponse();
            addressTO = new AddressTO();
            addressTO.setAddressName(address.getAddressName());
            addressTO.setAddressStatus(address.getStatus());
            addressTO.setAddressType(address.getAddressType().value());
        }
        return addressTO;
    }

    public TerminalTO getTerminal(String string, String string2) throws DAOException {
        String string3 = "getTerminal():";
        TerminalTO terminalTO = null;
        Terminal terminal = null;
        GetTerminalRequest getTerminalRequest = new GetTerminalRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        getTerminalRequest.setTerminalName(string2);
        getTerminalRequest.setSsoToken(ssoToken);
        TerminalResponse terminalResponse = null;
        try {
            terminalResponse = this.getPort().getTerminal(getTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (terminalResponse != null && terminalResponse.getTerminalResponse() != null) {
            terminal = terminalResponse.getTerminalResponse();
            terminalTO = new TerminalTO();
            terminalTO.setTerminalName(terminal.getTerminalName());
            terminalTO.setTerminalStatus(terminal.getStatus());
            terminalTO.setTerminalType(terminal.getTerminalType().value());
        }
        return terminalTO;
    }

    @Override
    public List<AgentTO> getAgents(String string) throws DAOException {
        GetAgentsResponse getAgentsResponse;
        String string2 = "getAgents():";
        ArrayList<AgentTO> arrayList = new ArrayList<AgentTO>();
        SsoRequest ssoRequest = new SsoRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        ssoRequest.setSsoToken(ssoToken);
        try {
            getAgentsResponse = this.getPort().getAgents(ssoRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (getAgentsResponse != null) {
            for (Agent agent : getAgentsResponse.getAgents()) {
                AgentTO agentTO = new AgentTO();
                agentTO.setAgentLoginId(agent.getAgentLoginId());
                agentTO.setAgentUsername(agent.getUserName());
                arrayList.add(agentTO);
            }
        }
        return arrayList;
    }

    @Override
    public CallResult setActivityCode(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setActivityCode():";
        SetActivityCodeRequest setActivityCodeRequest = new SetActivityCodeRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        setActivityCodeRequest.setTerminal(terminal);
        setActivityCodeRequest.setSsoToken(ssoToken);
        setActivityCodeRequest.setActivityCode(terminalTO.getTerminalActivityCode());
        try {
            this.getPort().setActivityCode(setActivityCodeRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult generateDTMF(TerminalTO terminalTO, ContactTO contactTO, String string, String string2) throws DAOException {
        String string3 = "generateDTMF():";
        GenerateDTMFRequest generateDTMFRequest = new GenerateDTMFRequest();
        Terminal terminal = new Terminal();
        Contact contact = new Contact();
        SsoToken ssoToken = new SsoToken();
        if (terminalTO == null) {
            throw new DAOException(new IllegalArgumentException("term parameter is NULL"));
        }
        if (contactTO == null) {
            throw new DAOException(new IllegalArgumentException("cont parameter is NULL"));
        }
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        contact.setContactId(contactTO.getContactId());
        ssoToken.setToken(string2);
        generateDTMFRequest.setSsoToken(ssoToken);
        generateDTMFRequest.setTerminal(terminal);
        generateDTMFRequest.setContact(contact);
        generateDTMFRequest.setDigits(string != null ? string : "");
        try {
            this.getPort().generateDTMF(generateDTMFRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setContactData(String string, AttachedDataTO attachedDataTO, String string2) throws DAOException {
        Object object;
        String string3 = "setContactData():";
        SetContactDataRequest setContactDataRequest = new SetContactDataRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        AttachedData attachedData = null;
        contact.setContactId(string);
        ssoToken.setToken(string2);
        if (attachedDataTO != null) {
            attachedData = new AttachedData();
            if (attachedDataTO.getType().equals((Object)AttachedDataTO.AttachedDataType.STRING)) {
                attachedData.setType(AttachmentType.STRING);
                attachedData.setStringData(attachedDataTO.getStringData());
            } else if (attachedDataTO.getType().equals((Object)AttachedDataTO.AttachedDataType.BINARY)) {
                attachedData.setType(AttachmentType.BINARY);
                object = new ByteArray();
                for (byte by : attachedDataTO.getBinaryData()) {
                    ((ByteArray)object).getItem().add(by);
                }
                attachedData.setBinaryData((ByteArray)object);
            } else {
                attachedData.setType(AttachmentType.KEY_VALUE_PAIRS);
                object = new KeyValuePairArray();
                for (KeyValuePairTO keyValuePairTO : attachedDataTO.getKeyValueData()) {
                    KeyValuePair keyValuePair = new KeyValuePair();
                    keyValuePair.setKey(keyValuePairTO.getKey());
                    keyValuePair.setValue(keyValuePairTO.getValue());
                    ((KeyValuePairArray)object).getItem().add(keyValuePair);
                }
                attachedData.setKeyValueData((KeyValuePairArray)object);
            }
        }
        setContactDataRequest.setContact(contact);
        setContactDataRequest.setContactData(attachedData);
        setContactDataRequest.setSsoToken(ssoToken);
        try {
            this.getPort().setContactData(setContactDataRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        object = new CallResult();
        return object;
    }

    @Override
    public CallResult getContactData(String string, String string2) throws DAOException {
        KeyValuePairTO[] keyValuePairTOArray;
        String string3 = "getContactData():";
        ContactRequest contactRequest = new ContactRequest();
        AttachedDataTO attachedDataTO = new AttachedDataTO();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        GetContactDataResponse getContactDataResponse = null;
        try {
            getContactDataResponse = this.getPort().getContactData(contactRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        if (getContactDataResponse != null && getContactDataResponse.getContactData() != null && getContactDataResponse.getContactData().getType() != null) {
            AttachedData attachedData = getContactDataResponse.getContactData();
            if (attachedData.getType().value().equals("STRING")) {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.STRING);
                attachedDataTO.setStringData(attachedData.getStringData());
            } else if (attachedData.getType().value().equals("BINARY")) {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.BINARY);
                keyValuePairTOArray = (KeyValuePairTO[])new byte[attachedData.getBinaryData().getItem().size()];
                int n = 0;
                for (Byte by : attachedData.getBinaryData().getItem()) {
                    keyValuePairTOArray[n++] = (KeyValuePairTO)((Object)by);
                }
                attachedDataTO.setBinaryData((byte[])keyValuePairTOArray);
            } else {
                attachedDataTO.setType(AttachedDataTO.AttachedDataType.KVP);
                keyValuePairTOArray = new KeyValuePairTO[attachedData.getKeyValueData().getItem().size()];
                int n = 0;
                for (KeyValuePair keyValuePair : attachedData.getKeyValueData().getItem()) {
                    KeyValuePairTO keyValuePairTO = new KeyValuePairTO();
                    keyValuePairTO.setKey(keyValuePair.getKey());
                    keyValuePairTO.setValue(keyValuePair.getValue());
                    keyValuePairTOArray[n] = keyValuePairTO;
                    ++n;
                }
                attachedDataTO.setKeyValueData(keyValuePairTOArray);
            }
        }
        keyValuePairTOArray = new CallResult();
        keyValuePairTOArray.setObject(attachedDataTO);
        return keyValuePairTOArray;
    }

    public int getCurrentAddressCount(String string) throws DAOException {
        String string2 = "getCurrentAddressCount():";
        int n = 0;
        SsoRequest ssoRequest = new SsoRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        ssoRequest.setSsoToken(ssoToken);
        try {
            n = this.getPort().getCurrentAddressCount(ssoRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return n;
    }

    public int getCurrentTerminalCount(String string) throws DAOException {
        String string2 = "getCurrentTerminalCount():";
        int n = 0;
        SsoRequest ssoRequest = new SsoRequest();
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        ssoRequest.setSsoToken(ssoToken);
        try {
            n = this.getPort().getCurrentTerminalCount(ssoRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return n;
    }

    public String getVersion(String string) throws DAOException {
        String string2 = "getVersion():";
        String string3 = "";
        GetVersionRequest getVersionRequest = new GetVersionRequest();
        GetVersionResponse getVersionResponse = null;
        try {
            getVersionResponse = this.getPort().getVersion(getVersionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        if (getVersionResponse != null) {
            string3 = getVersionResponse.getVersion();
        }
        return string3;
    }

    @Override
    public CallResult setIntrinsicData(String string, List<IntrinsicTO> list, String string2) throws DAOException {
        String string3 = "setIntrinsicData():";
        SetIntrinsicsRequest setIntrinsicsRequest = new SetIntrinsicsRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        setIntrinsicsRequest.setContact(contact);
        setIntrinsicsRequest.setSsoToken(ssoToken);
        for (IntrinsicTO intrinsicTO : list) {
            if (intrinsicTO.getKey() == null || intrinsicTO.getKey().equals("") || intrinsicTO.isImmutable()) continue;
            Intrinsic intrinsic = new Intrinsic();
            intrinsic.setKey(intrinsicTO.getKey());
            intrinsic.setValue(intrinsicTO.getValue());
            intrinsic.setImmutable(intrinsicTO.isImmutable());
            setIntrinsicsRequest.getIntrinsics().add(intrinsic);
        }
        try {
            this.getPort().setIntrinsics(setIntrinsicsRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getIntrinsicData(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getIntrinsicData():";
        ContactRequest contactRequest = new ContactRequest();
        SsoToken ssoToken = new SsoToken();
        Contact contact = new Contact();
        contact.setContactId(string);
        ssoToken.setToken(string2);
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        List<Intrinsic> list = null;
        try {
            object = this.getPort().getIntrinsics(contactRequest);
            if (object != null) {
                list = ((GetIntrinsicsResponse)object).getIntrinsic();
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        object = null;
        if (list != null) {
            object = new ArrayList(list.size());
            for (Intrinsic intrinsic : list) {
                IntrinsicTO intrinsicTO = new IntrinsicTO();
                intrinsicTO.setKey(intrinsic.getKey());
                intrinsicTO.setValue(intrinsic.getValue());
                intrinsicTO.setImmutable(intrinsic.isImmutable());
                object.add(intrinsicTO);
            }
        }
        CallResult callResult = new CallResult();
        callResult.setObject(object);
        return callResult;
    }

    public SessionService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCT(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(SessionService.class);
        object = (SessionService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

