/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.event;

import com.nortel.rc.dto.AddressCapabilitiesTO;
import com.nortel.rc.dto.AddressPropertyEventTO;
import com.nortel.rc.dto.AddressStateEventTO;
import com.nortel.rc.dto.AgentCapabilitiesTO;
import com.nortel.rc.dto.AgentPropertyEventTO;
import com.nortel.rc.dto.AgentStateEventTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.ConnectionCapabilitiesTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactCapabilitiesTO;
import com.nortel.rc.dto.ContactPropertyEventTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.KeyValuePairTO;
import com.nortel.rc.dto.StateEventTO;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalPropertyEventTO;
import com.nortel.rc.dto.TerminalStateEventTO;
import com.nortel.rc.event.NotificationHandler;
import com.nortel.rc.gui.SOARefClient;
import com.nortel.soa.oi.cct.basenotification.AddressPropertyEventType;
import com.nortel.soa.oi.cct.basenotification.AddressStateEventType;
import com.nortel.soa.oi.cct.basenotification.AgentPropertyEventType;
import com.nortel.soa.oi.cct.basenotification.AgentStateEventType;
import com.nortel.soa.oi.cct.basenotification.ConnectionStateEventType;
import com.nortel.soa.oi.cct.basenotification.ContactPropertyEventType;
import com.nortel.soa.oi.cct.basenotification.NotificationEventHolderType;
import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.basenotification.TerminalConnectionStateEventType;
import com.nortel.soa.oi.cct.basenotification.TerminalPropertyEventType;
import com.nortel.soa.oi.cct.basenotification.TerminalStateEventType;
import com.nortel.soa.oi.cct.notification.SystemEventType;
import com.nortel.soa.oi.cct.types.AddressCapabilities;
import com.nortel.soa.oi.cct.types.AddressPropertyAcquireStatus;
import com.nortel.soa.oi.cct.types.AddressPropertyDoNotDisturb;
import com.nortel.soa.oi.cct.types.AddressPropertyForwarding;
import com.nortel.soa.oi.cct.types.AddressPropertyForwardingArray;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.AgentCapabilities;
import com.nortel.soa.oi.cct.types.AgentLoginStatus;
import com.nortel.soa.oi.cct.types.AttachedData;
import com.nortel.soa.oi.cct.types.ConnectionCapabilities;
import com.nortel.soa.oi.cct.types.ContactCapabilities;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.KeyValuePair;
import com.nortel.soa.oi.cct.types.TerminalCapabilities;
import com.nortel.soa.oi.cct.types.TerminalConnectionCapabilities;
import com.nortel.soa.oi.cct.types.TerminalPropertyDoNotDisturb;
import com.nortel.soa.oi.cct.types.TerminalPropertyForwarding;
import com.nortel.soa.oi.cct.types.TerminalPropertyForwardingArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.springframework.core.task.TaskExecutor;

public final class NotificationManager {
    public static String EVENT_LOG_FILE = "";
    private final Logger logger = Logger.getLogger((String)NotificationManager.class.getName());
    private final BlockingQueue<List<NotificationMessageHolderType>> incomingMessageQueue = new LinkedBlockingQueue<List<NotificationMessageHolderType>>();
    private SOARefClient refClient;
    private final TaskExecutor taskExecutor;

    public NotificationManager(TaskExecutor taskExecutor) {
        this.initLogger();
        this.taskExecutor = taskExecutor;
        this.taskExecutor.execute((Runnable)new NotiticationMessageConsumer(this.incomingMessageQueue));
    }

    public void handleNotify(List<NotificationMessageHolderType> list) {
        this.incomingMessageQueue.add(list);
    }

    public SOARefClient getRefClient() {
        return this.refClient;
    }

    public void setRefClient(SOARefClient sOARefClient) {
        this.refClient = sOARefClient;
    }

    private void initLogger() {
        try {
            PatternLayout patternLayout = new PatternLayout("%d - %m%n");
            EVENT_LOG_FILE = "./logs/" + System.currentTimeMillis() + "_Event.log";
            RollingFileAppender rollingFileAppender = new RollingFileAppender((Layout)patternLayout, EVENT_LOG_FILE, true);
            rollingFileAppender.setMaxBackupIndex(3);
            rollingFileAppender.setMaximumFileSize(100000L);
            this.logger.addAppender((Appender)rollingFileAppender);
            this.logger.setAdditivity(false);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Exception while setting up new event log file!", (Throwable)exception);
        }
    }

    private class NotiticationMessageConsumer
    implements Runnable {
        private final BlockingQueue<List<NotificationMessageHolderType>> messageQueue;

        NotiticationMessageConsumer(BlockingQueue<List<NotificationMessageHolderType>> blockingQueue) {
            this.messageQueue = blockingQueue;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    List<NotificationMessageHolderType> list = this.messageQueue.take();
                    this.processMessage(list);
                }
                catch (InterruptedException interruptedException) {
                    NotificationManager.this.logger.error((Object)"Message processing thread has been interrupted!", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    NotificationManager.this.logger.error((Object)"Exception while processing message", (Throwable)exception);
                }
            }
        }

        private void processMessage(List<NotificationMessageHolderType> list) throws Exception {
            for (NotificationMessageHolderType notificationMessageHolderType : list) {
                NotificationEventHolderType notificationEventHolderType = notificationMessageHolderType.getMessage();
                if (!notificationMessageHolderType.getSubscriptionId().equals(NotificationHandler.SUBSCRIPTION_ID)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("subscriptionId", notificationMessageHolderType.getSubscriptionId());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Unsubscribing incorrect subscription: " + notificationMessageHolderType.getSubscriptionId()));
                    NotificationManager.this.getRefClient().getRequestHandler().handle("Unsubscribe", hashMap);
                    break;
                }
                if (notificationEventHolderType.getAddressPropertyEvent() != null) {
                    this.processAddressPropertyEvent(notificationEventHolderType.getAddressPropertyEvent());
                    continue;
                }
                if (notificationEventHolderType.getTerminalPropertyEvent() != null) {
                    this.processTerminalPropertyEvent(notificationEventHolderType.getTerminalPropertyEvent());
                    continue;
                }
                if (notificationEventHolderType.getAgentPropertyEvent() != null) {
                    this.processAgentPropertyEvent(notificationEventHolderType.getAgentPropertyEvent());
                    continue;
                }
                if (notificationEventHolderType.getContactPropertyEvent() != null) {
                    this.processContactPropertyEvent(notificationEventHolderType.getContactPropertyEvent());
                    continue;
                }
                if (notificationEventHolderType.getConnectionStateEvent() != null) {
                    this.processConnectionStateEvent(notificationEventHolderType.getConnectionStateEvent());
                    continue;
                }
                if (notificationEventHolderType.getTerminalConnectionStateEvent() != null) {
                    this.processTerminalConnectionStateEvent(notificationEventHolderType.getTerminalConnectionStateEvent());
                    continue;
                }
                if (notificationEventHolderType.getAddressStateEvent() != null) {
                    this.processAddressStateEvent(notificationEventHolderType.getAddressStateEvent());
                    continue;
                }
                if (notificationEventHolderType.getTerminalStateEvent() != null) {
                    this.processTerminalStateEvent(notificationEventHolderType.getTerminalStateEvent());
                    continue;
                }
                if (notificationEventHolderType.getAgentStateEvent() != null) {
                    this.processAgentStateEvent(notificationEventHolderType.getAgentStateEvent());
                    continue;
                }
                if (notificationEventHolderType.getSystemEvent() != null) {
                    this.processSystemEvent(notificationEventHolderType.getSystemEvent());
                    continue;
                }
                NotificationManager.this.logger.log((Priority)Level.WARN, (Object)"Unknown event received! Ignoring...");
            }
        }

        private void processAddressPropertyEvent(AddressPropertyEventType addressPropertyEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property Event: AddressName [" + addressPropertyEventType.getAddress().getAddressName() + "]\n AddressProperty [" + (Object)((Object)addressPropertyEventType.getAddressProperty()) + "]"));
            AddressPropertyEventTO addressPropertyEventTO = new AddressPropertyEventTO();
            addressPropertyEventTO.setRoutePoint(AddressType.ROUTE_POINT.equals((Object)addressPropertyEventType.getAddress().getAddressType()));
            addressPropertyEventTO.setAddressName(addressPropertyEventType.getAddress().getAddressName());
            AddressCapabilities addressCapabilities = addressPropertyEventType.getAddressCapabilities();
            AddressCapabilitiesTO addressCapabilitiesTO = new AddressCapabilitiesTO();
            addressCapabilitiesTO.setCanConference(addressCapabilities.isCanConference());
            addressCapabilitiesTO.setCanConference(addressCapabilities.isCanConsult());
            addressCapabilitiesTO.setCanDoNotDisturb(addressCapabilities.isCanDoNotDisturb());
            addressCapabilitiesTO.setCanForward(addressCapabilities.isCanForward());
            addressCapabilitiesTO.setCanGetMessageWaiting(addressCapabilities.isCanGetMessageWaiting());
            addressCapabilitiesTO.setCanOriginate(addressCapabilities.isCanOriginate());
            addressCapabilitiesTO.setCanSetMessageWaiting(addressCapabilities.isCanSetMessageWaiting());
            addressCapabilitiesTO.setCanTransfer(addressCapabilities.isCanTransfer());
            addressPropertyEventTO.setCapabilities(addressCapabilitiesTO);
            switch (addressPropertyEventType.getAddressProperty()) {
                case DO_NOT_DISTURB: {
                    addressPropertyEventTO.setPropertyType(AddressPropertyEventTO.AddressProperty.DO_NOT_DISTURB);
                    AddressPropertyDoNotDisturb addressPropertyDoNotDisturb = addressPropertyEventType.getAddressPropertyDoNotDisturb();
                    addressPropertyEventTO.setActive(addressPropertyDoNotDisturb.isDoNotDisturbSet());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + AddressPropertyEventTO.AddressProperty.DO_NOT_DISTURB.toString() + " " + addressPropertyEventType.getAddress().getAddressName() + " " + addressPropertyEventType.getAddressProperty().value() + ": " + addressPropertyDoNotDisturb.isDoNotDisturbSet()));
                    break;
                }
                case ACQUIRE_STATUS: {
                    addressPropertyEventTO.setPropertyType(AddressPropertyEventTO.AddressProperty.ACQUIRE_STATUS);
                    AddressPropertyAcquireStatus addressPropertyAcquireStatus = addressPropertyEventType.getAddressPropertyAcquireStatus();
                    addressPropertyEventTO.setActive(addressPropertyAcquireStatus.isAcquired());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + AddressPropertyEventTO.AddressProperty.ACQUIRE_STATUS.toString() + " " + addressPropertyEventType.getAddress().getAddressName() + " " + addressPropertyEventType.getAddressProperty().value() + ": " + addressPropertyAcquireStatus.isAcquired()));
                    break;
                }
                case CONTROLLED: {
                    addressPropertyEventTO.setPropertyType(AddressPropertyEventTO.AddressProperty.CONTROLLED);
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + AddressPropertyEventTO.AddressProperty.CONTROLLED.toString() + " " + addressPropertyEventType.getAddress().getAddressName() + " " + addressPropertyEventType.getAddressProperty().value()));
                    break;
                }
                case FORWARDING: {
                    List<AddressPropertyForwarding> list;
                    addressPropertyEventTO.setPropertyType(AddressPropertyEventTO.AddressProperty.FORWARDING);
                    AddressPropertyForwardingArray addressPropertyForwardingArray = addressPropertyEventType.getAddressPropertyForwardingArray();
                    if (addressPropertyForwardingArray != null && (list = addressPropertyForwardingArray.getItem()).size() > 0) {
                        addressPropertyEventTO.setActive(true);
                    }
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + AddressPropertyEventTO.AddressProperty.FORWARDING.toString() + " " + addressPropertyEventType.getAddress().getAddressName() + " " + addressPropertyEventType.getAddressProperty().value() + ": " + addressPropertyEventTO.isActive()));
                    break;
                }
                case SPECIFIC_CAPABILITY: {
                    addressPropertyEventTO.setPropertyType(AddressPropertyEventTO.AddressProperty.SPECIFIC_CAPABILITY);
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + AddressPropertyEventTO.AddressProperty.SPECIFIC_CAPABILITY.toString() + " " + addressPropertyEventType.getAddress().getAddressName() + " " + addressPropertyEventType.getAddressProperty().value()));
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address Property: " + addressPropertyEventType.getAddressProperty().value() + " is ingored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateAddressProperty(addressPropertyEventTO);
        }

        private void processTerminalPropertyEvent(TerminalPropertyEventType terminalPropertyEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property Event: TerminalName [" + terminalPropertyEventType.getTerminal().getTerminalName() + "]\n TerminalProperty [" + (Object)((Object)terminalPropertyEventType.getTerminalProperty()) + "]"));
            TerminalPropertyEventTO terminalPropertyEventTO = new TerminalPropertyEventTO();
            terminalPropertyEventTO.setTerminalName(terminalPropertyEventType.getTerminal().getTerminalName());
            TerminalCapabilities terminalCapabilities = terminalPropertyEventType.getTerminalCapabilities();
            TerminalCapabilitiesTO terminalCapabilitiesTO = new TerminalCapabilitiesTO();
            terminalCapabilitiesTO.setCanConference(terminalCapabilities.isCanConference());
            terminalCapabilitiesTO.setCanConsult(terminalCapabilities.isCanConsult());
            terminalCapabilitiesTO.setCanDoNotDisturb(terminalCapabilities.isCanDoNotDisturb());
            terminalCapabilitiesTO.setCanForward(terminalCapabilities.isCanForward());
            terminalCapabilitiesTO.setCanOriginate(terminalCapabilities.isCanOriginate());
            terminalCapabilitiesTO.setCanPickup(terminalCapabilities.isCanPickup());
            terminalCapabilitiesTO.setCanPickupFromGroup(terminalCapabilities.isCanPickupFromGroup());
            terminalCapabilitiesTO.setCanTransfer(terminalCapabilities.isCanTransfer());
            terminalPropertyEventTO.setCapabilities(terminalCapabilitiesTO);
            switch (terminalPropertyEventType.getTerminalProperty()) {
                case DO_NOT_DISTURB: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.DO_NOT_DISTURB);
                    TerminalPropertyDoNotDisturb terminalPropertyDoNotDisturb = terminalPropertyEventType.getTerminalPropertyDoNotDisturb();
                    terminalPropertyEventTO.setActive(terminalPropertyDoNotDisturb.isDoNotDisturbSet());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: " + TerminalPropertyEventTO.TerminalProperty.DO_NOT_DISTURB.toString() + " " + terminalPropertyEventType.getTerminal().getTerminalName() + " " + terminalPropertyEventType.getTerminalProperty().value() + ": " + terminalPropertyDoNotDisturb.isDoNotDisturbSet()));
                    break;
                }
                case FORWARDING: {
                    List<TerminalPropertyForwarding> list;
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.FORWARDING);
                    TerminalPropertyForwardingArray terminalPropertyForwardingArray = terminalPropertyEventType.getTerminalPropertyForwardingArray();
                    if (terminalPropertyForwardingArray != null && (list = terminalPropertyForwardingArray.getItem()).size() > 0) {
                        terminalPropertyEventTO.setActive(true);
                    }
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: " + AddressPropertyEventTO.AddressProperty.FORWARDING.toString() + " " + terminalPropertyEventType.getTerminal().getTerminalName() + " " + terminalPropertyEventType.getTerminalProperty().value() + ": " + terminalPropertyEventTO.isActive()));
                    break;
                }
                case READY_STATUS: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.READY_STATUS);
                    terminalPropertyEventTO.setActive(terminalPropertyEventType.getAgentTerminalPropertyReadyStatus().isStatus());
                    terminalPropertyEventTO.setValue(terminalPropertyEventType.getAgentTerminalPropertyReadyStatus().getReasonCode());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: READY_STATUS " + terminalPropertyEventType.getTerminal().getTerminalName() + " " + terminalPropertyEventType.getTerminalProperty().value() + ": " + terminalPropertyEventTO.isActive() + " Reason: " + terminalPropertyEventType.getAgentTerminalPropertyReadyStatus().getReasonCode()));
                    break;
                }
                case ACTIVITY_CODE: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.ACTIVITY_CODE);
                    terminalPropertyEventTO.setValue(terminalPropertyEventType.getAgentTerminalPropertyActivityCode().getActivityCode());
                    break;
                }
                case AGENT_LOGIN_SESSION: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.AGENT_LOGIN_SESSION);
                    terminalPropertyEventTO.setActive(!terminalPropertyEventType.getAgentTerminalPropertyAgentLoginSession().isLoginEnded());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: AGENT_LOGIN_SESSION " + terminalPropertyEventType.getTerminal().getTerminalName() + " " + terminalPropertyEventType.getTerminalProperty().value() + ": " + terminalPropertyEventTO.isActive()));
                    break;
                }
                case AGENT_LOGIN_SESSION_ENDED: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.AGENT_LOGIN_SESSION_ENDED);
                    terminalPropertyEventTO.setActive(terminalPropertyEventType.getAgentTerminalPropertyAgentLoginSessionEnded().isLoginEnded());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: AGENT_LOGIN_SESSION_ENDED " + terminalPropertyEventType.getTerminal().getTerminalName() + " " + terminalPropertyEventType.getTerminalProperty().value() + ": " + terminalPropertyEventTO.isActive()));
                    break;
                }
                case SPECIFIC_CAPABILITY: {
                    terminalPropertyEventTO.setPropertyType(TerminalPropertyEventTO.TerminalProperty.SPECIFIC_CAPABILITY);
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Property: " + terminalPropertyEventType.getTerminalProperty().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateTerminalProperty(terminalPropertyEventTO);
        }

        private void processAgentPropertyEvent(AgentPropertyEventType agentPropertyEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent Property Event: AgentLoginID [" + agentPropertyEventType.getAgent().getAgentLoginId() + "]\n AgentName [" + agentPropertyEventType.getAgent().getUserName() + "]\n AgentProperty [" + (Object)((Object)agentPropertyEventType.getAgentProperty()) + "]"));
            AgentPropertyEventTO agentPropertyEventTO = new AgentPropertyEventTO();
            agentPropertyEventTO.setAgentLoginId(agentPropertyEventType.getAgent().getAgentLoginId());
            AgentCapabilities agentCapabilities = agentPropertyEventType.getAgentCapabilities();
            AgentCapabilitiesTO agentCapabilitiesTO = new AgentCapabilitiesTO();
            agentCapabilitiesTO.setCanGetNotReadyReason(agentCapabilities.isCanGetNotReadyReason());
            agentCapabilitiesTO.setCanGetReadyStatus(agentCapabilities.isCanGetReadyStatus());
            agentCapabilitiesTO.setCanGetSupervisor(agentCapabilities.isCanGetSupervisor());
            agentCapabilitiesTO.setCanLogin(agentCapabilities.isCanLogin());
            agentCapabilitiesTO.setCanLogout(agentCapabilities.isCanLogout());
            agentCapabilitiesTO.setCanRetrieve(agentCapabilities.isCanRetrieve());
            agentCapabilitiesTO.setCanSetNotReadyReason(agentCapabilities.isCanSetNotReadyReason());
            agentCapabilitiesTO.setCanSetReadyStatus(agentCapabilities.isCanSetReadyStatus());
            agentCapabilitiesTO.setCanSetStaticVoiceTerminal(agentCapabilities.isCanSetStaticVoiceTerminal());
            agentPropertyEventTO.setCapabilities(agentCapabilitiesTO);
            switch (agentPropertyEventType.getAgentProperty()) {
                case READY_STATUS: {
                    agentPropertyEventTO.setPropertyType(AgentPropertyEventTO.AgentProperty.READY_STATUS);
                    agentPropertyEventTO.setActive(agentPropertyEventType.getAgentPropertyReadyStatus().isStatus());
                    agentPropertyEventTO.setReason(agentPropertyEventType.getAgentPropertyReadyStatus().getReasonCode());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent Property: " + AgentPropertyEventTO.AgentProperty.READY_STATUS.toString() + " " + agentPropertyEventType.getAgent().getAgentLoginId() + " " + agentPropertyEventType.getAgentProperty().value() + ": " + agentPropertyEventTO.isActive() + " Reason: " + agentPropertyEventTO.getReason()));
                    break;
                }
                case LOGIN_STATUS: {
                    agentPropertyEventTO.setPropertyType(AgentPropertyEventTO.AgentProperty.LOGIN_STATUS);
                    agentPropertyEventTO.setActive(agentPropertyEventType.getAgentPropertyLoginStatus().getStatus().equals((Object)AgentLoginStatus.LOGGED_IN));
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent Property: " + AgentPropertyEventTO.AgentProperty.LOGIN_STATUS.toString() + " " + agentPropertyEventType.getAgent().getAgentLoginId() + " " + agentPropertyEventType.getAgentProperty().value() + ": " + agentPropertyEventTO.isActive()));
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent Property: " + agentPropertyEventType.getAgentProperty().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateAgentProperty(agentPropertyEventTO);
        }

        private void processContactPropertyEvent(ContactPropertyEventType contactPropertyEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property Event: contactID [" + contactPropertyEventType.getContact().getContactId() + "]\n ExternalContactID [" + contactPropertyEventType.getContact().getExternalContactId() + "]\n ContactProperty [" + (Object)((Object)contactPropertyEventType.getContactProperty()) + "]"));
            ContactPropertyEventTO contactPropertyEventTO = new ContactPropertyEventTO();
            contactPropertyEventTO.setContactId(contactPropertyEventType.getContact().getContactId());
            ContactCapabilities contactCapabilities = contactPropertyEventType.getContactCapabilities();
            ContactCapabilitiesTO contactCapabilitiesTO = new ContactCapabilitiesTO();
            contactCapabilitiesTO.setCanAddParty(contactCapabilities.isCanAddParty());
            contactCapabilitiesTO.setCanBargeIn(contactCapabilities.isCanBargeIn());
            contactCapabilitiesTO.setCanDrop(contactCapabilities.isCanDrop());
            contactCapabilitiesTO.setCanGetAttachedData(contactCapabilities.isCanGetAttachedData());
            contactCapabilitiesTO.setCanGetCallingTerminal(contactCapabilities.isCanGetCallingTerminal());
            contactCapabilitiesTO.setCanGetIntrinsics(contactCapabilities.isCanGetIntrinsics());
            contactCapabilitiesTO.setCanGetLastRedirectedAddress(contactCapabilities.isCanGetLastRedirectedAddress());
            contactCapabilitiesTO.setCanGetOriginalDestination(contactCapabilities.isCanGetOriginalDestination());
            contactCapabilitiesTO.setCanGetUUI(contactCapabilities.isCanGetUUI());
            contactCapabilitiesTO.setCanObserve(contactCapabilities.isCanObserve());
            contactCapabilitiesTO.setCanSetAttachedData(contactCapabilities.isCanSetAttachedData());
            contactCapabilitiesTO.setCanSetIntrinsics(contactCapabilities.isCanSetIntrinsics());
            contactCapabilitiesTO.setCanSetUUI(contactCapabilities.isCanSetUUI());
            contactCapabilitiesTO.setCanWhisper(contactCapabilities.isCanWhisper());
            contactPropertyEventTO.setCapabilities(contactCapabilitiesTO);
            switch (contactPropertyEventType.getContactProperty()) {
                case ATTACHED_DATA: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"ATTACHED DATA");
                    contactPropertyEventTO.setPropertyType(ContactPropertyEventTO.ContactProperty.ATTACHED_DATA);
                    AttachedDataTO attachedDataTO = new AttachedDataTO();
                    AttachedData attachedData = contactPropertyEventType.getContactPropertyAttachedData().getAttachedData();
                    if (attachedData != null && attachedData.getType() != null) {
                        if (attachedData.getType().value().equals("STRING")) {
                            attachedDataTO.setType(AttachedDataTO.AttachedDataType.STRING);
                            attachedDataTO.setStringData(attachedData.getStringData());
                            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property - ATTACHED DATA: " + attachedDataTO.getStringData()));
                        } else if (attachedData.getType().value().equals("BINARY")) {
                            attachedDataTO.setType(AttachedDataTO.AttachedDataType.BINARY);
                            byte[] byArray = new byte[attachedData.getBinaryData().getItem().size()];
                            int n = 0;
                            for (Byte by : attachedData.getBinaryData().getItem()) {
                                byArray[n++] = by;
                            }
                            attachedDataTO.setBinaryData(byArray);
                            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property - ATTACHED DATA: " + attachedDataTO.getBinaryData().length + " bytes"));
                        } else {
                            attachedDataTO.setType(AttachedDataTO.AttachedDataType.KVP);
                            KeyValuePairTO[] keyValuePairTOArray = new KeyValuePairTO[attachedData.getKeyValueData().getItem().size()];
                            int n = 0;
                            for (KeyValuePair keyValuePair : attachedData.getKeyValueData().getItem()) {
                                KeyValuePairTO keyValuePairTO = new KeyValuePairTO();
                                keyValuePairTO.setKey(keyValuePair.getKey());
                                keyValuePairTO.setValue(keyValuePair.getValue());
                                keyValuePairTOArray[n] = keyValuePairTO;
                                ++n;
                            }
                            attachedDataTO.setKeyValueData(keyValuePairTOArray);
                            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property - ATTACHED DATA: " + attachedDataTO.getKeyValueData().length + " key-value pair"));
                        }
                    }
                    contactPropertyEventTO.setObject(attachedDataTO);
                    break;
                }
                case UUI: {
                    contactPropertyEventTO.setPropertyType(ContactPropertyEventTO.ContactProperty.UUI);
                    contactPropertyEventTO.setValue(contactPropertyEventType.getContactPropertyUui().getUui());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property: " + contactPropertyEventType.getContactProperty().value() + " " + contactPropertyEventType.getContactPropertyUui().getUui()));
                    break;
                }
                case INTRINSICS: {
                    contactPropertyEventTO.setPropertyType(ContactPropertyEventTO.ContactProperty.INTRINSICS);
                    ArrayList<IntrinsicTO> arrayList = new ArrayList<IntrinsicTO>();
                    for (Intrinsic intrinsic : contactPropertyEventType.getContactPropertyIntrinsicArray().getItem()) {
                        IntrinsicTO intrinsicTO = new IntrinsicTO();
                        intrinsicTO.setKey(intrinsic.getKey());
                        intrinsicTO.setValue(intrinsic.getValue());
                        intrinsicTO.setImmutable(intrinsic.isImmutable());
                        arrayList.add(intrinsicTO);
                    }
                    contactPropertyEventTO.setObject(arrayList);
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property: " + contactPropertyEventType.getContactProperty().value() + " " + arrayList.size() + " pieces of Intrinsics"));
                    break;
                }
                case CALLED_ADDRESS: {
                    contactPropertyEventTO.setContactId(contactPropertyEventType.getContact().getContactId());
                    contactPropertyEventTO.setPropertyType(ContactPropertyEventTO.ContactProperty.CALLED_ADDRESS);
                    contactPropertyEventTO.setObject(contactPropertyEventType.getContactPropertyCalledAddress().getCalledAddress());
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property: " + contactPropertyEventType.getContactProperty().value() + " CalledAddressName " + contactPropertyEventType.getContactPropertyCalledAddress().getCalledAddress().getAddressName()));
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Contact Property: " + contactPropertyEventType.getContactProperty().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateContactProperty(contactPropertyEventTO);
        }

        private void processConnectionStateEvent(ConnectionStateEventType connectionStateEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Connection State Event: AddressName [" + connectionStateEventType.getAddress().getAddressName() + "]\n " + (Object)((Object)connectionStateEventType.getPreviousState()) + " -> " + (Object)((Object)connectionStateEventType.getNewState()) + "\n ContactID [" + connectionStateEventType.getContact().getContactId() + "]\n ExternalContactID [" + connectionStateEventType.getContact().getExternalContactId() + "]\n Reason [" + (Object)((Object)connectionStateEventType.getReason()) + "]"));
            if ("IDLE".equalsIgnoreCase(connectionStateEventType.getNewState().value())) {
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"Ignoring IDLE TCS Event");
            } else if ("ROUTING".equalsIgnoreCase(connectionStateEventType.getNewState().value())) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("connectionId", connectionStateEventType.getConnection().getConnectionId());
                NotificationManager.this.getRefClient().getRequestHandler().handle("AlertConnection", hashMap);
            } else if ("FAILED".equalsIgnoreCase(connectionStateEventType.getNewState().value())) {
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"Ignoring FAILED TCS Event");
            } else {
                StateEventTO stateEventTO = new StateEventTO();
                stateEventTO.setRoutePoint(connectionStateEventType.getAddress().getAddressType().equals((Object)AddressType.ROUTE_POINT));
                stateEventTO.setTreatment(connectionStateEventType.getAddress().getAddressType().equals((Object)AddressType.TREATMENT));
                if (stateEventTO.isTreatment()) {
                    stateEventTO.setDefaultTreatment(connectionStateEventType.getSendingAddress().getAddressName());
                }
                stateEventTO.setAddress(connectionStateEventType.getAddress().getAddressName());
                stateEventTO.setRemoteState(connectionStateEventType.getNewState().value());
                stateEventTO.setPrevRemoteState(connectionStateEventType.getPreviousState().value());
                stateEventTO.setReason(connectionStateEventType.getReason() == null ? "" : connectionStateEventType.getReason().value());
                stateEventTO.setContactId(connectionStateEventType.getContact().getContactId());
                stateEventTO.setExternalContactId(connectionStateEventType.getContact().getExternalContactId());
                ConnectionTO connectionTO = new ConnectionTO();
                connectionTO.setConnectionId(connectionStateEventType.getConnection().getConnectionId());
                stateEventTO.setConnection(connectionTO);
                ConnectionCapabilities connectionCapabilities = connectionStateEventType.getConnectionCapabilities();
                ConnectionCapabilitiesTO connectionCapabilitiesTO = new ConnectionCapabilitiesTO();
                connectionCapabilitiesTO.setCanAccept(connectionCapabilities.isCanAccept());
                connectionCapabilitiesTO.setCanDisconnect(connectionCapabilities.isCanDisconnect());
                connectionCapabilitiesTO.setCanAlert(connectionCapabilities.isCanAlert());
                connectionCapabilitiesTO.setCanPark(connectionCapabilities.isCanPark());
                connectionCapabilitiesTO.setCanRedirect(connectionCapabilities.isCanRedirect());
                connectionCapabilitiesTO.setCanReject(connectionCapabilities.isCanReject());
                stateEventTO.getConnection().setCapabilities(connectionCapabilitiesTO);
                stateEventTO.setNotifiedAddress(connectionStateEventType.getSendingAddress().getAddressName());
                if (stateEventTO.getAddress().toString().equals(stateEventTO.getNotifiedAddress().toString())) {
                    stateEventTO.setRemote(true);
                } else {
                    stateEventTO.setRemote(false);
                }
                NotificationManager.this.getRefClient().updateContactsInfo(stateEventTO);
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("updateContactsInfo: " + stateEventTO.toString()));
                if (stateEventTO.isRoutePoint() || stateEventTO.isTreatment()) {
                    NotificationManager.this.getRefClient().updateRoutePointContactsInfo(stateEventTO);
                }
            }
        }

        private void processTerminalConnectionStateEvent(TerminalConnectionStateEventType terminalConnectionStateEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal Connection State Event: TerminalName [" + terminalConnectionStateEventType.getTerminal().getTerminalName() + "]\n " + (Object)((Object)terminalConnectionStateEventType.getPreviousState()) + " -> " + (Object)((Object)terminalConnectionStateEventType.getNewState()) + "\n ContactID [" + terminalConnectionStateEventType.getContact().getContactId() + "]\n ExternalContactID [" + terminalConnectionStateEventType.getContact().getExternalContactId() + "]\n Reason [" + (Object)((Object)terminalConnectionStateEventType.getReason()) + "]"));
            if ("IDLE".equalsIgnoreCase(terminalConnectionStateEventType.getNewState().value())) {
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"Ignoring IDLE TCS Event");
            } else if ("ROUTING".equalsIgnoreCase(terminalConnectionStateEventType.getNewState().value())) {
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"Ignoring ROUTING TCS Event");
            } else {
                StateEventTO stateEventTO = new StateEventTO();
                stateEventTO.setTerminal(terminalConnectionStateEventType.getTerminal().getTerminalName());
                stateEventTO.setLocalState(terminalConnectionStateEventType.getNewState().value());
                stateEventTO.setPrevLocalState(terminalConnectionStateEventType.getPreviousState().value());
                stateEventTO.setReason(terminalConnectionStateEventType.getReason() == null ? "" : terminalConnectionStateEventType.getReason().value());
                stateEventTO.setContactId(terminalConnectionStateEventType.getContact().getContactId());
                stateEventTO.setExternalContactId(terminalConnectionStateEventType.getContact().getExternalContactId());
                TerminalConnectionTO terminalConnectionTO = new TerminalConnectionTO();
                terminalConnectionTO.setTerminalConnectionId(terminalConnectionStateEventType.getTerminalConnection().getTerminalConnectionId());
                stateEventTO.setTerminalConnection(terminalConnectionTO);
                TerminalConnectionCapabilities terminalConnectionCapabilities = terminalConnectionStateEventType.getTerminalConnectionCapabilities();
                TerminalConnectionCapabilitiesTO terminalConnectionCapabilitiesTO = new TerminalConnectionCapabilitiesTO();
                terminalConnectionCapabilitiesTO.setCanAnswer(terminalConnectionCapabilities.isCanAnswer());
                terminalConnectionCapabilitiesTO.setCanBlindTransfer(terminalConnectionCapabilities.isCanBlindTransfer());
                terminalConnectionCapabilitiesTO.setCanCompleteConference(terminalConnectionCapabilities.isCanCompleteConference());
                terminalConnectionCapabilitiesTO.setCanCompleteTransfer(terminalConnectionCapabilities.isCanCompleteTransfer());
                terminalConnectionCapabilitiesTO.setCanConsult(terminalConnectionCapabilities.isCanConsult());
                terminalConnectionCapabilitiesTO.setCanGenerateDTMF(terminalConnectionCapabilities.isCanGenerateDTMF());
                terminalConnectionCapabilitiesTO.setCanHold(terminalConnectionCapabilities.isCanHold());
                terminalConnectionCapabilitiesTO.setHeldReason(terminalConnectionCapabilities.isCanHold() ? "" : stateEventTO.getReason());
                terminalConnectionCapabilitiesTO.setCanInitiateConference(terminalConnectionCapabilities.isCanInitiateConference());
                terminalConnectionCapabilitiesTO.setCanInitiateTransfer(terminalConnectionCapabilities.isCanInitiateTransfer());
                terminalConnectionCapabilitiesTO.setCanUnhold(terminalConnectionCapabilities.isCanUnhold());
                stateEventTO.getTerminalConnection().setCapabilities(terminalConnectionCapabilitiesTO);
                stateEventTO.setRemote(true);
                NotificationManager.this.getRefClient().updateContactsInfo(stateEventTO);
                NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("updateContactsInfo: " + stateEventTO.toString()));
                if (stateEventTO.isRoutePoint() || stateEventTO.isTreatment()) {
                    NotificationManager.this.getRefClient().updateRoutePointContactsInfo(stateEventTO);
                }
            }
        }

        private void processAddressStateEvent(AddressStateEventType addressStateEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address State Event: AddressName [" + addressStateEventType.getAddress().getAddressName() + "]\n State [" + addressStateEventType.getState().value() + "]\n Reason [" + addressStateEventType.getReason() + "]"));
            AddressStateEventTO addressStateEventTO = new AddressStateEventTO();
            addressStateEventTO.setRoutePoint(addressStateEventType.getAddress().getAddressType().equals((Object)AddressType.ROUTE_POINT));
            addressStateEventTO.setAddressName(addressStateEventType.getAddress().getAddressName());
            addressStateEventTO.setAddressType(addressStateEventType.getAddress().getAddressType().value());
            addressStateEventTO.setProviderName(addressStateEventType.getAddress().getProvider().getProviderName());
            AddressCapabilities addressCapabilities = addressStateEventType.getAddressCapabilities();
            AddressCapabilitiesTO addressCapabilitiesTO = new AddressCapabilitiesTO();
            if (addressCapabilities != null) {
                addressCapabilitiesTO.setCanConference(addressCapabilities.isCanConference());
                addressCapabilitiesTO.setCanConference(addressCapabilities.isCanConsult());
                addressCapabilitiesTO.setCanDoNotDisturb(addressCapabilities.isCanDoNotDisturb());
                addressCapabilitiesTO.setCanForward(addressCapabilities.isCanForward());
                addressCapabilitiesTO.setCanGetMessageWaiting(addressCapabilities.isCanGetMessageWaiting());
                addressCapabilitiesTO.setCanOriginate(addressCapabilities.isCanOriginate());
                addressCapabilitiesTO.setCanSetMessageWaiting(addressCapabilities.isCanSetMessageWaiting());
                addressCapabilitiesTO.setCanTransfer(addressCapabilities.isCanTransfer());
            }
            addressStateEventTO.setCapabilities(addressCapabilitiesTO);
            switch (addressStateEventType.getState()) {
                case IN_SERVICE: {
                    addressStateEventTO.setStateType(AddressStateEventTO.AddressState.IN_SERVICE);
                    break;
                }
                case OUT_OF_SERVICE: {
                    addressStateEventTO.setStateType(AddressStateEventTO.AddressState.OUT_OF_SERVICE);
                    break;
                }
                case INVALID: {
                    addressStateEventTO.setStateType(AddressStateEventTO.AddressState.INVALID);
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Address State Event: " + addressStateEventType.getState().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateAddressState(addressStateEventTO);
        }

        private void processTerminalStateEvent(TerminalStateEventType terminalStateEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal State Event: TerminalName [" + terminalStateEventType.getTerminal().getTerminalName() + "]\n State [" + terminalStateEventType.getState().value() + "]\n Reason [" + terminalStateEventType.getReason() + "]"));
            TerminalStateEventTO terminalStateEventTO = new TerminalStateEventTO();
            terminalStateEventTO.setTerminalName(terminalStateEventType.getTerminal().getTerminalName());
            terminalStateEventTO.setTerminalType(terminalStateEventType.getTerminal().getTerminalType().value());
            terminalStateEventTO.setProviderName(terminalStateEventType.getTerminal().getProvider().getProviderName());
            TerminalCapabilities terminalCapabilities = terminalStateEventType.getTerminalCapabilities();
            TerminalCapabilitiesTO terminalCapabilitiesTO = new TerminalCapabilitiesTO();
            if (terminalCapabilities != null) {
                terminalCapabilitiesTO.setCanConference(terminalCapabilities.isCanConference());
                terminalCapabilitiesTO.setCanConsult(terminalCapabilities.isCanConsult());
                terminalCapabilitiesTO.setCanDoNotDisturb(terminalCapabilities.isCanDoNotDisturb());
                terminalCapabilitiesTO.setCanForward(terminalCapabilities.isCanForward());
                terminalCapabilitiesTO.setCanOriginate(terminalCapabilities.isCanOriginate());
                terminalCapabilitiesTO.setCanPickup(terminalCapabilities.isCanPickup());
                terminalCapabilitiesTO.setCanPickupFromGroup(terminalCapabilities.isCanPickupFromGroup());
                terminalCapabilitiesTO.setCanTransfer(terminalCapabilities.isCanTransfer());
            }
            terminalStateEventTO.setCapabilities(terminalCapabilitiesTO);
            switch (terminalStateEventType.getState()) {
                case IN_SERVICE: {
                    terminalStateEventTO.setStateType(TerminalStateEventTO.TerminalState.IN_SERVICE);
                    break;
                }
                case OUT_OF_SERVICE: {
                    terminalStateEventTO.setStateType(TerminalStateEventTO.TerminalState.OUT_OF_SERVICE);
                    break;
                }
                case INVALID: {
                    terminalStateEventTO.setStateType(TerminalStateEventTO.TerminalState.INVALID);
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Terminal State Event: " + terminalStateEventType.getState().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateTerminalState(terminalStateEventTO);
        }

        private void processAgentStateEvent(AgentStateEventType agentStateEventType) {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent State Event: AgentLoginID [" + agentStateEventType.getAgent().getAgentLoginId() + "]\n UserName [" + agentStateEventType.getAgent().getUserName() + "]\n State [" + (Object)((Object)agentStateEventType.getState())));
            AgentStateEventTO agentStateEventTO = new AgentStateEventTO();
            agentStateEventTO.setUserId(agentStateEventType.getAgent().getAgentLoginId());
            agentStateEventTO.setUserName(agentStateEventType.getAgent().getUserName());
            agentStateEventTO.setCapabilities(new AgentCapabilitiesTO());
            switch (agentStateEventType.getState()) {
                case MAPPED: {
                    agentStateEventTO.setStateType(AgentStateEventTO.AgentState.MAPPED);
                    break;
                }
                case UNMAPPED: {
                    agentStateEventTO.setStateType(AgentStateEventTO.AgentState.UNMAPPED);
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Agent State Event: " + agentStateEventType.getState().value() + " is ignored"));
                    return;
                }
            }
            NotificationManager.this.getRefClient().updateAgentState(agentStateEventTO);
        }

        private void processSystemEvent(SystemEventType systemEventType) throws Exception {
            NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("System Event: " + systemEventType.getSystemEvent().value()));
            switch (systemEventType.getSystemEvent()) {
                case CONNECTION_FAILURE: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"CONNECTION_FAILURE");
                    break;
                }
                case SUBSCRIPTION_TERMINATION: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"SUBSCRIPTION_TERMINATION");
                    break;
                }
                case SUBSCRIPTION_TERMINATION_IMMINENT: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"SUBSCRIPTION_TERMINATION_IMMINENT");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("subscriptionId", NotificationHandler.SUBSCRIPTION_ID);
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("Renewing subscription for id: " + NotificationHandler.SUBSCRIPTION_ID));
                    NotificationManager.this.getRefClient().getRequestHandler().handle("RenewSubscription", hashMap);
                    break;
                }
                case SESSION_TERMINATION_IMMINENT: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)"SessionTerminationImminent event received, renewing session");
                    NotificationManager.this.getRefClient().getRequestHandler().handle("SwitchOverHandler", new HashMap<String, Object>());
                    break;
                }
                default: {
                    NotificationManager.this.logger.log((Priority)Level.INFO, (Object)("System Event: " + systemEventType.getSystemEvent().value() + " is unrecognized"));
                }
            }
        }
    }
}

