/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import java.util.List;
import java.util.Map;

public class GetContactCapabilitiesCommand
extends Command {
    private ICapabilitiesFacade capabilitiesFacade;
    private IContactServiceDAO contactServiceDAO;
    private IConnectionServiceDAO connectionServiceDAO;

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        String string = (String)map.get("contactId");
        ContactTO contactTO = new ContactTO();
        contactTO.setContactId(string);
        this.getCapabilitiesFacade().getCapabilities(contactTO, ssoToken);
        List list = (List)this.getContactServiceDAO().getConnections(string, ssoToken).getObject();
        for (ConnectionTO connectionTO : list) {
            this.getCapabilitiesFacade().getCapabilities(connectionTO, ssoToken);
            List list2 = (List)this.getConnectionServiceDAO().getTerminalConnections(connectionTO.getConnectionId(), ssoToken).getObject();
            for (TerminalConnectionTO terminalConnectionTO : list2) {
                this.getCapabilitiesFacade().getCapabilities(terminalConnectionTO, ssoToken);
                connectionTO.addTerminalConnection(terminalConnectionTO);
            }
            contactTO.addConnection(connectionTO);
        }
        this.getRefClient().updateCurrentContactCapabilities(contactTO);
    }

    public ICapabilitiesFacade getCapabilitiesFacade() {
        return this.capabilitiesFacade;
    }

    public void setCapabilitiesFacade(ICapabilitiesFacade iCapabilitiesFacade) {
        this.capabilitiesFacade = iCapabilitiesFacade;
    }

    public IContactServiceDAO getContactServiceDAO() {
        return this.contactServiceDAO;
    }

    public void setContactServiceDAO(IContactServiceDAO iContactServiceDAO) {
        this.contactServiceDAO = iContactServiceDAO;
    }

    public IConnectionServiceDAO getConnectionServiceDAO() {
        return this.connectionServiceDAO;
    }

    public void setConnectionServiceDAO(IConnectionServiceDAO iConnectionServiceDAO) {
        this.connectionServiceDAO = iConnectionServiceDAO;
    }
}

