/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalTO;
import java.util.List;
import java.util.Map;

public class GetTerminalStateCommand
extends Command {
    private IAgentTerminalServiceDAO agentTerminalServiceDAO;
    private ITerminalServiceDAO terminalServiceDAO;
    private ICapabilitiesFacade capabilitiesFacade;
    private IContactDAO contactDAO;

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        TerminalCapabilitiesTO terminalCapabilitiesTO;
        TerminalTO terminalTO = (TerminalTO)map.get("terminal");
        CallResult callResult = this.getAgentTerminalServiceDAO().isLoggedIn(terminalTO, ssoToken);
        terminalTO.setAgentLoggedIn((Boolean)callResult.getObject());
        callResult = this.getAgentTerminalServiceDAO().isReady(terminalTO, ssoToken);
        terminalTO.setTerminalReady((Boolean)callResult.getObject());
        if (terminalTO.isAgentLoggedIn()) {
            callResult = this.getAgentTerminalServiceDAO().getLoginId(terminalTO, ssoToken);
            terminalTO.setLoginId(callResult.getObject().toString());
        }
        if ((terminalCapabilitiesTO = terminalTO.getTerminalCapabilities()) != null && terminalCapabilitiesTO.isCanForward()) {
            callResult = this.getTerminalServiceDAO().isForwarded(terminalTO, ssoToken);
            terminalTO.setForwarding((Boolean)callResult.getObject());
        }
        if (terminalCapabilitiesTO != null && terminalCapabilitiesTO.isCanDoNotDisturb()) {
            callResult = this.getTerminalServiceDAO().getDoNotDisturb(terminalTO, ssoToken);
            terminalTO.setDoNotDisturb((Boolean)callResult.getObject());
        }
        callResult = this.getTerminalServiceDAO().getContactTypes(terminalTO, ssoToken);
        terminalTO.setContactTypes((List)callResult.getObject());
        List<AddressTO> list = this.getContactDAO().getTerminalAddresses(terminalTO, ssoToken);
        for (int i = 0; i < list.size(); ++i) {
            this.getCapabilitiesFacade().getCapabilities(list.get(i), ssoToken);
        }
        terminalTO.setAddresses(list);
        this.getRefClient().addNewTerminal(terminalTO);
    }

    public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
        return this.agentTerminalServiceDAO;
    }

    public void setAgentTerminalServiceDAO(IAgentTerminalServiceDAO iAgentTerminalServiceDAO) {
        this.agentTerminalServiceDAO = iAgentTerminalServiceDAO;
    }

    public IContactDAO getContactDAO() {
        return this.contactDAO;
    }

    public void setContactDAO(IContactDAO iContactDAO) {
        this.contactDAO = iContactDAO;
    }

    public ITerminalServiceDAO getTerminalServiceDAO() {
        return this.terminalServiceDAO;
    }

    public void setTerminalServiceDAO(ITerminalServiceDAO iTerminalServiceDAO) {
        this.terminalServiceDAO = iTerminalServiceDAO;
    }

    public ICapabilitiesFacade getCapabilitiesFacade() {
        return this.capabilitiesFacade;
    }

    public void setCapabilitiesFacade(ICapabilitiesFacade iCapabilitiesFacade) {
        this.capabilitiesFacade = iCapabilitiesFacade;
    }
}

