/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.Nonce;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceHistory;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceStore;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceVerifier;

public class NonceVerifierImpl
implements NonceVerifier {
    private NonceStore nonceStore;
    private long allowedWindow;

    @Override
    public void verifyNonce(String tokenKey, String clientNonceString, String clientTimestampString) throws OAuthServiceException {
        if (StringUtils.isEmpty((String)clientNonceString) || StringUtils.isEmpty((String)clientTimestampString)) {
            throw new OAuthServiceException("Nonce or timestamp is not available");
        }
        long serverClock = System.currentTimeMillis();
        long clientTimestamp = Long.valueOf(clientTimestampString);
        NonceHistory nonceHistory = this.nonceStore.getNonceHistory(tokenKey);
        Nonce nonce = new Nonce(clientNonceString, clientTimestamp);
        if (nonceHistory == null) {
            long requestTimeDelta = serverClock - clientTimestamp;
            this.nonceStore.initNonceHistory(tokenKey, nonce, requestTimeDelta);
        } else {
            this.checkAdjustedRequestTime(serverClock, clientTimestamp, nonceHistory);
            if (!nonceHistory.addNonce(nonce)) {
                throw new OAuthServiceException("Duplicate nonce");
            }
        }
    }

    private void checkAdjustedRequestTime(long serverClock, long clientTimestamp, NonceHistory nonceHistory) {
        long adjustedRequestTime = clientTimestamp + nonceHistory.getRequestTimeDelta();
        long requestDelta = Math.abs(serverClock - adjustedRequestTime);
        if (requestDelta > this.allowedWindow) {
            throw new OAuthServiceException("Timestamp is invalid");
        }
    }

    public void setAllowedWindow(long allowedWindow) {
        this.allowedWindow = allowedWindow;
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.nonceStore = nonceStore;
    }
}

