/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Scanner;
import org.springframework.core.io.ClassPathResource;

public class SetServerDetailsCommand
extends Command {
    private String securityConfig;
    private String endpointFilename;
    private String serverPort = null;
    private String newServerPort = null;

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        String string = (String)map.get("protocol");
        String string2 = (String)map.get("newProtocol");
        this.serverPort = string + "://" + (String)map.get("server") + ":" + (String)map.get("port");
        this.newServerPort = string2 + "://" + (String)map.get("newServer") + ":" + (String)map.get("newPort");
        boolean bl = false;
        if (!this.serverPort.equalsIgnoreCase(this.newServerPort)) {
            Object object;
            ClassPathResource classPathResource;
            OutputStreamWriter outputStreamWriter = null;
            try {
                classPathResource = new ClassPathResource(this.getEndpointFilename());
                object = new File(classPathResource.getURL().toURI());
                outputStreamWriter = new FileWriter((File)object);
                outputStreamWriter.write(this.newServerPort);
                bl = true;
            }
            catch (IOException iOException) {
                this.undoEndpointUpdate();
                throw new Exception("Problem updating endpoint " + iOException.getMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.undoEndpointUpdate();
                throw new Exception("Problem updating endpoint " + uRISyntaxException.getMessage());
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bl && !string2.equalsIgnoreCase(string)) {
                try {
                    System.out.println("Updating Security Config");
                    classPathResource = new ClassPathResource(this.getSecurityConfig());
                    object = classPathResource.getURL().toURI().toString();
                    File file = new File(new URI((String)object));
                    if (string2.equalsIgnoreCase("https")) {
                        classPathResource = new ClassPathResource(this.getSecurityConfig() + "_https");
                        File file2 = new File(classPathResource.getURL().toURI());
                        File file3 = new File(new URI((String)object + "_http"));
                        if (file3.exists()) {
                            file3.delete();
                        }
                        if (!file.renameTo(file3)) {
                            throw new IOException("Error renaming current file in use to <NAME>_http");
                        }
                        file3 = new File(new URI((String)object));
                        if (file3.exists()) {
                            file3.delete();
                        }
                        if (!file2.renameTo(file3)) {
                            throw new IOException("Error renaming https file to " + this.getSecurityConfig());
                        }
                    } else {
                        classPathResource = new ClassPathResource(this.getSecurityConfig() + "_http");
                        File file4 = new File(classPathResource.getURL().toURI());
                        File file5 = new File(new URI((String)object + "_https"));
                        if (file5.exists()) {
                            file5.delete();
                        }
                        if (!file.renameTo(file5)) {
                            throw new IOException("Error renaming current file in use to <NAME>_https");
                        }
                        file5 = new File(new URI((String)object));
                        if (file5.exists()) {
                            file5.delete();
                        }
                        if (!file4.renameTo(file5)) {
                            throw new IOException("Error renaming http file to " + this.getSecurityConfig());
                        }
                    }
                    this.getRefClient().promptForRestart();
                }
                catch (IOException iOException) {
                    this.undoEndpointUpdate();
                    throw new Exception("Problem changing " + this.getSecurityConfig() + " to use " + string2 + " version:" + iOException.getMessage());
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.undoEndpointUpdate();
                    throw new Exception("Problem changing " + this.getSecurityConfig() + " to use " + string2 + " version:" + uRISyntaxException.getMessage());
                }
            } else if (bl && string2.equalsIgnoreCase(string)) {
                this.getRefClient().promptForRestart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(File file, File file2, String string, String string2, String string3) throws Exception {
        FileWriter fileWriter = null;
        Scanner scanner = null;
        try {
            fileWriter = new FileWriter(file2);
            scanner = new Scanner(file);
            scanner.useDelimiter(System.getProperty("line.separator"));
            String string4 = null;
            String string5 = null;
            while (scanner.hasNext()) {
                string4 = scanner.next();
                Scanner scanner2 = new Scanner(string4);
                string5 = scanner2.findInLine(string);
                if (string5 != null) {
                    string4 = string4.replaceFirst(string2, string3);
                }
                fileWriter.write(string4 + System.getProperty("line.separator"));
                scanner2.close();
            }
            string5 = null;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private void undoEndpointUpdate() throws Exception {
        try {
            ClassPathResource classPathResource = new ClassPathResource(this.getEndpointFilename());
            String string = classPathResource.getURL().toURI().toString();
            File file = new File(new URI(string));
            File file2 = new File(new URI(string + ".new"));
            this.updateFile(file, file2, this.newServerPort, this.newServerPort, this.serverPort);
            if (file.delete() && !file2.renameTo(new File(new URI(string)))) {
                throw new IOException("Error renaming file " + file2.getName());
            }
        }
        catch (Exception exception) {
            throw new Exception("Problem updating endpoint", exception);
        }
    }

    public String getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(String string) {
        this.securityConfig = string;
    }

    public String getEndpointFilename() {
        return this.endpointFilename;
    }

    public void setEndpointFilename(String string) {
        this.endpointFilename = string;
    }
}

