/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IAgentServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AgentCapabilitiesTO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ProviderTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.agentservice.AgentService;
import com.nortel.soa.oi.cct.agentservice.SOAOICCTAgentService;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AgentCapabilities;
import com.nortel.soa.oi.cct.types.AgentReadyStatus;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.agentservice.AgentRequest;
import com.nortel.soa.oi.cct.types.agentservice.BooleanResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetAgentContactTypesResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetStaticVoiceTerminalResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetSupervisorResponse;
import com.nortel.soa.oi.cct.types.agentservice.LoginRequest;
import com.nortel.soa.oi.cct.types.agentservice.RetrieveRequest;
import com.nortel.soa.oi.cct.types.agentservice.StringResponse;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AgentServiceDAO
extends ServiceDAO
implements IAgentServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.AgentServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getReadyState(AgentTO agentTO, String string) throws DAOException {
        String string2 = "getReadyState():";
        AgentRequest agentRequest = new AgentRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        BooleanResponse booleanResponse = null;
        try {
            booleanResponse = this.getPort().isReady(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(booleanResponse != null ? booleanResponse.isResponse() : false);
        return callResult;
    }

    @Override
    public CallResult getNotReadyReasonCode(AgentTO agentTO, String string) throws DAOException {
        String string2 = "getNotReadyReasonCode():";
        AgentRequest agentRequest = new AgentRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        StringResponse stringResponse = null;
        try {
            stringResponse = this.getPort().getNotReadyReasonCode(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(stringResponse.getResponse());
        return callResult;
    }

    @Override
    public CallResult getStaticVoiceTerminal(AgentTO agentTO, String string) throws DAOException {
        String string2 = "getStaticVoiceTerminal():";
        AgentRequest agentRequest = new AgentRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        GetStaticVoiceTerminalResponse getStaticVoiceTerminalResponse = null;
        try {
            getStaticVoiceTerminalResponse = this.getPort().getStaticVoiceTerminal(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (getStaticVoiceTerminalResponse != null && getStaticVoiceTerminalResponse.getTerminal() != null) {
            Terminal terminal = getStaticVoiceTerminalResponse.getTerminal();
            TerminalTO terminalTO = new TerminalTO();
            terminalTO.setTerminalName(terminal.getTerminalName());
            terminalTO.setTerminalType(terminal.getTerminalType().value());
            terminalTO.setTerminalStatus(terminal.getStatus());
            ProviderTO providerTO = new ProviderTO();
            providerTO.setProviderName(terminal.getProvider() != null ? terminal.getProvider().getProviderName() : "");
            terminalTO.setProvider(providerTO);
            callResult.setObject(terminalTO);
        }
        return callResult;
    }

    @Override
    public CallResult getSupervisor(AgentTO agentTO, String string) throws DAOException {
        String string2 = "getSupervisor():";
        AgentRequest agentRequest = new AgentRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        GetSupervisorResponse getSupervisorResponse = null;
        try {
            getSupervisorResponse = this.getPort().getSupervisor(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (getSupervisorResponse != null && getSupervisorResponse.getAgent() != null) {
            Agent agent2 = getSupervisorResponse.getAgent();
            AgentTO agentTO2 = new AgentTO();
            agentTO2.setAgentLoginId(agent2.getAgentLoginId());
            agentTO2.setAgentUsername(agent2.getUserName());
            callResult.setObject(agentTO2);
        }
        return callResult;
    }

    @Override
    public CallResult isLoggedIn(AgentTO agentTO, String string) throws DAOException {
        String string2 = "isLoggedIn():";
        AgentRequest agentRequest = new AgentRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        BooleanResponse booleanResponse = null;
        try {
            booleanResponse = this.getPort().isLoggedIn(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(booleanResponse != null ? booleanResponse.isResponse() : false);
        return callResult;
    }

    @Override
    public CallResult login(AgentTO agentTO, int n, String string, String string2) throws DAOException {
        String string3 = "login():";
        LoginRequest loginRequest = new LoginRequest();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        SsoToken ssoToken = new SsoToken();
        ssoToken.setToken(string2);
        loginRequest.setAgent(agent);
        loginRequest.setSsoToken(ssoToken);
        loginRequest.setInitialState(n == 2 ? AgentReadyStatus.READY : AgentReadyStatus.NOT_READY);
        loginRequest.setPassword(string);
        try {
            this.getPort().login(loginRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult getCapabilities(AgentTO agentTO, String string) throws DAOException {
        String string2 = "getCapabilities():";
        AgentRequest agentRequest = new AgentRequest();
        AgentCapabilities agentCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        ssoToken.setToken(string);
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        try {
            agentCapabilities = this.getPort().getCapabilities(agentRequest).getAgentCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        AgentCapabilitiesTO agentCapabilitiesTO = new AgentCapabilitiesTO();
        agentCapabilitiesTO.setCanGetNotReadyReason(agentCapabilities.isCanGetNotReadyReason());
        agentCapabilitiesTO.setCanGetReadyStatus(agentCapabilities.isCanGetReadyStatus());
        agentCapabilitiesTO.setCanGetSupervisor(agentCapabilities.isCanGetSupervisor());
        agentCapabilitiesTO.setCanLogin(agentCapabilities.isCanLogin());
        agentCapabilitiesTO.setCanLogout(agentCapabilities.isCanLogout());
        agentCapabilitiesTO.setCanRetrieve(agentCapabilities.isCanRetrieve());
        agentCapabilitiesTO.setCanSetNotReadyReason(agentCapabilities.isCanSetNotReadyReason());
        agentCapabilitiesTO.setCanSetReadyStatus(agentCapabilities.isCanSetReadyStatus());
        agentCapabilitiesTO.setCanSetStaticVoiceTerminal(agentCapabilities.isCanSetStaticVoiceTerminal());
        CallResult callResult = new CallResult();
        callResult.setObject(agentCapabilitiesTO);
        return callResult;
    }

    @Override
    public CallResult retrieveContact(AgentTO agentTO, String string, String string2) throws DAOException {
        String string3 = "retrieveContact():";
        RetrieveRequest retrieveRequest = new RetrieveRequest();
        SsoToken ssoToken = new SsoToken();
        Agent agent = new Agent();
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        ssoToken.setToken(string2);
        retrieveRequest.setAgent(agent);
        retrieveRequest.setContactExternalId(string);
        retrieveRequest.setSsoToken(ssoToken);
        try {
            this.getPort().retrieve(retrieveRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getContactTypes(AgentTO agentTO, String string) throws DAOException {
        GetAgentContactTypesResponse getAgentContactTypesResponse;
        String string2 = "getContactTypes():";
        AgentRequest agentRequest = new AgentRequest();
        SsoToken ssoToken = new SsoToken();
        Agent agent = new Agent();
        ssoToken.setToken(string);
        agent.setAgentLoginId(agentTO.getAgentLoginId());
        agent.setUserName(agentTO.getAgentUsername());
        agentRequest.setAgent(agent);
        agentRequest.setSsoToken(ssoToken);
        try {
            getAgentContactTypesResponse = this.getPort().getContactTypes(agentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(getAgentContactTypesResponse.getContactTypes());
        return callResult;
    }

    public AgentService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTAgentService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(AgentService.class);
        object = (AgentService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

