/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionCapabilitiesTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.connectionservice.ConnectionService;
import com.nortel.soa.oi.cct.connectionservice.SOAOICCTConnectionService;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.ConnectionCapabilities;
import com.nortel.soa.oi.cct.types.ConnectionStateInfo;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.TerminalConnection;
import com.nortel.soa.oi.cct.types.connectionservice.AddressResponse;
import com.nortel.soa.oi.cct.types.connectionservice.ConnectionRequest;
import com.nortel.soa.oi.cct.types.connectionservice.ConnectionStateResponse;
import com.nortel.soa.oi.cct.types.connectionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.connectionservice.TerminalConnectionsResponse;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ConnectionServiceDAO
extends ServiceDAO
implements IConnectionServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.ConnectionServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getCapabilities(String string, String string2) throws DAOException {
        String string3 = "getCapabilities():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        ConnectionCapabilities connectionCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            connectionCapabilities = this.getPort().getConnectionCapabilities(connectionRequest).getConnectionCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ConnectionCapabilitiesTO connectionCapabilitiesTO = new ConnectionCapabilitiesTO();
        connectionCapabilitiesTO.setCanAccept(connectionCapabilities.isCanAccept());
        connectionCapabilitiesTO.setCanDisconnect(connectionCapabilities.isCanDisconnect());
        connectionCapabilitiesTO.setCanAlert(connectionCapabilities.isCanAlert());
        connectionCapabilitiesTO.setCanPark(connectionCapabilities.isCanPark());
        connectionCapabilitiesTO.setCanRedirect(connectionCapabilities.isCanRedirect());
        connectionCapabilitiesTO.setCanReject(connectionCapabilities.isCanReject());
        CallResult callResult = new CallResult();
        callResult.setObject(connectionCapabilitiesTO);
        return callResult;
    }

    @Override
    public CallResult getContact(String string, String string2) throws DAOException {
        String string3 = "getContact():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        ContactResponse contactResponse = null;
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            contactResponse = this.getPort().getContact(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ContactTO contactTO = new ContactTO();
        if (contactResponse != null) {
            contactTO.setContactId(contactResponse.getContact().getContactId());
            contactTO.setExternalContactId(contactResponse.getContact().getExternalContactId());
        }
        CallResult callResult = new CallResult();
        callResult.setObject(contactTO);
        return callResult;
    }

    @Override
    public CallResult getAddress(String string, String string2) throws DAOException {
        String string3 = "getAddress():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        AddressResponse addressResponse = null;
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            addressResponse = this.getPort().getAddress(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        AddressTO addressTO = new AddressTO();
        if (addressResponse != null) {
            addressTO.setAddressName(addressResponse.getAddress().getAddressName());
        }
        CallResult callResult = new CallResult();
        callResult.setObject(addressTO);
        return callResult;
    }

    @Override
    public CallResult getTerminalConnections(String string, String string2) throws DAOException {
        String string3 = "getTerminalConnections():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        TerminalConnectionsResponse terminalConnectionsResponse = null;
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            terminalConnectionsResponse = this.getPort().getTerminalConnections(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ArrayList<TerminalConnectionTO> arrayList = new ArrayList<TerminalConnectionTO>();
        if (terminalConnectionsResponse != null) {
            for (TerminalConnection terminalConnection : terminalConnectionsResponse.getTerminalConnections()) {
                TerminalConnectionTO terminalConnectionTO = new TerminalConnectionTO();
                terminalConnectionTO.setTerminalConnectionId(terminalConnection.getTerminalConnectionId());
                arrayList.add(terminalConnectionTO);
            }
        }
        CallResult callResult = new CallResult();
        callResult.setObject(arrayList);
        return callResult;
    }

    @Override
    public CallResult getState(String string, String string2) throws DAOException {
        String string3 = "getState():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        ConnectionStateResponse connectionStateResponse = null;
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            connectionStateResponse = this.getPort().getState(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (connectionStateResponse != null) {
            StateSummaryTO stateSummaryTO = new StateSummaryTO();
            ConnectionStateInfo connectionStateInfo = connectionStateResponse.getConnectionStateInfo();
            if (connectionStateInfo != null) {
                if (connectionStateInfo.getCurrentState() != null) {
                    stateSummaryTO.setCurrent(connectionStateInfo.getCurrentState().getState().toString());
                    if (connectionStateInfo.getCurrentState().getReasonCode() != null) {
                        stateSummaryTO.setReason(connectionStateInfo.getCurrentState().getReasonCode().toString());
                    }
                }
                if (connectionStateInfo.getLastState() != null && connectionStateInfo.getLastState().getState() != null) {
                    stateSummaryTO.setPrevious(connectionStateInfo.getLastState().getState().toString());
                }
                callResult.setObject(stateSummaryTO);
            }
        }
        return callResult;
    }

    @Override
    public CallResult disconnect(String string, String string2) throws DAOException {
        String string3 = "disconnect():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            this.getPort().disconnect(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    public ConnectionService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTConnectionService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(ConnectionService.class);
        object = (ConnectionService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }

    @Override
    public CallResult alert(String string, String string2) throws DAOException {
        String string3 = "alert():";
        ConnectionRequest connectionRequest = new ConnectionRequest();
        SsoToken ssoToken = new SsoToken();
        Connection connection = new Connection();
        connection.setConnectionId(string);
        ssoToken.setToken(string2);
        connectionRequest.setConnection(connection);
        connectionRequest.setSsoToken(ssoToken);
        try {
            this.getPort().alert(connectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }
}

