/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IRoutePointAddressServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.routepointaddressservice.RoutePointAddressService;
import com.nortel.soa.oi.cct.routepointaddressservice.SOAOICCTRoutePointAddressService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.routepointaddressservice.BooleanResponse;
import com.nortel.soa.oi.cct.types.routepointaddressservice.RoutePointAddressRequest;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RoutePointAddressServiceDAO
extends ServiceDAO
implements IRoutePointAddressServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.RoutePointAddressServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult control(AddressTO addressTO, String string) throws DAOException {
        String string2 = "control():";
        RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        if (addressTO != null) {
            Address address = new Address();
            address.setAddressName(addressTO.getAddressName());
            address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
            routePointAddressRequest.setRoutePointAddress(address);
        }
        ssoToken.setToken(string);
        routePointAddressRequest.setSsoToken(ssoToken);
        try {
            this.getPort().control(routePointAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult releaseControl(AddressTO addressTO, String string) throws DAOException {
        String string2 = "releaseControl():";
        RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        if (addressTO != null) {
            Address address = new Address();
            address.setAddressName(addressTO.getAddressName());
            address.setAddressType(AddressType.valueOf(addressTO.getAddressType()));
            routePointAddressRequest.setRoutePointAddress(address);
        }
        ssoToken.setToken(string);
        routePointAddressRequest.setSsoToken(ssoToken);
        try {
            this.getPort().releaseControl(routePointAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult isControlled(AddressTO addressTO, String string) throws DAOException {
        Object object;
        String string2 = "isControlled():";
        RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        if (addressTO != null) {
            object = new Address();
            ((Address)object).setAddressName(addressTO.getAddressName());
            ((Address)object).setAddressType(AddressType.valueOf(addressTO.getAddressType()));
            routePointAddressRequest.setRoutePointAddress((Address)object);
        }
        ssoToken.setToken(string);
        routePointAddressRequest.setSsoToken(ssoToken);
        try {
            object = this.getPort().isControlled(routePointAddressRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(object != null ? ((BooleanResponse)object).isResponse() : false);
        return callResult;
    }

    public RoutePointAddressService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTRoutePointAddressService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(RoutePointAddressService.class);
        object = (RoutePointAddressService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

