/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.ITerminalConnectionServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionCapabilitiesTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.terminalconnectionservice.SOAOICCTTerminalConnectionService;
import com.nortel.soa.oi.cct.terminalconnectionservice.TerminalConnectionService;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalConnection;
import com.nortel.soa.oi.cct.types.TerminalConnectionCapabilities;
import com.nortel.soa.oi.cct.types.TerminalConnectionStateInfo;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.GetContactTypeResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.GetTerminalConnectionCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalConnectionRequest;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalConnectionStateResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalResponse;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TerminalConnectionServiceDAO
extends ServiceDAO
implements ITerminalConnectionServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.TerminalConnectionServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getCapabilities(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getCapabilities():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        TerminalConnectionCapabilities terminalConnectionCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            object = this.getPort().getTerminalConnectionCapabilities(terminalConnectionRequest);
            if (object != null) {
                terminalConnectionCapabilities = ((GetTerminalConnectionCapabilitiesResponse)object).getTerminalConnectionCapabilities();
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        object = new CallResult();
        if (terminalConnectionCapabilities != null) {
            TerminalConnectionCapabilitiesTO terminalConnectionCapabilitiesTO = new TerminalConnectionCapabilitiesTO();
            terminalConnectionCapabilitiesTO.setCanAnswer(terminalConnectionCapabilities.isCanAnswer());
            terminalConnectionCapabilitiesTO.setCanBlindTransfer(terminalConnectionCapabilities.isCanBlindTransfer());
            terminalConnectionCapabilitiesTO.setCanCompleteConference(terminalConnectionCapabilities.isCanCompleteConference());
            terminalConnectionCapabilitiesTO.setCanCompleteTransfer(terminalConnectionCapabilities.isCanCompleteTransfer());
            terminalConnectionCapabilitiesTO.setCanConsult(terminalConnectionCapabilities.isCanConsult());
            terminalConnectionCapabilitiesTO.setCanGenerateDTMF(terminalConnectionCapabilities.isCanGenerateDTMF());
            terminalConnectionCapabilitiesTO.setCanHold(terminalConnectionCapabilities.isCanHold());
            terminalConnectionCapabilitiesTO.setCanInitiateConference(terminalConnectionCapabilities.isCanInitiateConference());
            terminalConnectionCapabilitiesTO.setCanInitiateTransfer(terminalConnectionCapabilities.isCanInitiateTransfer());
            terminalConnectionCapabilitiesTO.setCanUnhold(terminalConnectionCapabilities.isCanUnhold());
            terminalConnectionCapabilitiesTO.setCanSetActivityCode(terminalConnectionCapabilities.isCanSetActivityCode());
            terminalConnectionCapabilitiesTO.setCanGetActivityCode(terminalConnectionCapabilities.isCanGetActivityCode());
            ((CallResult)object).setObject(terminalConnectionCapabilitiesTO);
        }
        return object;
    }

    @Override
    public CallResult getTerminal(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getTerminal():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        TerminalResponse terminalResponse = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            terminalResponse = this.getPort().getTerminal(terminalConnectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        TerminalTO terminalTO = new TerminalTO();
        if (terminalResponse != null) {
            object = terminalResponse.getTerminal();
            terminalTO.setTerminalName(((Terminal)object).getTerminalName());
        }
        object = new CallResult();
        ((CallResult)object).setObject(terminalTO);
        return object;
    }

    @Override
    public CallResult getState(String string, String string2) throws DAOException {
        String string3 = "getState():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        TerminalConnectionStateResponse terminalConnectionStateResponse = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            terminalConnectionStateResponse = this.getPort().getState(terminalConnectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (terminalConnectionStateResponse != null) {
            StateSummaryTO stateSummaryTO = new StateSummaryTO();
            TerminalConnectionStateInfo terminalConnectionStateInfo = terminalConnectionStateResponse.getTerminalConnectionStateInfo();
            if (terminalConnectionStateInfo != null) {
                if (terminalConnectionStateInfo.getCurrentState() != null) {
                    stateSummaryTO.setCurrent(terminalConnectionStateInfo.getCurrentState().getState().toString());
                    if (terminalConnectionStateInfo.getCurrentState().getReasonCode() != null) {
                        stateSummaryTO.setReason(terminalConnectionStateInfo.getCurrentState().getReasonCode().toString());
                    }
                }
                if (terminalConnectionStateInfo.getLastState() != null && terminalConnectionStateInfo.getLastState().getState() != null) {
                    stateSummaryTO.setPrevious(terminalConnectionStateInfo.getLastState().getState().toString());
                }
                callResult.setObject(stateSummaryTO);
            }
        }
        return callResult;
    }

    @Override
    public CallResult getContactType(String string, String string2) throws DAOException {
        String string3 = "getContactType():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        GetContactTypeResponse getContactTypeResponse = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            getContactTypeResponse = this.getPort().getContactType(terminalConnectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        if (getContactTypeResponse != null) {
            callResult.setObject(getContactTypeResponse.getContactType());
        }
        return callResult;
    }

    @Override
    public CallResult getConferenceConsult(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getConferenceConsult():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        ContactResponse contactResponse = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            contactResponse = this.getPort().getConferenceConsultContact(terminalConnectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ContactTO contactTO = null;
        if (contactResponse != null && contactResponse.getContact() != null) {
            contactTO = new ContactTO();
            object = contactResponse.getContact();
            contactTO.setContactId(((Contact)object).getContactId());
            contactTO.setExternalContactId(((Contact)object).getExternalContactId());
        }
        object = new CallResult();
        ((CallResult)object).setObject(contactTO);
        return object;
    }

    @Override
    public CallResult getTransferConsult(String string, String string2) throws DAOException {
        Object object;
        String string3 = "getTransferConsult():";
        TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        ContactResponse contactResponse = null;
        SsoToken ssoToken = new SsoToken();
        TerminalConnection terminalConnection = new TerminalConnection();
        terminalConnection.setTerminalConnectionId(string);
        ssoToken.setToken(string2);
        terminalConnectionRequest.setTerminalConnection(terminalConnection);
        terminalConnectionRequest.setSsoToken(ssoToken);
        try {
            contactResponse = this.getPort().getTransferConsultContact(terminalConnectionRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        ContactTO contactTO = null;
        if (contactResponse != null && contactResponse.getContact() != null) {
            contactTO = new ContactTO();
            object = contactResponse.getContact();
            contactTO.setContactId(((Contact)object).getContactId());
            contactTO.setExternalContactId(((Contact)object).getExternalContactId());
        }
        object = new CallResult();
        ((CallResult)object).setObject(contactTO);
        return object;
    }

    public TerminalConnectionService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTTerminalConnectionService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(TerminalConnectionService.class);
        object = (TerminalConnectionService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

