/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.event;

import com.nortel.rc.event.INotificationHandler;
import com.nortel.rc.event.NotificationManager;
import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@WebService(name="NotificationConsumer", serviceName="SOAOICCT_NotificationConsumer", portName="NotificationConsumer", targetNamespace="http://www.nortel.com/soa/oi/cct/NotificationConsumer", endpointInterface="com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer")
public final class NotificationHandler
implements NotificationConsumer,
INotificationHandler {
    public static String NOTIFICATIONS_HOSTNAME;
    public static String NOTIFICATIONS_PORT;
    public static String SUBSCRIPTION_ID;
    private static Logger logger;
    private NotificationManager notificationManager;

    public NotificationHandler(String string) {
        Object object;
        String string2 = null;
        try {
            object = InetAddress.getLocalHost();
            string2 = ((InetAddress)object).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "localhost";
        }
        object = System.getProperty("notification.port");
        String string3 = object == null || "".equals(object) ? NotificationHandler.findAvailablePort(string) : object;
        NotificationHandler.setStaticHostname(string2);
        NotificationHandler.setStaticPort(string3);
        String string4 = "http://" + string2 + ":" + string3 + "/SOAOICCT/services/NotificationConsumer";
        logger.log((Priority)Level.INFO, (Object)("Publishing NotificationHandler: " + string4));
        Endpoint.publish((String)string4, (Object)this);
    }

    @Override
    @WebMethod
    public void notify(List<NotificationMessageHolderType> list) {
        this.notificationManager.handleNotify(list);
    }

    private static void setStaticHostname(String string) {
        NOTIFICATIONS_HOSTNAME = string;
    }

    private static void setStaticPort(String string) {
        NOTIFICATIONS_PORT = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findAvailablePort(String string) {
        ServerSocket serverSocket = null;
        String string2 = string;
        try {
            serverSocket = new ServerSocket(0);
            string2 = Integer.toString(serverSocket.getLocalPort());
        }
        catch (IOException iOException) {
            logger.error((Object)"findAvailablePort(): Exception while creating server socket: ", (Throwable)iOException);
        }
        finally {
            try {
                if (serverSocket != null && !serverSocket.isClosed()) {
                    serverSocket.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)"findAvailablePort(): Exception while closing server socket: ", (Throwable)iOException);
            }
        }
        return string2;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    static {
        logger = Logger.getLogger((String)NotificationHandler.class.getName());
    }
}

