/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.gui;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.TerminalTO;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeviceMutableTreeNode
extends DefaultMutableTreeNode {
    private static final String TERMINAL = "TerminalTO";
    private static final String ADDRESS = "AddressTO";
    private static final String OTHER = "Other";
    private String userObjectType = null;

    public DeviceMutableTreeNode() {
        this.setUserObjectType(null);
    }

    public DeviceMutableTreeNode(Object object) {
        super(object);
        this.setUserObjectType(object);
    }

    public DeviceMutableTreeNode(Object object, boolean bl) {
        super(object, bl);
        this.setUserObjectType(object);
    }

    private void setUserObjectType(Object object) {
        this.userObjectType = object instanceof TerminalTO ? TERMINAL : (object instanceof AddressTO ? ADDRESS : OTHER);
    }

    public boolean hasChildren() {
        return super.getChildCount() != 0;
    }

    private String getObjectName() {
        String string = null;
        if (this.userObjectType.equals(TERMINAL)) {
            TerminalTO terminalTO = (TerminalTO)super.getUserObject();
            string = terminalTO.getTerminalName();
        } else if (this.userObjectType.equals(ADDRESS)) {
            AddressTO addressTO = (AddressTO)super.getUserObject();
            string = addressTO.getAddressName();
        } else {
            string = super.getUserObject().toString();
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getObjectName().toString();
    }

    public boolean isTerminal() {
        return this.userObjectType.equals(TERMINAL);
    }

    public boolean isAddress() {
        return this.userObjectType.equals(ADDRESS);
    }
}

