/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

@Path(value="authorize")
public class AuthorizationService {
    private Map<String, RedirectionBasedGrantService> servicesMap = new HashMap<String, RedirectionBasedGrantService>();

    @Context
    public void setMessageContext(MessageContext context) {
        for (RedirectionBasedGrantService service : this.servicesMap.values()) {
            service.setMessageContext(context);
        }
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize(@QueryParam(value="response_type") String responseType) {
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorize();
        }
        return this.reportInvalidResponseType();
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision(@QueryParam(value="response_type") String responseType) {
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorizeDecision();
        }
        return this.reportInvalidResponseType();
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm(MultivaluedMap<String, String> params) {
        String responseType = (String)params.getFirst((Object)"response_type");
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorizeDecisionForm(params);
        }
        return this.reportInvalidResponseType();
    }

    private RedirectionBasedGrantService getService(String responseType) {
        return responseType == null ? null : this.servicesMap.get(responseType);
    }

    public void setServices(List<RedirectionBasedGrantService> services) {
        for (RedirectionBasedGrantService service : services) {
            for (String responseType : service.getSupportedResponseTypes()) {
                this.servicesMap.put(responseType, service);
            }
        }
    }

    protected Response reportInvalidResponseType() {
        return JAXRSUtils.toResponseBuilder((int)400).type("application/json").entity((Object)new OAuthError("unsupported_response_type")).build();
    }
}

